/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.excel;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.excel.ExcelForStructImporter;
import com.trs.components.metadata.definition.excel.FieldInfo;
import com.trs.components.metadata.definition.excel.FieldInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import org.apache.log4j.Logger;

public class DefaultTabelsForHaierEN {
    private static Logger logger = Logger.getLogger(ExcelForStructImporter.class);
    private static StringBuffer sbDropSQL = new StringBuffer();
    public static FieldInfos DEFAULT_FIELDS_GS = new FieldInfos();
    public static FieldInfos DEFAULT_FIELDS_SM;
    public static FieldInfos DEFAULT_FIELDS_FAQ;
    public static FieldInfos DEFAULT_FIELDS_DRIVE;
    public static String PRE_TABLE_NAME;
    public static FieldInfos[] pDefaultFields;
    public static String[] pTableAnotherNames;
    public static String[] pTableNames;

    private static MetaViewField createDBFieldFromDataType(FieldInfo fieldInfo) throws WCMException {
        MetaViewField metaViewField = MetaViewField.createNewInstance();
        if (fieldInfo.getEnumValues() != null) {
            metaViewField.setEnmValue(fieldInfo.getEnumValues());
        }
        metaViewField.setNotNull(fieldInfo.isNotNull());
        metaViewField.setHidden(fieldInfo.isHidden());
        metaViewField.setInOutline(fieldInfo.isInOutline());
        metaViewField.setTitleField(fieldInfo.isTitle());
        metaViewField.setSearchField(fieldInfo.isSearchField());
        metaViewField.setAnotherName(fieldInfo.getDataTypeDesc());
        metaViewField.setName(fieldInfo.getKey());
        metaViewField.setType(fieldInfo.getDataType());
        metaViewField.setDBType(fieldInfo.getSqlDataType());
        return metaViewField;
    }

    private static MetaDBTable createTable(String string, String string2, FieldInfos fieldInfos) throws WCMException {
        sbDropSQL.append("drop table WCMMetaTable" + string2 + ";");
        sbDropSQL.append("\n");
        IMetaDataDefMgr iMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        User user = User.findByName("admin");
        MetaDBTable metaDBTable = MetaDBTable.createNewInstance();
        metaDBTable.setAnotherName(string);
        metaDBTable.setName(string2);
        iMetaDataDefMgr.save(user, metaDBTable);
        MetaView metaView = DefaultTabelsForHaierEN.createViewFrom(metaDBTable);
        iMetaDataDefMgr.save(user, metaView);
        int n = fieldInfos.getDataTypesCount();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = DefaultTabelsForHaierEN.createDBFieldFromDataType(fieldInfos.getDataTypeAt(i));
            try {
                iMetaDataDefMgr.save(user, metaView, metaViewField);
                continue;
            }
            catch (Exception exception) {
                iMetaDataDefMgr.delete(user, metaDBTable);
                logger.error((Object)(I18NMessage.get(DefaultTabelsForHaierEN.class, "DefaultTabelsForHaierEN.label1", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + string + "." + string2 + "." + metaViewField.getAnotherName() + "." + metaViewField.getName() + "]"), (Throwable)exception);
                break;
            }
        }
        return metaDBTable;
    }

    public static void createDefaultTables() throws Exception {
        for (int i = 0; i < pTableAnotherNames.length; ++i) {
            if (!PRE_TABLE_NAME.equalsIgnoreCase("HUK") && pTableAnotherNames[i].equalsIgnoreCase("Manual")) continue;
            DefaultTabelsForHaierEN.createTable(PRE_TABLE_NAME + "_" + pTableAnotherNames[i], PRE_TABLE_NAME + "_" + pTableNames[i], pDefaultFields[i]);
        }
        CMyFile.writeFile("c:\\drop_default_tables_" + PRE_TABLE_NAME + ".sql", sbDropSQL.toString());
    }

    private static MetaView createViewFrom(MetaDBTable metaDBTable) throws WCMException {
        MetaView metaView = MetaView.createNewInstance();
        metaView.setMainTable(metaDBTable);
        metaView.setDesc(metaDBTable.getAnotherName());
        metaView.setName(metaDBTable.getName());
        return metaView;
    }

    static {
        FieldInfo fieldInfo = DEFAULT_FIELDS_GS.register(3, "Title", "GName", 12, 60);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_GS.register(4, "Description", "GDesc", 12, 140);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_GS.register(8, "Icon", "Icon", 12, 20);
        DEFAULT_FIELDS_SM = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_SM.register(3, "Name", "GName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(3, "File Name", "GFileName", 12, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(11, "Publishing Date", "GPubDate", 93, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(8, "File", "GFile", 12, 20);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        DEFAULT_FIELDS_FAQ = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_FAQ.register(3, "Question", "FName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_FAQ.register(4, "Answer", "FFileName", 12, 2000);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_DRIVE = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, "Name", "DName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(6, "Operating System", "DOS", 4, 0);
        fieldInfo.setEnumValues("Windows XP`1~Windows Visto`2~Windows 7`3~Other`4");
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, "File Path", "DFilePath", 12, 300);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        PRE_TABLE_NAME = "HUK";
        pDefaultFields = new FieldInfos[]{DEFAULT_FIELDS_GS, DEFAULT_FIELDS_SM, DEFAULT_FIELDS_FAQ, DEFAULT_FIELDS_DRIVE};
        pTableAnotherNames = new String[]{"Product Overview", "Manual", "FAQ", "Driver"};
        pTableNames = new String[]{"Overview", "Manual", "FAQ", "DRIVER"};
    }
}

