/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class InfoViewQueryHelper {
    private static final String DEFAULT_TIMERANGE_FIELD = "CRTIME";
    protected static Logger logger = Logger.getLogger(InfoViewQueryHelper.class);
    private static final String FIELD_OPERATIONMARK = "FLOWOPERATIONMARK";
    private static HashMap m_oSystemFieldMap = null;
    private static DocumentFactory m_oDocFactory = null;
    private static String[] m_aDefaultOutlineFields = new String[]{"FLOWOPERATIONMARK", "_DOCID", "DOCTITLE", "CRTIME", "DOCSTATUS", "ARCHIVESERIAL", "POSTUSER", "POSITIONCODE", "POSTUSER", "DOCPUBTIME", "DOCPUBURL"};

    private static DocumentFactory getDocumentFactory() {
        if (m_oDocFactory == null) {
            m_oDocFactory = new DocumentFactory();
        }
        return m_oDocFactory;
    }

    private static HashMap getSystemFieldMap() {
        if (m_oSystemFieldMap == null) {
            m_oSystemFieldMap = new HashMap();
            m_oSystemFieldMap.put("_EDIT", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label1", "\u7f16\u8f91"));
            m_oSystemFieldMap.put("_PREVIEW", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label2", "\u9884\u89c8"));
            m_oSystemFieldMap.put("_DOCSTATUS", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label3", "\u6587\u6863\u72b6\u6001"));
            m_oSystemFieldMap.put("_DOCID", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label4", "\u6587\u6863\u7f16\u53f7"));
            m_oSystemFieldMap.put("INFOVIEWID", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label5", "\u8868\u5355\u7f16\u53f7"));
            m_oSystemFieldMap.put("DOCTITLE", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label6", "\u6587\u6863\u6807\u9898"));
            m_oSystemFieldMap.put(DEFAULT_TIMERANGE_FIELD, I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label7", "\u521b\u5efa\u65f6\u95f4"));
            m_oSystemFieldMap.put("CRUSER", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label8", "\u53d1\u7a3f\u4eba"));
            m_oSystemFieldMap.put("POSTUSER", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label9", "\u53d1\u7a3f\u4eba(\u5916\u7f51)"));
            m_oSystemFieldMap.put("ARCHIVESERIAL", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label10", "\u5b58\u6863\u7f16\u53f7"));
            m_oSystemFieldMap.put("POSITIONCODE", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label11", "\u67e5\u8be2\u7f16\u53f7"));
            m_oSystemFieldMap.put(FIELD_OPERATIONMARK, I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label12", "\u72b6\u6001"));
            m_oSystemFieldMap.put("DOCPUBTIME", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label13", "\u53d1\u5e03\u65f6\u95f4"));
            m_oSystemFieldMap.put("DOCPUBURL", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label14", "\u53d1\u5e03\u5730\u5740"));
        }
        return m_oSystemFieldMap;
    }

    public static String[] getFieldDisplay(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.lastIndexOf(58);
            if (n > 0) {
                stringArray2[i] = string.substring(n + 1);
                continue;
            }
            String string2 = (String)InfoViewQueryHelper.getSystemFieldMap().get(string);
            if (string2 == null) {
                string2 = string;
            }
            stringArray2[i] = string2;
        }
        return stringArray2;
    }

    private static boolean getBooleanValue(String string, boolean bl) {
        String string2 = string;
        if (CMyString.isEmpty(string2)) {
            return bl;
        }
        if ("true".equals(string2 = string2.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        try {
            int n = Integer.parseInt(string2);
            n = bl ? 1 : 0;
            return n != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
    }

    public static int getDocumentStatus(String string) throws WCMException {
        int n = Integer.parseInt(string);
        return DBManager.getDBManager().sqlExecuteIntQuery("select DocStatus from WCMChnlDoc where DocId=? and Modal=1", new int[]{n});
    }

    public static String getStatusName(int n) throws WCMException {
        Status status;
        if (n < 0) {
            n = -n;
        }
        if ((status = Status.findById(n)) == null) {
            return I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label15", "\u672a\u77e5");
        }
        return status.getDisp();
    }

    private static String[] getFieldNames(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("InfoviewId", 0);
        InfoView infoView = InfoView.findById(n);
        String string = methodContext.getValue("SelectFields");
        if (CMyString.isEmpty(string) && infoView != null) {
            string = infoView.getOutlineFields();
        }
        string = CMyString.showNull(string);
        String[] stringArray = null;
        stringArray = CMyString.isEmpty(string) ? m_aDefaultOutlineFields : string.split(",");
        return stringArray;
    }

    static Element createDataItem(String[] stringArray, HashMap hashMap) {
        DocumentFactory documentFactory = InfoViewQueryHelper.getDocumentFactory();
        Element element = documentFactory.createElement("dataitem");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Element element2 = documentFactory.createElement(string);
            element.add(element2);
            String string2 = (String)hashMap.get(string);
            if (string2 == null) {
                string2 = "";
            }
            element2.add(documentFactory.createCDATA(string2));
        }
        if (hashMap.get("DOCEDITURL") != null) {
            Element element3 = documentFactory.createElement("DOCEDITURL");
            element.add(element3);
            element3.add(documentFactory.createCDATA((String)hashMap.get("DOCEDITURL")));
        }
        return element;
    }

    static Document createDataSetDocument() {
        DocumentFactory documentFactory = InfoViewQueryHelper.getDocumentFactory();
        Document document = documentFactory.createDocument("UTF-8");
        Element element = documentFactory.createElement("dataset");
        document.setRootElement(element);
        return document;
    }

    private static Element createHeaderItem(String string, String string2) {
        DocumentFactory documentFactory = InfoViewQueryHelper.getDocumentFactory();
        Element element = documentFactory.createElement("field");
        element.add(documentFactory.createAttribute(element, "name", string));
        element.add(documentFactory.createAttribute(element, "desc", string2));
        return element;
    }

    static Element createDataHeader(String[] stringArray, String[] stringArray2) {
        DocumentFactory documentFactory = InfoViewQueryHelper.getDocumentFactory();
        Element element = documentFactory.createElement("dataheader");
        for (int i = 0; i < stringArray.length; ++i) {
            element.add(InfoViewQueryHelper.createHeaderItem(stringArray[i], stringArray2[i]));
        }
        return element;
    }

    public static void testCase1() {
        Document document = InfoViewQueryHelper.createDataSetDocument();
        Element element = document.getRootElement();
        String[] stringArray = new String[]{"field1", "field2", "field3"};
        String[] stringArray2 = new String[]{I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label16", "\u59d3\u540d"), I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label17", "\u5e74\u9f84"), I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label18", "\u6027\u522b")};
        Element element2 = InfoViewQueryHelper.createDataHeader(stringArray, stringArray2);
        element.add(element2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element3 = null;
        hashMap.put("field1", "gronlet1");
        hashMap.put("field2", "24");
        hashMap.put("field3", "1");
        element3 = InfoViewQueryHelper.createDataItem(stringArray, hashMap);
        element.add(element3);
        hashMap.clear();
        hashMap.put("field1", "gronlet2");
        hashMap.put("field2", "25");
        element3 = InfoViewQueryHelper.createDataItem(stringArray, hashMap);
        element.add(element3);
        hashMap.clear();
        hashMap.put("field1", "gronlet3");
        hashMap.put("field3", "1");
        element3 = InfoViewQueryHelper.createDataItem(stringArray, hashMap);
        element.add(element3);
        hashMap.clear();
        hashMap.put("field1", "gronlet4");
        hashMap.put("field2", "27");
        hashMap.put("field3", "1");
        element3 = InfoViewQueryHelper.createDataItem(stringArray, hashMap);
        element.add(element3);
        System.out.println(document.asXML());
        document.clearContent();
    }

    public static void main(String[] stringArray) {
        InfoViewQueryHelper.testCase1();
    }
}

