/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract.manifest;

import com.trs.components.infoview.extract.manifest.MenuArea;
import com.trs.components.infoview.extract.manifest.MenuButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;

public class View {
    private String m_sName;
    private String m_sCaption;
    private String m_sTransform;
    private String m_sXSLPrefix;
    private MenuArea m_oContextMenuArea;
    private HashMap m_oContextMenuMap;
    private HashMap m_oBind2EditIDMap;
    private String m_sViewWidth;
    private boolean m_zDefaultView;
    private String m_sNewTransform;
    private Document m_oDOM4JDocument;
    private int m_iTRSObjectID;

    View build(Element element) {
        Object object;
        Object object2;
        this.m_sName = element.attributeValue("name");
        this.m_sCaption = element.attributeValue("caption");
        this.m_sTransform = element.element("mainpane").attributeValue("transform");
        Element element2 = element.element("editing");
        if (element2 == null) {
            return this;
        }
        this.m_oBind2EditIDMap = new HashMap();
        Iterator iterator = element2.elementIterator("xmlToEdit");
        while (iterator.hasNext()) {
            int n;
            object2 = (Element)iterator.next();
            object = object2.attributeValue("name");
            String string = object2.attributeValue("item");
            if (string.charAt(0) == '/' && (n = string.indexOf(47, 1)) > 0) {
                string = string.substring(n + 1);
            }
            this.m_oBind2EditIDMap.put(string, object);
        }
        object2 = element.elementIterator("menuArea");
        while (object2.hasNext()) {
            object = new MenuArea();
            ((MenuArea)object).build((Element)object2.next());
            this.addMenuArea((MenuArea)object);
        }
        return this;
    }

    public String getCaption() {
        return this.m_sCaption;
    }

    public void setCaption(String string) {
        this.m_sCaption = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public String getTransform() {
        return this.m_sTransform;
    }

    public void setTransform(String string) {
        this.m_sTransform = string;
    }

    public void addMenuArea(MenuArea menuArea) {
        if (menuArea == null) {
            return;
        }
        if ("msoStructuralEditingContextMenu".equals(menuArea.getName())) {
            this.m_oContextMenuArea = menuArea;
            this.initContextMenuMap(menuArea);
        }
    }

    private void initContextMenuMap(MenuArea menuArea) {
        ArrayList arrayList = menuArea.getButton();
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        if (this.m_oContextMenuMap == null) {
            this.m_oContextMenuMap = new HashMap();
        }
        MenuButton menuButton = null;
        ArrayList<MenuButton> arrayList2 = null;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            menuButton = (MenuButton)arrayList.get(i);
            arrayList2 = (ArrayList<MenuButton>)this.m_oContextMenuMap.get(menuButton.getXMLToEdit());
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<MenuButton>();
                this.m_oContextMenuMap.put(menuButton.getXMLToEdit(), arrayList2);
            }
            arrayList2.add(menuButton);
        }
    }

    public ArrayList getContextMenuForBinding(String string) {
        if (string == null || this.m_oBind2EditIDMap == null) {
            return null;
        }
        String string2 = (String)this.m_oBind2EditIDMap.get(string);
        if (string2 == null) {
            return null;
        }
        return this.getContextMenuForXMLToEdit(string2);
    }

    public ArrayList getContextMenuForXMLToEdit(String string) {
        if (string == null || this.m_oContextMenuMap == null) {
            return null;
        }
        return (ArrayList)this.m_oContextMenuMap.get(string);
    }

    public MenuArea getContextMenuArea() {
        return this.m_oContextMenuArea;
    }

    public void setContextMenuArea(MenuArea menuArea) {
        this.m_oContextMenuArea = menuArea;
    }

    public HashMap getContextMenuMap() {
        return this.m_oContextMenuMap;
    }

    public void setContextMenuMap(HashMap hashMap) {
        this.m_oContextMenuMap = hashMap;
    }

    public String getViewWidth() {
        return this.m_sViewWidth;
    }

    public void setViewWidth(String string) {
        this.m_sViewWidth = string;
    }

    public boolean isDefaultView() {
        return this.m_zDefaultView;
    }

    public void setDefaultView(boolean bl) {
        this.m_zDefaultView = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("View::name=").append(this.m_sName);
        stringBuffer.append(",caption=").append(this.m_sCaption);
        stringBuffer.append(",transform=").append(this.m_sTransform);
        return stringBuffer.toString();
    }

    public String getNewTransform() {
        if (this.m_sNewTransform == null) {
            this.m_sNewTransform = System.currentTimeMillis() + this.m_sTransform;
        }
        return this.m_sNewTransform;
    }

    public void setNewTransform(String string) {
        this.m_sNewTransform = string;
    }

    public Document getDOM4JDocument() {
        return this.m_oDOM4JDocument;
    }

    public void setDOM4JDocument(Document document) {
        this.m_oDOM4JDocument = document;
    }

    public int getViewID() {
        return this.m_iTRSObjectID;
    }

    public void setTRSObjectID(int n) {
        this.m_iTRSObjectID = n;
    }

    public String getXSLPrefix() {
        return this.m_sXSLPrefix;
    }

    public void setXSLPrefix(String string) {
        this.m_sXSLPrefix = string;
    }
}

