/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.components.infoview.InfoViewHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class InfoviewXMLDataUpdator {
    protected static Logger logger = Logger.getLogger(InfoviewXMLDataUpdator.class);
    private List m_oComplexFieldDatas;
    private String m_sXMLContent = null;
    private Document m_oXMLDoc = null;
    private Hashtable m_hProperties = new Hashtable();
    private Hashtable m_hBakProperties = new Hashtable();
    private Hashtable m_hRepeatFieldProperties = new Hashtable();
    private HashMap m_hRepeatFieldOrder = new HashMap();
    private HashMap m_hRepeatGroupDataSize = new HashMap();
    private HashMap m_hAddRepeatGroupDataSize = new HashMap();
    private HashMap m_hRepeatFieldSize = new HashMap();
    private Hashtable m_hAddRepeatGroupData = new Hashtable();
    private Hashtable m_hAddRepeatGroup = new Hashtable();
    private List m_lDeleteFields = new ArrayList();

    public InfoviewXMLDataUpdator(String string) throws WCMException {
        this.m_sXMLContent = string;
        this.m_oXMLDoc = InfoViewHelper.parseToDocument(string);
    }

    public void setProperty(String string, String string2) {
        this.m_hProperties.put(string.trim().toUpperCase(), string2);
        this.m_hBakProperties.put(string.trim().toUpperCase(), string2);
    }

    private boolean containsProperty(String string) {
        return this.m_hProperties.containsKey(string.trim().toUpperCase());
    }

    private String getProperty(String string) {
        return (String)this.m_hProperties.get(string.trim().toUpperCase());
    }

    public void setRepeatField(String string, String string2, int n) throws WCMException {
        int n2 = this.getFieldInRepeatSize(string);
        if (n2 >= n) {
            this.m_hProperties.put(string.trim().toUpperCase(), string2);
            this.m_hRepeatFieldProperties.put(string.trim().toUpperCase() + ";" + n, string2);
            this.m_hRepeatFieldOrder.put(string.trim().toUpperCase(), String.valueOf(0));
        } else {
            this.setAddRepeatFieldValue(string, string2, n - n2);
        }
    }

    private void setAddRepeatFieldValue(String string, String string2, int n) {
        Enumeration enumeration = this.m_hAddRepeatGroupData.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            HashMap hashMap = (HashMap)this.m_hAddRepeatGroupData.get(string3);
            if (hashMap == null) {
                return;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                String[] stringArray = entry.toString().split("=");
                if (!stringArray[0].equals(string) || Integer.parseInt(string3.split(";")[1]) != n) continue;
                hashMap.put(string, string2);
            }
        }
    }

    private void addFieldOrder(String string) {
        int n = Integer.parseInt((String)this.m_hRepeatFieldOrder.get(string.trim().toUpperCase()));
        this.m_hRepeatFieldOrder.put(string.trim().toUpperCase(), String.valueOf(++n));
    }

    public List getFieldValue(String string) throws WCMException {
        ArrayList arrayList = new ArrayList();
        this.getElementFieldValue(string, arrayList);
        return arrayList;
    }

    public void addInfoViewField(String string, String string2) {
        this.m_hBakProperties.put(string.trim().toUpperCase(), string2);
    }

    public void addRepeatFieldLine(String string, HashMap hashMap) {
        String string2 = string.trim().toUpperCase();
        if (this.m_hAddRepeatGroupDataSize.containsKey(string2)) {
            int n = Integer.parseInt((String)this.m_hAddRepeatGroupDataSize.get(string2)) + 1;
            this.m_hAddRepeatGroupDataSize.put(string2, String.valueOf(n));
        } else {
            this.m_hAddRepeatGroupDataSize.put(string2, String.valueOf(1));
        }
        this.m_hAddRepeatGroupData.put(string2 + ";" + this.m_hAddRepeatGroupDataSize.get(string2), hashMap);
    }

    public void addRepeatFieldGroup(String string, HashMap hashMap) {
        this.m_hAddRepeatGroup.put(string, hashMap);
    }

    public void setRemoveField(String string, int n) {
        this.m_lDeleteFields.add(string + ";" + n);
    }

    public int getRepeatFieldSize(String string) {
        if (this.m_hRepeatGroupDataSize.containsKey(string.trim().toUpperCase())) {
            return Integer.parseInt((String)this.m_hRepeatGroupDataSize.get(string.trim().toUpperCase()));
        }
        int n = 0;
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return 0;
        }
        n = this.getRepeatFieldElementSize(element, string);
        this.m_hRepeatGroupDataSize.put(string.trim().toUpperCase(), String.valueOf(n));
        return n;
    }

    public int getAppenDixFieldSize(String string) {
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return 0;
        }
        if (element != null && element.elements(string) != null) {
            return element.elements(string).size();
        }
        return 0;
    }

    public void setAppendixField(String string, String string2, int n) {
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return;
        }
        if (element != null && element.elements(string) != null) {
            List list = element.elements(string);
            if (n > list.size() - 1) {
                return;
            }
            ((Element)list.get(n)).setText(string2);
        }
    }

    public int getNomalFieldSize(String string) {
        if (this.m_hRepeatFieldSize.containsKey(string)) {
            return Integer.parseInt((String)this.m_hRepeatFieldSize.get(string));
        }
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return 0;
        }
        int n = 0;
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            String string2;
            Element element2 = (Element)iterator.next();
            if (element2 == null || !string.equals(string2 = element2.getName())) continue;
            ++n;
        }
        this.m_hRepeatFieldSize.put(string, String.valueOf(n));
        return n;
    }

    public int getFieldInRepeatSize(String string) {
        if (this.m_hRepeatFieldSize.containsKey(string)) {
            return Integer.parseInt((String)this.m_hRepeatFieldSize.get(string));
        }
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return 0;
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = this.getFieldNode((Element)iterator.next(), string);
            if (element2 == null) continue;
            String string2 = element2.getParent().getName();
            int n = this.getRepeatFieldSize(string2);
            this.m_hRepeatFieldSize.put(string, String.valueOf(n));
            return n;
        }
        return 0;
    }

    private Element getFieldNode(Element element, String string) {
        if (element.getName().equals(string)) {
            return element;
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = this.getFieldNode((Element)iterator.next(), string);
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    public int getRepeatFieldElementSize(Element element, String string) {
        int n = 0;
        if (element != null) {
            List list = element.elements();
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                List list2 = element2.elements(string);
                if (list2.size() == 0) continue;
                n = list2.size();
            }
        }
        return n;
    }

    public String update(String[] stringArray) throws WCMException {
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return this.m_sXMLContent;
        }
        String[] stringArray2 = this.getNSPrefix(element, stringArray);
        if (stringArray2 == null) {
            stringArray2 = new String[]{element.getNamespacePrefix()};
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            this.addElementField((Element)iterator.next(), stringArray2);
        }
        this.insertOtherElementField(element);
        this.insertRepeatFieldGroup(element);
        this.removeField(element);
        return this.m_oXMLDoc.asXML();
    }

    private String[] getNSPrefix(Element element, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        List list = element.declaredNamespaces();
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!namespace.getURI().equals(stringArray[j])) continue;
                arrayList.add(namespace.getPrefix());
            }
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private void addElementField(Element element, String[] stringArray) throws WCMException {
        Object object;
        if (!this.acceptNamespace(element, stringArray)) {
            return;
        }
        String string = element.getName();
        if (this.acceptElement(element, stringArray) && this.containsProperty(string)) {
            object = element.node(0);
            if (this.m_hRepeatFieldOrder.containsKey(string.trim().toUpperCase())) {
                this.addFieldOrder(string);
                this.setRepeatFieldNodeValue(element, (Node)object);
            } else {
                this.setGeneralFieldValue(element, (Node)object);
            }
            this.m_hBakProperties.remove(string.trim().toUpperCase());
        }
        if (this.m_hAddRepeatGroupDataSize.containsKey(string.trim().toUpperCase())) {
            this.InsertRepeatFieldData(element);
        }
        object = element.elementIterator();
        while (object.hasNext()) {
            this.addElementField((Element)object.next(), stringArray);
        }
    }

    private void setRepeatFieldNodeValue(Element element, Node node) {
        String string = element.getName();
        int n = Integer.parseInt((String)this.m_hRepeatFieldOrder.get(string.trim().toUpperCase()));
        String string2 = string.trim().toUpperCase() + ";" + n;
        if (!this.m_hRepeatFieldProperties.containsKey(string2)) {
            return;
        }
        String string3 = (String)this.m_hRepeatFieldProperties.get(string2);
        this.setFieldValue(element, node, string3);
    }

    private void InsertRepeatFieldData(Element element) {
        Element element2 = element.getParent();
        String string = element.getName();
        String string2 = string.trim().toUpperCase();
        int n = Integer.parseInt((String)this.m_hAddRepeatGroupDataSize.get(string2));
        List list = element2.elements(string);
        Element element3 = null;
        Element element4 = null;
        int n2 = list.size();
        if (n2 > 0) {
            element4 = (Element)list.get(n2 - 1);
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                element3 = (Element)element4.clone();
                Iterator iterator = element3.elementIterator();
                while (iterator.hasNext()) {
                    Element element5 = (Element)iterator.next();
                    String string3 = string2 + ";" + (i + 1);
                    String string4 = this.m_hAddRepeatGroupData.get(string3) != null ? (((HashMap)this.m_hAddRepeatGroupData.get(string3)).containsKey(element5.getName()) ? (String)((HashMap)this.m_hAddRepeatGroupData.get(string3)).get(element5.getName()) : "") : "";
                    Node node = element5.node(0);
                    if (node.getText() != null && !node.getText().equals("")) {
                        bl = false;
                    }
                    this.setFieldValue(element5, node, string4);
                }
                element2.add(element3);
            }
            if (bl) {
                element2.remove(element4);
            }
        }
        this.m_hAddRepeatGroupDataSize.clear();
    }

    private void insertOtherElementField(Element element) {
        Enumeration enumeration = this.m_hBakProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.m_hBakProperties.get(string);
            Element element2 = DocumentHelper.createElement((String)("my:" + string));
            CDATA cDATA = DocumentHelper.createCDATA((String)string2);
            element2.add(cDATA);
            element.add(element2);
        }
    }

    private void insertRepeatFieldGroup(Element element) {
        Enumeration enumeration = this.m_hAddRepeatGroup.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = string.split("_");
            if (stringArray.length != 2) continue;
            Element element2 = DocumentHelper.createElement((String)("my:" + stringArray[0]));
            Element element3 = DocumentHelper.createElement((String)("my:" + stringArray[1]));
            element3.addAttribute("complex_field", "1");
            HashMap hashMap = (HashMap)this.m_hAddRepeatGroup.get(string);
            for (Map.Entry entry : hashMap.entrySet()) {
                String[] stringArray2 = entry.toString().split("=");
                String string2 = stringArray2.length == 2 ? stringArray2[1] : "";
                Element element4 = DocumentHelper.createElement((String)("my:" + stringArray2[0]));
                CDATA cDATA = DocumentHelper.createCDATA((String)string2);
                element4.add(cDATA);
                element3.add(element4);
            }
            element2.add(element3);
            element.add(element2);
        }
    }

    private void removeField(Element element) {
        if (this.m_lDeleteFields.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_lDeleteFields.size(); ++i) {
            String string = (String)this.m_lDeleteFields.get(i);
            String[] stringArray = string.split(";");
            int n = Integer.parseInt(stringArray[1]);
            String string2 = stringArray[0];
            boolean bl = false;
            if (string2.indexOf("_") < 0) {
                bl = this.removeChildElement(element, string2, n);
            } else {
                String[] stringArray2 = string2.split("_");
                Element element2 = element.element(stringArray2[0]);
                if (element2 == null) continue;
                bl = this.removeChildElement(element2, stringArray2[1], n);
            }
            if (!bl) continue;
            this.reduceSameRemoveFieldIndex(string2, n);
        }
    }

    private void reduceSameRemoveFieldIndex(String string, int n) {
        if (CMyString.isEmpty(string)) {
            return;
        }
        for (int i = 0; i < this.m_lDeleteFields.size(); ++i) {
            int n2;
            String[] stringArray = ((String)this.m_lDeleteFields.get(i)).split(";");
            String string2 = stringArray[0];
            if (!string.equals(string2) || n >= (n2 = Integer.parseInt(stringArray[1]))) continue;
            String string3 = string2 + ";" + --n2;
            this.m_lDeleteFields.set(i, string3);
        }
    }

    private boolean removeChildElement(Element element, String string, int n) {
        if (element == null || CMyString.isEmpty(string)) {
            return false;
        }
        List list = element.elements(string);
        if (list == null || n > list.size() || n < 1) {
            return false;
        }
        Element element2 = (Element)list.get(n - 1);
        if (element2 == null) {
            return false;
        }
        element2.detach();
        return true;
    }

    private void setGeneralFieldValue(Element element, Node node) {
        String string = element.getName();
        String string2 = this.getProperty(string);
        this.setFieldValue(element, node, string2);
    }

    private void setFieldValue(Element element, Node node, String string) {
        if (node != null && node.getNodeType() == 4) {
            node.setText(string);
        } else {
            element.setText(string);
        }
    }

    private void getElementFieldValue(String string, List list) throws WCMException {
        Element element = this.m_oXMLDoc.getRootElement();
        if (element == null) {
            return;
        }
        String[] stringArray = this.getNSPrefix(element, null);
        if (stringArray == null) {
            stringArray = new String[]{element.getNamespacePrefix()};
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            this.getElementField((Element)iterator.next(), stringArray, string, list);
        }
    }

    private void getElementField(Element element, String[] stringArray, String string, List list) throws WCMException {
        if (!this.acceptNamespace(element, stringArray)) {
            return;
        }
        if (element != null) {
            if (this.acceptElement(element, stringArray, string)) {
                if (element.getText() != null) {
                    list.add(element.getTextTrim());
                } else {
                    list.add("");
                }
            }
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                this.getElementField((Element)iterator.next(), stringArray, string, list);
            }
        }
    }

    private boolean acceptElement(Element element, String[] stringArray, String string) {
        if (element.hasMixedContent()) {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                if (!this.acceptNamespace((Element)iterator.next(), stringArray)) continue;
                return false;
            }
        }
        return element.getName().equalsIgnoreCase(string);
    }

    private boolean acceptElement(Element element, String[] stringArray) {
        if (element.hasMixedContent()) {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                if (!this.acceptNamespace((Element)iterator.next(), stringArray)) continue;
                return false;
            }
        }
        return this.m_hProperties.containsKey(element.getName().toUpperCase());
    }

    private boolean acceptNamespace(Element element, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        String string = element.getNamespacePrefix();
        if (string == null || string.length() <= 0) {
            return false;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public List getComplexFieldDatas() {
        if (this.m_oComplexFieldDatas == null) {
            this.m_oComplexFieldDatas = new ArrayList(5);
        }
        return this.m_oComplexFieldDatas;
    }

    public static void main(String[] stringArray) {
        try {
            String string = CMyFile.readFile("c:\\infoview_data.txt");
            System.out.println(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label1", "==============\u5904\u7406\u4e4b\u524d\u7684\u6570\u636e=================="));
            System.out.println(string);
            InfoviewXMLDataUpdator infoviewXMLDataUpdator = new InfoviewXMLDataUpdator(string);
            int n = infoviewXMLDataUpdator.getAppenDixFieldSize("\u9644\u4ef6_01");
            infoviewXMLDataUpdator.setAppendixField("\u9644\u4ef6_01", "lalal", 1);
            System.out.println("\u6700\u540e\u662f\u4ec0\u4e48\u5462------------" + infoviewXMLDataUpdator.update(null));
            System.out.println("==========================\u83b7\u53d6\u5230\u7684\u503c\u4e3a===============");
            List list = infoviewXMLDataUpdator.getFieldValue("\u5ba2\u6237\u7ecf\u7406");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
            infoviewXMLDataUpdator.setProperty(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label2", "\u5ba2\u6237\u7ecf\u7406"), I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label3", "test"));
            System.out.println(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label4", "==============\u5904\u7406\u540e\u7684\u6570\u636e=================="));
            infoviewXMLDataUpdator.setRepeatField("\u5e8f\u53f7", "200", 2);
            infoviewXMLDataUpdator.setRepeatField("\u5e8f\u53f7", "100", 1);
            infoviewXMLDataUpdator.setProperty("\u59d3\u540d", "\u5218\u7ea2\u6885");
            infoviewXMLDataUpdator.addInfoViewField("\u5355\u4f4d", "TRS");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("\u5e8f\u53f7", "new1");
            hashMap.put("\u4ea7\u54c1\u540d\u79f0", "new2");
            infoviewXMLDataUpdator.addRepeatFieldLine("group10", hashMap);
            infoviewXMLDataUpdator.addRepeatFieldGroup("group11_group12", hashMap);
            infoviewXMLDataUpdator.setRepeatField("\u5e8f\u53f7", "300", 3);
            System.out.println(infoviewXMLDataUpdator.update(null));
            System.out.println("==========================\u83b7\u53d6\u5230\u7684\u503c\u4e3a===============");
            List list2 = infoviewXMLDataUpdator.getFieldValue("\u5e8f\u53f7");
            for (int i = 0; i < list2.size(); ++i) {
                System.out.println("\u7b2c\u51e0\u4e2a\u5462=====" + list2.get(i));
            }
            List list3 = infoviewXMLDataUpdator.getFieldValue("\u5ba2\u6237\u7ecf\u7406");
            if (list3.get(0).equals("admin")) {
                infoviewXMLDataUpdator.setProperty("\u5ba2\u6237\u7ecf\u7406", "newadmin");
            }
            infoviewXMLDataUpdator.setRepeatField("\u4ea7\u54c1\u540d\u79f0", "portal", 1);
            infoviewXMLDataUpdator.addInfoViewField("\u65b0\u589e\u7684\u5b57\u6bb5", "new");
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("\u5e8f\u53f7", "3");
            hashMap2.put("\u7248\u672cBuild", "\u8868\u5355");
            infoviewXMLDataUpdator.addRepeatFieldLine("group10", hashMap2);
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap3.put("\u5e8f\u53f7", "4");
            hashMap3.put("\u7248\u672cBuild", "\u8868\u5355");
            infoviewXMLDataUpdator.addRepeatFieldLine("group10", hashMap3);
            infoviewXMLDataUpdator.setRepeatField("\u7248\u672cBuild", "61\u7684\u8868\u5355", 4);
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            hashMap4.put("\u59d3\u540d", "\u5218\u7ea2\u6885");
            hashMap4.put("\u6027\u522b", "\u4e0d\u7537\u4e0d\u5973");
            infoviewXMLDataUpdator.addRepeatFieldGroup("group11_group12", hashMap4);
            System.out.println("\u6700\u540e\u7684\u6570\u636e\u4e3a=========================================");
            System.out.println(infoviewXMLDataUpdator.update(null));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

