/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.infoview.PatternAnalyzer;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.DocReply;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.TRSMailer;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class InfoViewReplyNoticeSender {
    private static Logger s_logger = Logger.getLogger(InfoViewReplyNoticeSender.class);
    private InfoView m_oInfoView;
    private com.trs.components.wcm.content.persistent.Document m_oDocument;
    private DocReply m_oDocReply;
    private boolean m_zSendEmail;
    private boolean m_zSendMessage;
    private Document m_oXmlDocument;

    public InfoViewReplyNoticeSender(InfoView infoView, com.trs.components.wcm.content.persistent.Document document, DocReply docReply) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label1", "\u65e0\u6548\u7684\u8868\u5355\u5bf9\u8c61[null]!"));
        }
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label2", "\u65e0\u6548\u7684\u8868\u5355\u6587\u6863\u5bf9\u8c61[null]!"));
        }
        if (docReply == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label3", "\u65e0\u6548\u7684\u8868\u5355\u56de\u590d\u5bf9\u8c61[null]!"));
        }
        this.m_oInfoView = infoView;
        this.m_oDocument = document;
        this.m_oDocReply = docReply;
    }

    public void sendNotice() throws WCMException {
        if (!this.m_oInfoView.isReplyNoticeRequired()) {
            return;
        }
        String string = this.m_oInfoView.getNoticeRelatedField();
        if (CMyString.isEmpty(string)) {
            return;
        }
        try {
            this.m_oXmlDocument = DocumentHelper.parseText((String)this.m_oDocument.getContent());
        }
        catch (Exception exception) {
            throw new WCMException(154, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label4", "\u83b7\u53d6\u8868\u5355\u6587\u6863\u5185\u5bb9\u5931\u8d25!"));
        }
        User user = this.m_oDocument.getCrUser();
        String string2 = this.m_oDocReply.getContent();
        String string3 = this.m_oDocReply.getTitle();
        String string4 = this.m_oInfoView.getNoticeSubjectPattern();
        if (!CMyString.isEmpty(string4)) {
            PatternAnalyzer patternAnalyzer = new PatternAnalyzer(string4);
            patternAnalyzer.setDocument(this.m_oXmlDocument);
            patternAnalyzer.setCurrentUser(user);
            String string5 = patternAnalyzer.getAnalyzedResult();
            if (!CMyString.isEmpty(string5)) {
                string3 = string5;
            }
        }
        if (this.isSendEmail()) {
            this.sendEmail(string, string2, string3);
        }
        if (this.isSendMessage()) {
            this.sendMessage(user, string3, string2);
        }
    }

    private void sendMessage(User user, String string, String string2) throws WCMException {
        if (user == null) {
            return;
        }
        Message message = new Message();
        message.setTitle(string);
        message.setBody(string2);
        message.setReceivers(204, String.valueOf(user.getId()));
        message.setSendTypes("Message");
        MessageServer.send(message);
    }

    private void sendEmail(String string, String string2, String string3) throws WCMException {
        String string4;
        User user = this.m_oDocument.getCrUser();
        if ("${::user}".equals(string)) {
            if (user == null) {
                return;
            }
            string = user.getEmail();
        } else {
            string4 = this.m_oXmlDocument.selectSingleNode("//" + string);
            if (string4 == null) {
                return;
            }
            string = string4.getText();
        }
        string4 = this.m_oInfoView.getNoticeContentPattern();
        if (!CMyString.isEmpty(string4)) {
            string2 = CMyString.replaceStr(string4, "${mailcontent}", CMyString.transDisplay(string2));
        }
        String string5 = "";
        try {
            string5 = ConfigServer.getServer().getSysConfigValue("MAIL_SENDER", "");
        }
        catch (Exception exception) {
            s_logger.error((Object)"failed to get mail sender config!", (Throwable)exception);
        }
        CMyEmail cMyEmail = new CMyEmail();
        cMyEmail.setFrom(string5);
        cMyEmail.setTo(string);
        cMyEmail.setSubject(string3);
        cMyEmail.setBody(string2);
        cMyEmail.setMailFormat(1);
        TRSMailer tRSMailer = new TRSMailer();
        try {
            tRSMailer.send(cMyEmail);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(InfoViewReplyNoticeSender.class, "InfoViewReplyNoticeSender.label5", "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25!"), cMyException);
        }
    }

    public static void main(String[] stringArray) {
    }

    public final boolean isSendEmail() {
        return this.m_zSendEmail;
    }

    public final void setSendEmail(boolean bl) {
        this.m_zSendEmail = bl;
    }

    public final boolean isSendMessage() {
        return this.m_zSendMessage;
    }

    public final void setSendMessage(boolean bl) {
        this.m_zSendMessage = bl;
    }
}

