/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewEmploy;
import com.trs.components.infoview.persistent.InfoViewEmploys;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;
import java.util.List;

public class InfoViewEmployMgr {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public int clearByInfoView(InfoView infoView) throws WCMException {
        if (infoView == null) {
            return 0;
        }
        return this.clearByInfoView(infoView.getId());
    }

    public int clearByInfoView(int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "InfoViewID=?", "");
        wCMFilter.addSearchValues(0, n);
        InfoViewEmploys infoViewEmploys = new InfoViewEmploys(this.getLoginUser());
        infoViewEmploys.open(wCMFilter);
        int n2 = infoViewEmploys.size();
        infoViewEmploys.removeAll(true);
        return n2;
    }

    public int clearByEmployer(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            return 0;
        }
        return this.clearByEmployer(cMSObj.getWCMType(), cMSObj.getId());
    }

    public int clearByEmployer(int n, int n2) throws WCMException {
        String string = "EMPLOYERID=? AND EMPLOYERTYPE=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, n2);
        wCMFilter.addSearchValues(1, n);
        InfoViewEmploys infoViewEmploys = new InfoViewEmploys(this.getLoginUser());
        infoViewEmploys.open(wCMFilter);
        int n3 = infoViewEmploys.size();
        infoViewEmploys.removeAll(true);
        return n3;
    }

    public List getInfoViewEmployers(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u83b7\u53d6\u5176\u4f7f\u7528\u4f4d\u7f6e!"));
        }
        return this.getInfoViewEmployers(infoView.getId());
    }

    public List getInfoViewEmployers(int n) throws WCMException {
        return this.getInfoViewEmployers(n, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getInfoViewEmployers(int n, WCMFilter wCMFilter) throws WCMException {
        ArrayList<CMSObj> arrayList = null;
        BaseObjs baseObjs = null;
        try {
            try {
                String string = "InfoViewID=" + n;
                WCMFilter wCMFilter2 = new WCMFilter("", string, "");
                if (wCMFilter != null) {
                    wCMFilter2.mergeWith(wCMFilter);
                }
                baseObjs = new InfoViewEmploys(this.getLoginUser());
                baseObjs.open(wCMFilter2);
                arrayList = new ArrayList<CMSObj>(baseObjs.size());
                for (int i = 0; i < baseObjs.size(); ++i) {
                    InfoViewEmploy infoViewEmploy = (InfoViewEmploy)baseObjs.getAt(i);
                    if (infoViewEmploy == null) continue;
                    arrayList.add(infoViewEmploy.getEmployer());
                }
                Object var10_10 = null;
                if (baseObjs == null) return arrayList;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label2", "\u83b7\u53d6\u8868\u5355\u7684\u4f7f\u7528\u573a\u6240\u96c6\u5408\u51fa\u9519!"), exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (baseObjs == null) throw throwable;
            baseObjs.clear();
            throw throwable;
        }
        baseObjs.clear();
        return arrayList;
    }

    public List getEmployedInfoViews(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label3", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        return this.getEmployedInfoViews(cMSObj.getWCMType(), cMSObj.getId());
    }

    public List getEmployedInfoViews(int n, int n2) throws WCMException {
        return this.getEmployedInfoViews(n, n2, null);
    }

    public List getEmployedInfoViews(int n, int n2, WCMFilter wCMFilter) throws WCMException {
        ArrayList<InfoView> arrayList = null;
        InfoViewEmploys infoViewEmploys = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("EMPLOYERID=").append(n2);
            stringBuffer.append(" AND EMPLOYERTYPE=").append(n);
            WCMFilter wCMFilter2 = new WCMFilter("", stringBuffer.toString(), "");
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            infoViewEmploys = new InfoViewEmploys(this.getLoginUser());
            infoViewEmploys.open(wCMFilter2);
            arrayList = new ArrayList<InfoView>(infoViewEmploys.size());
            for (int i = 0; i < infoViewEmploys.size(); ++i) {
                InfoViewEmploy infoViewEmploy = (InfoViewEmploy)infoViewEmploys.getAt(i);
                if (infoViewEmploy == null) continue;
                arrayList.add(infoViewEmploy.getInfoView());
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", exception);
        }
        return arrayList;
    }

    public void setEmployedInfoView(CMSObj cMSObj, int n) throws WCMException {
        int[] nArray = new int[]{n};
        this.setEmployedInfoViews(cMSObj, nArray);
    }

    public void setEmployedInfoViews(CMSObj cMSObj, int[] nArray) throws WCMException {
        InfoViewEmploy infoViewEmploy;
        int n;
        int n2;
        if (nArray.length < 1) {
            this.clearByEmployer(cMSObj);
            return;
        }
        User user = ContextHelper.getLoginUser();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EMPLOYERID=").append(cMSObj.getId());
        stringBuffer.append(" AND EMPLOYERTYPE=").append(cMSObj.getWCMType());
        WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "");
        InfoViewEmploys infoViewEmploys = new InfoViewEmploys(user);
        infoViewEmploys.open(wCMFilter);
        for (n2 = 0; n2 < infoViewEmploys.size(); ++n2) {
            n = 0;
            infoViewEmploy = (InfoViewEmploy)infoViewEmploys.getAt(n2);
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                if (infoViewEmploy.getInfoViewId() != n3) continue;
                n = 1;
                nArray[i] = 0;
            }
            if (n != 0) continue;
            infoViewEmploy.delete(user);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n <= 0) continue;
            infoViewEmploy = new InfoViewEmploy();
            infoViewEmploy.setEmployer(cMSObj);
            infoViewEmploy.setInfoViewId(n);
            infoViewEmploy.save(user);
        }
    }
}

