/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.publish.tagparser.WCMTagParserLogoBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;

public class WCMTagParserSpecialAppendix
extends BaseTagParser {
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_SpecialAppendix");
            tBI.setDesc("TRS_SpecialAppendix");
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FILENAME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("URLISABS");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        IPublishFolder iPublishFolder = publishTagContext.getUpperFolder();
        if (iPublishFolder == null) {
            return null;
        }
        String string = publishTagContext.getAttribute("FILENAME");
        String string2 = this.getFileFullName(string);
        this.distributeFile(publishTagContext, iPublishFolder, string2);
        boolean bl = "TRUE".equalsIgnoreCase(publishTagContext.getAttribute("URLISABS"));
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        String string3 = bl ? (publishTagContext.isPreview() ? publishPathCompass.getPreviewHttpPath(iPublishFolder) : publishPathCompass.getAbsoluteHttpPath(iPublishFolder)) : "./";
        return new String[]{string3 + string};
    }

    private String getFileFullName(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        String string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        if (!CMyFile.fileExists(string2)) {
            return null;
        }
        return string2;
    }

    private boolean distributeFile(PublishTagContext publishTagContext, IPublishFolder iPublishFolder, String string) throws WCMException {
        boolean bl;
        if (iPublishFolder == null) {
            return false;
        }
        if (!CMyFile.fileExists(string)) {
            publishTagContext.addWarning(iPublishFolder.getInfo() + "-appendix", iPublishFolder.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label1", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + iPublishFolder.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + string + "]");
            return false;
        }
        String string2 = CMyFile.extractFileName(string);
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        String string3 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishFolder, bl = publishTagContext.isPreview()), File.separatorChar) + File.separatorChar;
        if (CMyFile.fileExists(string3 + string2)) {
            return true;
        }
        PublishSyncGlobalTuner.insureLocalPathExists(string3);
        try {
            CMyFile.copyFile(string, string3 + string2);
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
            publishTagContext.addWarning(iPublishFolder.getInfo() + "-appendix", iPublishFolder.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label3", "\u62f7\u8d1d(") + iPublishFolder.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684\u9644\u4ef6[") + string2 + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label4", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(cMyException));
        }
        if (!bl) {
            publishTagContext.getFileDistributeShip().distributeFile(string, iPublishFolder, null, true);
        }
        return true;
    }

    private class TBI
    extends TagBeanInfo {
        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
        }
    }
}

