/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class WCMTagParserResources
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(WCMTagParserResources.class);
    private static String[] designResources = new String[]{"layout/default.css", "css/widget4common.css", "css/widget4design.css", "css/common.css", "../js/easyversion/lightbase.js", "../js/easyversion/extrender.js", "../js/easyversion/elementmore.js", "js/adapter4Top.js", "js/data.js", "dataopers4chnl.js", "dataopers4doc.js", "js/state.js", "js/widget.js", "js/drag.js", "js/layout.js", "js/column.js", "page.js"};
    private static String[] publishResources = new String[]{"layout/default.css", "css/widget4common.css", "css/common.css", "../js/easyversion/lightbase.js"};
    private static final String DESIGN_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/design/");
    private static String PUBLISH_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/publish/");
    private static String COMMON_RESOURCE_DIR = WCMTagParserResources.getLocalFormatPath("ext-res/common/");
    private String sourceLocalBasePath = "D:/workspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/app/special/";
    private String publishLocalBasePath;
    private String publishHttpBasePath;
    private String publishResourceDir = "images/resources";
    private IPublishFolder folder;
    private PublishTagContext context;
    private boolean isVisualParseMode;
    private Comparator compartor = new Comparator(){

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return file.getName().compareTo(file2.getName());
        }
    };
    private static TagBeanInfo s_TagBeanInfo = null;

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.context = publishTagContext;
        this.folder = this.context.getRoot();
        this.isVisualParseMode = TagParseHelper.isVisualParseMode(this.context);
        StringBuffer stringBuffer = new StringBuffer(300);
        this.initSourceLocalBasePath();
        this.initPublishBasePath();
        if (this.isVisualParseMode) {
            this.addResources(this.sourceLocalBasePath, designResources, stringBuffer);
            this.addResources(this.sourceLocalBasePath + COMMON_RESOURCE_DIR, stringBuffer);
            this.addResources(this.sourceLocalBasePath + DESIGN_RESOURCE_DIR, stringBuffer);
        } else {
            this.addResources(this.sourceLocalBasePath, publishResources, stringBuffer);
            this.addResources(this.sourceLocalBasePath + COMMON_RESOURCE_DIR, stringBuffer);
            this.addResources(this.sourceLocalBasePath + PUBLISH_RESOURCE_DIR, stringBuffer);
        }
        return new String[]{stringBuffer.toString()};
    }

    private void initSourceLocalBasePath() throws WCMException {
        this.sourceLocalBasePath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.sourceLocalBasePath = WCMTagParserResources.getLocalFormatPath(this.sourceLocalBasePath);
        this.sourceLocalBasePath = CMyString.setStrEndWith(this.sourceLocalBasePath, File.separatorChar) + WCMTagParserResources.getLocalFormatPath("app/special/");
    }

    private static String getLocalFormatPath(String string) {
        String string2;
        String string3;
        if (CMyString.isEmpty(string)) {
            return "";
        }
        if (File.separatorChar == '/') {
            string3 = "\\\\";
            string2 = "/";
        } else {
            string3 = "/";
            string2 = "\\\\";
        }
        return string.replaceAll(string3, string2);
    }

    private void initPublishBasePath() throws WCMException {
        if (this.publishLocalBasePath != null) {
            return;
        }
        PublishPathCompass publishPathCompass = this.context.getPathCompass();
        this.publishLocalBasePath = this.context.isPreview() ? publishPathCompass.getPreviewLocalPath(this.folder) : publishPathCompass.getPublishLocalPath(this.folder);
        this.publishLocalBasePath = this.publishLocalBasePath + this.publishResourceDir + File.separator;
        boolean bl = this.context.getAttribute("UrlIsAbs", false);
        this.publishHttpBasePath = bl ? (this.context.isPreview() ? publishPathCompass.getPreviewHttpPath(this.folder) : publishPathCompass.getAbsoluteHttpPath(this.folder)) : HtmlUtil.calRelativePath(publishPathCompass.getAbsoluteHttpPath(this.folder), this.context.getPageHttpPath());
        this.publishHttpBasePath = this.publishHttpBasePath + this.publishResourceDir + File.separator;
    }

    private void addResources(String string, StringBuffer stringBuffer) throws WCMException {
        File file = new File(string);
        if (!(file.exists() && file.canRead() && file.isDirectory())) {
            return;
        }
        File[] fileArray = file.listFiles();
        Arrays.sort(fileArray, this.compartor);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.addResources(fileArray[i].getAbsolutePath(), stringBuffer);
                continue;
            }
            this.addResource0(fileArray[i], stringBuffer);
        }
    }

    private void addResources(String string, String[] stringArray, StringBuffer stringBuffer) throws WCMException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addResource0(new File(string + stringArray[i]), stringBuffer);
        }
    }

    private void addResource0(File file, StringBuffer stringBuffer) throws WCMException {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return;
        }
        String string = this.copyToPublishResourceDirectory(file);
        if (string == null) {
            return;
        }
        if (string.endsWith(".js")) {
            stringBuffer.append("<script language=\"javascript\" src=\"");
            stringBuffer.append(this.getDstResourcePath(new File(string)));
            stringBuffer.append("\" commonresource=\"1\"");
            stringBuffer.append("\" charset=\"utf-8\"");
            stringBuffer.append(" type=\"text/javascript\"></script>");
            stringBuffer.append("\n");
        } else if (string.endsWith(".css")) {
            stringBuffer.append("<link href=\"");
            stringBuffer.append(this.getDstResourcePath(new File(string)));
            stringBuffer.append("\" commonresource=\"1\"");
            stringBuffer.append("\" charset=\"utf-8\"");
            stringBuffer.append(" rel=\"stylesheet\" type=\"text/css\" />");
            stringBuffer.append("\n");
        }
    }

    private String getDstResourcePath(File file) throws WCMException {
        if (this.isVisualParseMode) {
            return file.getPath().replaceAll("\\\\", "/").substring(this.sourceLocalBasePath.length());
        }
        String string = file.getAbsolutePath();
        return (this.publishHttpBasePath + string.substring(this.publishLocalBasePath.length())).replaceAll("\\\\", "/");
    }

    private String copyToPublishResourceDirectory(File file) throws WCMException {
        long l;
        long l2;
        if (!file.exists()) {
            return null;
        }
        if (this.isVisualParseMode) {
            return file.getAbsolutePath();
        }
        String string = this.extractDirectoryStructure(file);
        File file2 = new File(string + file.getName());
        if (file2.exists() && (l2 = file.lastModified()) <= (l = file2.lastModified())) {
            return file2.getAbsolutePath();
        }
        PublishSyncGlobalTuner.insureLocalPathExists(string);
        try {
            CMyFile.copyFile(file.getAbsolutePath(), file2.getAbsolutePath());
        }
        catch (CMyException cMyException) {
            logger.warn((Object)("\u62f7\u8d1d\u6587\u4ef6[" + file.getAbsolutePath() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)cMyException);
            this.context.addWarning("\u62f7\u8d1d\u6587\u4ef6[" + file.getAbsolutePath() + "]\u53d1\u751f\u5f02\u5e38:" + CMyException.getStackTraceText(cMyException));
        }
        if (!this.context.isPreview()) {
            String string2 = string.substring(this.publishLocalBasePath.length());
            this.context.getFileDistributeShip().distributeFile(file.getAbsolutePath(), this.folder, this.publishResourceDir + "/" + string2, false);
        }
        return file2.getAbsolutePath();
    }

    private String extractDirectoryStructure(File file) {
        String string = file.getAbsolutePath();
        String[] stringArray = new String[]{COMMON_RESOURCE_DIR, DESIGN_RESOURCE_DIR, PUBLISH_RESOURCE_DIR};
        String string2 = this.publishLocalBasePath;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = this.sourceLocalBasePath + stringArray[i];
            if (!string.startsWith(string3)) continue;
            string2 = string2 + CMyFile.extractFilePath(string).substring(string3.length());
            break;
        }
        return string2;
    }

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("URLISABS");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    private class TBI
    extends TagBeanInfo {
        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
        }
    }
}

