/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.widget.tagparser.WCMTagParserBaseOperation;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserDocOperation
extends WCMTagParserBaseOperation {
    private static Logger logger = Logger.getLogger(WCMTagParserDocOperation.class);
    private static TagBeanInfo s_TagBeanInfo = null;
    private static final int DOC_RECID = 1;
    private static final int DOC_RIGHTVALUE = 2;
    private static final int DOC_ORDER = 3;
    private static final int DOC_CHANNELID = 4;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            WCMTagParserBaseOperation.TBI tBI = new WCMTagParserBaseOperation.TBI();
            tBI.setName("TRS_DocOperation");
            tBI.setDesc("TRS_DocOperation");
            tBI.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RightValue");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ATTRIBUTES");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("DocTitle,RecId,ChannelId");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRACLS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    protected String parseHostSpecialProperty(int n, PublishTagContext publishTagContext) throws WCMException {
        if (this.m_host == null) {
            logger.error((Object)(publishTagContext.getTagItem() + "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173\u6587\u6863\u6ca1\u6709\u627e\u5230\uff01"));
            return null;
        }
        Document document = (Document)this.m_host;
        IPublishFolder iPublishFolder = publishTagContext.getUpperFolder();
        Channel channel = (Channel)iPublishFolder.getSubstance();
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(document, channel);
        if (chnlDoc == null) {
            chnlDoc = ChnlDoc.findByDocument(document);
        }
        String string = chnlDoc.getPropertyAsString("RECID");
        User user = ContextHelper.getLoginUser();
        switch (n) {
            case 1: {
                return string;
            }
            case 2: {
                RightValue rightValue = this.getRightValue(user, document, channel);
                return rightValue.toString();
            }
            case 3: {
                return String.valueOf(chnlDoc.getDocOrder());
            }
            case 4: {
                return String.valueOf(channel.getId());
            }
        }
        return null;
    }

    protected void registerHostSpecialAttributes() {
        this.registerHostSpecialAttribute("RIGHTVALUE", 2);
        this.registerHostSpecialAttribute("RECID", 1);
        this.registerHostSpecialAttribute("DOCORDER", 3);
        this.registerHostSpecialAttribute("CHANNELID", 4);
    }

    protected String getDefaultField() {
        return "DocTitle,RecId,ChannelId";
    }

    private RightValue getRightValue(User user, Document document, Channel channel) throws WCMException {
        String string = document.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bl2 = bl && !CMyString.isEmpty(string) && !string.equalsIgnoreCase("RESERVED_FORCED_END") && !string.equals(I18NMessage.get(ViewDocument.class, "ViewDocument.label8", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] nArray = WCMRightTypes.getRemoveRightIndexs();
        boolean bl3 = user.getName().equalsIgnoreCase(document.getCrUserName());
        if (this.isRightDefined(document)) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(user, 605, document.getId(), true);
                this.addOwnerValue(rightValue, bl3);
                if (bl2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        rightValue.setBit(nArray[i], false);
                    }
                }
                return rightValue;
            }
            catch (WCMException wCMException) {
                throw new WCMException(1100, I18NMessage.get(ViewDocument.class, "ViewDocument.label9", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", wCMException);
            }
        }
        if (user.isAdministrator()) {
            RightValue rightValue = RightValue.getAdministratorRightValue();
            if (bl2) {
                for (int i = 0; i < nArray.length; ++i) {
                    rightValue.setBit(nArray[i], false);
                }
            }
            return rightValue;
        }
        Channel channel2 = document.getChannel();
        RightValue rightValue = new RightValue();
        RightValue rightValue2 = this.getChannelRightValue(user, channel);
        if (channel2.getId() == channel.getId()) {
            rightValue = rightValue2;
        } else {
            RightValue rightValue3 = this.getChannelRightValue(user, channel2);
            rightValue.copy(rightValue3);
            int[] nArray2 = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(channel.getSiteId());
            for (int i = 0; i < nArray2.length; ++i) {
                int n = nArray2[i];
                rightValue.setBit(n, rightValue2.getBit(n));
            }
        }
        this.addOwnerValue(rightValue, bl3);
        if (bl2) {
            for (int i = 0; i < nArray.length; ++i) {
                rightValue.setBit(nArray[i], false);
            }
        }
        return rightValue;
    }

    private void addOwnerValue(RightValue rightValue, boolean bl) {
        if (!bl) {
            return;
        }
        int[] nArray = DocumentAuthServer.INDEXES_OWNER_HAS;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            rightValue.setBit(n, true);
        }
    }

    private boolean isRightDefined(Document document) throws WCMException {
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return rightCacheMgr.isExistsRight(605, document.getDocId());
    }
}

