/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.widget.tagparser.WCMTagParserBaseOperation;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserChannel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class WCMTagParserDocInChnlOperation
extends WCMTagParserBaseOperation {
    private static Logger logger = Logger.getLogger(WCMTagParserChannel.class);
    private static TagBeanInfo s_TagBeanInfo = null;
    private static final int CHNL_DESC = 100;
    private static final int CHNL_RIGHTVALUE = 101;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            WCMTagParserBaseOperation.TBI tBI = new WCMTagParserBaseOperation.TBI();
            tBI.setName("TRS_DocInChnlOperation");
            tBI.setDesc("TRS_DocInChnlOperation");
            tBI.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("OWNER");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RightValue");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ATTRIBUTES");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("CHNLDESC");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRACLS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    protected String parseHostSpecialProperty(int n, PublishTagContext publishTagContext) throws WCMException {
        if (this.m_host == null) {
            logger.error((Object)(publishTagContext.getTagItem() + "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173\u9891\u9053\u6ca1\u6709\u627e\u5230\uff01"));
            return null;
        }
        BaseChannel baseChannel = (BaseChannel)this.m_host;
        switch (n) {
            case 100: {
                String string = baseChannel.getDesc();
                if (string == null || (string = string.trim()).length() <= 0) {
                    string = baseChannel.getName();
                }
                return this.parseProperty(string, publishTagContext);
            }
            case 101: {
                User user = ContextHelper.getLoginUser();
                return this.getChannelRightValue(user, baseChannel).toString();
            }
        }
        return null;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        this.m_host = WCMTagParserHelper.findFolderHost(publishTagContext.getTagItem(), publishTagContext, true);
        if (this.m_host == null) {
            this.m_host = super.findHost(publishTagContext);
        }
        if (!(this.m_host instanceof Channel)) {
            this.m_host = this.getDefaultChannel();
            if (this.m_host == null) {
                throw new WCMException(200007, "\u5f53\u524d\u6a21\u677f\u89e3\u6790\u65f6\uff0c\u5728\u975e\u680f\u76ee\u4e0a\u4e0b\u6587\u73af\u5883\u4e0b\u4f7f\u7528\u680f\u76ee\u7f6e\u6807\uff0c\u4ece\u800c\u5bfc\u81f4\u51fa\u73b0\u4e86\u9519\u8bef\uff0c\u53ef\u4ee5\u5728\u7cfb\u7edf\u914d\u7f6e\u6dfb\u52a0\u9ed8\u8ba4\u680f\u76ee\u914d\u7f6e\u9879(SPECIAL_DEFAULT_CHANNELID)\u89e3\u51b3\u8be5\u95ee\u9898");
            }
            publishTagContext.setUpperHost(PublishElementFactory.lookupElement(this.m_host.getWCMType(), this.m_host.getId()));
        }
        return this.m_host;
    }

    public boolean hasSuperRight(BaseChannel baseChannel, CMSObj cMSObj) throws WCMException {
        switch (cMSObj.getWCMType()) {
            case 204: {
                User user = (User)cMSObj;
                if (user.isAdministrator()) {
                    return true;
                }
                if (baseChannel == null || !user.getName().equalsIgnoreCase(baseChannel.getCrUserName())) break;
                return true;
            }
            case 203: {
                Role role = (Role)cMSObj;
                if (!role.isAdministrators()) break;
                return true;
            }
        }
        return false;
    }

    protected void registerHostSpecialAttributes() {
        this.registerHostSpecialAttribute("CHNLDESC", 100);
        this.registerHostSpecialAttribute("RightValue", 101);
    }

    protected String getDefaultField() {
        return "CHNLDESC";
    }
}

