/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.IWidgetServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.Widgets;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.webframework.context.MethodContext;

public class WidgetServiceProvider
implements IWidgetServiceProvider {
    private IWidgetMgr m_oIWidgetMgr = (IWidgetMgr)DreamFactory.createObjectById("IWidgetMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(MethodContext methodContext) throws Exception {
        String string;
        User user = this.getLoginUser();
        Widgets widgets = Widgets.findByIds(user, string = methodContext.getObjectIds());
        if (widgets == null || widgets.size() == 0) {
            throw new WCMException(200006, "\u6ca1\u6709\u8981\u5220\u9664\u7684\u8d44\u6e90.");
        }
        int n = widgets.size();
        for (int i = 0; i < n; ++i) {
            Widget widget = (Widget)widgets.getAt(i);
            if (widget == null) continue;
            boolean bl = SpecialAuthServer.hasRight(user, widget, 23);
            if (!bl) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8d44\u6e90[" + widget.getWname() + "]\u3002");
            }
            this.m_oIWidgetMgr.delete(user, widget);
        }
    }

    public Object query(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("WidgetType", 0);
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        WCMFilter wCMFilter2 = new WCMFilter();
        if (n != 0) {
            wCMFilter2.addSearchValues(n);
            wCMFilter2.setWhere("WidgetType in (0,?)");
        }
        wCMFilter.mergeWith(wCMFilter2);
        Widgets widgets = this.m_oIWidgetMgr.query(user, wCMFilter);
        for (int i = widgets.size() - 1; i >= 0; --i) {
            boolean bl;
            Widget widget = (Widget)widgets.getAt(i);
            if (widget == null || (bl = SpecialAuthServer.hasRight(user, widget, 24))) continue;
            widgets.remove(widget, false);
        }
        return widgets;
    }

    public int save(MethodContext methodContext) throws Exception {
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getObjectId();
        Widget widget = null;
        widget = n2 > 0 ? Widget.findById(n2) : new Widget();
        boolean bl = SpecialAuthServer.hasRight(user, widget, n = n2 > 0 ? 22 : 21);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (n2 > 0 ? "\u4fee\u6539\u8d44\u6e90[" + widget.getWname() + "]\u3002" : "\u65b0\u5efa\u8d44\u6e90\u3002"));
        }
        String[] stringArray = new String[]{"WidgetId"};
        widget = (Widget)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, widget, stringArray);
        this.m_oIWidgetMgr.saveWidget(user, widget);
        return widget.getId();
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Exception {
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGET", "WNAME=? and WIDGETID<>?", "", "WIDGETID");
        wCMFilter.addSearchValues(methodContext.getValue("widgetName"));
        wCMFilter.addSearchValues(methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public String importWidgets(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ImportFile");
        int n = methodContext.getValue("ImportMode", 1);
        WCMAJAXServiceHelper.validateFile(string);
        boolean bl = SpecialAuthServer.hasRight(user, Widget.createNewInstance(), 21);
        if (!bl) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u8d44\u6e90\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u8d44\u6e90");
        }
        return this.m_oIWidgetMgr.importWidgets(string, n).toJSONXML();
    }

    public String export(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        Widgets widgets = Widgets.findByIds(user, string);
        for (int i = widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)widgets.getAt(i);
            if (widget == null || SpecialAuthServer.hasRight(user, widget, 24)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8d44\u6e90");
        }
        return this.m_oIWidgetMgr.export(widgets);
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }
}

