/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.special.Special;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecialAuthServer {
    private static Logger logger;
    private static final int[] SPECIAL_INDEX_RANGE;
    public static final int SPECIAL_ADD = 1;
    public static final int SPECIAL_EDIT = 2;
    public static final int SPECIAL_DELETE = 3;
    public static final int SPECIAL_BROWSE = 4;
    public static final int SPECIAL_PUBLISH = 5;
    private static final int[] STYLE_INDEX_RANGE;
    public static final int STYLE_ADD = 11;
    public static final int STYLE_EDIT = 12;
    public static final int STYLE_DELETE = 13;
    public static final int STYLE_BROWSE = 14;
    private static final int[] WIDGET_INDEX_RANGE;
    public static final int WIDGET_ADD = 21;
    public static final int WIDGET_EDIT = 22;
    public static final int WIDGET_DELETE = 23;
    public static final int WIDGET_BROWSE = 24;
    private static final int[] EVERYONE_HAS_RIGHTINDEX;
    private static final String SPECIAL_ROLE = "\u4e13\u9898\u7ef4\u62a4\u4eba\u5458";
    private static final String SPECIAL_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u4e13\u9898\u7ef4\u62a4\u4eba\u5458";
    private static final String STYLE_ROLE = "\u98ce\u683c\u7ef4\u62a4\u4eba\u5458";
    private static final String STYLE_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u98ce\u683c\u7ef4\u62a4\u4eba\u5458";
    private static final String WIDGET_ROLE = "\u8d44\u6e90\u7ef4\u62a4\u4eba\u5458";
    private static final String WIDGET_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u8d44\u6e90\u7ef4\u62a4\u4eba\u5458";
    private static Map objRoleMapping;
    private static Map objRoleMappingForSameGroup;
    private static Map objRightValueMapping;
    private static final RightValue EVERYONE_HAS_RIGHT_VALUE;
    private static final RightValue SPECIAL_RIGHT_VALUE;
    private static final RightValue WIDGET_RIGHT_VALUE;
    private static final RightValue STYLE_RIGHT_VALUE;

    public static boolean hasRight(CMSObj cMSObj, CMSObj cMSObj2, int n) throws WCMException {
        User user = (User)cMSObj;
        if (user.isAdministrator()) {
            return true;
        }
        if (user.getName().equalsIgnoreCase(cMSObj2.getCrUserName())) {
            return true;
        }
        for (int i = 0; i < EVERYONE_HAS_RIGHTINDEX.length; ++i) {
            if (EVERYONE_HAS_RIGHTINDEX[i] != n) continue;
            return true;
        }
        Role role = (Role)objRoleMapping.get(cMSObj2.getClass());
        if (role == null) {
            return true;
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles roles = roleUserCacheMgr.getRoles(user, null);
        if (roles.indexOf(role.getId()) >= 0) {
            return true;
        }
        Role role2 = (Role)objRoleMappingForSameGroup.get(cMSObj2.getClass());
        if (role2 == null) {
            return false;
        }
        if (roles.indexOf(role2.getId()) < 0) {
            return false;
        }
        if (cMSObj2.isAddMode()) {
            return true;
        }
        return SpecialAuthServer.isInSameParentGroup(user, cMSObj2.getCrUser());
    }

    private static boolean isInSameParentGroup(User user, User user2) throws WCMException {
        Groups groups = Groups.createNewInstance(null);
        if (user2 != null) {
            groups = user2.getGroups();
        }
        if (groups == null || groups.size() == 0) {
            return false;
        }
        Groups groups2 = user.getGroups();
        if (groups2 == null || groups2.size() == 0) {
            return false;
        }
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                if (groups2.indexOf(group2.getId()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static RightValue getRightValue(CMSObj cMSObj, CMSObj cMSObj2) throws WCMException {
        return SpecialAuthServer.getRightValue(cMSObj, cMSObj2.getClass());
    }

    public static RightValue getRightValue(CMSObj cMSObj, Class clazz) throws WCMException {
        User user = (User)cMSObj;
        if (user.isAdministrator()) {
            return RightValue.getAdministratorRightValue();
        }
        Role role = (Role)objRoleMapping.get(clazz);
        if (role == null) {
            return RightValue.getAdministratorRightValue();
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles roles = roleUserCacheMgr.getRoles(user, null);
        RightValue rightValue = (RightValue)objRightValueMapping.get(clazz);
        if (rightValue == null) {
            rightValue = EVERYONE_HAS_RIGHT_VALUE;
        }
        if (roles.indexOf(role.getId()) >= 0) {
            return rightValue;
        }
        Role role2 = (Role)objRoleMappingForSameGroup.get(clazz);
        if (role2 != null && roles.indexOf(role2.getId()) >= 0) {
            return rightValue;
        }
        return EVERYONE_HAS_RIGHT_VALUE;
    }

    static {
        int n;
        logger = Logger.getLogger(SpecialAuthServer.class);
        SPECIAL_INDEX_RANGE = new int[]{1, 10};
        STYLE_INDEX_RANGE = new int[]{11, 20};
        WIDGET_INDEX_RANGE = new int[]{21, 30};
        EVERYONE_HAS_RIGHTINDEX = new int[]{4, 14, 24};
        objRoleMapping = new HashMap();
        objRoleMappingForSameGroup = new HashMap();
        try {
            RoleMgr roleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
            Role role = roleMgr.findRoleByName(SPECIAL_ROLE);
            objRoleMapping.put(Special.class, role);
            Role role2 = roleMgr.findRoleByName(SPECIAL_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(Special.class, role2);
            Role role3 = roleMgr.findRoleByName(STYLE_ROLE);
            objRoleMapping.put(PageStyle.class, role3);
            objRoleMapping.put(ContentStyle.class, role3);
            objRoleMapping.put(ResourceStyle.class, role3);
            Role role4 = roleMgr.findRoleByName(STYLE_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(PageStyle.class, role4);
            objRoleMappingForSameGroup.put(ContentStyle.class, role4);
            objRoleMappingForSameGroup.put(ResourceStyle.class, role4);
            Role role5 = roleMgr.findRoleByName(WIDGET_ROLE);
            objRoleMapping.put(Widget.class, role5);
            objRoleMapping.put(Master.class, role5);
            objRoleMapping.put(Layout.class, role5);
            Role role6 = roleMgr.findRoleByName(WIDGET_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(Widget.class, role6);
            objRoleMappingForSameGroup.put(Master.class, role6);
            objRoleMappingForSameGroup.put(Layout.class, role6);
        }
        catch (Exception exception) {
            logger.error((Object)"\u521d\u59cb\u5316\u4e13\u9898\u76f8\u5173\u6743\u9650\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
        }
        objRightValueMapping = new HashMap();
        EVERYONE_HAS_RIGHT_VALUE = new RightValue();
        for (n = 0; n < EVERYONE_HAS_RIGHTINDEX.length; ++n) {
            EVERYONE_HAS_RIGHT_VALUE.setBit(EVERYONE_HAS_RIGHTINDEX[n], true);
        }
        SPECIAL_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (n = SPECIAL_INDEX_RANGE[0]; n <= SPECIAL_INDEX_RANGE[1]; ++n) {
            SPECIAL_RIGHT_VALUE.setBit(n, true);
        }
        objRightValueMapping.put(Special.class, SPECIAL_RIGHT_VALUE);
        WIDGET_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (n = WIDGET_INDEX_RANGE[0]; n <= WIDGET_INDEX_RANGE[1]; ++n) {
            WIDGET_RIGHT_VALUE.setBit(n, true);
        }
        objRightValueMapping.put(Widget.class, WIDGET_RIGHT_VALUE);
        objRightValueMapping.put(Master.class, WIDGET_RIGHT_VALUE);
        objRightValueMapping.put(Layout.class, WIDGET_RIGHT_VALUE);
        STYLE_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (n = STYLE_INDEX_RANGE[0]; n <= STYLE_INDEX_RANGE[1]; ++n) {
            STYLE_RIGHT_VALUE.setBit(n, true);
        }
        objRightValueMapping.put(PageStyle.class, STYLE_RIGHT_VALUE);
        objRightValueMapping.put(ContentStyle.class, STYLE_RIGHT_VALUE);
        objRightValueMapping.put(ResourceStyle.class, STYLE_RIGHT_VALUE);
    }
}

