/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import org.dom4j.Element;

public class PageStyleXmlConverter
extends BaseObjToXmlConverter {
    private ObjToXmlConverter m_converter;

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, "\u65e0\u6548\u7684\u5bf9\u8c61[null]!");
        }
        if (baseObj instanceof StyleItem) {
            return null;
        }
        Element[] elementArray = null;
        if (baseObj instanceof PageStyle) {
            PageStyle pageStyle = (PageStyle)baseObj;
            Element element = this.getPageStyleItemElement(pageStyle);
            Element element2 = this.getPageResourceStyleElement(pageStyle);
            Element element3 = this.getPageContentStyleElement(pageStyle);
            elementArray = new Element[]{element, element2, element3};
        } else if (baseObj instanceof ResourceStyle) {
            ResourceStyle resourceStyle = (ResourceStyle)baseObj;
            StyleItems styleItems = this.getBaseStyleItems(resourceStyle);
            Element element = this.toXmlElement(styleItems, null);
            elementArray = new Element[]{element};
        } else if (baseObj instanceof ContentStyle) {
            ContentStyle contentStyle = (ContentStyle)baseObj;
            StyleItems styleItems = this.getBaseStyleItems(contentStyle);
            Element element = this.toXmlElement(styleItems, null);
            elementArray = new Element[]{element};
        }
        return elementArray;
    }

    private Element getPageStyleItemElement(PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        StyleItems styleItems = this.getBaseStyleItems(pageStyle);
        return this.toXmlElement(styleItems, null);
    }

    private Element getPageResourceStyleElement(PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        IResourceStyleMgr iResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
        ResourceStyles resourceStyles = iResourceStyleMgr.query(pageStyle, null);
        if (resourceStyles == null || resourceStyles.isEmpty()) {
            return null;
        }
        return this.toXmlElement(resourceStyles, null);
    }

    private Element getPageContentStyleElement(PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        IContentStyleMgr iContentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
        ContentStyles contentStyles = iContentStyleMgr.query(pageStyle, null);
        if (contentStyles == null || contentStyles.isEmpty()) {
            return null;
        }
        return this.toXmlElement(contentStyles, null);
    }

    private StyleItems getBaseStyleItems(BaseStyle baseStyle) throws WCMException {
        if (baseStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684BaseStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        WCMFilter wCMFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        if (baseStyle instanceof PageStyle) {
            PageStyle pageStyle = (PageStyle)baseStyle;
            wCMFilter.addSearchValues(0, pageStyle.getWCMType());
            wCMFilter.addSearchValues(1, pageStyle.getId());
        } else if (baseStyle instanceof ResourceStyle) {
            ResourceStyle resourceStyle = (ResourceStyle)baseStyle;
            wCMFilter.addSearchValues(0, resourceStyle.getWCMType());
            wCMFilter.addSearchValues(1, resourceStyle.getId());
        } else if (baseStyle instanceof ContentStyle) {
            ContentStyle contentStyle = (ContentStyle)baseStyle;
            wCMFilter.addSearchValues(0, contentStyle.getWCMType());
            wCMFilter.addSearchValues(1, contentStyle.getId());
        } else {
            throw new WCMException("\u5bf9\u8c61[" + baseStyle.getClass().getName() + "]\u4e0d\u662f\u7ee7\u627fBaseStyle\uff01");
        }
        return StyleItems.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

