/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleXmlConverter;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ContentStyleExporter {
    private static Logger logger = Logger.getLogger(ContentStyleExporter.class);
    private String m_sXMLEncoding = "UTF-8";
    private String[] m_aImageClassNameStyleItems = new String[]{"p_w_list_li_background", "p_doc_title_background", "c_line_background_image", "doc_new_icon_background_image"};
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");

    public String export(ContentStyles contentStyles, int n) throws Exception {
        if (contentStyles == null) {
            throw new WCMException("\u5bfc\u51fa\u7684ContentStyle\u5bf9\u8c61\u4e3anull!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip cMyZip = new CMyZip();
        cMyZip.setZipFileName(string);
        String string2 = CMyFile.extractFilePath(string);
        CMyDateTime cMyDateTime = CMyDateTime.now();
        String string3 = string2 + cMyDateTime.toString("yyyy-MM-dd") + "_" + System.currentTimeMillis() + "_temp";
        CMyFile.makeDir(string3, true);
        try {
            try {
                Object object;
                int n2;
                File[] fileArray;
                if (n > 0) {
                    fileArray = PageStyle.findById(n);
                    this.exportContentStylesForOnePageStyle(contentStyles, (PageStyle)fileArray, string3);
                } else {
                    fileArray = this.m_oPageStyleMgr.query(null);
                    int n3 = fileArray.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = (PageStyle)fileArray.getAt(n2);
                        if (object == null) continue;
                        int n4 = ((BaseObj)object).getId();
                        ContentStyles contentStyles2 = new ContentStyles(this.getLoginUser());
                        int n5 = contentStyles.size();
                        for (int i = 0; i < n5; ++i) {
                            String string4;
                            ContentStyles contentStyles3;
                            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
                            if (contentStyle == null || (contentStyles3 = ContentStyles.findSameCssFlagStyles(string4 = contentStyle.getCssFlag(), n4)) == null || contentStyles3.size() == 0) continue;
                            contentStyles2.addElement(contentStyles3.getAt(0));
                        }
                        this.exportContentStylesForOnePageStyle(contentStyles2, (PageStyle)object, string3);
                    }
                }
                cMyZip.setZipWithChildDirPath(true);
                fileArray = CMyFile.listSubDirectories(string3);
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    File file = fileArray[n2];
                    object = file.getAbsolutePath();
                    cMyZip.addToZip((String)object, false);
                }
                cMyZip.done();
            }
            catch (Exception exception) {
                logger.error((Object)"failed to zip files!", (Throwable)exception);
                CMyFile.deleteFile(string);
                throw new WCMException(1100, "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!", exception);
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            CMyFile.deleteDir(string3);
            throw throwable;
        }
        CMyFile.deleteDir(string3);
        return CMyFile.extractFileName(string);
    }

    private void exportContentStylesForOnePageStyle(ContentStyles contentStyles, PageStyle pageStyle, String string) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", "xml", null, true);
        ContentStyleXmlConverter contentStyleXmlConverter = new ContentStyleXmlConverter();
        contentStyleXmlConverter.setXmlEncoding(this.m_sXMLEncoding);
        contentStyleXmlConverter.toXMLFile(contentStyles, string2);
        String string3 = pageStyle.getStyleName();
        String string4 = string + File.separator + string3 + File.separator;
        CMyFile.makeDir(string4, true);
        String string5 = CMyFile.extractFileName(string2);
        CMyFile.copyFile(string2, string4 + string5);
        CMyFile.deleteFile(string2);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            String string6 = string4 + "thumb" + File.separator;
            if (!CMyFile.fileExists(string6)) {
                CMyFile.makeDir(string6, true);
            }
            this.addContentStyleThumbFolder(contentStyle, string6);
            String string7 = StylePathHelper.getStyleCommonDir();
            String string8 = contentStyle.getCustomStyle();
            if (CMyString.isEmpty(string8)) {
                this.addStyleItemImagesFolder(contentStyle, string7, string);
                continue;
            }
            this.addCustomStyleContentImagesFolder(string8, string7, string);
        }
    }

    private void addCustomStyleContentImagesFolder(String string, String string2, String string3) throws CMyException {
        if (CMyString.isEmpty(string)) {
            return;
        }
        Pattern pattern = Pattern.compile("(../style_common/\\w+/\\w+.(gif|png|jpeg|bmp|jpg))");
        Matcher matcher = pattern.matcher(string);
        matcher.reset();
        while (matcher.find()) {
            File file;
            String string4 = string.substring(matcher.start(), matcher.end());
            String string5 = this.calculteStyleItemImage(string2, string4);
            if (CMyString.isEmpty(string5) || !CMyFile.fileExists(string5) || !(file = new File(string5)).exists()) continue;
            String string6 = file.getName();
            String string7 = CMyFile.extractFilePath(string5);
            string7 = string7.substring(0, string7.length() - 1);
            int n = string7.lastIndexOf(File.separatorChar);
            String string8 = CMyString.setStrEndWith(string3, File.separatorChar);
            String string9 = string7.substring(n + 1);
            if (!CMyFile.fileExists(string8 = string8 + string9 + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(string8, true);
            }
            CMyFile.copyFile(string5, string8 + string6, false);
        }
    }

    private void addContentStyleThumbFolder(ContentStyle contentStyle, String string) throws Exception {
        if (contentStyle == null) {
            return;
        }
        String string2 = contentStyle.getStyleThumb();
        if (CMyString.isEmpty(string2)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = filesMan.mapFilePath(string2, 0) + string2;
        CMyFile.copyFile(string3, string + string2);
    }

    private void addStyleItemImagesFolder(ContentStyle contentStyle, String string, String string2) throws Exception {
        if (contentStyle == null) {
            return;
        }
        ArrayList arrayList = this.getContentStyleItemImages(contentStyle, string);
        for (int i = 0; i < arrayList.size(); ++i) {
            File file;
            String string3 = (String)arrayList.get(i);
            if (CMyString.isEmpty(string3) || !(file = new File(string3)).exists()) continue;
            String string4 = file.getName();
            String string5 = CMyFile.extractFilePath(string3);
            string5 = string5.substring(0, string5.length() - 1);
            int n = string5.lastIndexOf(File.separatorChar);
            String string6 = CMyString.setStrEndWith(string2, File.separatorChar);
            String string7 = string5.substring(n + 1);
            if (!CMyFile.fileExists(string6 = string6 + string7 + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(string6, true);
            }
            CMyFile.copyFile(string3, string6 + string4, false);
        }
    }

    public ArrayList getContentStyleItemImages(ContentStyle contentStyle, String string) throws WCMException {
        if (contentStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684\u5185\u5bb9\u6837\u5f0f\u5bf9\u8c61\u4e3anull\uff01");
        }
        if (string == null) {
            throw new WCMException("\u8bf7\u4f20\u5165\u5f53\u524d\u5185\u5bb9\u6837\u5f0f\u7f29\u7565\u56fe\u5b58\u653e\u7684\u8def\u5f84\uff01");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        WCMFilter wCMFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        wCMFilter.addSearchValues(0, contentStyle.getWCMType());
        wCMFilter.addSearchValues(1, contentStyle.getId());
        StyleItems styleItems = StyleItems.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c[Id=" + contentStyle.getId() + "]\u7684styleItem\u7684\u8def\u5f84\u5931\u8d25\uff01");
        }
        for (int i = 0; i < styleItems.size(); ++i) {
            String string2;
            String string3;
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null || !this.isImageStyleItem(styleItem) || CMyString.isEmpty(string3 = styleItem.getClassValue()) || CMyString.isEmpty(string2 = this.calculteStyleItemImage(string, string3)) || !CMyFile.fileExists(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String calculteStyleItemImage(String string, String string2) {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(string2)) {
            return null;
        }
        string2 = string2.replace('\\', File.separatorChar);
        string2 = string2.replace('/', File.separatorChar);
        String string3 = CMyFile.extractFileName(string2);
        String string4 = CMyFile.extractFilePath(string2);
        int n = (string4 = string4.substring(0, string4.length() - 1)).lastIndexOf(File.separatorChar);
        if (n < 0 || n + 1 >= string2.length()) {
            return null;
        }
        String string5 = string4.substring(n + 1);
        return CMyString.setStrEndWith(string, File.separatorChar) + string5 + File.separatorChar + string3;
    }

    private boolean isImageStyleItem(StyleItem styleItem) {
        if (styleItem == null) {
            return false;
        }
        for (int i = 0; i < this.m_aImageClassNameStyleItems.length; ++i) {
            if (!this.m_aImageClassNameStyleItems[i].equalsIgnoreCase(styleItem.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setXMLEncoding(String string) {
        this.m_sXMLEncoding = string;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] stringArray) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        ContentStyleExporter contentStyleExporter = new ContentStyleExporter();
        ContentStyles contentStyles = ContentStyles.findByIds(ContextHelper.getLoginUser(), "19690");
        String string = contentStyleExporter.export(contentStyles, 0);
        System.out.println("------------" + string);
    }
}

