/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TempApdRels;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Template
extends CMSObj {
    private static final Logger logger = Logger.getLogger(Template.class);
    public static final int OBJ_TYPE = 102;
    public static final String DB_TABLE_NAME = "WCMTEMPLATE";
    public static final String DB_ID_NAME = "TEMPID";
    public static final int INPUT_TEMPLATE = 0;
    public static final int DETAIL_TEMPLATE = 2;
    public static final int OUTLINE_TEMPLATE = 1;
    public static final int ALL_TEMPLATE = -1;
    private TemplateParameterList m_oParameters = null;
    private boolean m_zHadSetPara = false;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 102;
    }

    public static int guessTypeByName(String string) {
        if (string.indexOf(I18NMessage.get(Template.class, "Template.label1", "\u6982\u89c8")) >= 0 || string.indexOf("outline") >= 0) {
            return 1;
        }
        if (string.indexOf(I18NMessage.get(Template.class, "Template.label2", "\u7ec6\u89c8")) >= 0 || string.indexOf("detail") >= 0) {
            return 2;
        }
        if (string.indexOf(I18NMessage.get(Template.class, "Template.label3", "\u5d4c\u5957")) >= 0) {
            return 0;
        }
        return 1;
    }

    public String getName() {
        return (String)this.getProperty("TEMPNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("TEMPNAME", string);
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("TEMPTYPE", n);
    }

    public int getType() {
        return this.getPropertyAsInt("TEMPTYPE", -1);
    }

    public String getOutputFileName() {
        String string = this.getPropertyAsString("OUTPUTFILENAME");
        if (CMyString.isEmpty(string)) {
            if (this.getType() == 1) {
                string = "index";
            }
        } else {
            string = string.replace('/', File.separatorChar);
            string = CMyFile.extractMainFileName(string);
        }
        return string;
    }

    public boolean setOutputFileName(String string) throws WCMException {
        return this.setProperty("OUTPUTFILENAME", CMyFile.extractFileName(string));
    }

    public String getOutputFileExt() {
        String string = (String)this.getProperty("TEMPEXT");
        if (CMyString.isEmpty(string)) {
            string = "htm";
        } else {
            int n;
            int n2 = (string = string.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                string = string.substring(n + 1);
            }
        }
        return string;
    }

    public boolean setOutputFileExt(String string) throws WCMException {
        return this.setProperty("TEMPEXT", CMyFile.extractFileExt(string));
    }

    public int getRootType() {
        return this.getPropertyAsInt("ROOTTYPE", 0);
    }

    public int getRootId() {
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public IPublishFolder getRoot() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getRootType(), this.getRootId());
    }

    public boolean setRoot(int n, int n2) throws WCMException {
        return this.setProperty("ROOTTYPE", n) && this.setProperty("ROOTID", n2);
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public IPublishFolder getFolder() throws WCMException {
        int n = this.getFolderId();
        if (n <= 0) {
            return null;
        }
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), n);
    }

    public boolean setFolder(int n, int n2, int n3, int n4) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2) && this.setRoot(n3, n4);
    }

    public boolean setFolder(IPublishFolder iPublishFolder, IPublishFolder iPublishFolder2) throws WCMException {
        return this.setFolder(iPublishFolder.getType(), iPublishFolder.getId(), iPublishFolder2.getType(), iPublishFolder2.getId());
    }

    public boolean setFolder(int n, int n2) throws WCMException {
        IPublishFolder iPublishFolder;
        try {
            iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(n, n2);
        }
        catch (Exception exception) {
            throw new WCMException(200006, "Failed to lookup the specified folder [type=" + n + ", id=" + n2 + "]!", exception);
        }
        if (iPublishFolder == null) {
            throw new WCMException(200006, "The specified folder [type=" + n + ", id=" + n2 + "] is not found!");
        }
        return this.setFolder(iPublishFolder);
    }

    public boolean setFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        if (iPublishFolder2 == null) {
            throw new WCMException(200006, "Root of the folder not found!");
        }
        return this.setFolder(iPublishFolder.getType(), iPublishFolder.getId(), iPublishFolder2.getType(), iPublishFolder2.getId());
    }

    public String getDesc() {
        return (String)this.getProperty("TEMPDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("TEMPDESC", string);
    }

    public String getText() {
        return CMyString.showNull(((CDBText)this.getProperty("TEMPTEXT")).getText(), I18NMessage.get(Template.class, "Template.label4", "\u65e0\u5185\u5bb9"));
    }

    public boolean setText(String string) throws WCMException {
        return this.setTextProperty("TEMPTEXT", string);
    }

    public boolean isApdModified() {
        return this.getPropertyAsBoolean("APDMODIFIED", false);
    }

    public boolean setApdModified(boolean bl) throws WCMException {
        return this.setProperty("APDMODIFIED", bl);
    }

    public boolean isParsed() {
        return this.getPropertyAsBoolean("ISPARSED", false);
    }

    public boolean setParsed(boolean bl) throws WCMException {
        return this.setProperty("ISPARSED", bl);
    }

    public boolean isValid() throws WCMException {
        String string;
        String string2 = null;
        if (this.isAddMode()) {
            string2 = (String)this.getProperty("TEMPNAME");
            if (string2 == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label5", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TEMPTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label6", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ROOTTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label7", "\u5c5e\u6027RootType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label8", "\u5c5e\u6027RootId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") != null && this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Template.class, "Template.label9", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (CMyString.isEmpty(this.getPropertyAsString("TEMPEXT"))) {
                this.setPropertyWithString("TEMPEXT", "html");
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Template.class, "Template.label10", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            string2 = (String)this.getNewProperty("TEMPNAME");
        }
        if (string2 != null) {
            string = "ROOTTYPE=" + this.getRootType() + " and ROOTID=" + this.getRootId() + " and TEMPNAME='" + CMyString.filterForSQL(string2) + "'";
            if (!this.isAddMode()) {
                string = string + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string)) {
                throw new WCMException(1108, I18NMessage.get(Template.class, "Template.label11", "\u6a21\u677f\u540d\u79f0[") + string2 + I18NMessage.get(Template.class, "Template.label12", "]\u5df2\u7ecf\u5b58\u5728"));
            }
        }
        if ((string = this.getFinalPropertyAsString("OUTPUTFILENAME", "")).matches("^.*[\\.\\\\//].*$")) {
            throw new WCMException("The outputfilename contains invalid chars [.\\/].");
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setApdModified(true);
            if (this.getProperty("FOLDERID") == null) {
                this.setFolder(0, 0);
            }
            if (this.getProperty("ISPARSED") == null) {
                this.setParsed(false);
            }
            this.setCrUser(user);
            this.setCrTime();
            super.insert(user);
        }
    }

    public void save(User user) throws WCMException {
        this.setLastModified(user);
        super.save(user);
    }

    private void setLastModified(User user) throws WCMException {
        this.setProperty("LASTMODIFIEDUSER", user.getName());
        this.setProperty("LASTMODIFIEDTIME", CMyDateTime.now());
    }

    public TempAppendixes getAppendixes(User user) throws WCMException {
        return this.getAppendixes(user, null);
    }

    public TempAppendixes getAppendixes(User user, int[] nArray) throws WCMException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WCMTempApdRel.TEMPID=").append(this.getId());
            stringBuffer.append(" AND WCMTempAppendix.TEMPAPPENDIXID=WCMTempApdRel.APPENDIXID");
            if (nArray != null) {
                stringBuffer.append(" AND WCMTempAppendix.APDFLAG");
                if (nArray.length == 1) {
                    stringBuffer.append('=').append(nArray[0]);
                } else {
                    stringBuffer.append(" in (");
                    for (int i = 0; i < nArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(nArray[i]);
                    }
                    stringBuffer.append(')');
                }
            }
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            TempAppendixes tempAppendixes = new TempAppendixes(user);
            tempAppendixes.open(new WCMFilter("WCMTempAppendix, WCMTempApdRel", string, "", "WCMTempAppendix.*"));
            return tempAppendixes;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label13", "\u63d0\u53d6\u6a21\u677f\u7684\u9644\u4ef6\u96c6\u5408\u5931\u8d25"), exception);
        }
    }

    public TempApdRels getApdRels(WCMFilter wCMFilter) throws WCMException {
        try {
            WCMFilter wCMFilter2 = new WCMFilter("", "TEMPID=" + this.getId(), "");
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            TempApdRels tempApdRels = new TempApdRels(ContextHelper.getLoginUser());
            tempApdRels.open(wCMFilter2);
            return tempApdRels;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the template appendix relations!", exception);
        }
    }

    public TempAppendix addAppendix(User user, String string, boolean bl) throws WCMException {
        TempAppendix tempAppendix = null;
        try {
            int n = this.getRootType();
            int n2 = this.getRootId();
            String string2 = "APDFILE='" + CMyString.filterForSQL(string) + "' AND ROOTID=" + n2 + " AND ROOTTYPE=" + n;
            TempAppendixes tempAppendixes = new TempAppendixes(user, 1, 1);
            tempAppendixes.open(new WCMFilter("", string2, ""));
            if (tempAppendixes.isEmpty()) {
                try {
                    tempAppendix = (TempAppendix)tempAppendixes.addNew();
                    tempAppendix.setRoot(n, n2);
                    tempAppendix.setFile(string);
                    tempAppendix.setFlag(0);
                    tempAppendix.setCrUser(user);
                    tempAppendixes.update();
                }
                catch (Exception exception) {
                    throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label14", "\u65b0\u5efa\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), exception);
                }
            } else {
                tempAppendix = (TempAppendix)tempAppendixes.getAt(0);
            }
            if (bl) {
                tempAppendix.addRelation(this);
            }
            return tempAppendix;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label15", "\u6dfb\u52a0\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), exception);
        }
    }

    public boolean deleteAppendix(TempAppendix tempAppendix) throws WCMException {
        if (tempAppendix == null || !tempAppendix.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Template.class, "Template.label16", "\u65e0\u6548\u7684\u6a21\u677f\u9644\u4ef6\u5bf9\u8c61"));
        }
        return tempAppendix.deleteRelation(this);
    }

    /*
     * Loose catch block
     */
    public boolean deleteAppendix(int n) throws WCMException {
        boolean bl;
        DBManager dBManager;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            connection = null;
            preparedStatement = null;
            dBManager = this.getDBManager();
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPAPDREL WHERE TEMPID=? AND APPENDIXID=?");
            preparedStatement.setInt(1, this.getId());
            preparedStatement.setInt(2, n);
            bl = preparedStatement.executeUpdate() > 0;
            Object var8_7 = null;
            if (preparedStatement == null) break block9;
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return bl;
        catch (Exception exception) {
            try {
                throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label17", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25"), exception);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_8 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2) {
                            logger.error((Object)"Failed to close prepared statement", (Throwable)exception2);
                        }
                    }
                    if (connection == null) break block10;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public int clearAppendixes() throws WCMException {
        TempAppendixes tempAppendixes = this.getAppendixes(ContextHelper.getLoginUser());
        int n = this.clearAppendixRelaion();
        this.clearAppendixsData(tempAppendixes);
        return n;
    }

    /*
     * Loose catch block
     */
    private int clearAppendixRelaion() throws WCMException {
        int n;
        DBManager dBManager;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            connection = null;
            preparedStatement = null;
            dBManager = this.getDBManager();
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPAPDREL WHERE TEMPID=?");
            preparedStatement.setInt(1, this.getId());
            n = preparedStatement.executeUpdate();
            Object var7_6 = null;
            if (preparedStatement == null) break block9;
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return n;
        catch (Exception exception) {
            try {
                throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label17", "\u5220\u9664\u6a21\u677f\u9644\u4ef6\u5173\u8054\u5931\u8d25"), exception);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var7_7 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2) {
                            logger.error((Object)"Failed to close prepared statement", (Throwable)exception2);
                        }
                    }
                    if (connection == null) break block10;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    protected void clearAppendixsData(TempAppendixes tempAppendixes) throws WCMException {
        User user = ContextHelper.getLoginUser();
        for (int i = 0; i < tempAppendixes.size(); ++i) {
            TempAppendix tempAppendix = (TempAppendix)tempAppendixes.getAt(i);
            if (tempAppendix == null || this.isInUse(tempAppendix)) continue;
            tempAppendix.delete(user);
            this.deleteLocalAppendixFile(tempAppendix.getFile());
            this.deleteAppendixFileDistributed(tempAppendix.getFile());
        }
    }

    private boolean isInUse(TempAppendix tempAppendix) throws WCMException {
        String string = "SELECT COUNT(*) FROM WCMTEMPAPDREL WHERE AppendixId=" + tempAppendix.getId();
        return this.getDBManager().sqlExecuteIntQuery(string) > 0;
    }

    private void deleteLocalAppendixFile(String string) {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = "";
        try {
            string2 = filesMan.getTemplateAppendixPath(this.getRootType(), this.getRootId(), 0, false);
        }
        catch (WCMException wCMException) {
            logger.error((Object)"failed to get the appendix local source path!", (Throwable)wCMException);
        }
        String string3 = "";
        try {
            string3 = filesMan.getPathConfigValue("LP", 0) + this.getApdFilePubHttpPath();
        }
        catch (Exception exception) {
            logger.error((Object)"failed to get the appendix local pub path!", (Throwable)exception);
        }
        CMyFile.deleteFile(string2 + string);
        CMyFile.deleteFile(string3 + string);
    }

    private void deleteAppendixFileDistributed(String string) {
        FileDistributeShip fileDistributeShip = new FileDistributeShip();
        try {
            fileDistributeShip.withdrawFile(string, this.getRoot(), this.getApdFilePubHttpPath());
        }
        catch (Exception exception) {
            logger.error((Object)("failed to withdraw a distributed template appendix file[" + string + "]"), (Throwable)exception);
        }
    }

    public String getApdFilePubHttpPath() throws Exception {
        IPublishFolder iPublishFolder = this.getRoot();
        if (iPublishFolder == null) {
            return null;
        }
        return "/" + iPublishFolder.getDataPath() + "/images/";
    }

    public String getPubText() throws WCMException {
        boolean bl = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"));
        if (bl) {
            IPublishFolder iPublishFolder = this.getRoot();
            if (iPublishFolder == null) {
                throw new WCMException(I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label19", "]\u7684Root[ID=") + this.getRootId() + I18NMessage.get(Template.class, "Template.label20", "]\u4e0d\u5b58\u5728\uff01"));
            }
            String[] stringArray = Template.convertURL2ImageURL(iPublishFolder.getDataPath());
            return this.getTextWithImgFilter(stringArray, true);
        }
        return this.getTextWithImgFilter("${ROOT_PATH}images/", true);
    }

    public String getTextWithImgFilter(String string, boolean bl) throws WCMException {
        return this.getTextWithImgFilter(new String[]{string}, bl);
    }

    public String getTextWithImgFilter(String string, boolean bl, boolean bl2) throws WCMException {
        return this.getTextWithImgFilter(new String[]{string}, bl, bl2);
    }

    public String getTextWithImgFilter(String[] stringArray, boolean bl) throws WCMException {
        return this.getTextWithImgFilter(stringArray, bl, true);
    }

    private String getTextWithImgFilter(String[] stringArray, boolean bl, boolean bl2) throws WCMException {
        String string = this.getText();
        if (string == null || string.length() == 0) {
            return "";
        }
        if ("XML".equalsIgnoreCase(this.getOutputFileExt())) {
            return string;
        }
        String[] stringArray2 = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] stringArray3 = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        int n = 0;
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                HtmlElement htmlElement;
                String string2 = stringArray2[i];
                String string3 = stringArray3[i];
                HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string);
                while ((htmlElement = htmlElementFinder.findNextElement(string2, true)) != null) {
                    String string4;
                    if (bl2) {
                        htmlElement.removeAttribute("ignoreapd");
                    }
                    if ((string4 = htmlElement.getAttributeValue("OLDSRC")) != null) {
                        String string5 = stringArray[n++];
                        string4 = string5 + string4;
                        if (n >= stringArray.length) {
                            n = 0;
                        }
                        htmlElement.setAttribute(string3, string4);
                        if (bl) {
                            htmlElement.removeAttribute("OLDSRC");
                            htmlElement.removeAttribute("OLDID");
                            htmlElement.removeAttribute("RELATED");
                        }
                    }
                    htmlElementFinder.putElement(htmlElement);
                }
                string = htmlElementFinder.getContent();
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(Template.class, "Template.label21", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6a21\u677f\u6b63\u6587\u5185\u5bb9\u5931\u8d25"), exception);
        }
    }

    public synchronized void updateAppendixStatus() throws WCMException {
        block6: {
            try {
                if (!this.canEdit(User.getSystem())) break block6;
                try {
                    this.setApdModified(false);
                    this.update(User.getSystem());
                }
                catch (Exception exception) {
                    try {
                        this.cancelUpdate(User.getSystem());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this.getName() + I18NMessage.get(Template.class, "Template.label22", "]\u9644\u4ef6\u5c5e\u6027\u66f4\u65b0\u9519\u8bef!"), exception);
                }
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(Template.class, "Template.label18", "\u6a21\u677f[") + this.getName() + I18NMessage.get(Template.class, "Template.label22", "]\u9644\u4ef6\u5c5e\u6027\u66f4\u65b0\u9519\u8bef!"), exception);
            }
        }
    }

    public boolean isHaveRelation(Connection connection, int n) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        boolean bl = false;
        statement = connection.createStatement();
        resultSet = statement.executeQuery(string = "select count(*) from WCMTempApdRel  where tempid=" + this.getId() + " and appendixid=" + n);
        if (resultSet.next()) {
            bl = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        statement.close();
        return bl;
    }

    public static final Template findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Template)BaseObj.findById(Template.class, n);
    }

    public static final Template createNewInstance() throws WCMException {
        return (Template)BaseObj.createNewInstance(Template.class);
    }

    public static final Template findByKey(Object object) throws WCMException {
        return (Template)BaseObj.findByKey(Template.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getInfo();
    }

    public String getInfo() {
        return this.getName() + I18NMessage.get(Template.class, "Template.label23", "[\u6a21\u677f-") + this.getId() + "]";
    }

    public TemplateParameterList getTemplateParameters() {
        if (!this.m_zHadSetPara) {
            try {
                this.m_zHadSetPara = true;
                TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
                templateParseMgr.parse(this);
            }
            catch (Exception exception) {
                logger.error((Object)I18NMessage.get(Template.class, "Template.label24", "\u83b7\u53d6\u6a21\u677f\u7684\u5f62\u5f0f\u53c2\u6570\u5217\u8868\u5931\u8d25!"), (Throwable)exception);
            }
        }
        return this.m_oParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateParameterList getTemplateParameters(boolean bl) {
        TemplateParameterList templateParameterList = this.getTemplateParameters();
        if (bl && templateParameterList != null) {
            Template template = this;
            synchronized (template) {
                if (!templateParameterList.getNestParsed()) {
                    templateParameterList.setNestParsed(true);
                }
            }
        }
        return templateParameterList;
    }

    public void setTemplateParameters(TemplateParameterList templateParameterList) {
        this.m_oParameters = templateParameterList;
        this.m_zHadSetPara = true;
    }

    public boolean isAccessibleFrom(IPublishFolder iPublishFolder) {
        int n = this.getFolderType();
        int n2 = this.getFolderId();
        while (iPublishFolder != null) {
            if (n == iPublishFolder.getType() && n2 == iPublishFolder.getId()) {
                return true;
            }
            try {
                iPublishFolder = iPublishFolder.getParent();
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(Template.class, "Template.label25", "\u83b7\u53d6") + iPublishFolder.getInfo() + I18NMessage.get(Template.class, "Template.label26", "\u7684\u7236\u76ee\u5f55\u5931\u8d25")), (Throwable)exception);
                break;
            }
        }
        return false;
    }

    public Template getNestedTemplate(IPublishElement iPublishElement, String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        try {
            TagItem tagItem;
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDocument = templateParseMgr.parse(this);
            Iterator iterator = tagDocument.findItems("TRS_TEMPLATE");
            while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
                String string2 = this.makeNestedIndentiy(tagItem.getAttribute("TEMPNAME"));
                if (!string.equals(tagItem.getAttribute("IDENTITY")) && !string.equals(string2)) continue;
                PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, null);
                PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
                publishTagContext.setTagItem(tagItem);
                return TagParseHelper.findNestedTemplate(publishTagContext);
            }
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(Template.class, "Template.label27", "\u83b7\u53d6\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label28", "]\u4e2d\u6307\u5b9a\u6807\u8bc6[") + string + I18NMessage.get(Template.class, "Template.label29", "]\u7684\u5d4c\u5957\u6a21\u677f\u5931\u8d25!")), (Throwable)exception);
        }
        return null;
    }

    public String makeNestedIndentiy(String string) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(string).append('_').append(this.id);
        return stringBuffer.toString();
    }

    public Iterator iterateNestedIdentity() {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            TagItem tagItem;
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDocument = templateParseMgr.parse(this);
            Iterator iterator = tagDocument.findItems("TRS_TEMPLATE");
            String string = null;
            while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
                String string2 = tagItem.getAttribute("IDENTITY");
                if (string2 != null) {
                    linkedList.add(string2);
                    continue;
                }
                string = this.makeNestedIndentiy(tagItem.getAttribute("TEMPNAME"));
                if (linkedList.contains(string)) continue;
                linkedList.add(string);
            }
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(Template.class, "Template.label30", "\u679a\u4e3e\u6a21\u677f[") + this + I18NMessage.get(Template.class, "Template.label31", "]\u4e2d\u5e26\u6709\u6807\u8bc6\u7684\u5d4c\u5957\u6a21\u677f\u5931\u8d25!")), (Throwable)exception);
        }
        if (linkedList.size() > 0) {
            return linkedList.listIterator();
        }
        return null;
    }

    private static String[] convertURL2ImageURL(String string) throws WCMException {
        String string2 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
        int n = Integer.parseInt(string2);
        String string3 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String string4 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String[] stringArray = new String[n];
        stringArray[0] = "http://" + string3 + "." + string4 + "/" + string + "/" + "images/";
        for (int i = 1; i < n; ++i) {
            stringArray[i] = "http://" + string3 + i + "." + string4 + "/" + string + "/" + "images/";
        }
        return stringArray;
    }

    public String getCharSet() throws WCMException {
        String string = this.getPropertyAsString("TEMPCHARSET");
        if (CMyString.isEmpty(string)) {
            string = this.getRoot().getEncoding();
        }
        if (CMyString.isEmpty(string)) {
            string = "UTF-8";
        }
        return string;
    }

    public boolean setCharSet(String string) throws WCMException {
        return this.setPropertyWithString("TEMPCHARSET", string);
    }
}

