/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.publisher;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class FolderPublishConfig
extends CMSObj {
    public static final int OBJ_TYPE = 956;
    public static final String DB_TABLE_NAME = "WCMFOLDERPUBLISHCONFIG";
    public static final String DB_ID_NAME = "FOLDERPUBLISHCONFIGID";
    private static FolderPublishConfigCacheMgr s_oCacheMgr = new FolderPublishConfigCacheMgr();

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 956;
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int n, int n2) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2);
    }

    public boolean setFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.setFolder(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public String getOutlineFileName() {
        return this.getPropertyAsString("OUTLINEFILE");
    }

    public boolean setOutlineFileName(String string) throws WCMException {
        return this.setProperty("OUTLINEFILE", string);
    }

    public String getDetailFileExt() {
        return this.getPropertyAsString("DETAILFILEEXT");
    }

    public boolean setDetailFileExt(String string) throws WCMException {
        return this.setProperty("DETAILFILEEXT", string);
    }

    public String getDataPath() {
        String string = this.getPropertyAsString("DATAPATH");
        if (string == null || (string = string.trim()).length() <= 0) {
            string = "errorpath";
        }
        return string;
    }

    public boolean setDataPath(String string) throws WCMException {
        return this.setProperty("DATAPATH", string);
    }

    public String getRootDomain() {
        return this.getPropertyAsString("ROOTDOMAIN");
    }

    public boolean setRootDomain(String string) throws WCMException {
        return this.setProperty("ROOTDOMAIN", string);
    }

    public int getSiteLanguage() {
        return this.getPropertyAsInt("SITELANGUAGE", 0);
    }

    public boolean setSiteLanguage(int n) throws WCMException {
        return this.setProperty("SITELANGUAGE", n);
    }

    public String getPageEncoding() {
        String string = this.getPropertyAsString("PAGEENCODING");
        if (CMyString.isEmpty(string)) {
            string = "GBK";
        }
        return string;
    }

    public boolean setPageEncoding(String string) throws WCMException {
        return this.setProperty("PAGEENCODING", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATAPATH") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label3", "\u5c5e\u6027DataPath\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public int delete(User user) throws WCMException {
        int n = super.delete(user);
        s_oCacheMgr.notifyOnRemoveConfig(this);
        return n;
    }

    public static final FolderPublishConfig findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FolderPublishConfig)BaseObj.findById(FolderPublishConfig.class, n);
    }

    public static final FolderPublishConfig findOf(int n, int n2) throws WCMException {
        return s_oCacheMgr.findConfig(n, n2);
    }

    public static final FolderPublishConfig findOf(IPublishFolder iPublishFolder) throws WCMException {
        return s_oCacheMgr.findConfig(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public static final FolderPublishConfig createNewInstance() throws WCMException {
        return (FolderPublishConfig)BaseObj.createNewInstance(FolderPublishConfig.class);
    }

    public static final FolderPublishConfig findByKey(Object object) throws WCMException {
        return (FolderPublishConfig)BaseObj.findByKey(FolderPublishConfig.class, object);
    }
}

