/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.TagFormatterConfig;
import com.trs.components.common.publish.domain.tagparser.ITagFormatter;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class TagFormatHelper {
    private static final Logger logger = Logger.getLogger((String)TagFormatHelper.class.getName());
    private HashMap m_formattersMap = new HashMap();
    private boolean m_bLoaded = false;
    private static TagFormatHelper s_instance = new TagFormatHelper();

    private TagFormatHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagFormatHelper getInstance() throws WCMException {
        if (!TagFormatHelper.s_instance.m_bLoaded) {
            TagFormatHelper tagFormatHelper = s_instance;
            synchronized (tagFormatHelper) {
                if (!TagFormatHelper.s_instance.m_bLoaded) {
                    s_instance.refresh();
                }
            }
        }
        return s_instance;
    }

    public void refresh() throws WCMException {
        try {
            List list;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"to load the tag formatters config ...");
            }
            if (this.m_formattersMap != null && !this.m_formattersMap.isEmpty()) {
                this.m_formattersMap.clear();
            }
            if ((list = PublishServerConfigMapper.getTagFormattersConfigs()) == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                TagFormatterConfig tagFormatterConfig = (TagFormatterConfig)list.get(i);
                ITagFormatter iTagFormatter = (ITagFormatter)Class.forName(tagFormatterConfig.getClassName()).newInstance();
                this.m_formattersMap.put(tagFormatterConfig.getTagName(), iTagFormatter);
            }
            this.m_bLoaded = true;
            logger.debug((Object)"tag formatter config has been loaded successfully!");
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to refresh the tag formatter helper!", exception);
        }
    }

    public static ITagFormatter getFormatter(String string) throws WCMException {
        return (ITagFormatter)TagFormatHelper.getInstance().m_formattersMap.get(string);
    }

    public static void standardize(TagItem tagItem) throws WCMException {
        ITagFormatter iTagFormatter = TagFormatHelper.getFormatter(tagItem.getName());
        if (iTagFormatter != null) {
            iTagFormatter.standardize(tagItem);
        }
    }
}

