/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.persistent.element.IFolderQuoter;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PublishServer
extends BaseServer {
    private static final Logger logger = Logger.getLogger(PublishServer.class);
    private ITemplateEmployCacheMgr m_oCacheMgr = (ITemplateEmployCacheMgr)DreamFactory.createObjectById("ITemplateEmployCacheMgr");
    private IPublishTaskDispatcher m_taskDispatcher;
    private IPublishTaskMgr m_taskManager = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");

    public PublishServer() {
        this.m_taskDispatcher = (IPublishTaskDispatcher)DreamFactory.createObjectById("IPublishTaskDispatcher");
        try {
            ContextHelper.getLoginUser();
        }
        catch (RuntimeException runtimeException) {
            ContextHelper.setLoginUser(User.getSystem());
        }
    }

    public static PublishServer getInstance() {
        PublishServer publishServer = (PublishServer)DreamFactory.createObjectById("PublishServer");
        if (!publishServer.isStarted()) {
            publishServer.startup();
            if (!publishServer.isStarted()) {
                throw new RuntimeException(I18NMessage.get(PublishServer.class, "PublishServer.label1", "PublishServer\u672a\u542f\u52a8\uff01"));
            }
        }
        return publishServer;
    }

    protected boolean doStart() throws WCMException {
        logger.info((Object)"to start template employer cache...");
        this.m_oCacheMgr.init();
        logger.info((Object)"template employer cache is ready now.");
        logger.info((Object)"to start publish task dispatcher...");
        this.m_taskDispatcher.startup();
        logger.info((Object)"publish task dispatcher is ready now.");
        return true;
    }

    protected void doShutdown() {
        logger.info((Object)"to shutdown template employer cache...");
        this.m_oCacheMgr.clear();
        logger.info((Object)"template employer cache is closed.");
        logger.info((Object)"to shutdown the publish task dispatcher...");
        this.m_taskDispatcher.shutdown();
        logger.info((Object)"publish task dispatcher is closed.");
    }

    public String[] previewFolder(IPublishFolder iPublishFolder, String[] stringArray) throws WCMException {
        return this.previewFolder(iPublishFolder, stringArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] previewFolder(IPublishFolder iPublishFolder, String[] stringArray, Template template) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label2", "\u6ca1\u6709\u6307\u5b9a\u53d1\u5e03\u7684\u680f\u76ee!"));
        }
        iPublishFolder.validateCanDoPreview();
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, iPublishFolder);
        PublishPageContext publishPageContext = new PublishPageContext(iPublishFolder, publishTaskContext);
        publishPageContext.setTemplate(template);
        try {
            String[] stringArray2 = PageGenerator.generateOutlines(publishPageContext);
            if (stringArray != null) {
                stringArray[0] = publishPageContext.getWarnings();
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        finally {
            publishPageContext.clear();
            publishTaskContext.clear();
        }
    }

    public String previewContent(IPublishContent iPublishContent, String[] stringArray) throws Exception {
        return this.previewContent(iPublishContent, stringArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String previewContent(IPublishContent iPublishContent, String[] stringArray, Template template) throws Exception {
        block7: {
            if (iPublishContent == null) {
                throw new WCMException(10, "ContentTypeConfig to publish required!");
            }
            try {
                iPublishContent.validateCanDoPreview();
            }
            catch (Exception exception) {
                if (template != null && exception instanceof CMyException && ((CMyException)exception).getErrNo() == 200003) break block7;
                throw exception;
            }
        }
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, iPublishContent.getFolder());
        PublishPageContext publishPageContext = new PublishPageContext(iPublishContent, publishTaskContext);
        publishPageContext.setTemplate(template);
        try {
            String string = PageGenerator.generateDetail(publishPageContext);
            if (stringArray != null) {
                stringArray[0] = publishPageContext.getWarnings();
            }
            String string2 = string;
            return string2;
        }
        finally {
            publishPageContext.clear();
            publishTaskContext.clear();
        }
    }

    public void publishFolder(IPublishFolder iPublishFolder, int n) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label4", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u53d1\u5e03\u7684\u5bf9\u8c61!"));
        }
        PublishServer.validateElement(iPublishFolder);
        PublishTask publishTask = this.m_taskManager.createFolderPublishTask(iPublishFolder, n);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void publishFolderAndPublishedDocs(IPublishFolder iPublishFolder, int n, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label4", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u53d1\u5e03\u7684\u5bf9\u8c61!"));
        }
        PublishServer.validateElement(iPublishFolder);
        PublishTask publishTask = this.m_taskManager.createPublishTaskForFolderAndPubDocs(iPublishFolder, n, cMyDateTime, cMyDateTime2);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void deleteFolder(IPublishFolder iPublishFolder) throws Exception {
        this.deleteFolder(iPublishFolder, true);
    }

    public void deleteFolder(IPublishFolder iPublishFolder, boolean bl) throws Exception {
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig to delete is required!");
        }
        PageDestroyer.withdraw(iPublishFolder, null);
        if (bl) {
            iPublishFolder.setPublishStatus(10);
        }
        this.updateFoldersQuotingMe(iPublishFolder);
    }

    public void deleteFolderSelfOnly(IPublishFolder iPublishFolder) throws Exception {
        if (iPublishFolder == null) {
            return;
        }
        PageDestroyer.withdraw(iPublishFolder, null);
        this.updateFoldersQuotingMe(iPublishFolder);
    }

    public void publishContent(IPublishContent iPublishContent, IPublishElements iPublishElements) throws WCMException {
        PublishTask publishTask;
        if (iPublishContent == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label5", "\u7f3a\u5c11\u5f85\u53d1\u5e03\u7684\u6587\u6863\uff01"));
        }
        IPublishFolder iPublishFolder = iPublishContent.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label6", "\u5f85\u53d1\u5e03\u7684\u6587\u6863\u7f3a\u5c11\u76ee\u5f55\uff01"));
        }
        if (!iPublishFolder.canDoDetailPageTask() && iPublishContent.getDetailTemplate() == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + iPublishFolder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
        }
        if (iPublishElements != null) {
            for (int i = iPublishElements.size() - 1; i >= 0; --i) {
                IPublishFolder iPublishFolder2 = (IPublishFolder)iPublishElements.get(i);
                if (iPublishFolder2 != null && iPublishFolder2.canDoOutlinePageTask()) continue;
                iPublishElements.remove(i);
            }
        }
        if ((publishTask = this.m_taskManager.createContentPublishTask(iPublishContent, iPublishFolder, iPublishElements)) == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void publishContent(IPublishContent iPublishContent, int n) throws WCMException {
        Object object;
        if (iPublishContent == null) {
            throw new WCMException(10, "ContentTypeConfig to publish required!");
        }
        if (iPublishContent.getFolder() == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (plz call IPublishContent.setFolder())!");
        }
        boolean bl = ConfigServer.getServer().getSysConfigValue("DIRECTPUB_STATUS_CHECK", "false").trim().equalsIgnoreCase("true");
        if (7 == n) {
            PublishServer.validateElement(iPublishContent.getFolder());
        } else if (n == 10 && !bl) {
            object = iPublishContent.getFolder();
            if (!object.canDoDetailPageTask() && iPublishContent.getDetailTemplate() == null) {
                throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + object.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
            }
        } else {
            PublishServer.validateElement(iPublishContent);
        }
        object = this.m_taskManager.createContentPublishTask(iPublishContent, n);
        if (object == null) {
            return;
        }
        this.m_taskDispatcher.pushTask((PublishTask)object);
    }

    public void publishContent(IPublishContent iPublishContent) throws Exception {
        this.publishContent(iPublishContent, 3);
    }

    public void publishContents(IPublishElements iPublishElements, IPublishFolder iPublishFolder, int n) throws Exception {
        if (iPublishElements == null) {
            throw new WCMException(10, "Contents to publish is required!");
        }
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        PublishServer.validateElement(iPublishFolder);
        if (iPublishElements.isEmpty()) {
            return;
        }
        int n2 = 0;
        IPublishContent iPublishContent = null;
        int n3 = iPublishElements.size();
        for (int i = 0; i < n3; ++i) {
            iPublishContent = (IPublishContent)iPublishElements.get(i);
            if (iPublishContent == null) continue;
            if (iPublishFolder.isRoot()) {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            } else {
                iPublishContent.setFolder(iPublishFolder);
            }
            if (7 != n) {
                iPublishContent.validateCanDoPub();
            }
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        PublishTask publishTask = null;
        publishTask = n2 == 1 ? this.m_taskManager.createContentPublishTask(iPublishContent, n) : this.m_taskManager.createContentPublishTask(iPublishElements, iPublishFolder, n);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void deleteContent(IPublishContent iPublishContent) throws Exception {
        if (iPublishContent == null) {
            throw new WCMException(10, "ContentTypeConfig to delete required!");
        }
        IPublishFolder iPublishFolder = iPublishContent.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (call IPublishContent.setFolder())!");
        }
        this.withdrawFileIfNeed(iPublishContent, false);
        iPublishContent.setPublishStatus(10);
        iPublishContent.setPublishTimeAndURL(null, null);
        PublishTask publishTask = this.m_taskManager.createDeleteContentsSynPublishTask(iPublishFolder, iPublishContent);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContents(IPublishElements iPublishElements, IPublishFolder iPublishFolder) throws Exception {
        if (iPublishElements == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (iPublishElements.isEmpty()) {
            return;
        }
        PublishTaskContext publishTaskContext = null;
        try {
            for (int i = 0; i < iPublishElements.size(); ++i) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
                iPublishContent.setFolder(iPublishFolder);
                this.withdrawFileIfNeed(iPublishContent, false);
                iPublishContent.setPublishStatus(10);
                iPublishContent.setPublishTimeAndURL(null, null);
            }
        }
        finally {
            if (publishTaskContext != null) {
                publishTaskContext.clear();
            }
        }
        PublishTask publishTask = this.m_taskManager.createDeleteContentsSynPublishTask(iPublishFolder, iPublishElements);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void deleteContents(IPublishElements iPublishElements, IPublishFolder iPublishFolder, IPublishElements iPublishElements2) throws Exception {
        this.deleteContents(iPublishElements, iPublishFolder, iPublishElements2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContents(IPublishElements iPublishElements, IPublishFolder iPublishFolder, IPublishElements iPublishElements2, boolean bl) throws Exception {
        if (iPublishElements == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (iPublishElements.isEmpty()) {
            return;
        }
        PublishTaskContext publishTaskContext = null;
        try {
            for (int i = 0; i < iPublishElements.size(); ++i) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
                iPublishContent.setFolder(iPublishFolder);
                this.withdrawFileIfNeed(iPublishContent, false);
                if (bl) {
                    iPublishContent.setPublishStatus(10);
                }
                iPublishContent.setPublishTimeAndURL(null, null);
            }
        }
        finally {
            if (publishTaskContext != null) {
                publishTaskContext.clear();
            }
        }
        PublishTask publishTask = this.m_taskManager.createDestroyPublishTask(iPublishElements, iPublishFolder, iPublishElements2);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    public void deleteContentsWithMirror(IPublishElements iPublishElements, IPublishFolder iPublishFolder, IPublishElements iPublishElements2) throws Exception {
        if (iPublishElements == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (iPublishElements.isEmpty()) {
            return;
        }
        for (int i = 0; i < iPublishElements.size(); ++i) {
            IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
            iPublishContent.setFolder(iPublishFolder);
            this.withdrawFileIfNeed(iPublishContent, true);
            iPublishContent.setPublishStatus(10);
            iPublishContent.setPublishTimeAndURL(null, null);
        }
        PublishTask publishTask = this.m_taskManager.createDestroyPublishTask(iPublishElements, iPublishFolder, iPublishElements2);
        if (publishTask == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(publishTask);
    }

    private void withdrawFileIfNeed(IPublishContent iPublishContent, boolean bl) throws Exception {
        int n = iPublishContent.getModal();
        if (n != 2) {
            PageDestroyer.withdraw(iPublishContent, null);
        }
        if (!bl) {
            return;
        }
        int n2 = 10;
        boolean bl2 = n == 1;
        IPublishElements iPublishElements = this.getMirrorFolders(iPublishContent.getId());
        StringBuffer stringBuffer = null;
        if (iPublishElements != null && iPublishElements.size() > 0) {
            IPublishFolder iPublishFolder = iPublishContent.getFolder();
            if (!bl2) {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
                try {
                    PageDestroyer.withdraw(iPublishContent, null);
                    iPublishContent.setPublishStatus(n2);
                    iPublishContent.setPublishTimeAndURL(null, null);
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer(1024);
                    stringBuffer.append("Failed to withdraw: ");
                    stringBuffer.append(iPublishContent.getInfo());
                    stringBuffer.append(" in: ");
                    stringBuffer.append(iPublishContent.getOriginalHome());
                }
            }
            int n3 = iPublishElements.size();
            for (int i = 0; i < n3; ++i) {
                IPublishFolder iPublishFolder2 = (IPublishFolder)iPublishElements.get(i);
                if (iPublishFolder2 == null) continue;
                iPublishContent.setFolder(iPublishFolder2);
                try {
                    PageDestroyer.withdraw(iPublishContent, null);
                    iPublishContent.setPublishStatus(n2);
                    iPublishContent.setPublishTimeAndURL(null, null);
                    continue;
                }
                catch (Exception exception) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(1024);
                        stringBuffer.append("Failed to withdraw: ");
                        stringBuffer.append(iPublishContent.getInfo());
                        stringBuffer.append(" in: ");
                        stringBuffer.append(iPublishFolder2.getInfo());
                        continue;
                    }
                    stringBuffer.append(", ").append(iPublishFolder2.getInfo());
                }
            }
            iPublishContent.setFolder(iPublishFolder);
        }
        if (stringBuffer != null) {
            throw new Exception(stringBuffer.toString());
        }
    }

    private IPublishElements getMirrorFolders(int n) throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select chnlid from wcmchnldoc where modal=3 and docid=?";
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer = new StringBuffer(64);
            while (resultSet.next()) {
                stringBuffer.append(',').append(resultSet.getInt(1));
            }
            if (stringBuffer.length() > 1) {
                IPublishElements iPublishElements = PublishElementFactory.lookupElements(101, stringBuffer.substring(1));
                return iPublishElements;
            }
        }
        catch (Exception exception) {
            throw new WCMException("\u64a4\u9500\u53d1\u5e03\u5931\u8d25!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            dBManager.freeConnection(connection);
        }
        return null;
    }

    private void updateFoldersQuotingMe(IPublishFolder iPublishFolder) throws WCMException {
        Collection collection = null;
        try {
            collection = iPublishFolder instanceof IFolderQuoter ? ((IFolderQuoter)((Object)iPublishFolder)).getFoldersQuotingMe(true) : iPublishFolder.getFoldersQuotingMe();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (IPublishFolder iPublishFolder2 : collection) {
                PublishTask publishTask = this.m_taskManager.createFolderPublishTask(iPublishFolder2, 8);
                if (publishTask == null) {
                    return;
                }
                this.m_taskDispatcher.pushTask(publishTask);
            }
        }
        catch (Exception exception) {
            throw new WCMException(222, I18NMessage.get(PublishServer.class, "PublishServer.label9", "\u66f4\u65b0\u53d1\u5e03\u5f15\u7528[") + iPublishFolder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label10", "]\u7684\u6587\u4ef6\u5939\u5931\u8d25\uff01"), exception);
        }
        finally {
            if (collection != null) {
                collection.clear();
            }
        }
    }

    public PublishTasks getMyTasks(WCMFilter wCMFilter) throws Exception {
        return this.m_taskManager.getTasks(wCMFilter);
    }

    public PublishTasks getAllTasks(WCMFilter wCMFilter) throws Exception {
        return this.m_taskManager.getTasks(wCMFilter);
    }

    public void pauseTask(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (publishTask.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.pauseTask(publishTask.getId());
    }

    public void resumeTask(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (publishTask.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.resumeTask(publishTask.getId());
    }

    public PublishTaskRuntime getTaskRuntime(int n) {
        return this.m_taskDispatcher.getTaskRuntime(n);
    }

    public PublishTask getRunningTask(int n) {
        return this.m_taskDispatcher.getRunningTask(n);
    }

    public Iterator getRunningTasks() {
        return this.m_taskDispatcher.getRunningTasks();
    }

    public void cancelTask(PublishTask publishTask) throws WCMException {
        if (publishTask == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (publishTask.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.cancelTask(publishTask.getId());
    }

    public void deleteTask(PublishTask publishTask) throws Exception {
        if (publishTask == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (!publishTask.isExecuted()) {
            this.m_taskDispatcher.cancelTask(publishTask.getId());
        }
        publishTask.delete(ContextHelper.getLoginUser());
    }

    public void cancelTask(PublishTasks publishTasks) throws Exception {
        if (publishTasks == null) {
            throw new WCMException(10, "The publish tasks collection is required!");
        }
        if (publishTasks.isEmpty()) {
            return;
        }
        for (int i = 0; i < publishTasks.size(); ++i) {
            PublishTask publishTask = (PublishTask)publishTasks.getAt(i);
            if (publishTask.isExecuted()) continue;
            this.m_taskDispatcher.cancelTask(publishTask.getId());
        }
    }

    public void redoTask(PublishTask publishTask) throws Exception {
        this.redoTask(publishTask, ContextHelper.getLoginUser());
    }

    public void redoTask(PublishTasks publishTasks) throws Exception {
        if (publishTasks == null) {
            throw new WCMException(10, "The publish tasks collection is required!");
        }
        if (publishTasks.isEmpty()) {
            return;
        }
        User user = publishTasks.getCurrUser();
        for (int i = 0; i < publishTasks.size(); ++i) {
            this.redoTask((PublishTask)publishTasks.getAt(i), user);
        }
    }

    private void redoTask(PublishTask publishTask, User user) throws Exception {
        if (publishTask == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (!publishTask.isExecuted()) {
            throw new WCMException(223, "The publish task must has been executed before re-start!");
        }
        PublishTask publishTask2 = publishTask.duplicate(user, true);
        this.m_taskDispatcher.pushTask(publishTask2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int distributeFile(String string, IPublishElement iPublishElement) throws WCMException {
        FileDistributeShip fileDistributeShip = new FileDistributeShip();
        try {
            int n = fileDistributeShip.distributeFile(string, iPublishElement);
            return n;
        }
        finally {
            fileDistributeShip.clear();
        }
    }

    public static void validateElement(int n, int n2) throws WCMException {
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n, n2);
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u53d1\u5e03\u5bf9\u8c61\uff01[Type=") + n + ",Id=" + n2 + "]");
        }
        PublishServer.validateElement(iPublishElement);
    }

    public static void validateElement(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label12", "\u6ca1\u6709\u6307\u5b9a\u53d1\u5e03\u5bf9\u8c61\uff01"));
        }
        iPublishElement.validateCanDoPub();
    }

    public static boolean isValidateElement(IPublishElement iPublishElement) {
        try {
            PublishServer.validateElement(iPublishElement);
            return true;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label13", "\u53d1\u5e03\u5143\u7d20[") + iPublishElement.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label14", "]\u7684\u975e\u6cd5\uff01")), throwable);
            }
            return false;
        }
    }

    public static boolean isValidateElement(int n, int n2) {
        try {
            PublishServer.validateElement(n, n2);
            return true;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label15", "\u53d1\u5e03\u5143\u7d20[Type=") + n + ", Id=" + n2 + I18NMessage.get(PublishServer.class, "PublishServer.label16", "]\u975e\u6cd5\uff01")), throwable);
            }
            return false;
        }
    }

    private String getFolderIndexFile(IPublishFolder iPublishFolder) {
        return "index.html";
    }

    private String makeBackupFileFor(String string) {
        return string + ".bak";
    }

    public void publishConfirm(IPublishFolder iPublishFolder, String string, String string2, String string3) throws WCMException {
        String string4;
        String string5;
        if (iPublishFolder == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label17", "\u7f3a\u5c11\u5f85\u786e\u8ba4\u7684\u76ee\u5f55\uff01"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label18", "\u7f3a\u5c11\u5f85\u786e\u8ba4\u7684\u5143\u6587\u4ef6\uff01"));
        }
        if (string2 == null) {
            string2 = this.getFolderIndexFile(iPublishFolder);
            logger.info((Object)I18NMessage.get(PublishServer.class, "PublishServer.label19", "\u4ece\u7cfb\u7edf\u914d\u7f6e\u8bfb\u53d6\u76ee\u6807\u914d\u7f6e\u6587\u4ef6..."));
        }
        if (string3 == null) {
            string3 = this.makeBackupFileFor(string2);
            logger.info((Object)I18NMessage.get(PublishServer.class, "PublishServer.label20", "\u4ece\u7cfb\u7edf\u914d\u7f6e\u8bfb\u53d6\u5907\u4efd\u914d\u7f6e\u6587\u4ef6..."));
        }
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string6 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishFolder, false), File.separatorChar);
        try {
            if (CMyFile.fileExists(string6 + string)) {
                if (CMyFile.fileExists(string6 + string2)) {
                    CMyFile.copyFile(string6 + string2, string6 + string3);
                }
                CMyFile.copyFile(string6 + string, string6 + string2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(PublishServer.class, "PublishServer.label21", "\u62f7\u8d1d\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff01"), (Throwable)exception);
        }
        String string7 = PublishPathCompass.calFullDataPath(iPublishFolder, false);
        FileDistributeShip fileDistributeShip = new FileDistributeShip();
        String string8 = CMyDateTime.now().toString("yyyyMMdd_hhmmss");
        String string9 = string + "." + string8;
        if (!this.renameFile(iPublishFolder, string, string7, fileDistributeShip, string9)) {
            return;
        }
        String string10 = string3 + "." + string8;
        if (this.renameFile(iPublishFolder, string3, string7, fileDistributeShip, string10)) {
            try {
                fileDistributeShip.withdrawFile(string10, iPublishFolder, string7);
            }
            catch (Exception exception) {
                logger.error((Object)I18NMessage.get(PublishServer.class, "PublishServer.label22", "\u5df2\u7ecf\u5ffd\u7565\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u5220\u9664\u539f\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef"), (Throwable)exception);
            }
        }
        if (this.renameFile(iPublishFolder, string2, string7, fileDistributeShip, string5 = string2 + "." + string8)) {
            try {
                fileDistributeShip.renameFile(iPublishFolder, string5, string3, string7);
            }
            catch (Exception exception) {
                string4 = I18NMessage.get(PublishServer.class, "PublishServer.label23", "\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u91cd\u547d\u540d\u6b63\u5f0f\u76ee\u6807\u6587\u4ef6\u4e3a\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef");
                logger.error((Object)string4, (Throwable)exception);
            }
        }
        try {
            fileDistributeShip.renameFile(iPublishFolder, string9, string2, string7);
        }
        catch (Exception exception) {
            string4 = I18NMessage.get(PublishServer.class, "PublishServer.label23", "\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u91cd\u547d\u540d\u6b63\u5f0f\u76ee\u6807\u6587\u4ef6\u4e3a\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef");
            logger.error((Object)string4, (Throwable)exception);
            throw new WCMException(string4, exception);
        }
    }

    private boolean renameFile(IPublishFolder iPublishFolder, String string, String string2, FileDistributeShip fileDistributeShip, String string3) {
        try {
            fileDistributeShip.renameFile(iPublishFolder, string, string3, string2);
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label24", "\u66f4\u540d\u6587\u4ef6\u5931\u8d25\uff01") + string + "-->" + string3));
            return false;
        }
        return true;
    }
}

