/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventMgr;
import com.trs.components.common.calendar.EventShare;
import com.trs.components.common.calendar.EventShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;

public class EventShareIdsMan
extends BaseIdsMan {
    private EventShares m_existsShares;
    private EventMgr m_eventMgr;
    private int m_nSharerType;
    private Event m_event;

    protected EventShareIdsMan() {
    }

    public EventShareIdsMan(int n, int n2) throws WCMException {
        this.assertValidSharerType(n2);
        this.m_nSharerType = n2;
        this.m_event = Event.findById(n);
        this.m_eventMgr = (EventMgr)DreamFactory.createObjectById("EventMgr");
        this.m_existsShares = this.m_eventMgr.getEventShares(n, n2);
    }

    private void assertValidSharerType(int n) throws WCMException {
        if (204 != n && 201 != n) {
            throw new WCMException(10, I18NMessage.get(EventShareIdsMan.class, "EventShareIdsMan.label1", "\u65e0\u6548\u7684\u65e5\u7a0b\u5171\u4eab\u8005\u7c7b\u578b!"));
        }
    }

    protected int getExistsSize() {
        return this.m_existsShares.size();
    }

    protected int getExistsIdAt(int n) {
        return ((EventShare)this.m_existsShares.getAt(n)).getId();
    }

    protected void deleteExists(int n) throws WCMException {
        this.m_existsShares.removeAt(n);
    }

    protected void addRelation(int n) throws WCMException {
        CMSObj cMSObj = null;
        cMSObj = 204 == this.m_nSharerType ? User.findById(n) : Group.findById(n);
        if (cMSObj == null) {
            return;
        }
        this.m_eventMgr.shareTo(this.m_event, cMSObj);
    }
}

