/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.EventShare;
import com.trs.components.common.calendar.EventShares;
import com.trs.components.common.calendar.Events;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MsgReceiver;
import com.trs.components.common.message.MsgReceivers;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class EventMgr {
    private static final int EVENTSHARER_TYPE_ALL = -1;

    public Event save(Event event) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label1", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u4fdd\u5b58!"));
        }
        event.save(ContextHelper.getLoginUser());
        return event;
    }

    public boolean delete(Event event) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label2", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        this.cancelShares(event);
        return event.delete(ContextHelper.getLoginUser()) == 1;
    }

    public Events getDailyEvents(CMyDateTime cMyDateTime, WCMFilter wCMFilter) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(EventMgr.class, "EventMgr.label3", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label4", "\u65e0\u6548\u7684\u65e5\u671f,\u65e0\u6cd5\u83b7\u53d6\u5f53\u65e5\u7684\u65e5\u7a0b\u5b89\u6392"));
        }
        StringBuffer stringBuffer = new StringBuffer("Owner='");
        stringBuffer.append(CMyString.filterForSQL(user.getName()));
        stringBuffer.append("' AND ");
        this.setDateZoneSql(cMyDateTime, stringBuffer);
        WCMFilter wCMFilter2 = new WCMFilter("", stringBuffer.toString(), "EventId desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Events.openWCMObjs(user, wCMFilter2);
    }

    private void setDateZoneSql(CMyDateTime cMyDateTime, StringBuffer stringBuffer) throws WCMException {
        String[] stringArray = this.getDateZone(cMyDateTime);
        stringBuffer.append("EStart<=");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append(" AND ");
        stringBuffer.append("EEnd>=");
        stringBuffer.append(stringArray[1]);
    }

    public Events getEvents(User user, CMyDateTime cMyDateTime, boolean bl, WCMFilter wCMFilter) throws WCMException {
        Object object;
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label5", "\u65e0\u6548\u7684\u5f53\u524d\u7528\u6237!"));
        }
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label4", "\u65e0\u6548\u7684\u65e5\u671f,\u65e0\u6cd5\u83b7\u53d6\u5f53\u65e5\u7684\u65e5\u7a0b\u5b89\u6392"));
        }
        int n = user.getId();
        StringBuffer stringBuffer = new StringBuffer();
        this.setDateZoneSql(cMyDateTime, stringBuffer);
        stringBuffer.append(" AND (");
        if (bl) {
            object = new StringBuffer();
            ((StringBuffer)object).append("(OBJID=");
            ((StringBuffer)object).append(n);
            ((StringBuffer)object).append(" AND OBJTYPE=");
            ((StringBuffer)object).append(204);
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(" OR ");
            ((StringBuffer)object).append("(OBJTYPE=");
            ((StringBuffer)object).append(201);
            ((StringBuffer)object).append(" AND EXISTS(");
            ((StringBuffer)object).append(" SELECT ");
            ((StringBuffer)object).append("GROUPID");
            ((StringBuffer)object).append(" FROM ");
            ((StringBuffer)object).append("WCMGRPUSER");
            ((StringBuffer)object).append(" GrpUser WHERE ");
            ((StringBuffer)object).append("USERID");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(n);
            ((StringBuffer)object).append(" AND ");
            ((StringBuffer)object).append("GrpUser.");
            ((StringBuffer)object).append("GROUPID");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append("WCMEVENTSHARE.OBJID");
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(")");
            EventShares eventShares = EventShares.openWCMObjs(user, new WCMFilter("", ((StringBuffer)object).toString(), ""));
            String string = ",";
            for (int i = 0; i < eventShares.size(); ++i) {
                EventShare eventShare = (EventShare)eventShares.getAt(i);
                if (eventShare == null) continue;
                string = string + eventShare.getEventId() + ",";
            }
            if (string.length() > 1) {
                stringBuffer.append("EVENTID");
                stringBuffer.append(" IN (");
                stringBuffer.append(string.substring(1, string.length() - 1));
                stringBuffer.append(")");
                stringBuffer.append(" OR ");
            }
        }
        stringBuffer.append("Owner='");
        stringBuffer.append(CMyString.filterForSQL(user.getName()));
        stringBuffer.append("'");
        stringBuffer.append(")");
        object = new WCMFilter("", stringBuffer.toString(), "");
        ((WCMFilter)object).mergeWith(wCMFilter);
        return this.getEvents((WCMFilter)object);
    }

    private String[] getDateZone(CMyDateTime cMyDateTime) throws WCMException {
        String[] stringArray = new String[2];
        String string = CMyDateTime.getStr(cMyDateTime, "yyyy-MM-dd");
        stringArray[0] = this.getDBManager().getDBType().sqlDateTime(string + " 23:59:59", "YYYY-MM-DD HH24:MI:SS");
        stringArray[1] = this.getDBManager().getDBType().sqlDateTime(string + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        return stringArray;
    }

    public Users getUsers(Event event) throws WCMException {
        if (event == null || !event.isShared()) {
            return Users.createNewInstance(ContextHelper.getLoginUser());
        }
        String string = "EXISTS (SELECT ObjId FROM WCMEVENTSHARE WHERE ObjType=204 AND EventId=" + event.getId() + " AND WCMEVENTSHARE.OBJID=WCMUSER.USERID )";
        WCMFilter wCMFilter = new WCMFilter("WCMUSER", string, "");
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Groups getGroups(Event event) throws WCMException {
        if (event == null || !event.isShared()) {
            return Groups.createNewInstance(ContextHelper.getLoginUser());
        }
        String string = "EXISTS (SELECT ObjId FROM WCMEVENTSHARE WHERE ObjType=201 AND EventId=" + event.getId() + " AND WCMEVENTSHARE.OBJID=WCMGROUP.GROUPID )";
        WCMFilter wCMFilter = new WCMFilter("WCMGROUP", string, "");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Events getEvents(WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMEVENT", "", "Estart desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Events.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public void shareTo(Event event, CMSObj cMSObj) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label6", "\u65e0\u6548\u7684Event\u5bf9\u8c61,\u65e0\u6cd5\u5171\u4eab!"));
        }
        if (!this.isValidSharer(cMSObj)) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label7", "\u4e0d\u6b63\u786e\u7684\u5171\u4eab\u8005\u7c7b\u578b!"));
        }
        int n = cMSObj.getId();
        int n2 = cMSObj.getWCMType();
        EventShare eventShare = this.getEventShare(event.getId(), n, n2);
        if (eventShare != null) {
            return;
        }
        eventShare = EventShare.createNewInstance();
        eventShare.setEventId(event.getId());
        eventShare.setObjId(n);
        eventShare.setObjType(n2);
        eventShare.insert(ContextHelper.getLoginUser());
        if (!event.isShared()) {
            event.canEdit(ContextHelper.getLoginUser());
            event.setShare(true);
            event.save(ContextHelper.getLoginUser());
        }
        this.addMsgReceivers(event, cMSObj);
    }

    private void addMsgReceivers(Event event, CMSObj cMSObj) throws WCMException {
        Message message = Message.findById(event.getRemindMsgId());
        if (message == null) {
            return;
        }
        int n = cMSObj.getId();
        int n2 = cMSObj.getWCMType();
        String string = "";
        if (n2 == 204) {
            string = ((User)cMSObj).getName();
        }
        if (n2 == 201) {
            string = ((Group)cMSObj).getName();
        }
        if (n2 == 203) {
            string = ((Role)cMSObj).getName();
        }
        WCMFilter wCMFilter = new WCMFilter("", "MsgId=" + message.getId() + " and ReceiverId=" + n + " and ReceiverType=" + n2, "");
        wCMFilter.setMaxRowNumber(1);
        MsgReceivers msgReceivers = MsgReceivers.openWCMObjs(wCMFilter);
        if (!msgReceivers.isEmpty()) {
            return;
        }
        MsgReceiver msgReceiver = MsgReceiver.createNewInstance();
        msgReceiver.setMsgId(message.getId());
        msgReceiver.setReceiverId(n);
        msgReceiver.setReceiverType(n2);
        msgReceiver.setReceiverName(string);
        msgReceiver.insert();
    }

    private void removeMsgReceivers(Event event, CMSObj cMSObj) throws WCMException {
        Message message = Message.findById(event.getRemindMsgId());
        if (message == null) {
            return;
        }
        String string = "MsgId=" + message.getId();
        if (cMSObj != null) {
            int n = cMSObj.getId();
            int n2 = cMSObj.getWCMType();
            string = string + " and ReceiverId=" + n + " and ReceiverType=" + n2;
        } else {
            User user = event.getCrUser();
            if (user != null) {
                string = string + " and not(ReceiverId=" + user.getId() + " and ReceiverType=" + user.getWCMType() + ")";
            }
        }
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        MsgReceivers msgReceivers = MsgReceivers.openWCMObjs(wCMFilter);
        if (msgReceivers.isEmpty()) {
            return;
        }
        msgReceivers.removeAll();
    }

    private boolean isValidSharer(CMSObj cMSObj) {
        if (cMSObj == null) {
            return false;
        }
        return 204 == cMSObj.getWCMType() || 201 == cMSObj.getWCMType();
    }

    public void cancelShare(Event event, CMSObj cMSObj) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label8", "\u65e0\u6548\u7684Event\u5bf9\u8c61!"));
        }
        if (!event.isShared()) {
            return;
        }
        if (!this.isValidSharer(cMSObj)) {
            return;
        }
        EventShare eventShare = this.getEventShare(event.getId(), cMSObj.getId(), cMSObj.getWCMType());
        if (eventShare == null) {
            return;
        }
        this.removeMsgReceivers(event, cMSObj);
        eventShare.delete(ContextHelper.getLoginUser());
    }

    private EventShare getEventShare(int n, int n2, int n3) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer("EventId=");
        stringBuffer.append(n);
        stringBuffer.append(" AND ObjId=");
        stringBuffer.append(n2);
        stringBuffer.append(" AND ObjType=");
        stringBuffer.append(n3);
        WCMFilter wCMFilter = new WCMFilter("WCMEVENTSHARE", stringBuffer.toString(), "", "EVENTSHAREID", 1);
        EventShares eventShares = EventShares.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (eventShares.isEmpty()) {
            return null;
        }
        return (EventShare)eventShares.getAt(0);
    }

    public void cancelShares(Event event) throws WCMException {
        if (event == null) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label8", "\u65e0\u6548\u7684Event\u5bf9\u8c61!"));
        }
        if (!event.isShared()) {
            return;
        }
        EventShares eventShares = this.getEventShares(event.getId(), -1);
        eventShares.removeAll();
        this.removeMsgReceivers(event, null);
        event.canEdit(ContextHelper.getLoginUser());
        event.setShare(false);
        event.update(ContextHelper.getLoginUser());
    }

    EventShares getEventShares(int n, int n2) throws WCMException {
        String string = "EventId=" + n;
        if (-1 != n2) {
            string = string + " AND ObjType=" + n2;
        }
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        EventShares eventShares = EventShares.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        return eventShares;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label9", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(EventMgr.class, "EventMgr.label10", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }
}

