/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.EventType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.message.Message;
import com.trs.components.common.reminder.Reminder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;

public class Event
extends CMSObj {
    public static final int OBJ_TYPE = 306;
    public static final String DB_TABLE_NAME = "WCMEVENT";
    public static final String DB_ID_NAME = "EVENTID";
    public static final int[] ALL_REMIND_TYPES = new int[]{0, 1, 2};

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 306;
    }

    public String getTitle() {
        return (String)this.getProperty("TITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        return this.setProperty("TITLE", string);
    }

    public String getDesc() {
        return (String)this.getProperty("EDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("EDESC", string);
    }

    public int getTypeId() {
        return this.getPropertyAsInt("ETYPE", 0);
    }

    public EventType getType() throws WCMException {
        int n = this.getTypeId();
        if (n == 0) {
            return null;
        }
        return EventType.findById(n);
    }

    public boolean setType(int n) throws WCMException {
        System.out.println(n);
        EventType eventType = EventType.findById(n);
        return this.setType(eventType);
    }

    public boolean setType(EventType eventType) throws WCMException {
        if (eventType == null || !eventType.isValidInstance()) {
            throw new WCMException(1104, I18NMessage.get(Event.class, "Event.label1", "Type\u503c\u65e0\u6548(Event.setType)"));
        }
        return this.setProperty("ETYPE", eventType.getId());
    }

    public String getOwnerName() {
        return (String)this.getProperty("OWNER");
    }

    public User getOwner() {
        String string = this.getOwnerName();
        return string == null ? null : User.findByName(string);
    }

    public boolean setOwner(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label2", "\u5c5e\u6027Owner\u4e0d\u5141\u8bb8\u4fee\u6539(Event.setOwner)"));
        }
        return this.setProperty("OWNER", string);
    }

    public boolean setOwner(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Event.class, "Event.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Event.setOwner)"));
        }
        return this.setOwner(user.getName());
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("ESTART");
    }

    public boolean setStartTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label4", "\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f(Event.setStartTime)"));
        }
        return this.setProperty("ESTART", cMyDateTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EEND");
    }

    public boolean setEndTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label5", "\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f(Event.setEndTime)"));
        }
        return this.setProperty("EEND", cMyDateTime);
    }

    private String getRemindFieldName(int n) throws WCMException {
        switch (n) {
            case 0: {
                return "ONLINEREMIND";
            }
            case 1: {
                return "EMAILREMIND";
            }
            case 2: {
                return "MOBILEREMIND";
            }
        }
        throw new WCMException(10, I18NMessage.get(Event.class, "Event.label6", "\u65e0\u6548\u7684\u63d0\u9192\u7c7b\u522b\uff08Event.getRemindFieldName\uff09"));
    }

    public boolean isRemindBy(int n) throws WCMException {
        String string = this.getRemindFieldName(n);
        int n2 = this.getPropertyAsInt(string, 0);
        return n2 == 1;
    }

    public String getSendTypes() throws WCMException {
        String string = "";
        for (int i = 0; i < ALL_REMIND_TYPES.length; ++i) {
            int n = ALL_REMIND_TYPES[i];
            if (!this.isRemindBy(n)) continue;
            string = string + "," + this.getSendTypeName(n);
        }
        if (string.length() > 2) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    private String getSendTypeName(int n) {
        switch (n) {
            case 0: {
                return "Message";
            }
            case 1: {
                return "Email";
            }
            case 2: {
                return "SMS";
            }
        }
        return "";
    }

    public boolean setRemindBy(int n, boolean bl) throws WCMException {
        if (!this.isAddMode() && this.isRemindDone(n)) {
            return true;
        }
        String string = this.getRemindFieldName(n);
        return this.setProperty(string, bl ? 1 : 0);
    }

    public boolean isRemindDone(int n) throws WCMException {
        String string = this.getRemindFieldName(n);
        int n2 = this.getPropertyAsInt(string, 0);
        return n2 == 2;
    }

    public boolean setRemindDone(int n) throws WCMException {
        String string = this.getRemindFieldName(n);
        int n2 = ((Number)this.getProperty(string)).intValue();
        if (n2 != 1) {
            throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label7", "\u65e0\u6548\u64cd\u4f5c\uff1a\u5f53\u524d\u8bbe\u7f6e\u4e3a\u65e0\u63d0\u9192\uff08Event.setRemindDone\uff09"));
        }
        return this.setProperty(string, 2L);
    }

    public int getAheadRemindTime() {
        return this.getPropertyAsInt("AHEADREMDTIME", 0);
    }

    public boolean setAheadRemindTime(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(Event.class, "Event.label8", "\u65e0\u6548\u7684\u53c2\u6570\u503c(Event.setAheadRemindTime)"));
        }
        return this.setProperty("AHEADREMDTIME", n);
    }

    public boolean isShared() {
        return this.getPropertyAsBoolean("ISSHARE", false);
    }

    public boolean setShare(boolean bl) throws WCMException {
        return this.setProperty("ISSHARE", bl);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String string) throws WCMException {
        return this.setProperty("EMAIL", string);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("TITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label9", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("ESTART") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label10", "\u5c5e\u6027StartTime\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("EEND") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label11", "\u5c5e\u6027EndTime\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("OWNER") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label12", "\u5c5e\u6027Owner\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("ETYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label13", "\u5c5e\u6027\u65e5\u7a0b\u5b89\u6392\u7684\u4e8b\u4ef6\u7c7b\u578bEType\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)!"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Event.class, "Event.label14", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Event.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            String string = null;
            string = this.getRemindFieldName(0);
            if (this.getProperty(string) == null) {
                this.setRemindBy(0, false);
            }
            if (this.getProperty(string = this.getRemindFieldName(1)) == null) {
                this.setRemindBy(1, false);
            }
            if (this.getProperty(string = this.getRemindFieldName(2)) == null) {
                this.setRemindBy(2, false);
            }
            if (this.getProperty("AHEADREMDTIME") == null) {
                this.setAheadRemindTime(10);
            }
            this.setCrTime();
            super.insert(user);
            this.doRemindJob();
        }
    }

    public synchronized void update(User user) throws WCMException {
        String string;
        boolean[] blArray = new boolean[ALL_REMIND_TYPES.length];
        boolean bl = false;
        for (int i = 0; i < ALL_REMIND_TYPES.length; ++i) {
            string = this.getRemindFieldName(ALL_REMIND_TYPES[i]);
            Number number = (Number)this.getNewProperty(string);
            if (number == null || number.intValue() != 1) {
                blArray[i] = false;
                continue;
            }
            Number number2 = (Number)this.getAllProperty().get(string);
            boolean bl2 = blArray[i] = number2 == null || number2.intValue() == 0;
            if (!blArray[i] || bl) continue;
            bl = true;
        }
        super.update(user);
        Message message = Message.findById(this.getRemindMsgId());
        boolean bl3 = bl = bl || message == null;
        if (bl) {
            try {
                this.doRemindJob();
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label15", "\u5904\u7406\u63d0\u9192Job\u65f6\u5931\u8d25(Event.update)"), exception);
            }
        } else {
            string = this.getSendTypes();
            if (string.length() > 0) {
                message.canEdit(user);
                message.setSendTypes(this.getSendTypes());
                message.save(user);
            } else {
                message.delete(user);
                this.removeRemindJob(message, user);
            }
        }
    }

    private boolean setRemindMsgId(int n) throws WCMException {
        return this.setProperty("REMINDMSGID", n);
    }

    public int getRemindMsgId() {
        return this.getPropertyAsInt("REMINDMSGID", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemindJob() throws WCMException {
        try {
            String string = this.getSendTypes();
            if (string == null || string.length() == 0) {
                return;
            }
            Message message = Message.createNewInstance();
            message.setTitle(this.getTitle());
            message.setBody(this.getDesc());
            User user = User.findByName(this.getCrUserName());
            message.setReceivers(204, String.valueOf(user.getId()));
            message.setSendTypes(string);
            message.insert(this.getCrUser());
            try {
                this.canEdit(user);
                this.setRemindMsgId(message.getId());
                this.update(user);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            CMyDateTime cMyDateTime = (CMyDateTime)this.getStartTime().clone();
            cMyDateTime.dateAdd(5, this.getAheadRemindTime() * -1);
            Reminder.createSchedule(message, cMyDateTime);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label16", "\u5904\u7406\u63d0\u9192Job\u65f6\u5931\u8d25(Event.doRemindJob)"), exception);
        }
    }

    private void removeRemindJob(Message message, User user) throws WCMException {
        Schedule schedule = Schedule.findBySender(1, message);
        if (schedule != null) {
            schedule.delete(user);
        }
    }

    public static final Event findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Event)BaseObj.findById(Event.class, n);
    }

    public static final Event createNewInstance() throws WCMException {
        return (Event)BaseObj.createNewInstance(Event.class);
    }

    public static final Event findByKey(Object object) throws WCMException {
        return (Event)BaseObj.findByKey(Event.class, object);
    }
}

