/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import org.apache.log4j.Logger;

public class FlowNodeLCListenerForForceEnd
implements IObjectLCListenerOnDel {
    private static Logger s_logger = Logger.getLogger(FlowNodeLCListenerForForceEnd.class);
    private IFlowServer m_oFlowServer = null;

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof FlowNode)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        FlowNode flowNode = (FlowNode)baseObj;
        WCMFilter wCMFilter = new WCMFilter("", "NODEID=? and Worked=0 and ParentId=0", "", "ObjType, ObjId");
        wCMFilter.addSearchValues(flowNode.getId());
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), wCMFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        for (int i = 0; i < flowDocs.size(); ++i) {
            try {
                IFlowContent iFlowContent;
                FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
                if (flowDoc == null || (iFlowContent = flowDoc.getFlowContent()) == null) continue;
                FlowContext flowContext = new FlowContext();
                flowContext.setFlowContent(iFlowContent);
                flowContext.setPostUser(user);
                flowContext.setCurrUser(user);
                this.getFlowServer().forceEnd(flowContext);
                continue;
            }
            catch (Throwable throwable) {
                s_logger.error((Object)I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label3", "\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c\u53d1\u751f\u5f02\u5e38"), throwable);
            }
        }
    }

    private IFlowServer getFlowServer() {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        }
        return this.m_oFlowServer;
    }
}

