/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FlowContext {
    private boolean m_bFromRule = false;
    private long m_nSerialNum = -1L;
    private long m_nBranchSerialNum = -1L;
    private FlowDoc m_oCurrFlowDoc = null;
    private User m_oPostUser = null;
    private Users m_oToUsers = null;
    private String m_sPostDesc = null;
    private FlowNode m_oNextNode = null;
    private User m_oCurrUser = null;
    private Flow m_oCurrFlow = null;
    private boolean m_bIsStarting = false;
    private IFlowContent m_oFlowContent = null;
    private FlowNodeBranch m_oBranch = null;
    private FlowNode m_oCurrNode = null;
    private String m_sNotifyTypes = null;
    private Map m_hProperties = new HashMap();

    public FlowContext() {
    }

    public FlowContext(User user, IFlowContent iFlowContent, String string, Users users, Flow flow) throws WCMException {
        this.initFlowStartContext(user, iFlowContent, string, users, flow);
    }

    public FlowContext(User user, IFlowContent iFlowContent) throws WCMException {
        this.initFlowStartContext(user, iFlowContent, null, null, null);
    }

    private void initFlowStartContext(User user, IFlowContent iFlowContent, String string, Users users, Flow flow) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label1", "\u6ca1\u6709\u6307\u5b9a\u5f85\u6d41\u8f6c\u7684\u5185\u5bb9"));
        }
        this.m_oFlowContent = iFlowContent;
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label2", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237"));
        }
        this.m_oCurrUser = user;
        this.m_oPostUser = user;
        this.m_bIsStarting = true;
        this.m_sPostDesc = string;
        if (flow == null) {
            this.m_oCurrFlow = iFlowContent.getOwnerFlow();
            if (this.m_oCurrFlow == null) {
                throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label3", "\u6307\u5b9a\u7684\u5185\u5bb9[") + this.m_oFlowContent.getInfo() + I18NMessage.get(FlowContext.class, "FlowContext.label4", "]\u6ca1\u6709\u5de5\u4f5c\u6d41\u5c5e\u6027"));
            }
        } else {
            this.m_oCurrFlow = flow;
        }
        this.m_oCurrNode = this.m_oCurrFlow.getStartNode();
        FlowNodeBranchs flowNodeBranchs = this.m_oCurrNode.getBranchs(null);
        if (flowNodeBranchs == null || flowNodeBranchs.isEmpty()) {
            throw new WCMException(I18NMessage.get(FlowContext.class, "FlowContext.label5", "\u5de5\u4f5c\u6d41\u8bbe\u8ba1\u5f97\u6709\u95ee\u9898\uff0c\u5f00\u59cb\u8282\u70b9\u6ca1\u6709\u5206\u652f\uff01"));
        }
        this.m_oNextNode = ((FlowNodeBranch)flowNodeBranchs.getAt(0)).getNextNode(null);
        if (users != null && !users.isEmpty()) {
            this.m_oToUsers = users;
        }
    }

    public FlowDoc getCurrFlowDoc() {
        return this.m_oCurrFlowDoc;
    }

    public void setCurrFlowDoc(FlowDoc flowDoc) {
        this.m_oCurrFlowDoc = flowDoc;
    }

    public User getPostUser() {
        return this.m_oPostUser;
    }

    public void setPostUser(User user) {
        this.m_oPostUser = user;
    }

    public Users getToUsers() {
        return this.m_oToUsers;
    }

    public void setToUsers(Users users) {
        this.m_oToUsers = users;
    }

    public String getPostDesc() {
        return this.m_sPostDesc;
    }

    public void setPostDesc(String string) {
        this.m_sPostDesc = string;
    }

    public void validate() throws WCMException {
        if (this.m_oCurrUser == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label6", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u64cd\u4f5c\u7528\u6237"));
        }
        if (this.m_oPostUser == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label7", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u5904\u7406\u4eba"));
        }
        if (this.m_oCurrFlowDoc == null) {
            throw new WCMException(10, I18NMessage.get(FlowContext.class, "FlowContext.label8", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u5904\u7406\u7684\u8f68\u8ff9"));
        }
    }

    public FlowNode getNextNode() {
        return this.m_oNextNode;
    }

    public void setNextNode(FlowNode flowNode) {
        this.m_oNextNode = flowNode;
    }

    public User getCurrUser() {
        return this.m_oCurrUser;
    }

    public void setCurrUser(User user) {
        this.m_oCurrUser = user;
    }

    public boolean isStarting() {
        return this.m_bIsStarting;
    }

    public int getWorkModal() {
        if (this.isStarting()) {
            return 0;
        }
        return this.m_oCurrFlowDoc.getWorkModal();
    }

    public IFlowContent getFlowContent() throws WCMException {
        if (this.m_oFlowContent == null) {
            this.m_oFlowContent = this.m_oCurrFlowDoc.getFlowContent();
        }
        return this.m_oFlowContent;
    }

    public void setFlowContent(IFlowContent iFlowContent) {
        this.m_oFlowContent = iFlowContent;
    }

    public String getNotifyTypes() throws WCMException {
        if (CMyString.isEmpty(this.m_sNotifyTypes)) {
            FlowNode flowNode = this.getCurrNode();
            if (flowNode == null) {
                return null;
            }
            if (this.m_oNextNode == null) {
                return null;
            }
            if (this.getBranch() != null) {
                this.m_sNotifyTypes = this.m_oBranch.getNotifyTypes();
            }
        }
        return this.m_sNotifyTypes;
    }

    public FlowNode getCurrNode() throws WCMException {
        if (this.m_oCurrNode == null) {
            this.m_oCurrNode = this.m_oCurrFlowDoc == null ? this.m_oCurrFlow.getStartNode() : this.m_oCurrFlowDoc.getNode();
        }
        return this.m_oCurrNode;
    }

    public void setCurrNode(FlowNode flowNode) {
        this.m_oCurrNode = flowNode;
    }

    public void setNotifyTypes(String string) {
        this.m_sNotifyTypes = string;
    }

    public FlowNodeBranch getBranch() throws WCMException {
        FlowNode flowNode = this.getCurrNode();
        if (flowNode == null) {
            return null;
        }
        if (this.m_oBranch == null) {
            this.m_oBranch = flowNode.getBranchTo(null, this.m_oNextNode);
        }
        return this.m_oBranch;
    }

    public long getSerialNum() throws WCMException {
        if (this.m_nSerialNum == -1L) {
            if (this.m_oCurrFlowDoc == null) {
                if (this.isStarting()) {
                    this.m_nSerialNum = System.currentTimeMillis();
                } else {
                    ArrayList<Long> arrayList = new ArrayList<Long>(2);
                    arrayList.add(new Long(this.getFlowContent().getType()));
                    arrayList.add(new Long(this.getFlowContent().getId()));
                    this.m_nSerialNum = DBManager.getDBManager().sqlExecuteQuery("select max(SerialNum) from WCMFlowDoc where ObjType=? and ObjId=?", arrayList, System.currentTimeMillis());
                }
            } else {
                this.m_nSerialNum = this.m_oCurrFlowDoc.getSerialNum();
            }
        }
        return this.m_nSerialNum;
    }

    public void setSerialNum(long l) {
        this.m_nSerialNum = l;
    }

    public long getBranchSerialNum() throws WCMException {
        if (this.m_nBranchSerialNum == -1L) {
            if (this.m_oCurrFlowDoc == null) {
                if (this.isStarting()) {
                    this.m_nBranchSerialNum = System.currentTimeMillis();
                } else {
                    ArrayList<Long> arrayList = new ArrayList<Long>(2);
                    arrayList.add(new Long(this.getFlowContent().getType()));
                    arrayList.add(new Long(this.getFlowContent().getId()));
                    this.m_nBranchSerialNum = DBManager.getDBManager().sqlExecuteQuery("select max(BranchSerialNum) from WCMFlowDoc where ObjType=? and ObjId=?", arrayList, System.currentTimeMillis());
                }
            } else {
                this.m_nBranchSerialNum = this.m_oCurrFlowDoc.getBranchSerialNum();
            }
        }
        return this.m_nBranchSerialNum;
    }

    public Flow getCurrFlow() {
        return this.m_oCurrFlow;
    }

    public boolean isFromRule() {
        return this.m_bFromRule;
    }

    public void setFromRule(boolean bl) {
        this.m_bFromRule = bl;
    }

    public void setProperty(String string, Object object) {
        this.m_hProperties.put(string.toUpperCase(), object);
    }

    public Object getProperty(String string) {
        return this.m_hProperties.get(string.toUpperCase());
    }
}

