/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class FlowEmployCacheMgr
implements ICacheMgr {
    private static Logger s_logger = Logger.getLogger(FlowEmployCacheMgr.class);
    private LRUCacheContainer m_lruFlowEmployCache = null;
    private static final int MAX_CACHE_SIZE = 3000;

    Flow getFlowOfEmployer(int n, int n2) throws WCMException {
        return (Flow)this.getFlowEmployCache().get((Object)this.makeKey(n, n2));
    }

    private LRUCacheContainer getFlowEmployCache() throws WCMException {
        if (this.m_lruFlowEmployCache == null) {
            this.initFlowEmployCache();
        }
        return this.m_lruFlowEmployCache;
    }

    private synchronized void initFlowEmployCache() throws WCMException {
        if (this.m_lruFlowEmployCache != null) {
            return;
        }
        s_logger.info((Object)"init...");
        LRUCacheContainer lRUCacheContainer = new LRUCacheContainer();
        lRUCacheContainer.setMaxSize(3000);
        FlowEmploys flowEmploys = FlowEmploys.openWCMObjs(null, null);
        int n = flowEmploys.size();
        FlowEmploy flowEmploy = null;
        for (int i = 0; i < n; ++i) {
            flowEmploy = (FlowEmploy)flowEmploys.getAt(i);
            if (flowEmploy == null) continue;
            this.putInCache(flowEmploy, lRUCacheContainer);
        }
        this.m_lruFlowEmployCache = lRUCacheContainer;
    }

    private void putInCache(FlowEmploy flowEmploy, LRUCacheContainer lRUCacheContainer) throws WCMException {
        Flow flow = flowEmploy.getFlow();
        if (flow == null) {
            return;
        }
        lRUCacheContainer.put((Object)this.makeKey(flowEmploy), (Object)flow);
    }

    private String makeKey(FlowEmploy flowEmploy) {
        return this.makeKey(flowEmploy.getEmployerType(), flowEmploy.getEmployerId());
    }

    private String makeKey(int n, int n2) {
        return n + "_" + n2;
    }

    public void notify(int n, Object object, Object[] objectArray) {
    }

    public boolean init() throws WCMException {
        this.initFlowEmployCache();
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        if (this.m_lruFlowEmployCache == null) {
            return;
        }
        this.m_lruFlowEmployCache.clear();
        this.m_lruFlowEmployCache = null;
    }

    public boolean isDoNotify(int n, Object object, Object[] objectArray) {
        return false;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.putInCache((FlowEmploy)baseObj, this.getFlowEmployCache());
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.getFlowEmployCache().remove((Object)this.makeKey((FlowEmploy)baseObj));
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj.isChangeProperty("FLOWID")) {
            this.getFlowEmployCache().remove((Object)this.makeKey((FlowEmploy)baseObj));
            Flow flow = Flow.findById(baseObj.getNewPropertyAsInt("FLOWID", 0));
            if (flow != null) {
                this.getFlowEmployCache().put((Object)this.makeKey((FlowEmploy)baseObj), (Object)flow);
            }
        }
    }
}

