/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.config;

import com.trs.cms.process.config.ActionHandlerConfig;
import com.trs.cms.process.config.ConditionHandlerConfig;
import com.trs.cms.process.config.FlowContentField;
import com.trs.cms.process.config.FlowContentTypeConfig;
import com.trs.cms.process.config.OperatorConfig;
import com.trs.cms.process.config.ParamConfig;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.config.ValueConfig;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FlowConfigServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(FlowConfigServer.class);
    private FlowContentTypeConfig[] m_pContentTypeConfigs = null;
    private ConditionHandlerConfig[] m_pConditionHandlerConfigs = null;
    private ActionHandlerConfig[] m_pActionHandlerConfigs = null;
    private ToUsersCreatorConfig[] m_pToUsersCreatorConfigs = null;
    private Element m_oConfigFileRootElement = null;

    protected void doShutdown() {
        this.m_pContentTypeConfigs = null;
        this.m_pConditionHandlerConfigs = null;
        this.m_pActionHandlerConfigs = null;
        this.m_pToUsersCreatorConfigs = null;
    }

    protected boolean doStart() throws WCMException {
        if (this.m_pContentTypeConfigs != null) {
            return true;
        }
        this.m_pContentTypeConfigs = new FlowContentTypeConfig[0];
        this.m_pConditionHandlerConfigs = new ConditionHandlerConfig[0];
        this.m_pActionHandlerConfigs = new ActionHandlerConfig[0];
        this.m_pToUsersCreatorConfigs = new ToUsersCreatorConfig[0];
        this.m_oConfigFileRootElement = DocumentHelper.createElement((String)"workflow-config");
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getResources("workflow_config.xml");
        while (iterator.hasNext()) {
            SAXReader sAXReader;
            URL uRL = (URL)iterator.next();
            Document document = null;
            try {
                sAXReader = new SAXReader();
                document = sAXReader.read(uRL);
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(FlowConfigServer.class, "FlowConfigServer.label1", "\u914d\u7f6e\u6587\u4ef6[") + uRL + I18NMessage.get(FlowConfigServer.class, "FlowConfigServer.label2", "]\u683c\u5f0f\u6709\u95ee\u9898\uff01\u8bfb\u53d6\u9519\u8bef\uff01")), (Throwable)exception);
                continue;
            }
            sAXReader = document.getRootElement();
            this.loadContentTypesConfig((Element)sAXReader);
            this.loadConditionHandlerConfigs((Element)sAXReader);
            this.loadActionHandlerConfigs((Element)sAXReader);
            this.loadToCreatorConfigs((Element)sAXReader, "tousers-creator");
            this.loadToCreatorConfigs((Element)sAXReader, "initvalue-creator");
        }
        return true;
    }

    public ConditionHandlerConfig[] getConditionHandlerConfigs() {
        return this.m_pConditionHandlerConfigs;
    }

    public ActionHandlerConfig[] getActionHandlerConfigs() {
        return this.m_pActionHandlerConfigs;
    }

    public ToUsersCreatorConfig[] getToUsersCreatorConfigs() {
        return this.m_pToUsersCreatorConfigs;
    }

    public ToUsersCreatorConfig getToUsersCreatorConfigByName(String string) {
        return this.getToUsersCreatorConfigByName(string, null);
    }

    public ToUsersCreatorConfig getToUsersCreatorConfigByName(String string, String string2) {
        if (this.m_pToUsersCreatorConfigs == null) {
            this.startup();
        }
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_pToUsersCreatorConfigs.length; ++i) {
            ToUsersCreatorConfig toUsersCreatorConfig = this.m_pToUsersCreatorConfigs[i];
            if (!toUsersCreatorConfig.getName().equalsIgnoreCase(string)) continue;
            if (string2 != null) {
                toUsersCreatorConfig.setAttributes(string2);
            }
            return toUsersCreatorConfig;
        }
        return null;
    }

    public FlowContentTypeConfig[] getContentTypeConfigs() {
        if (this.m_pContentTypeConfigs == null) {
            this.startup();
        }
        return this.m_pContentTypeConfigs;
    }

    public FlowContentTypeConfig findContentTypeConfig(int n) {
        if (this.m_pContentTypeConfigs == null) {
            this.startup();
        }
        if (this.m_pContentTypeConfigs == null) {
            return null;
        }
        for (int i = 0; i < this.m_pContentTypeConfigs.length; ++i) {
            if (this.m_pContentTypeConfigs[i].getContentType() != n) continue;
            return this.m_pContentTypeConfigs[i];
        }
        return null;
    }

    public void setContentTypeConfigs(FlowContentTypeConfig[] flowContentTypeConfigArray) {
        this.m_pContentTypeConfigs = flowContentTypeConfigArray;
    }

    public void addContentTypeConfig(FlowContentTypeConfig flowContentTypeConfig) {
        int n = this.m_pContentTypeConfigs.length;
        FlowContentTypeConfig[] flowContentTypeConfigArray = new FlowContentTypeConfig[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pContentTypeConfigs, 0, flowContentTypeConfigArray, 0, n);
        }
        flowContentTypeConfigArray[n] = flowContentTypeConfig;
        this.m_pContentTypeConfigs = flowContentTypeConfigArray;
    }

    private void loadContentTypesConfig(Element element) throws WCMException {
        Element element2 = element.element("content-types");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator("content-type");
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            FlowContentTypeConfig flowContentTypeConfig = new FlowContentTypeConfig();
            flowContentTypeConfig.setName(element3.attributeValue("name"));
            flowContentTypeConfig.setDesc(element3.attributeValue("desc"));
            flowContentTypeConfig.setDBTableName(element3.attributeValue("table-name"));
            flowContentTypeConfig.setClassName(element3.attributeValue("class-name"));
            Iterator iterator2 = element3.elementIterator("field");
            while (iterator2 != null && iterator2.hasNext()) {
                Element element4 = (Element)iterator2.next();
                FlowContentField flowContentField = new FlowContentField(flowContentTypeConfig);
                flowContentField.setName(element4.attributeValue("name"));
                flowContentField.setDBName(element4.attributeValue("db-name"));
                flowContentTypeConfig.addContentField(flowContentField);
            }
            this.addContentTypeConfig(flowContentTypeConfig);
        }
        this.addConfigs(element2);
    }

    private void addConfigs(Element element) {
        Element element2 = this.m_oConfigFileRootElement.element(element.getName());
        if (element2 == null) {
            this.m_oConfigFileRootElement.add(DocumentHelper.createText((String)"\n    "));
            this.m_oConfigFileRootElement.add((Element)element.clone());
            this.m_oConfigFileRootElement.add(DocumentHelper.createText((String)"\n"));
            return;
        }
        int n = element.nodeCount();
        for (int i = 0; i < n; ++i) {
            element2.add((Node)element.node(i).clone());
        }
    }

    private void loadConditionHandlerConfigs(Element element) throws WCMException {
        Element element2 = element.element("condition-handlers");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator("handler");
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            ConditionHandlerConfig conditionHandlerConfig = new ConditionHandlerConfig();
            conditionHandlerConfig.setName(element3.attributeValue("name"));
            conditionHandlerConfig.setDesc(element3.attributeValue("desc"));
            conditionHandlerConfig.setClassName(element3.attributeValue("class-name"));
            this.loadParams(element3, conditionHandlerConfig);
            this.addConditionHandlerConfig(conditionHandlerConfig);
        }
        this.addConfigs(element2);
    }

    private void loadParams(Element element, ConditionHandlerConfig conditionHandlerConfig) {
        Iterator iterator = element.elementIterator("param");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            ParamConfig paramConfig = new ParamConfig();
            paramConfig.setName(element2.attributeValue("name"));
            paramConfig.setDesc(element2.attributeValue("desc"));
            this.loadOperators(element2, paramConfig);
            conditionHandlerConfig.addParamConfig(paramConfig);
        }
    }

    private void loadParams(Element element, ActionHandlerConfig actionHandlerConfig) {
        Iterator iterator = element.elementIterator("param");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            ParamConfig paramConfig = new ParamConfig();
            paramConfig.setName(element2.attributeValue("name"));
            paramConfig.setDesc(element2.attributeValue("desc"));
            this.loadValues(element2, paramConfig);
            this.loadDefaultValue(element2, paramConfig);
            actionHandlerConfig.addParamConfig(paramConfig);
        }
    }

    private void loadDefaultValue(Element element, ParamConfig paramConfig) {
        Element element2;
        String string = element.attributeValue("default-value");
        if (string == null && (element2 = element.element("default-value")) != null) {
            string = element2.getTextTrim();
        }
        if (string != null) {
            paramConfig.setDefaultValue(string);
        }
    }

    private void loadOperators(Element element, ParamConfig paramConfig) {
        Element element2 = element.element("operators");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator("operator");
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            OperatorConfig operatorConfig = new OperatorConfig();
            operatorConfig.setName(element3.attributeValue("name"));
            operatorConfig.setValue(element3.attributeValue("value"));
            paramConfig.addOperatorConfig(operatorConfig);
        }
    }

    private void loadValues(Element element, ParamConfig paramConfig) {
        Element element2 = element.element("values");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator("value");
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            ValueConfig valueConfig = new ValueConfig();
            valueConfig.setName(element3.attributeValue("name"));
            valueConfig.setDesc(element3.attributeValue("value"));
            paramConfig.addValueConfig(valueConfig);
        }
    }

    private void addConditionHandlerConfig(ConditionHandlerConfig conditionHandlerConfig) {
        int n = this.m_pConditionHandlerConfigs.length;
        ConditionHandlerConfig[] conditionHandlerConfigArray = new ConditionHandlerConfig[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pConditionHandlerConfigs, 0, conditionHandlerConfigArray, 0, n);
        }
        conditionHandlerConfigArray[n] = conditionHandlerConfig;
        this.m_pConditionHandlerConfigs = conditionHandlerConfigArray;
    }

    private void loadActionHandlerConfigs(Element element) throws WCMException {
        Element element2 = element.element("action-handlers");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator("handler");
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            ActionHandlerConfig actionHandlerConfig = new ActionHandlerConfig();
            actionHandlerConfig.setName(element3.attributeValue("name"));
            actionHandlerConfig.setDesc(element3.attributeValue("desc"));
            actionHandlerConfig.setClassName(element3.attributeValue("class-name"));
            this.loadParams(element3, actionHandlerConfig);
            this.addActionHandlerConfig(actionHandlerConfig);
        }
        this.addConfigs(element2);
    }

    private void addActionHandlerConfig(ActionHandlerConfig actionHandlerConfig) {
        int n = this.m_pActionHandlerConfigs.length;
        ActionHandlerConfig[] actionHandlerConfigArray = new ActionHandlerConfig[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pActionHandlerConfigs, 0, actionHandlerConfigArray, 0, n);
        }
        actionHandlerConfigArray[n] = actionHandlerConfig;
        this.m_pActionHandlerConfigs = actionHandlerConfigArray;
    }

    public Element getConfigFileRootElement() {
        return this.m_oConfigFileRootElement;
    }

    public String getConfigFileContent() {
        if (this.m_oConfigFileRootElement == null) {
            this.startup();
        }
        return this.m_oConfigFileRootElement.asXML();
    }

    private void loadToCreatorConfigs(Element element, String string) throws WCMException {
        Element element2 = element.element(string + "s");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.elementIterator(string);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            ToUsersCreatorConfig toUsersCreatorConfig = new ToUsersCreatorConfig();
            for (int i = 0; i < element3.attributeCount(); ++i) {
                Attribute attribute = element3.attribute(i);
                String string2 = attribute.getName();
                String string3 = attribute.getValue();
                if (string2.equals("name")) {
                    toUsersCreatorConfig.setName(string3.trim());
                    continue;
                }
                if (string2.equals("class-name")) {
                    toUsersCreatorConfig.setClassName(string3.trim());
                    continue;
                }
                toUsersCreatorConfig.setAttribute(string2, string3);
            }
            this.addToUsersCreatorConfig(toUsersCreatorConfig);
        }
        this.addConfigs(element2);
    }

    private void addToUsersCreatorConfig(ToUsersCreatorConfig toUsersCreatorConfig) {
        int n = this.m_pToUsersCreatorConfigs.length;
        ToUsersCreatorConfig[] toUsersCreatorConfigArray = new ToUsersCreatorConfig[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pToUsersCreatorConfigs, 0, toUsersCreatorConfigArray, 0, n);
        }
        toUsersCreatorConfigArray[n] = toUsersCreatorConfig;
        this.m_pToUsersCreatorConfigs = toUsersCreatorConfigArray;
    }
}

