/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.FlowingDocOptMarkScouter;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotifyWorker;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.IWorkflowDelegateMgr;
import com.trs.cms.process.QueryFlowDocContext;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.RuleExecuteHelper;
import com.trs.components.common.message.MessageServer;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.database.FieldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FlowServerImpl
extends BaseServer
implements IFlowServer {
    private static Logger logger = Logger.getLogger(FlowServerImpl.class);
    private IFlowNotifyWorker m_oNotify = null;
    private IFlowRuleCacheServer m_oRuleCacheServer = null;
    private FlowConfigServer m_oFlowConfigServer = null;
    public static final float INCREASE_FIELD_LENGTH_FACTOR = 1.5f;

    public FlowServerImpl() {
        try {
            this.m_oNotify = (IFlowNotifyWorker)DreamFactory.createObjectById("Flow.Notify.Worker");
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label1", "\u521b\u5efa\u6d88\u606f\u901a\u77e5\u5668\u5931\u8d25\uff01"), throwable);
        }
        try {
            this.m_oRuleCacheServer = (IFlowRuleCacheServer)DreamFactory.createObjectById("IFlowRuleCacheServer");
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label2", "\u521b\u5efa\u89c4\u5219\u7f13\u51b2\u5668\u5931\u8d25\uff01"), throwable);
        }
        try {
            this.m_oFlowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label3", "\u521b\u5efa\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25\uff01"), throwable);
        }
    }

    public boolean backTo(FlowContext flowContext) throws WCMException {
        boolean bl;
        FlowDoc flowDoc;
        flowContext.validate();
        boolean bl2 = false;
        if ("1".equals(flowContext.getProperty("ApplyExtension"))) {
            bl2 = true;
        }
        if ((flowDoc = flowContext.getCurrFlowDoc()).getNode().isStartNode()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label4", "\u60a8\u5df2\u7ecf\u5904\u4e8e\u5f00\u59cb\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u6253\u56de\u64cd\u4f5c"));
        }
        if (flowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label5", "\u6d41\u7a0b\u5df2\u7ecf\u5904\u7406\uff0c\u4e0d\u80fd\u6267\u884c\u8981\u6c42\u8fd4\u5de5\u64cd\u4f5c\uff01"));
        }
        if (flowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label6", "\u5bf9\u4e8e\u5df2\u62d2\u7edd\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u8fd4\u5de5\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        flowDoc.validCanEditAndLock(flowContext.getCurrUser());
        flowDoc.setWorked(true);
        flowDoc.update(flowContext.getCurrUser());
        this.setOtherSiblingsWorked(flowDoc);
        this.setParentWorked(flowDoc);
        Users users = new Users(null, 1, 1);
        FlowDoc flowDoc2 = flowDoc;
        while (flowDoc2.getFlag() == 4) {
            if ((flowDoc2 = flowDoc2.getPreFlowDoc()) != null) continue;
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label7", "\u6570\u636e\u6709\u8bef\uff01[FlowDocId=") + flowDoc.getId() + "]");
        }
        int n = flowDoc2.getPreNodeId();
        int n2 = flowDoc2.getNodeId();
        int n3 = flowDoc2.getId();
        boolean bl3 = bl = flowDoc2.getFlag() == 2;
        if (flowDoc2.getFlag() == 2 || flowDoc2.getFlag() == 12) {
            flowDoc2 = FlowServerImpl.lookupRealBackFlowDocAgain(flowDoc2);
            switch (flowDoc2.getWorkModal()) {
                case 1: {
                    if (flowDoc2.getParentId() > 0) {
                        users.addElement(flowDoc2.getPostUser());
                        break;
                    }
                    users = flowDoc2.getToUsers(null);
                    break;
                }
                default: {
                    users.addElement(flowDoc2.getPostUser());
                    break;
                }
            }
        } else {
            users.addElement(flowDoc2.getPostUser());
        }
        if (bl) {
            n2 = flowDoc2.getNodeId();
            n = flowDoc2.getPreNodeId();
            n3 = flowDoc2.getId();
        }
        if (users == null || users.isEmpty()) {
            logger.warn((Object)(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label8", "\u6253\u56de\u627e\u4e0d\u5230\u63a5\u6536\u4eba\uff0c\u5efa\u8bae\u5c3d\u5feb\u548cTRS\u652f\u6301\u4eba\u5458\u8054\u7cfb\uff01[FlowDocId=") + flowDoc.getId() + "]"));
            return false;
        }
        int n4 = users.size();
        FlowDoc flowDoc3 = new FlowDoc();
        flowDoc3.setContentType(flowDoc2.getContentType());
        flowDoc3.setContentId(flowDoc2.getContentId());
        flowDoc3.setPostUser(flowContext.getPostUser());
        flowDoc3.setPostTime(CMyDateTime.now());
        flowDoc3.setPostDesc(flowContext.getPostDesc());
        flowDoc3.setToUsers(users.getIdListAsString());
        if (bl2) {
            flowDoc3.setFlag(13);
        } else {
            flowDoc3.setFlag(2);
        }
        flowDoc3.setPreNode(n2);
        flowDoc3.setNode(n);
        flowDoc3.setPreFlowDoc(n3);
        flowDoc3.setWorkModal(flowDoc2.getWorkModal());
        flowDoc3.setNextId();
        if (n4 == 1) {
            flowDoc3.setToUser(users.getIdAt(0));
            flowDoc3.setWorkModal(0);
            this.sendNotify(flowContext.getPostUser(), (User)users.getAt(0), flowContext.getNotifyTypes(), flowDoc3.getId(), flowContext.getFlowContent());
        } else {
            for (int i = 0; i < n4; ++i) {
                User user = (User)users.getAt(i);
                if (user == null) continue;
                FlowDoc flowDoc4 = new FlowDoc();
                flowDoc4.setContentType(flowDoc2.getContentType());
                flowDoc4.setContentId(flowDoc2.getContentId());
                flowDoc4.setPostUser(flowContext.getPostUser());
                flowDoc4.setPostTime(CMyDateTime.now());
                flowDoc4.setPostDesc(flowContext.getPostDesc());
                flowDoc4.setToUser(user);
                flowDoc4.setFlag(2);
                flowDoc4.setPreNode(n2);
                flowDoc4.setNode(n);
                flowDoc4.setPreFlowDoc(n3);
                flowDoc4.setWorkModal(flowDoc2.getWorkModal());
                flowDoc4.setParent(flowDoc3.getId());
                flowDoc4.setSerialNum(flowContext.getSerialNum());
                flowDoc4.setBranchSerialNum(flowContext.getBranchSerialNum());
                flowDoc4.insert(flowContext.getCurrUser());
                this.sendNotify(flowContext.getPostUser(), user, flowContext.getNotifyTypes(), flowDoc4.getId(), flowContext.getFlowContent());
            }
        }
        flowDoc3.setSerialNum(flowContext.getSerialNum());
        flowDoc3.setBranchSerialNum(flowContext.getBranchSerialNum());
        flowDoc3.insert(flowContext.getCurrUser());
        String string = ConfigServer.getServer().getSysConfigValue("BACK_TO_STATUS", String.valueOf(15));
        int n5 = Integer.parseInt(string);
        if (n5 > 0) {
            flowContext.getFlowContent().updateStatus(flowContext.getCurrUser(), n5);
        }
        if (!bl2) {
            this.onEvent(flowContext, 4);
        }
        FlowingDocOptMarkScouter.updateOperationMark(flowContext);
        this.autodeleteMessage(flowContext);
        return true;
    }

    public static FlowDoc lookupRealBackFlowDocAgain(FlowDoc flowDoc) throws WCMException {
        if (flowDoc == null) {
            return null;
        }
        FlowDoc flowDoc2 = null;
        switch (flowDoc.getFlag()) {
            case 2: {
                flowDoc2 = flowDoc.getPreFlowDoc();
                if (flowDoc2 == null) {
                    throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label9", "\u6570\u636e\u4e0d\u6b63\u786e\uff01"));
                }
                if (flowDoc2.getFlag() == 0) {
                    throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label10", "\u60a8\u662f\u6700\u5148\u53d1\u8d77\u4eba\uff0c\u4e0d\u80fd\u8fdb\u884c\u8fd4\u5de5\u64cd\u4f5c\u3002"));
                }
                return FlowServerImpl.lookupRealBackFlowDocAgain(flowDoc2.getPreFlowDoc());
            }
            case 12: {
                flowDoc2 = flowDoc.getPreFlowDoc();
                if (flowDoc2.getFlag() == 8) {
                    return FlowServerImpl.lookupRealBackFlowDocAgain(flowDoc2);
                }
                return flowDoc2.getParent();
            }
        }
        return flowDoc;
    }

    public boolean refuse(FlowContext flowContext) throws WCMException {
        int n;
        flowContext.validate();
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        if (flowDoc.getNode().isStartNode()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label11", "\u60a8\u5df2\u7ecf\u5904\u4e8e\u5f00\u59cb\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u62d2\u7edd\u64cd\u4f5c"));
        }
        if (flowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label12", "\u6d41\u7a0b\u5df2\u7ecf\u5904\u7406\uff0c\u4e0d\u80fd\u6267\u884c\u62d2\u7edd\u64cd\u4f5c\uff01"));
        }
        if (flowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label13", "\u5bf9\u4e8e\u5df2\u62d2\u7edd\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u62d2\u7edd\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        if (flowDoc.getWorkModal() == 3) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label42", "\u5e76\u8054\u5ba1\u6279\u7ed3\u675f\u8282\u70b9\u4e0d\u5141\u8bb8\u8fdb\u884c\u62d2\u7edd\u64cd\u4f5c\u3002"));
        }
        if (flowDoc.getFlag() == 2) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label43", "\u5bf9\u4e8e\u8fd4\u5de5\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u62d2\u7edd\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        flowDoc.validCanEditAndLock(flowContext.getCurrUser());
        flowDoc.setWorked(true);
        flowDoc.update(flowContext.getCurrUser());
        boolean bl = false;
        if (flowDoc.getWorkModal() == 1) {
            this.setOtherSiblingsWorked(flowDoc);
            this.setParentWorked(flowDoc);
            bl = true;
            this.makeNewFlowDocForRefuse(flowDoc, flowContext, bl, null);
        } else if (flowDoc.getWorkModal() == 0 || flowDoc.getWorkModal() == 2) {
            boolean bl2 = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("OTHERS_CAN_PROCESS_IFONEREFUSE", "false"));
            if (bl2) {
                this.setOtherSiblingsWorked(flowDoc);
                this.setParentWorked(flowDoc);
                bl = true;
            } else if (this.isLastUserOfTogether(flowDoc)) {
                bl = true;
                this.setParentWorked(flowDoc);
            } else {
                bl = false;
            }
            this.makeNewFlowDocForRefuse(flowDoc, flowContext, bl, null);
        } else if (flowDoc.getWorkModal() == 3) {
            FlowDocs flowDocs = this.getSeperatorDealedFlowDocs(flowContext);
            bl = true;
            for (n = 0; n <= flowDocs.size(); ++n) {
                FlowDoc flowDoc2 = (FlowDoc)flowDocs.getAt(n);
                this.makeNewFlowDocForRefuse(flowDoc, flowContext, bl, flowDoc2);
            }
        }
        String string = ConfigServer.getServer().getSysConfigValue("REFUSE_TO_STATUS", String.valueOf(15));
        n = Integer.parseInt(string);
        if (n > 0) {
            flowContext.getFlowContent().updateStatus(flowContext.getCurrUser(), n);
        }
        this.onEvent(flowContext, 6);
        FlowingDocOptMarkScouter.updateOperationMark(flowContext);
        this.autodeleteMessage(flowContext);
        return true;
    }

    public boolean forceEnd(FlowContext flowContext) throws WCMException {
        User user = flowContext.getCurrUser();
        int n = flowContext.getFlowContent().getType();
        int n2 = flowContext.getFlowContent().getId();
        WCMFilter wCMFilter = new WCMFilter("", "Worked=0", "");
        FlowDocs flowDocs = FlowDocs.findOfContent(user, n, n2, wCMFilter);
        int n3 = 0;
        int n4 = 0;
        int n5 = flowDocs.size();
        for (int i = 0; i < n5; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            if (flowDoc.getParentId() == 0) {
                n4 = flowDoc.getId();
            }
            flowDoc.validCanEditAndLock(flowContext.getCurrUser());
            flowDoc.setWorked(true);
            flowDoc.update(flowContext.getCurrUser());
            n3 = flowDoc.getNodeId() > 0 ? flowDoc.getNodeId() : flowDoc.getPreNodeId();
        }
        FlowDoc flowDoc = new FlowDoc();
        flowDoc.setPostUser(flowContext.getPostUser());
        flowDoc.setPostDesc(flowContext.getPostDesc());
        if (flowContext.isFromRule()) {
            flowDoc.setFlag(18);
        } else {
            flowDoc.setFlag(7);
        }
        flowDoc.setContentType(flowContext.getFlowContent().getType());
        flowDoc.setContentId(flowContext.getFlowContent().getId());
        flowDoc.setNode(n3);
        flowDoc.setPreNode(n3);
        flowDoc.setAccepted();
        flowDoc.setWorked(true);
        flowDoc.setPreFlowDoc(n4);
        flowDoc.setSerialNum(flowContext.getSerialNum());
        flowDoc.setBranchSerialNum(flowContext.getBranchSerialNum());
        flowDoc.insert(flowContext.getCurrUser());
        FlowingDocOptMarkScouter.updateOperationMark(flowContext, "RESERVED_FORCED_END");
        return true;
    }

    public boolean doAccept(FlowContext flowContext) throws WCMException {
        flowContext.validate();
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        if (flowDoc.isAccepted()) {
            return true;
        }
        flowDoc.validCanEditAndLock(flowContext.getCurrUser());
        flowDoc.setAccepted();
        flowDoc.update(flowContext.getCurrUser());
        this.onEvent(flowContext, 1);
        FlowingDocOptMarkScouter.updatePreOperationMark(flowContext, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label14", "\u5df2\u7b7e\u6536"));
        return true;
    }

    private void onEvent(FlowContext flowContext, int n) throws WCMException {
        ExecuteContext executeContext = new ExecuteContext(flowContext);
        FlowRule[] flowRuleArray = this.m_oRuleCacheServer.getRules(flowContext.getCurrNode(), n);
        RuleExecuteHelper.executeRules(executeContext, flowRuleArray);
    }

    public boolean doReceive(FlowContext flowContext) throws WCMException {
        flowContext.validate();
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        if (flowDoc.isReceived()) {
            return true;
        }
        flowDoc.validCanEditAndLock(flowContext.getCurrUser());
        flowDoc.setReceiveTime();
        flowDoc.update(flowContext.getCurrUser());
        this.onEvent(flowContext, 0);
        FlowingDocOptMarkScouter.updatePreOperationMark(flowContext, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label15", "\u5df2\u6536\u5230"));
        return true;
    }

    public IFlowContent[] getFlowContentsDoneByUser(User user) throws WCMException {
        return this.getFlowContentsDoneByUser(user, null);
    }

    public IFlowContent[] getFlowContentsDoneByUser(User user, CPager cPager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(user);
        queryFlowDocContext.setPager(cPager);
        return this.getFlowContentsDoneByUser(queryFlowDocContext);
    }

    public IFlowContent[] getFlowContentsStartByUser(User user, CPager cPager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(user);
        queryFlowDocContext.setPager(cPager);
        return this.getFlowContentsStartByUser(queryFlowDocContext);
    }

    public IFlowContent[] getFlowContentsStartByUser(User user) throws WCMException {
        return this.getFlowContentsStartByUser(user, null);
    }

    private FlowDoc getCurrentFlowDoc(IFlowContent iFlowContent, long l) throws WCMException {
        if (l < 0L) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=? and SerialNum=? and Worked=0 and ParentId=0", "FlowDocId Desc");
        wCMFilter.addSearchValues(iFlowContent.getType());
        wCMFilter.addSearchValues(iFlowContent.getId());
        wCMFilter.addSearchValues(l);
        wCMFilter.setMaxRowNumber(1);
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxBufferSize(2);
        flowDocs.open(wCMFilter);
        if (flowDocs.isEmpty()) {
            return null;
        }
        return (FlowDoc)flowDocs.getAt(0);
    }

    private FlowDoc getCurrFlowDoc(IFlowContent iFlowContent, long l, User user) throws WCMException {
        if (l < 0L) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=? and SerialNum=? and ParentId=0 and postuser=? and Flag=0", "FlowDocId Desc");
        wCMFilter.addSearchValues(iFlowContent.getType());
        wCMFilter.addSearchValues(iFlowContent.getId());
        wCMFilter.addSearchValues(l);
        wCMFilter.addSearchValues(user.getName());
        wCMFilter.setMaxRowNumber(1);
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxBufferSize(2);
        flowDocs.open(wCMFilter);
        if (flowDocs.isEmpty()) {
            return null;
        }
        return (FlowDoc)flowDocs.getAt(0);
    }

    public IFlowContent[] getFlowContentsInFlow(Flow flow) throws WCMException {
        Connection connection = DBManager.getDBManager().getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        IFlowContent[] iFlowContentArray = new IFlowContent[]{};
        try {
            Object object;
            preparedStatement = connection.prepareStatement("select distinct ObjType, ObjId, SerialNum from WCMFlowDoc where ParentId=0 and exists( select WCMFlowNode.NodeId  from WCMFlowNode  where WCMFlowNode.FlowId=? and WCMFlowDoc.NodeId=WCMFlowNode.NodeId) order by ObjId Desc, ObjType Desc");
            preparedStatement.setInt(1, flow.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = FlowContentFactory.makeFlowContent(resultSet.getInt(1), resultSet.getInt(2));
                if (object == null || object.isDeleted()) continue;
                int n = iFlowContentArray.length;
                IFlowContent[] iFlowContentArray2 = new IFlowContent[n + 1];
                if (n > 0) {
                    System.arraycopy(iFlowContentArray, 0, iFlowContentArray2, 0, n);
                }
                iFlowContentArray2[n] = object;
                iFlowContentArray = iFlowContentArray2;
                long l = resultSet.getLong("SerialNum");
                object.setSerialNum(l);
                object.setFlowDoc(this.getCurrentFlowDoc((IFlowContent)object, l));
            }
            object = iFlowContentArray;
            return object;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label16", "\u6784\u9020\u5185\u5bb9\u5931\u8d25\uff01"), exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            DBManager.getDBManager().freeConnection(connection);
        }
    }

    public IFlowContent[] getFlowContentsOfUser(User user) throws WCMException {
        return this.getFlowContentsOfUser(user, null);
    }

    public IFlowContent[] getFlowContentsOfUser(User user, CPager cPager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(user);
        queryFlowDocContext.setPager(cPager);
        return this.getFlowContentsOfUser(queryFlowDocContext);
    }

    public boolean submitTo(FlowContext flowContext) throws WCMException {
        boolean bl;
        boolean bl2;
        if (flowContext == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label17", "\u6ca1\u6709\u6307\u5b9a\u7684\u5904\u7406\u53c2\u6570\uff01"));
        }
        if (flowContext.getCurrFlowDoc() != null && flowContext.getCurrFlowDoc().isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label18", "\u5f53\u524d\u4e8b\u52a1\u53ef\u80fd\u5df2\u5904\u7406\u3002"));
        }
        if (flowContext.getWorkModal() == 1 && flowContext.getNextNode() == null && (bl2 = this.isLastUserOfTogether(flowContext.getCurrFlowDoc()))) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label19", "\u60a8\u53ef\u80fd\u548c\u5176\u4ed6\u4eba\u540c\u65f6\u5904\u7406\u4e86\u8fd9\u4e2a\u4e8b\u52a1\uff0c\u8fd9\u6b21\u64cd\u4f5c\u65e0\u6548\uff0c\u60a8\u9700\u8981\u91cd\u65b0\u5904\u7406\u3002"));
        }
        FlowNodeBranch flowNodeBranch = flowContext.getBranch();
        FlowNode flowNode = flowContext.getNextNode();
        boolean bl3 = bl = flowNode != null && flowNode.isEndNode();
        if (!flowContext.isStarting()) {
            this.doBeforeCreateNewFlowDoc(flowContext);
        }
        if (!bl) {
            this.onEvent(flowContext, 3);
        }
        this.autodeleteMessage(flowContext);
        int n = 0;
        int n2 = 0;
        if (flowNodeBranch != null) {
            n = flowNodeBranch.getStatusId();
            n2 = flowContext.getFlowContent().getStatusId();
            boolean bl4 = true;
            if (n2 == 10 && flowNode != null && flowNode.isEndNode()) {
                bl4 = false;
            }
            if (bl4 && n != n2) {
                flowContext.getFlowContent().updateStatus(flowContext.getCurrUser(), n);
            }
        }
        try {
            if (bl) {
                this.createEndFlowDoc(flowContext);
                this.onEvent(flowContext, 3);
            } else {
                this.createNewFlowDoc(flowContext);
            }
        }
        catch (Throwable throwable) {
            if (n2 > 0) {
                flowContext.getFlowContent().updateStatus(flowContext.getCurrUser(), n2);
            }
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label41", "\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff01"), throwable);
        }
        FlowingDocOptMarkScouter.updateOperationMark(flowContext);
        return true;
    }

    private void createEndFlowDoc(FlowContext flowContext) throws WCMException {
        int n = flowContext.isStarting() ? 0 : flowContext.getCurrFlowDoc().getNodeId();
        FlowDoc flowDoc = new FlowDoc();
        flowDoc.setPostUser(flowContext.getPostUser());
        flowDoc.setPostDesc(flowContext.getPostDesc());
        flowDoc.setFlag(18);
        flowDoc.setPreNode(n);
        flowDoc.setNode(flowContext.getNextNode());
        flowDoc.setFlowContent(flowContext.getFlowContent());
        flowDoc.setWorked(true);
        flowDoc.setSerialNum(flowContext.getSerialNum());
        flowDoc.setBranchSerialNum(this.makeBranchSerialNum(flowContext, FlowNode.findById(n)));
        flowDoc.setAccepted();
        flowDoc.insert(flowContext.getPostUser());
    }

    private void createNewFlowDoc(FlowContext flowContext) throws WCMException {
        int n;
        int n2 = flowContext.getCurrNode().getId();
        int n3 = flowContext.getWorkModal();
        int n4 = flowContext.isStarting() ? 0 : 1;
        switch (n3) {
            case 0: 
            case 3: {
                break;
            }
            case 2: {
                if (flowContext.getNextNode() != null) break;
                return;
            }
            case 1: {
                this.createSingleSignFlowDoc(flowContext, n3);
                n = this.isLastUserOfTogether(flowContext.getCurrFlowDoc());
                if (n == 0) {
                    return;
                }
                n4 = 12;
                flowContext.setPostDesc(FlowEngineHelper.makeTogetherComments(flowContext.getCurrFlowDoc().getParentId()));
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label20", "\u65e0\u6548\u7684\u4e8b\u52a1\u6a21\u5f0f\uff01"));
            }
        }
        n = 0;
        boolean bl = false;
        if (flowContext.getNextNode() != null) {
            n = flowContext.getNextNode().getWorkModal();
            boolean bl2 = bl = n == 3 && flowContext.getSerialNum() != flowContext.getBranchSerialNum();
        }
        if (bl) {
            this.createSingleSignFlowDoc(flowContext, n);
            String string = "ObjType=? and ObjId=? and ParentId=0 and Worked=0 and SerialNum=?";
            WCMFilter wCMFilter = new WCMFilter("", string, "", "FlowDocId");
            wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentType());
            wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentId());
            wCMFilter.addSearchValues(flowContext.getSerialNum());
            wCMFilter.setMaxRowNumber(1);
            FlowDocs flowDocs = FlowDocs.openWCMObjs(null, wCMFilter);
            if (!flowDocs.isEmpty()) {
                return;
            }
        }
        boolean bl3 = n == 3 && flowContext.getSerialNum() == flowContext.getBranchSerialNum();
        this.createNewFlowDoc(flowContext, n2, n4, bl3);
    }

    private void createSingleSignFlowDoc(FlowContext flowContext, int n) throws WCMException {
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        FlowDoc flowDoc2 = new FlowDoc();
        flowDoc2.setContent(flowContext.getFlowContent());
        flowDoc2.setPostUser(flowContext.getPostUser());
        flowDoc2.setPostDesc(flowContext.getPostDesc());
        flowDoc2.setFlag(n == 1 ? 10 : 11);
        flowDoc2.setWorked(true);
        flowDoc2.setWorkModal(n);
        flowDoc2.setPreFlowDoc(flowContext.getCurrFlowDoc());
        if (n == 1) {
            flowDoc2.setNode(flowDoc.getNodeId());
            flowDoc2.setPreNode(flowDoc.getNodeId());
        } else {
            int n2 = flowContext.getNextNode().getId();
            flowDoc2.setNode(n2);
            flowDoc2.setPreNode(n2);
        }
        flowDoc2.setSerialNum(flowContext.getSerialNum());
        flowDoc2.setBranchSerialNum(flowContext.getBranchSerialNum());
        flowDoc2.insert(flowContext.getCurrUser());
    }

    private void createNewFlowDoc(FlowContext flowContext, int n, int n2) throws WCMException {
        this.createNewFlowDoc(flowContext, n, n2, false);
    }

    private void createNewFlowDoc(FlowContext flowContext, int n, int n2, boolean bl) throws WCMException {
        Users users = flowContext.getToUsers();
        if (users == null) {
            users = this.getDealers(flowContext, flowContext.getNextNode());
        }
        if (users == null || users.isEmpty()) {
            return;
        }
        IWorkflowDelegateMgr iWorkflowDelegateMgr = (IWorkflowDelegateMgr)DreamFactory.createObjectById("IWorkflowDelegateMgr");
        try {
            users = iWorkflowDelegateMgr.getDelegateUsers(users, true);
        }
        catch (Throwable throwable) {
            throw new WCMException("\u83b7\u53d6\u59d4\u6258\u7528\u6237\u5931\u8d25\uff01", throwable);
        }
        int n3 = users.size();
        User user = flowContext.getPostUser();
        FlowNode flowNode = flowContext.getNextNode();
        if (flowNode == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label40", "\u65e0\u6cd5\u627e\u5230\u4e0b\u4e00\u4e2a\u8282\u70b9\uff0c\u8282\u70b9\u6216\u8fde\u7ebf\u53ef\u80fd\u88ab\u5220\u9664\u3002"));
        }
        int n4 = flowNode.getWorkModal();
        if (n4 == 3 && bl) {
            n4 = 0;
        }
        FlowDoc flowDoc = new FlowDoc();
        flowDoc.setPostUser(user);
        flowDoc.setPostDesc(flowContext.getPostDesc());
        flowDoc.setFlag(n2);
        flowDoc.setPreNode(n);
        flowDoc.setNode(flowContext.getNextNode());
        flowDoc.setFlowContent(flowContext.getFlowContent());
        flowDoc.setPreFlowDoc(flowContext.getCurrFlowDoc());
        flowDoc.setToUsers(users.getIdListAsString());
        flowDoc.setSerialNum(flowContext.getSerialNum());
        long l = this.makeBranchSerialNum(flowContext, FlowNode.findById(n));
        flowDoc.setBranchSerialNum(l);
        flowDoc.setNextId();
        if (n3 == 1) {
            if (n4 == 1) {
                n4 = 0;
            }
            flowDoc.setToUser(users.getIdAt(0));
            this.sendNotify(user, (User)users.getAt(0), flowContext.getNotifyTypes(), flowDoc.getId(), flowContext.getFlowContent());
        } else {
            for (int i = 0; i < n3; ++i) {
                User user2 = (User)users.getAt(i);
                if (user2 == null) continue;
                FlowDoc flowDoc2 = new FlowDoc();
                flowDoc2.setPostUser(user);
                flowDoc2.setPostDesc(flowContext.getPostDesc());
                flowDoc2.setToUser(user2);
                flowDoc2.setWorkModal(n4);
                flowDoc2.setFlag(n2);
                flowDoc2.setPreNode(n);
                flowDoc2.setNode(flowContext.getNextNode());
                flowDoc2.setFlowContent(flowContext.getFlowContent());
                flowDoc2.setParent(flowDoc.getId());
                flowDoc2.setPreFlowDoc(flowContext.getCurrFlowDoc());
                flowDoc2.setSerialNum(flowContext.getSerialNum());
                flowDoc2.setBranchSerialNum(l);
                flowDoc2.insert(user);
                this.sendNotify(user, user2, flowContext.getNotifyTypes(), flowDoc2.getId(), flowContext.getFlowContent());
            }
        }
        flowDoc.setWorkModal(n4);
        flowDoc.insert(user);
        flowContext.setCurrNode(flowContext.getNextNode());
        flowContext.setCurrFlowDoc(flowDoc);
        String string = (String)flowContext.getProperty("ReffererTo");
        if ("true".equalsIgnoreCase(string)) {
            return;
        }
        this.onEvent(flowContext, 5);
    }

    private boolean isLastUserOfTogether(FlowDoc flowDoc) throws WCMException {
        boolean bl = false;
        String string = "select FlowDocId from WCMFlowDoc where ObjType=? and ObjId=? and Worked=0 and ParentId=? and FlowDocId<>? and SerialNum=" + flowDoc.getSerialNum() + " and BranchSerialNum=" + flowDoc.getBranchSerialNum();
        int[] nArray = new int[]{flowDoc.getContentType(), flowDoc.getContentId(), flowDoc.getParentId(), flowDoc.getId()};
        bl = DBManager.getDBManager().sqlExecuteIntQuery(string, nArray) <= 0;
        return bl;
    }

    private Users getDealers(FlowContext flowContext, FlowNode flowNode) throws WCMException {
        Object object;
        if (flowNode == null) {
            return new Users(null);
        }
        String string = flowNode.getPropertyAsString("ToUsersCreator");
        if (!CMyString.isEmpty(string) && (object = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(string)) != null) {
            return ((ToUsersCreatorConfig)object).getToUsers(flowContext);
        }
        object = flowNode.getOperUsers(null, true);
        return object;
    }

    private void sendNotify(User user, User user2, String string, int n, IFlowContent iFlowContent) throws WCMException {
        if (string != null && string.toUpperCase().equalsIgnoreCase("NONE")) {
            return;
        }
        String string2 = ConfigServer.getServer().getSysConfigValue("WCM_URL", "htttp://localhost/wcm/");
        string2 = CMyString.setStrEndWith(string2, '/');
        String string3 = string2 + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "app") + "/flowdoc/workflow_process_render.jsp?FlowDocId=" + n;
        if (iFlowContent.getContentType() == 605) {
            try {
                if (((Document)iFlowContent.getSubstance()).getChannel().getType() == 13) {
                    string3 = string2 + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "app") + "/infoview/" + iFlowContent.getContentAddEditPage() + "&FlowDocId=" + n + "&WorklistViewType=1";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string4 = I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label21", "\u5de5\u4f5c\u6d41\u63d0\u9192-[") + iFlowContent.getDesc() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label22", "]\u9700\u8981\u60a8\u5904\u7406");
        DBManager dBManager = DBManager.getDBManager();
        FieldInfo fieldInfo = dBManager.getFieldInfo("WCMMESSAGE", "Title");
        int n2 = this.getCompressLength(fieldInfo.getDataLength());
        if (CMyString.getBytesLength(string4) > n2) {
            string4 = CMyString.truncateStr(string4, n2);
        }
        String string5 = "<P>" + CMyString.transDisplay(iFlowContent.getDesc()) + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label23", " \u9700\u8981\u60a8\u5904\u7406!</P><br><P>\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u53ef\u4ee5\u76f4\u63a5\u5904\u7406\uff1a") + "</P><P><a target=\"blank\" href=\"" + string3 + "\" title=\"" + string3 + "\">" + CMyString.transPrettyUrl(string3, 45) + "</a></P>";
        this.m_oNotify.addMsgEvent(user, user2, string4, string5, string);
    }

    private void doBeforeCreateNewFlowDoc(FlowContext flowContext) throws WCMException {
        boolean bl;
        User user = flowContext.getCurrUser();
        flowContext.validate();
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        if (flowContext.getPostUser().getId() != flowDoc.getToUserId()) {
            throw new WCMException(10, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label24", "\u7528\u6237[") + flowContext.getPostUser().getName() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label25", "]\u4e0d\u80fd\u5904\u7406\u5f53\u524d\u4e8b\u52a1[FlowDocId=") + flowDoc.getId() + "]\uff01");
        }
        if (flowContext.getCurrFlowDoc().isWorked()) {
            throw new WCMException(10, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label26", "\u5f53\u524d\u4e8b\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u8fc7\u4e86\uff0c\u4e0d\u80fd\u518d\u5904\u7406\uff01[FlowDocId=") + flowDoc.getId() + "]");
        }
        boolean bl2 = false;
        String string = (String)flowContext.getProperty("ReffererTo");
        if (!CMyString.isEmpty(string) && "true".equalsIgnoreCase(string)) {
            bl2 = true;
        }
        if (flowContext.getCurrFlowDoc().getWorkModal() == 2 && flowContext.getNextNode() != null && !bl2) {
            return;
        }
        flowDoc.validCanEditAndLock(user);
        flowDoc.setWorked(true);
        flowDoc.update(user);
        if ((flowDoc.getWorkModal() == 0 || flowDoc.getWorkModal() == 2 || flowDoc.getWorkModal() == 3) && flowDoc.getParentId() > 0) {
            this.setOtherSiblingsWorked(flowDoc);
            this.setParentWorked(flowDoc);
        }
        if (flowDoc.getWorkModal() == 1 && flowDoc.getParentId() > 0 && (bl = this.isLastUserOfTogether(flowDoc))) {
            this.setParentWorked(flowDoc);
        }
    }

    private void setParentWorked(FlowDoc flowDoc) throws WCMException {
        if (flowDoc.getParentId() <= 0) {
            return;
        }
        Object[] objectArray = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(flowDoc.getParentId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where FlowDocId=? and  Worked=0"}, objectArray);
    }

    private void setChildrenWorked(FlowDoc flowDoc) throws WCMException {
        if (flowDoc.getParentId() > 0) {
            return;
        }
        Object[] objectArray = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(flowDoc.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where ParentId=? and  Worked=0"}, objectArray);
    }

    private void setOtherSiblingsWorked(FlowDoc flowDoc) throws WCMException {
        if (flowDoc.getParentId() <= 0) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(9), CMyDateTime.now().toTimestamp(), new Integer(flowDoc.getParentId()), new Integer(flowDoc.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Flag=?,Worked=1,WorkTime=? where ParentId=? and FlowDocId<>? and Worked=0"}, objectArray);
    }

    private IFlowContent[] convertToFlowContents(FlowDocs flowDocs, CPager cPager, String string) throws WCMException {
        Object object;
        int n;
        if (cPager == null) {
            cPager = new CPager();
        }
        int n2 = flowDocs.size();
        cPager.setItemCount(n2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        int n4 = 0;
        for (n = cPager.getFirstItemIndex() - 1; n < n2; ++n) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(n);
            if (flowDoc == null) {
                ++n3;
                continue;
            }
            object = FlowContentFactory.makeFlowContent(flowDoc.getContentType(), flowDoc.getContentId());
            if (object == null || object.isDeleted()) {
                ++n3;
                continue;
            }
            if (string != null && !string.trim().equals("") && object.getInfo().indexOf(string) < 0) {
                ++n3;
                continue;
            }
            arrayList.add(object);
            object.setFlowDoc(flowDoc);
            if (++n4 >= cPager.getPageSize()) break;
        }
        n = n2 - n3;
        IFlowContent[] iFlowContentArray = new IFlowContent[n];
        int n5 = cPager.getFirstItemIndex() - 1;
        object = arrayList.iterator();
        while (object.hasNext()) {
            iFlowContentArray[n5++] = (IFlowContent)object.next();
        }
        return iFlowContentArray;
    }

    protected void doShutdown() {
    }

    protected boolean doStart() throws WCMException {
        return true;
    }

    public FlowDocs getFlowDocs(IFlowContent iFlowContent, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ObjType=? and ObjId=? and ParentId=0", "PostTime desc, FlowDocId desc");
        wCMFilter2.addSearchValues(iFlowContent.getType());
        wCMFilter2.addSearchValues(iFlowContent.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return FlowDocs.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public FlowNodes getNextFlowNodes(FlowDoc flowDoc, boolean bl) throws WCMException {
        FlowNode flowNode;
        if (flowDoc == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label29", "\u65e0\u6cd5\u627e\u5230\u8981\u5904\u7406\u7684\u8f68\u8ff9\u3002"));
        }
        FlowDoc flowDoc2 = flowDoc;
        if (bl) {
            flowDoc2 = this.convertToRealFlowDoc(flowDoc2);
            flowDoc2 = flowDoc2.getPreFlowDoc();
            if ((flowDoc2 = this.convertToRealFlowDoc(flowDoc2)) == null) {
                FlowNodes flowNodes = new FlowNodes(null, 1, 1);
                flowNodes.addElement(flowDoc.getNode());
                return flowNodes;
            }
        }
        boolean bl2 = true;
        if (flowDoc2.getWorkModal() == 1) {
            bl2 = this.isLastUserOfTogether(flowDoc2);
        }
        if (flowDoc2.getFlag() == 2 && (flowDoc2.getWorkModal() != 1 || bl2)) {
            FlowNode flowNode2 = flowDoc2.getPreNode();
            if (flowNode2 == null) {
                throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label30", "\u65e0\u6cd5\u627e\u5230\u6253\u56de\u7684\u8282\u70b9\uff0c\u53ef\u80fd\u8282\u70b9\u88ab\u5220\u9664\u6216\u6d41\u8f6c\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002"));
            }
            FlowNodes flowNodes = new FlowNodes(null, 1, 1);
            flowNodes.addElement(flowNode2);
            return flowNodes;
        }
        if (flowDoc2.getWorkModal() == 1) {
            if (bl) {
                return flowDoc.getPreNode().getNextNodes(null);
            }
            if (!bl2) {
                return new FlowNodes(null, 1, 1);
            }
        }
        if ((flowNode = flowDoc2.getNode()) == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label31", "\u5f53\u524d\u6240\u5904\u8282\u70b9[") + flowDoc2.getNodeId() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label32", "]\u4e0d\u80fd\u627e\u5230\uff01\u6570\u636e\u5e93\u4e2d\u88ab\u5220\u9664\u4e86\uff1f"));
        }
        WCMFilter wCMFilter = null;
        if (flowDoc.getFlag() == 8 && flowNode.getWorkModal() == 2) {
            String string = "not exists(select 1 from WCMFlowDoc b where b.ObjType=? and b.ObjId=? and b.PreNodeId=? and b.Worked=0 and b.ParentId=0 and WCMFlowNode.NodeId=b.NodeId)";
            wCMFilter = new WCMFilter("", string, "");
            wCMFilter.addSearchValues(flowDoc.getContentType());
            wCMFilter.addSearchValues(flowDoc.getContentId());
            wCMFilter.addSearchValues(flowDoc.getNodeId());
        }
        return flowNode.getNextNodes(null, wCMFilter);
    }

    public FlowNodes getProcessedFlowNodes(FlowDoc flowDoc) throws WCMException {
        if (flowDoc == null) {
            throw new WCMException("\u5f53\u524d\u6d41\u8f6c\u8f68\u8ff9\u4e3a\u7a7a\uff01");
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "", "NodeId, NodeName");
        int n = flowDoc.getNodeId();
        int n2 = flowDoc.getContentType();
        int n3 = flowDoc.getContentId();
        long l = flowDoc.getSerialNum();
        long l2 = flowDoc.getBranchSerialNum();
        String string = "";
        if (flowDoc.getWorkModal() == 3) {
            string = " nodeid in (select distinct NodeId from WCMFlowDoc where FlowDocId<(select min(flowdocid) from WCMFLOWDOC where NODEID=? and ObjType=? and ObjId=? and ((Serialnum=?  and Serialnum=BranchSerialNum) or (BranchSerialNum=?  and Serialnum<>BranchSerialNum))) and ObjType=? and ObjId=?  and nodeid<>? and ((Serialnum=?  and Serialnum=BranchSerialNum) or (BranchSerialNum=?  and Serialnum<>BranchSerialNum)))";
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n3);
            wCMFilter.addSearchValues(l);
            wCMFilter.addSearchValues(l2);
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n3);
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues(l);
            wCMFilter.addSearchValues(l2);
        } else {
            string = "nodeid in (select distinct NodeId from WCMFlowDoc where FlowDocId<(select min(flowdocid) from WCMFLOWDOC where NODEID=? and ObjType=? and ObjId=? and Serialnum=?) and ObjType=? and ObjId=? and nodeid<>? and Serialnum=?)";
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n3);
            wCMFilter.addSearchValues(l);
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n3);
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues(l);
        }
        wCMFilter.setWhere(string);
        return FlowNodes.openWCMObjs(null, wCMFilter);
    }

    public FlowNodes getWorkModalSepretorEndNodes(FlowDoc flowDoc) throws WCMException {
        if (flowDoc == null) {
            throw new WCMException("\u5f53\u524d\u6d41\u8f6c\u8f68\u8ff9\u4e3a\u7a7a\uff01");
        }
        FlowNode flowNode = flowDoc.getNode();
        int n = flowNode.getFlowId();
        WCMFilter wCMFilter = new WCMFilter("", "FLOWID=? AND WORKMODAL=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(3);
        return FlowNodes.openWCMObjs(null, wCMFilter);
    }

    private FlowDoc convertToRealFlowDoc(FlowDoc flowDoc) throws WCMException {
        return FlowServerImpl.convertToFlowDocNotFlags(flowDoc, new int[]{4});
    }

    public static FlowDoc convertToFlowDocNotFlags(FlowDoc flowDoc, int[] nArray) throws WCMException {
        if (flowDoc == null) {
            return null;
        }
        FlowDoc flowDoc2 = flowDoc;
        int n = 0;
        int n2 = 1000;
        while (flowDoc2 != null && FlowServerImpl.isInFlag(flowDoc2.getFlag(), nArray)) {
            int n3 = flowDoc2.getId();
            if ((flowDoc2 = flowDoc2.getPreFlowDoc()).getId() == n3) break;
            if (++n <= n2) continue;
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label33", "\u9519\u8bef\u6570\u636e\uff0c\u5bfc\u81f4\u6b7b\u5faa\u73af\uff01[FlowDocId=") + flowDoc2.getId() + "]");
        }
        return flowDoc2;
    }

    private static boolean isInFlag(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public ContentProcessInfo getProcessInfoOfContent(IFlowContent iFlowContent) throws WCMException {
        FlowDoc flowDoc;
        WCMFilter wCMFilter = new WCMFilter("WCMFlowDoc", "ObjType=? and ObjId=? and Flag=?", "SerialNum desc", "PostUser, SerialNum");
        wCMFilter.addSearchValues(iFlowContent.getType());
        wCMFilter.addSearchValues(iFlowContent.getId());
        wCMFilter.addSearchValues(0);
        String string = "";
        long l = -1L;
        FlowDocs flowDocs = new FlowDocs(null, 1, 1);
        flowDocs.setMaxSize(1);
        flowDocs.open(wCMFilter);
        if (!flowDocs.isEmpty()) {
            flowDoc = (FlowDoc)flowDocs.getAt(0);
            string = flowDoc.getPostUserName();
            l = flowDoc.getSerialNum();
        }
        flowDoc = this.getCurrentFlowDoc(iFlowContent, l);
        if (iFlowContent.getFlowDoc() == null) {
            iFlowContent.setFlowDoc(flowDoc);
        }
        boolean bl = flowDoc == null;
        Users users = null;
        if (flowDoc != null) {
            users = flowDoc.getToUsers(null);
        }
        return new ContentProcessInfo(bl, iFlowContent, string, users);
    }

    public FlowDoc autoToNextNode(FlowContext flowContext, FlowNode flowNode) throws WCMException {
        return this.autoToNextNode(flowContext, flowNode, null);
    }

    public FlowDoc autoToNextNode(FlowContext flowContext, FlowNode flowNode, Users users) throws WCMException {
        Object object;
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        if (flowDoc.isWorked()) {
            return null;
        }
        flowDoc.validCanEditAndLock(flowContext.getCurrUser());
        flowDoc.setWorked(true);
        flowDoc.update(flowContext.getCurrUser());
        this.setOtherSiblingsWorked(flowDoc);
        this.setParentWorked(flowDoc);
        if (flowNode == null) {
            return null;
        }
        if (flowContext.getNextNode() == null) {
            flowContext.setNextNode(flowNode);
        }
        if (flowNode.getWorkModal() == 3) {
            this.createSingleSignFlowDoc(flowContext, flowNode.getWorkModal());
            object = "ObjType=? and ObjId=? and ParentId=0 and Worked=0 and SerialNum=?";
            WCMFilter wCMFilter = new WCMFilter("", (String)object, "", "FlowDocId");
            wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentType());
            wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentId());
            wCMFilter.addSearchValues(flowContext.getSerialNum());
            wCMFilter.setMaxRowNumber(1);
            FlowDocs flowDocs = FlowDocs.openWCMObjs(null, wCMFilter);
            if (!flowDocs.isEmpty()) {
                return null;
            }
        }
        object = flowContext.getPostUser();
        int n = flowDoc.getContentType();
        int n2 = flowDoc.getContentId();
        int n3 = flowDoc.getNodeId();
        FlowNode flowNode2 = flowDoc.getPreNode();
        Users users2 = users;
        if (users2 == null || users2.isEmpty()) {
            users2 = this.getDealers(flowContext, flowNode);
        }
        if (users2 == null || users2.isEmpty()) {
            return null;
        }
        int n4 = users2.size();
        int n5 = flowNode.getWorkModal();
        FlowDoc flowDoc2 = new FlowDoc();
        flowDoc2.setPostUser((User)object);
        flowDoc2.setPostDesc(flowContext.getPostDesc());
        flowDoc2.setFlag(3);
        flowDoc2.setPreNode(n3);
        flowDoc2.setNode(flowNode);
        flowDoc2.setFlowContent(n, n2);
        flowDoc2.setToUsers(users2.getIdListAsString());
        flowDoc2.setPreFlowDoc(flowDoc.getId());
        flowDoc2.setSerialNum(flowContext.getSerialNum());
        long l = this.makeBranchSerialNum(flowContext, flowNode2);
        flowDoc2.setBranchSerialNum(l);
        flowDoc2.setNextId();
        if (n4 == 1) {
            if (n5 == 1) {
                n5 = 0;
            }
            flowDoc2.setToUser(users2.getIdAt(0));
            this.sendNotify((User)object, (User)users2.getAt(0), flowContext.getNotifyTypes(), flowDoc2.getId(), flowContext.getFlowContent());
        } else {
            for (int i = 0; i < n4; ++i) {
                User user = (User)users2.getAt(i);
                if (user == null) continue;
                FlowDoc flowDoc3 = new FlowDoc();
                flowDoc3.setPostUser((User)object);
                flowDoc3.setPostDesc(flowContext.getPostDesc());
                flowDoc3.setToUser(user);
                flowDoc3.setWorkModal(n5);
                flowDoc3.setFlag(3);
                flowDoc3.setPreNode(n3);
                flowDoc3.setNode(flowNode);
                flowDoc3.setFlowContent(n, n2);
                flowDoc3.setParent(flowDoc2.getId());
                flowDoc3.setPreFlowDoc(flowDoc.getId());
                flowDoc3.setSerialNum(flowContext.getSerialNum());
                flowDoc3.setBranchSerialNum(l);
                flowDoc3.insert((User)object);
                this.sendNotify((User)object, user, flowContext.getNotifyTypes(), flowDoc3.getId(), flowContext.getFlowContent());
            }
        }
        flowDoc2.setWorkModal(n5);
        flowDoc2.insert((User)object);
        FlowNodeBranch flowNodeBranch = flowDoc2.getPreNode().getBranchTo(null, flowDoc2.getNode());
        if (flowNodeBranch != null) {
            flowContext.getFlowContent().updateStatus(flowContext.getCurrUser(), flowNodeBranch.getStatusId());
        }
        flowContext.setCurrNode(flowNode);
        flowContext.setCurrFlowDoc(flowDoc2);
        this.onEvent(flowContext, 5);
        FlowingDocOptMarkScouter.updateOperationMark(flowContext);
        this.autodeleteMessage(flowContext);
        return flowDoc2;
    }

    private long makeBranchSerialNum(FlowContext flowContext, FlowNode flowNode) throws WCMException {
        long l = 0L;
        l = flowNode != null ? (flowNode.getWorkModal() == 2 && flowContext.getCurrFlowDoc().getFlag() != 2 ? System.currentTimeMillis() : (flowNode.getWorkModal() == 3 ? flowContext.getSerialNum() : flowContext.getBranchSerialNum())) : flowContext.getBranchSerialNum();
        return l;
    }

    public boolean resubmitTo(FlowContext flowContext) throws WCMException {
        flowContext.validate();
        FlowDoc flowDoc = flowContext.getCurrFlowDoc();
        int n = flowDoc.getWorkModal();
        User user = flowContext.getCurrUser();
        if (n != 2 && flowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label34", "\u5f53\u524d\u8f68\u8ff9\u5df2\u7ecf\u88ab\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (flowDoc.getParentId() > 0) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label35", "\u5f53\u524d\u8f68\u8ff9\u4e0d\u662f\u9876\u7ea7\u8f68\u8ff9\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (!user.getName().equals(flowDoc.getPostUserName())) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label36", "\u5f53\u524d\u7528\u6237[") + user.getName() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label37", "]\u4e0d\u662f\u5f53\u524d\u8f68\u8ff9\u7684\u5904\u7406\u8005\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (flowDoc.getFlag() == 2 || flowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label38", "\u5f53\u524d\u5904\u7406\u7684\u662f\u8981\u6c42\u8fd4\u5de5\u6216\u8005\u62d2\u7edd\u7684\u8f68\u8ff9\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (!flowDoc.isWorked()) {
            flowDoc.validCanEditAndLock(user);
            flowDoc.setWorked(true);
            flowDoc.update(user);
            this.setChildrenWorked(flowDoc);
            if (n == 2) {
                Object[] objectArray = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(flowDoc.getContentType()), new Integer(flowDoc.getContentId())};
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where ObjType=? and ObjId=? and Worked=0"}, objectArray);
            }
        }
        this.createNewFlowDoc(flowContext, flowDoc.getPreNodeId(), 4);
        FlowingDocOptMarkScouter.updateOperationMark(flowContext);
        return true;
    }

    public IFlowContent[] getFlowContentsDoneByUser(QueryFlowDocContext queryFlowDocContext) throws WCMException {
        if (queryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        String string = "PostUser=? and ParentId=0 and worked=1 and isObjDeleted <> 1";
        if (queryFlowDocContext.getContentType() > 0) {
            string = string + " and ObjType=?";
        }
        String string2 = queryFlowDocContext.getParameter("OrderBy", "FlowDocId Desc");
        WCMFilter wCMFilter = new WCMFilter("", string, string2);
        wCMFilter.addSearchValues(queryFlowDocContext.getCurrUser().getName());
        if (queryFlowDocContext.getContentType() > 0) {
            wCMFilter.addSearchValues(queryFlowDocContext.getContentType());
        }
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, wCMFilter);
        return this.convertToFlowContents(flowDocs, queryFlowDocContext.getPager(), queryFlowDocContext.getParameter("SearchValue", ""));
    }

    public IFlowContent[] getFlowContentsOfUser(QueryFlowDocContext queryFlowDocContext) throws WCMException {
        if (queryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        String string = "ToUserId=? and Worked=0 and isObjDeleted <> 1";
        if (queryFlowDocContext.getContentType() > 0) {
            string = string + " and ObjType=?";
        }
        String string2 = queryFlowDocContext.getParameter("OrderBy", "FlowDocId Desc");
        WCMFilter wCMFilter = new WCMFilter("", string, string2);
        wCMFilter.addSearchValues(queryFlowDocContext.getCurrUser().getId());
        if (queryFlowDocContext.getContentType() > 0) {
            wCMFilter.addSearchValues(queryFlowDocContext.getContentType());
        }
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, wCMFilter);
        return this.convertToFlowContents(flowDocs, queryFlowDocContext.getPager(), queryFlowDocContext.getParameter("SearchValue", ""));
    }

    public IFlowContent[] getFlowContentsStartByUser(QueryFlowDocContext queryFlowDocContext) throws WCMException {
        if (queryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        int n = queryFlowDocContext.getContentType();
        String string = queryFlowDocContext.getParameter("SearchValue", "");
        String string2 = queryFlowDocContext.getParameter("OrderBy", "PostTime Desc");
        String string3 = "select ObjType, ObjId, PostTime, SerialNum from WCMFlowDoc where PostUser=? and Flag=? and ParentId=0" + (n > 0 ? " and ObjType=?" : "") + " and isObjDeleted <> 1" + " order by " + string2;
        CPager cPager = queryFlowDocContext.getPager();
        if (cPager == null) {
            cPager = new CPager();
        }
        cPager.setItemCount(1000);
        Connection connection = DBManager.getDBManager().getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n2 = 0;
        int n3 = 0;
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, queryFlowDocContext.getCurrUser().getName());
            preparedStatement.setInt(2, 0);
            if (n > 0) {
                preparedStatement.setInt(3, n);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<IFlowContent> arrayList = new ArrayList<IFlowContent>();
            while (resultSet.next()) {
                if (++n3 < cPager.getFirstItemIndex() || arrayList.size() >= cPager.getPageSize()) continue;
                IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(resultSet.getInt(1), resultSet.getInt(2));
                if (iFlowContent == null || iFlowContent.isDeleted()) {
                    ++n2;
                    continue;
                }
                if (string != null && !string.trim().equals("") && iFlowContent.getInfo().indexOf(string) < 0) {
                    ++n2;
                    continue;
                }
                iFlowContent.setStartTime(new CMyDateTime(resultSet.getTimestamp("PostTime").getTime()));
                arrayList.add(iFlowContent);
                long l = resultSet.getLong("SerialNum");
                iFlowContent.setSerialNum(l);
                iFlowContent.setFlowDoc(this.getCurrentFlowDoc(iFlowContent, l));
            }
            int n4 = n3 - n2;
            IFlowContent[] iFlowContentArray = new IFlowContent[n4];
            n3 = cPager.getFirstItemIndex() - 1;
            IFlowContent[] iFlowContentArray2 = arrayList.iterator();
            while (iFlowContentArray2.hasNext()) {
                iFlowContentArray[n3++] = (IFlowContent)iFlowContentArray2.next();
            }
            iFlowContentArray2 = iFlowContentArray;
            return iFlowContentArray2;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label16", "\u6784\u9020\u53d1\u8d77\u7684\u5185\u5bb9\u5931\u8d25\uff01"), exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            DBManager.getDBManager().freeConnection(connection);
        }
    }

    private void makeNewFlowDocForRefuse(FlowDoc flowDoc, FlowContext flowContext, boolean bl, FlowDoc flowDoc2) throws WCMException {
        FlowDoc flowDoc3 = new FlowDoc();
        flowDoc3.setContentType(flowDoc.getContentType());
        flowDoc3.setContentId(flowDoc.getContentId());
        flowDoc3.setPostUser(flowContext.getPostUser());
        flowDoc3.setPostTime(CMyDateTime.now());
        flowDoc3.setPostDesc(flowContext.getPostDesc());
        if (flowDoc2 == null) {
            flowDoc3.setToUser(flowDoc.getPostUser());
        } else {
            flowDoc3.setToUser(flowDoc2.getPostUser());
        }
        flowDoc3.setFlag(8);
        flowDoc3.setPreNode(flowDoc.getNodeId());
        if (flowDoc2 == null) {
            flowDoc3.setNode(flowDoc.getPreNodeId());
        } else {
            flowDoc3.setNode(flowDoc2.getPreNodeId());
        }
        flowDoc3.setPreFlowDoc(flowDoc.getId());
        flowDoc3.setWorked(!bl);
        flowDoc3.setSerialNum(flowContext.getSerialNum());
        flowDoc3.setBranchSerialNum(flowContext.getBranchSerialNum());
        flowDoc3.insert(flowContext.getCurrUser());
    }

    private FlowDocs getSeperatorDealedFlowDocs(FlowContext flowContext) throws WCMException {
        String string = "ObjType=? and ObjId=? and Worked=1 and SerialNum=? and NodeId=? and ToUsers is null";
        WCMFilter wCMFilter = new WCMFilter("", string, "", "*");
        wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentType());
        wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getContentId());
        wCMFilter.addSearchValues(flowContext.getSerialNum());
        wCMFilter.addSearchValues(flowContext.getCurrFlowDoc().getNodeId());
        wCMFilter.setMaxRowNumber(1);
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, wCMFilter);
        return flowDocs;
    }

    private int getCompressLength(int n) {
        return (int)Math.floor((float)n / 1.5f);
    }

    private void autodeleteMessage(FlowContext flowContext) throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("DELETE_MESSAGE_AFTER_PROCESS", "false");
        if ("true".equalsIgnoreCase(string)) {
            FlowDoc flowDoc = flowContext.getCurrFlowDoc();
            if (flowDoc == null) {
                return;
            }
            MessageServer.deleteMessage(flowDoc.getId(), flowContext.getCurrUser());
        }
    }
}

