/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class FlowEngineHelper {
    public static String makeTogetherComments(int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "Flag=? and PreFlowDocId in(select FlowDocId from WCMFlowDoc where Worked=1 and ParentId=? )", "WorkTime Desc", "FlowDocId,PostUser,PostDesc");
        wCMFilter.addSearchValues(10);
        wCMFilter.addSearchValues(n);
        return FlowEngineHelper.makeComments(wCMFilter);
    }

    private static String makeComments(WCMFilter wCMFilter) throws WCMException {
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxSize(100);
        flowDocs.setMaxBufferSize(101);
        flowDocs.open(wCMFilter);
        StringBuffer stringBuffer = new StringBuffer(flowDocs.size() * 100);
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            String string;
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null || (string = flowDoc.getPostDesc()) == null || (string = string.trim()).length() == 0) continue;
            stringBuffer.append("~~");
            stringBuffer.append(flowDoc.getPostUserTrueName());
            stringBuffer.append("~~");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String makeSeperateComments(FlowDoc flowDoc) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=? and WorkModal=? and Worked=1", "WorkTime Desc", "FlowDocId,PostUser,PostDesc");
        wCMFilter.addSearchValues(flowDoc.getContentType());
        wCMFilter.addSearchValues(flowDoc.getContentId());
        wCMFilter.addSearchValues(11);
        return FlowEngineHelper.makeComments(wCMFilter);
    }

    public static String[] parseComments(FlowDoc flowDoc) {
        String string = flowDoc.getPostDesc();
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        if (!string.startsWith("~~")) {
            return new String[]{flowDoc.getPostUserTrueName(), string};
        }
        return string.substring("~~".length()).split("~~");
    }

    public static void main(String[] stringArray) {
        String string = "~~user1~~121313123~~user2~~1213";
        if (!string.startsWith("~~")) {
            System.out.println(I18NMessage.get(FlowEngineHelper.class, "FlowEngineHelper.label1", "\u5355\u4eba"));
        }
        System.out.println(string.substring("~~".length()).split("~~").length);
    }
}

