/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.Locker;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class LockManager {
    private static final String SQL_INS = "insert into WCMCLUSTERLOCK(OBJTYPE,OBJID,LOCKEDUSER,LOCKEDTIME) values(?,?,?,?)";
    private static final String SQL_DEL = "delete from WCMCLUSTERLOCK where OBJTYPE=? and OBJID=? and LOCKEDUSER=?";
    private static final LockManager INSTANCE = new LockManager();
    private static Logger logger = Logger.getLogger(LockManager.class);

    private LockManager() {
    }

    public static LockManager instance() {
        return INSTANCE;
    }

    public Locker getLocker(CMSObj cMSObj, boolean bl) {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            return null;
        }
        return this.getLocker(cMSObj.getWCMType(), cMSObj.getId(), bl);
    }

    public Locker getLocker(int n, int n2, boolean bl) {
        Locker locker = this.findGlobalLock(n, n2);
        if (locker != null) {
            return locker;
        }
        if (bl && this.globalLock(n, n2)) {
            locker = new Locker(ContextHelper.getLoginUser());
        }
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locker findGlobalLock(int n, int n2) {
        String string = "select LOCKEDUSER from WCMCLUSTERLOCK where OBJTYPE=? and OBJID=?";
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Locker locker = new Locker(User.findByName(resultSet.getString(1)));
                return locker;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to query lock info[Type" + n + ",Id=" + n2 + "]"), (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public Locker removeLocker(CMSObj cMSObj) {
        if (cMSObj == null || cMSObj.isAddMode()) {
            return null;
        }
        return this.removeLocker(cMSObj.getWCMType(), cMSObj.getId());
    }

    public Locker removeLocker(int n, int n2) {
        Locker locker = this.findGlobalLock(n, n2);
        if (!(locker == null || locker.lockUserIs(ContextHelper.getLoginUser()) && this.globalUnlock(n, n2))) {
            locker = null;
        }
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLockedObjBy(User user) {
        if (user == null) {
            return;
        }
        String string = "delete from WCMCLUSTERLOCK where LOCKEDUSER=?";
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, user.getName());
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockedObjIds(int n) {
        String string = "select OBJTID from WCMCLUSTERLOCK where OBJTYPE=?";
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer = new StringBuffer(128);
            while (resultSet.next()) {
                stringBuffer.append(',').append(resultSet.getInt(1));
            }
            String string2 = stringBuffer.substring(1);
            return string2;
        }
        catch (Exception exception) {
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean globalLock(int n, int n2) {
        DBManager dBManager = DBManager.getDBManager();
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(SQL_INS);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setString(3, ContextHelper.getLoginUser().getName());
            preparedStatement.setTimestamp(4, CMyDateTime.now().toTimestamp());
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        catch (Exception exception) {
            logger.error((Object)("failed to lock obj[Type=" + n + ",Id=" + n2 + "]"), (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean globalUnlock(int n, int n2) {
        DBManager dBManager = DBManager.getDBManager();
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(SQL_DEL);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setString(3, ContextHelper.getLoginUser().getName());
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        catch (Exception exception) {
            logger.error((Object)("failed to unlock obj[Type" + n + ",Id=" + n2 + "]"), (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }
}

