/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.IUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class UserCacheMgr
implements IUserCacheMgr {
    private static Logger s_logger = Logger.getLogger(UserCacheMgr.class);
    private LRUCacheContainer m_lruUserNameCache = null;
    public static int MAX_USERNAME_CACHE_SIZE = 52000;

    public User _getUserByName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        User user = null;
        String string2 = string.toLowerCase();
        try {
            user = (User)this.getUserNameCache().get((Object)string2);
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label1", "\u542f\u52a8\u7528\u6237\u540d\u7f13\u51b2\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)wCMException);
        }
        if (user == null) {
            try {
                user = this.loadByName(string2);
            }
            catch (Exception exception) {
                s_logger.error((Object)("get user[" + string2 + "] from db error!"), (Throwable)exception);
                return null;
            }
        }
        return user;
    }

    protected void addUserToNameCache(User user) {
        if (user == null) {
            return;
        }
        try {
            this.getUserNameCache().put((Object)user.getName(), (Object)user);
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label2", "\u83b7\u53d6\u7f13\u51b2\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\u5bfc\u81f4\u6dfb\u52a0\u7f13\u51b2\u5931\u8d25\uff01"), (Throwable)wCMException);
        }
    }

    protected void removeUserFromNameCache(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        }
        this.getUserNameCache().remove((Object)user.getName());
    }

    protected void initUserNameCache() throws WCMException {
        if (this.m_lruUserNameCache != null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label4", "\u6b63\u5728\u521d\u59cb\u5316\u7528\u6237\u540d\u7f13\u51b2..."));
        this.m_lruUserNameCache = new LRUCacheContainer();
        Users users = Users.openWCMObjs(null, null);
        int n = MAX_USERNAME_CACHE_SIZE;
        if (n < MAX_USERNAME_CACHE_SIZE && (n = (int)((double)n * 1.5)) > MAX_USERNAME_CACHE_SIZE) {
            n = MAX_USERNAME_CACHE_SIZE;
        }
        this.m_lruUserNameCache.setMaxSize(n);
        User user = null;
        for (int i = 0; i < users.size(); ++i) {
            user = (User)users.getAt(i);
            if (user == null) continue;
            this.getUserNameCache().put((Object)user.getName().toLowerCase(), (Object)user);
        }
        this.getUserNameCache().put((Object)"system", (Object)User.getSystem());
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label5", "\u521d\u59cb\u5316\u7528\u6237\u540d\u7f13\u51b2\u5b8c\u6210"));
    }

    protected void clearUserNameCache() {
        if (this.m_lruUserNameCache == null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label6", "\u6b63\u5728\u6e05\u7a7a\u7528\u6237\u540d\u7f13\u51b2..."));
        this.m_lruUserNameCache.clear();
        this.m_lruUserNameCache = null;
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label7", "\u6b63\u5728\u6e05\u7a7a\u7528\u6237\u540d\u7f13\u51b2\u5b8c\u6210\uff01"));
    }

    private User loadByName(String string) throws WCMException {
        Users users;
        WCMFilter wCMFilter = new WCMFilter("", "UserName=?", "", "", 1);
        wCMFilter.addSearchValues(string);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Cache\u4e0d\u591f\uff0c\u9700\u8981\u91cd\u65b0\u8bfb\u53d6\u7528\u6237[" + string + "]\u4fe1\u606f\uff01"));
            s_logger.debug((Object)wCMFilter.toSQL());
        }
        if ((users = Users.openWCMObjs(null, wCMFilter)).isEmpty()) {
            return null;
        }
        User user = (User)users.getAt(0);
        this.getUserNameCache().put((Object)user.getName().toLowerCase(), (Object)user);
        return user;
    }

    public void notifyOnAddObj(BaseObj baseObj) {
        this.addUserToNameCache((User)baseObj);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.removeUserFromNameCache((User)baseObj);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!baseObj.isChangeProperty("USERNAME")) {
            return;
        }
        this.removeUserFromNameCache((User)baseObj);
    }

    public boolean init() throws WCMException {
        this.initUserNameCache();
        return true;
    }

    public void clear() {
        this.clearUserNameCache();
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    protected LRUCacheContainer getUserNameCache() throws WCMException {
        if (this.m_lruUserNameCache == null) {
            this.initUserNameCache();
        }
        return this.m_lruUserNameCache;
    }
}

