/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class Right
extends CMSObj {
    public static final int OBJ_TYPE = 202;
    public static final String DB_TABLE_NAME = "WCMRIGHT";
    public static final String DB_ID_NAME = "RIGHTID";
    public static final int OPRTYPE_USER = 204;
    public static final int OPRTYPE_ROLE = 203;
    public static final int OPRTYPE_GROUP = 201;
    private static IRightMgr s_oRightMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 202;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(Right.class, "Right.label1", "ObjType\u503c\u65e0\u6548(Right.setObjType)"));
        }
        return this.setProperty("OBJTYPE", n);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(Right.class, "Right.label2", "ObjId\u503c\u65e0\u6548(Right.setObjId)"));
        }
        return this.setProperty("OBJID", n);
    }

    public boolean setObject(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label3", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(Right.setObject)"));
        }
        if (!this.setObjType(cMSObj.getWCMType())) {
            return false;
        }
        return this.setObjId(cMSObj.getId());
    }

    public boolean setObject(int n, int n2) throws WCMException {
        return this.setObjType(n) && this.setObjId(n2);
    }

    public int getOperatorType() {
        return this.getPropertyAsInt("OPRTYPE", 0);
    }

    public boolean setOperatorType(int n) throws WCMException {
        if (n != 203 && n != 204 && n != 201) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label4", "\u65e0\u6548\u7684\u8bbf\u95ee\u8005\u7c7b\u578b\uff08Right.setOperatorType\uff09"));
        }
        return this.setProperty("OPRTYPE", n);
    }

    public int getOperatorId() {
        return this.getPropertyAsInt("OPRID", 0);
    }

    public boolean setOperatorId(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label5", "\u65e0\u6548\u7684\u8bbf\u95ee\u8005ID"));
        }
        return this.setProperty("OPRID", n);
    }

    public CMSObj getOperator() throws WCMException {
        int n = this.getOperatorId();
        switch (this.getOperatorType()) {
            case 204: {
                return User.findById(n);
            }
            case 203: {
                return Role.findById(n);
            }
            case 201: {
                return Group.findById(n);
            }
        }
        return null;
    }

    public boolean setOperator(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label6", "\u64cd\u4f5c\u8005\u5bf9\u8c61\u4e3a\u7a7a(Right.setOperator)"));
        }
        if (!this.setOperatorType(cMSObj.getWCMType())) {
            return false;
        }
        return this.setOperatorId(cMSObj.getId());
    }

    public boolean setOperator(int n, int n2) throws WCMException {
        return this.setOperatorType(n) && this.setOperatorId(n2);
    }

    public long getValueAsLong() {
        return this.getPropertyAsLong("RIGHTVALUE", 0L);
    }

    public long getValueAsInt() {
        return this.getValueAsLong();
    }

    public RightValue getValue() {
        return new RightValue(this.getValueAsLong());
    }

    public boolean setValue(RightValue rightValue) throws WCMException {
        if (rightValue == null) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label7", "\u6743\u9650\u503c\u65e0\u6548(Right.setValue)"));
        }
        return this.setValue(rightValue.getValue());
    }

    public boolean setValue(long l) throws WCMException {
        if (l < 0L) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label8", "\u6743\u9650\u503c\u65e0\u6548[\u5fc5\u987b>=0](Right.setValue)"));
        }
        return this.setProperty("RIGHTVALUE", l);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            Number number = (Number)this.getAllProperty().get("OBJTYPE");
            Number number2 = (Number)this.getAllProperty().get("OBJID");
            Number number3 = (Number)this.getAllProperty().get("OPRTYPE");
            Number number4 = (Number)this.getAllProperty().get("OPRID");
            if (number == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (number2 == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (number3 == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label11", "\u5c5e\u6027OperType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (number4 == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label11", "\u5c5e\u6027OperType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (this.getAllProperty().get("RIGHTVALUE") == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label12", "\u6743\u9650\u503c\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            String string = " (ObjType=" + number + ") and (ObjId=" + number2 + ") and (OprType=" + number3 + ") and (OprId=" + number4 + ") ";
            if (!this.isAddMode()) {
                string = string + " and (" + this.getIdFieldName() + "<>" + this.getId() + ")";
            }
            if (this.checkExists(string)) {
                throw new WCMException(1108, I18NMessage.get(Right.class, "Right.label13", "\u6743\u9650\u5bf9\u8c61\u5df2\u7ecf\u5b58\u5728\uff08Right.isValid\uff09"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Right.class, "Right.label14", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Right.isValid)"));
        }
        return true;
    }

    public static Users getUsersWithRight(User user, int n, int n2, boolean bl) throws WCMException {
        WCMFilter wCMFilter = null;
        wCMFilter = bl ? new WCMFilter("wcmRight", "ObjType=" + n + " and ObjId=" + n2 + " and OprType=" + 204, "", "OprId as UserId") : new WCMFilter("wcmUser", "not exists(select RightId from wcmRight where (OprType=204) and (OprId=WCMUser.UserId) and (ObjType=" + n + ") and (ObjId=" + n2 + "))", "");
        Users users = new Users(user);
        try {
            users.open(wCMFilter);
            return users;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label15", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519(Right.getUsers)"), wCMException);
        }
    }

    public static Roles getRolesWithRight(User user, int n, int n2, boolean bl) throws WCMException {
        WCMFilter wCMFilter = null;
        wCMFilter = bl ? new WCMFilter("wcmRight", "ObjType=" + n + " and ObjId=" + n2 + " and OprType=" + 203, "", "OprId as RoleId") : new WCMFilter("wcmRole", "not exists(select RightId from wcmRight where (OprType=203) and (OprId=WCMRole.RoleId) and (ObjType=" + n + ") and (ObjId=" + n2 + "))", "");
        Roles roles = new Roles(user);
        try {
            roles.open(wCMFilter);
            return roles;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label16", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u89d2\u8272\u96c6\u5408\u65f6\u51fa\u9519(Right.getRolesWithRight)"), wCMException);
        }
    }

    public static Groups getGroupsWithRight(User user, int n, int n2, boolean bl) throws WCMException {
        WCMFilter wCMFilter = null;
        wCMFilter = bl ? new WCMFilter("wcmRight", "ObjType=" + n + " and ObjId=" + n2 + " and OprType=" + 201, "", "OprId as GROUPID") : new WCMFilter("wcmGroup", "not exists(select RightId from wcmRight where (OprType=201) and (OprId=wcmGroup.GroupId) and (ObjType=" + n + ") and (ObjId=" + n2 + "))", "");
        Groups groups = new Groups(user);
        try {
            groups.open(wCMFilter);
            return groups;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label17", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u7528\u6237\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(Right.getGroupsWithRight)"), wCMException);
        }
    }

    public static final Right findBy(int n, int n2, int n3, int n4) throws WCMException {
        return s_oRightMgr.getRight(n, n2, n3, n4);
    }

    public static final Right findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Right)BaseObj.findById(Right.class, n);
    }

    public static final Right createNewInstance() throws WCMException {
        return (Right)BaseObj.createNewInstance(Right.class);
    }

    public static final Right findByKey(Object object) throws WCMException {
        return (Right)BaseObj.findByKey(Right.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return "Value=" + this.getValueAsInt();
        }
        return "Value=" + this.getValueAsInt() + I18NMessage.get(Right.class, "Right.label18", "[\u6743\u9650\u503c-") + this.getId() + "]";
    }
}

