/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.Flows;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class FlowToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(FlowToXML.class);
    private static final int OWNERID = 1;
    private static final int INFOVIEWID = 2;

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        Flow flow = (Flow)baseObj;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                User user = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                boolean bl = false;
                if (user.isAdministrator() || user.getName().equals(flow.getCrUserName())) {
                    rightValue = new RightValue(RightValue.VALUE_ADMINISTRATOR);
                } else {
                    rightValue = (RightValue)methodContext.getContextCacheData("OwnerValue");
                    if (rightValue == null) {
                        CMSObj cMSObj = (CMSObj)methodContext.getContextCacheData("Owner");
                        if (cMSObj == null) {
                            cMSObj = (CMSObj)flow.getOwner();
                        }
                        if (cMSObj != null && !(cMSObj instanceof WCMSystemObject)) {
                            if (cMSObj instanceof Channel) {
                                cMSObj = ((Channel)cMSObj).getSite();
                            }
                            rightValue = AuthServer.getRightValue(cMSObj, user);
                        } else {
                            rightValue = new RightValue(0L);
                            bl = true;
                        }
                        methodContext.putContextCacheData("OwnerValue", rightValue);
                    }
                }
                return new String[][]{{"Right", rightValue.toString()}, {"IsRoot", String.valueOf(bl)}};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(FlowToXML.class, "FlowToXML.label1", "\u6784\u9020[") + flow + I18NMessage.get(FlowToXML.class, "FlowToXML.label2", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        return null;
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) {
        Flow flow = (Flow)baseObj;
        switch (n) {
            case 1: {
                try {
                    int n2 = flow.getOwnerId();
                    if (flow.getOwnerType() == 1) {
                        return new String[][]{{"Id", String.valueOf(n2)}, {"Name", WebSiteServiceProvider.findSiteTypeDesc(n2)}};
                    }
                    BaseObj baseObj2 = flow.getOwner();
                    if (baseObj2 == null) {
                        return new String[][]{{"Id", object.toString()}, {"Name", I18NMessage.get(FlowToXML.class, "FlowToXML.label3", "\u672a\u77e5")}};
                    }
                    return new String[][]{{"Id", object.toString()}, {"Name", baseObj2.toString()}};
                }
                catch (Throwable throwable) {
                    logger.error((Object)I18NMessage.get(FlowToXML.class, "FlowToXML.label4", "\u83b7\u53d6\u5de5\u4f5c\u6d41\u7684Owner\u53d1\u751f\u5f02\u5e38\uff01"), throwable);
                    return new String[][]{{"Id", object.toString()}, {"Name", I18NMessage.get(FlowToXML.class, "FlowToXML.label3", "\u672a\u77e5")}};
                }
            }
            case 2: {
                int n3 = flow.getPropertyAsInt("INFOVIEWID", 0);
                if (n3 <= 0) break;
                try {
                    InfoView infoView = InfoView.findById(n3);
                    if (infoView != null) {
                        return new String[][]{{"Id", String.valueOf(n3)}, {"Name", infoView.getName()}, {"Desc", infoView.getDesc()}};
                    }
                    break;
                }
                catch (Exception exception) {
                    throw new RuntimeException(I18NMessage.get(FlowToXML.class, "FlowToXML.label5", "\u67e5\u627e[ID=") + n3 + I18NMessage.get(FlowToXML.class, "FlowToXML.label6", "]\u7684\u8868\u5355\u5931\u8d25\uff01"), exception);
                }
            }
        }
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("OWNERID", 1, "OWNER");
        this.registerHostSpecialProperty("INFOVIEWID", 2, "INFOVIEW");
    }

    public String[] registerTargetClassName() {
        return new String[]{Flows.class.getName(), Flow.class.getName()};
    }
}

