/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.dom4j.Element;

public class FlowDocToXML
extends BaseWCMObjectToXML {
    private static final int FLAG = 1;
    private static final int NODEID = 2;
    private static final int PRENODEID = 3;
    private static final int TOUSERS = 4;
    private static final int TOUSERID = 5;
    private static final int POSTDESC = 6;
    private static final int POSTUSER = 7;

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        FlowDoc flowDoc = (FlowDoc)baseObj;
        switch (n) {
            case 1: {
                return new String[][]{{"Name", flowDoc.getFlagDesc()}, {"Id", String.valueOf(flowDoc.getFlag())}};
            }
            case 2: {
                try {
                    FlowNode flowNode = flowDoc.getNode();
                    if (flowNode == null) {
                        return null;
                    }
                    return new String[][]{{"Name", flowNode.getName()}, {"Id", String.valueOf(flowNode.getId())}};
                }
                catch (Exception exception) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label1", "\u6784\u9020\u5f53\u524d\u8282\u70b9\u5931\u8d25\uff01"), exception);
                }
            }
            case 3: {
                try {
                    FlowNode flowNode = flowDoc.getPreNode();
                    if (flowNode == null) {
                        return null;
                    }
                    return new String[][]{{"Name", flowNode.getName()}, {"Id", String.valueOf(flowNode.getId())}};
                }
                catch (Exception exception) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label1", "\u6784\u9020\u5f53\u524d\u8282\u70b9\u5931\u8d25\uff01"), exception);
                }
            }
            case 4: {
                try {
                    return new String[][]{{flowDoc.getToUserTrueNames()}};
                }
                catch (Exception exception) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label2", "\u6784\u9020\u63a5\u53d7\u7528\u6237\u5931\u8d25\uff01"), exception);
                }
            }
            case 5: {
                if (flowDoc.getToUserIds() != null && flowDoc.getToUserIds().length() > 0) {
                    return null;
                }
                try {
                    return new String[][]{{flowDoc.getToUserNames()}};
                }
                catch (Exception exception) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label2", "\u6784\u9020\u63a5\u53d7\u7528\u6237\u5931\u8d25\uff01"), exception);
                }
            }
            case 7: {
                User user = flowDoc.getPostUser();
                String string = user.getName();
                String string2 = user.getTrueName();
                if (string2 != null && !"".equals(string2)) {
                    string = string2;
                }
                return new String[][]{{string}};
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer(object.toString().length());
                String[] stringArray = FlowEngineHelper.parseComments(flowDoc);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(":\n");
                        stringBuffer.append(stringArray[++i]);
                        stringBuffer.append("\n");
                    }
                }
                return new String[][]{{stringBuffer.toString()}};
            }
        }
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("Flag", 1);
        this.registerHostSpecialProperty("NodeId", 2, "Node");
        this.registerHostSpecialProperty("PreNodeId", 3, "PreNode");
        this.registerHostSpecialProperty("ToUsers", 4);
        this.registerHostSpecialProperty("PostDesc", 6);
        this.registerHostSpecialProperty("ToUserId", 5, "ToUsers");
        this.registerHostSpecialProperty("Postuser", 7);
    }

    public String[] registerTargetClassName() {
        return new String[]{FlowDoc.class.getName(), FlowDocs.class.getName()};
    }

    protected Element makeElementFromBaseObj(MethodContext methodContext, String string, BaseObj baseObj, boolean bl, String[] stringArray) throws ConvertException {
        FlowDoc flowDoc = (FlowDoc)baseObj;
        Element element = super.makeElementFromBaseObj(methodContext, string, baseObj, bl, stringArray);
        Element element2 = element.addElement("Comments");
        String[] stringArray2 = FlowEngineHelper.parseComments(flowDoc);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Element element3 = element2.addElement("Comment");
                element3.addElement("User").addCDATA(stringArray2[i]);
                element3.addElement("Content").addCDATA(stringArray2[++i]);
            }
        }
        return element;
    }
}

