/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class DocumentToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(DocumentToXML.class);
    private static final int DOCCHANNEL = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCHTMLCON = 3;
    private static final int DOCTYPE = 4;
    private static final int DOCSOURCE = 5;
    private static final int OPERUSER = 6;
    private static final int OPERTIME = 7;
    private static final int DOCVERSION = 8;

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCHANNEL", 1);
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCHTMLCON", 3);
        this.registerHostSpecialProperty("DOCTYPE", 4);
        this.registerHostSpecialProperty("DOCSOURCE", 5);
        this.registerHostSpecialProperty("OPERUSER", 6);
        this.registerHostSpecialProperty("OPERTIME", 7);
        this.registerHostSpecialProperty("DOCVERSION", 8);
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        Document document = (Document)baseObj;
        try {
            switch (n) {
                case 1: {
                    return this.makeChannelValue(object);
                }
                case 2: {
                    int n2 = methodContext.getValue("ChannelId", 0);
                    return this.makeStatus(object, document, n2);
                }
                case 6: {
                    int n3 = methodContext.getValue("ChannelId", 0);
                    return this.makeOperUser(object, document, n3);
                }
                case 7: {
                    int n4 = methodContext.getValue("ChannelId", 0);
                    return this.makeOperTime(methodContext, object, document, n4);
                }
                case 3: {
                    return this.makeHTMLCon(document);
                }
                case 4: {
                    return new String[][]{{"Type", object.toString()}, {"Name", document.getTypeString()}};
                }
                case 5: {
                    return this.makeDocSource(object, document);
                }
                case 8: {
                    int n5 = 1;
                    if (object != null) {
                        n5 = ((Number)object).intValue() + 1;
                    }
                    return new String[][]{{String.valueOf(n5)}};
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label1", "\u8f6c\u6362\u5bf9\u8c61[") + baseObj + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label2", "]\u6570\u636e[") + n + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label3", "]\u5931\u8d25\uff01")), (Throwable)exception);
            throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label4", "\u8f6c\u6362\u6570\u636e[") + n + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label3", "]\u5931\u8d25\uff01"), exception);
        }
        return null;
    }

    private String[][] makeDocSource(Object object, Document document) throws WCMException {
        String string = "";
        Source source = document.getSource();
        if (source != null) {
            string = source.getName();
        }
        return new String[][]{{"Id", object.toString()}, {"Name", string}};
    }

    private String[][] makeHTMLCon(Document document) throws WCMException {
        switch (document.getType()) {
            case 20: {
                return new String[][]{{document.getHtmlContentWithImgFilter(null, false)}};
            }
            case 10: {
                return new String[][]{{CMyString.transDisplay(document.getContent(), false)}};
            }
            case 40: {
                return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label5", "\u5916\u90e8\u6587\u4ef6")}};
            }
            case 30: {
                return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label6", "\u94fe\u63a5\u6587\u6863")}};
            }
        }
        return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label7", "\u672a\u77e5\u7c7b\u578b\u6587\u6863[Type=") + document.getType() + "]"}};
    }

    private String[][] makeStatus(Object object, Document document, int n) throws WCMException {
        ChnlDoc chnlDoc;
        Status status = null;
        status = n == 0 || document.getChannelId() == n ? Status.findById(((Long)object).intValue()) : ((chnlDoc = this.findChnlDoc(document, n)) != null ? chnlDoc.getStatus() : Status.findById(((Long)object).intValue()));
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(DocumentToXML.class, "DocumentToXML.label8", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeOperUser(Object object, Document document, int n) throws WCMException {
        ChnlDoc chnlDoc;
        String string = n == 0 || document.getChannelId() == n ? (object == null ? "" : object.toString()) : ((chnlDoc = this.findChnlDoc(document, n)) != null ? chnlDoc.getOperUserName() : (object == null ? "" : object.toString()));
        return new String[][]{{string}};
    }

    private String[][] makeOperTime(MethodContext methodContext, Object object, Document document, int n) throws WCMException {
        Object object2;
        CMyDateTime cMyDateTime = n == 0 || document.getChannelId() == n ? (CMyDateTime)object : ((object2 = this.findChnlDoc(document, n)) != null ? ((ChnlDoc)object2).getOperTime() : (CMyDateTime)object);
        object2 = cMyDateTime != null && !cMyDateTime.isNull() ? this.convertDateTimeValueToString(methodContext, cMyDateTime) : "";
        return new String[][]{{object2}};
    }

    private ChnlDoc findChnlDoc(Document document, int n) throws WCMException {
        Object object = document.getProperty("ChnlDoc");
        if (object == null) {
            ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(document.getId(), n);
            if (chnlDoc != null) {
                document.setProperty("ChnlDoc", chnlDoc, false);
            } else {
                document.setProperty("ChnlDoc", new NullValue(0), false);
            }
            return chnlDoc;
        }
        if (object instanceof ChnlDoc) {
            return (ChnlDoc)object;
        }
        return null;
    }

    private String[][] makeChannelValue(Object object) throws WCMException {
        Channel channel = Channel.findById(Math.abs(((Long)object).intValue()));
        if (channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(DocumentToXML.class, "DocumentToXML.label8", "\u672a\u77e5")}, {"RIGHTVALUE", "0"}, {"CHANNELTYPE", "0"}};
        }
        String string = "";
        User user = ContextHelper.getLoginUser();
        string = user.isAdministrator() || user.equals(channel.getCrUser()) ? RightValue.getAdministratorValues() : AuthServer.getRightValue((CMSObj)channel, user).toString();
        return new String[][]{{"ID", channel.getKey().toString()}, {"NAME", channel.getDispDesc()}, {"RIGHTVALUE", string}, {"CHANNELTYPE", String.valueOf(channel.getType())}};
    }

    public String[] registerTargetClassName() {
        return new String[]{Documents.class.getName(), Document.class.getName(), DocBaks.class.getName()};
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)((Document)baseObj), 32))}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), wCMException);
        }
    }

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        String[] stringArray;
        CMSObj cMSObj;
        Document document = (Document)baseObj;
        String[] stringArray2 = null;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                User user = ContextHelper.getLoginUser();
                cMSObj = this.makeCurrChannel(methodContext);
                stringArray = WCMDocumentHelper.makeRightValue(methodContext, user, (Channel)cMSObj, document);
                stringArray2 = new String[]{"Right", stringArray};
            }
            catch (Exception exception) {
                System.out.println(methodContext.getValues());
                throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label10", "\u6784\u9020[") + document + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label11", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        int n = methodContext.getValue("ChannelId", 0);
        cMSObj = null;
        stringArray = null;
        try {
            cMSObj = this.findChnlDoc(document, n);
            if (cMSObj != null) {
                stringArray = new String[]{"Topped", String.valueOf(((ChnlDoc)cMSObj).isTopped())};
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new String[][]{stringArray, stringArray2};
    }

    private Channel makeCurrChannel(MethodContext methodContext) throws WCMException {
        String string = "CurrChannel";
        Channel channel = (Channel)methodContext.getContextCacheData(string);
        if (channel != null) {
            return channel;
        }
        int n = methodContext.getValue("ChannelId", 0);
        if (n <= 0) {
            return null;
        }
        channel = Channel.findById(n);
        methodContext.putContextCacheData(string, channel);
        return channel;
    }
}

