/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContentProcessInfoToXML
implements IXMLConvertor {
    public String[] registerTargetClassName() {
        return new String[]{ContentProcessInfo.class.getName()};
    }

    public String toXmlString(MethodContext methodContext, Object object) throws ConvertException {
        User user = ContextHelper.getLoginUser();
        ContentProcessInfo contentProcessInfo = (ContentProcessInfo)object;
        Element element = DocumentHelper.createElement((String)"ProcessInfo");
        element.addAttribute("IsEnd", contentProcessInfo.isEnd() ? "true" : "false");
        element.addAttribute("StartUser", CMyString.showNull(contentProcessInfo.getStartUserName()));
        boolean bl = user.getName().equals(contentProcessInfo.getStartUserName());
        element.addAttribute("LoginUserIsStarter", bl ? "true" : "false");
        element.addAttribute("FlowId", String.valueOf(contentProcessInfo.getContentFlowId()));
        try {
            boolean bl2 = user.isAdministrator();
            boolean bl3 = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ONLY_ADMIN_CTR_FLOW", "false"));
            element.addAttribute("ReInFlow", String.valueOf(contentProcessInfo.canReInFlow() && (bl2 || user.equals(contentProcessInfo.getContent().getCrUser()))));
            element.addAttribute("InFlow", String.valueOf(contentProcessInfo.canInFlow() && (bl2 || user.equals(contentProcessInfo.getContent().getCrUser()))));
            element.addAttribute("StopFlow", String.valueOf(contentProcessInfo.canStopFlow() && (!bl3 && bl || bl2)));
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(ContentProcessInfoToXML.class, "ContentProcessInfoToXML.label1", "\u6784\u9020\u6d41\u7a0b\u64cd\u4f5c\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff01"), exception);
        }
        return element.asXML();
    }
}

