/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.support.log.LogServer;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class PublishTaskLogger
extends AbstractLogger {
    private static final Logger LOG = Logger.getLogger(PublishTaskLogger.class);

    public int startLog(MethodConfig methodConfig, MethodContext methodContext) {
        String string = ContextHelper.getLoginUser().getName();
        String string2 = this.getLogType(methodConfig, methodContext);
        if (string2 == null) {
            string2 = "UNKNOWN_OPERTYPE";
        }
        CMSObj cMSObj = null;
        try {
            IPublishElements iPublishElements = PublishElementFactory.lookupElements(methodContext.getValue("ObjectType", 0), methodContext.getObjectIds());
            if (iPublishElements == null || iPublishElements.isEmpty()) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(string2).append(", \u88ab\u53d1\u5e03\u7684\u5bf9\u8c61\u662f: ");
            int n = iPublishElements.size();
            for (int i = 0; i < n; ++i) {
                IPublishElement iPublishElement = iPublishElements.get(i);
                if (iPublishElement == null || iPublishElement.getSubstance() == null) continue;
                if (cMSObj == null) {
                    cMSObj = iPublishElement.getSubstance();
                }
                stringBuffer.append(iPublishElement.getSubstance());
                stringBuffer.append(", ");
            }
            if (cMSObj == null) {
                LOG.warn((Object)"No need to log a pubish operate: no object found.");
                return 0;
            }
            return (int)LogServer.startRecord(string, string2, stringBuffer.substring(0, stringBuffer.length() - 2), cMSObj);
        }
        catch (WCMException wCMException) {
            LOG.error((Object)"Failed to log a publish operate.", (Throwable)wCMException);
            return 0;
        }
    }

    protected String getLogType(MethodConfig methodConfig, MethodContext methodContext) {
        int n = methodContext.getValue("PublishType", 0);
        int n2 = methodContext.getValue("ObjectType", -1);
        String string = WCMTypes.getObjName(n2, true) + "\u7684" + PublishConstants.getPublishTypeName(n, "\u672a\u77e5\u53d1\u5e03\u7c7b\u578b");
        try {
            if (!LogServer.existsLogType(string)) {
                this.createLogTypeIfNeed(string, string);
            }
        }
        catch (Exception exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return string;
    }
}

