/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.ajaxservice.DocumentPublishHelper;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.trsserver.DatasFromTRSServer;
import com.trs.components.wcm.content.trsserver.DocsFromTRSServer;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.Reports;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ViewDocumentServiceProvider
implements ISelfDefinedServiceProvider,
IDeleteServiceProvider,
IQueryServiceProvider,
IFindByIdServiceProvider {
    private static Logger logger = Logger.getLogger(ViewDocumentServiceProvider.class);
    private DocumentMgr m_oDocumentMgr = null;
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;
    private static final String GET_CRUSER_SQL = "select CrUser from WCMDocument where DocId=?";
    private RelationMgr m_oRelationMgr = null;
    private AppendixMgr m_oAppendixMgr = null;
    private DocReplyMgr m_oDocReplyMgr = null;
    private ContentExtFieldMgr m_oExtFieldMgr = null;
    private IImageLibMgr m_oImageLibMgr = null;
    private static String sQueryLeafChannelMode = "QUERY_LEAF_CHANNEL_MODE";

    public ViewDocumentServiceProvider() {
        this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        this.m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
        this.m_oImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Status status = Status.findById(methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label1", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(user, methodContext.getObjectIds(), status.getRightIndex(), I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label2", "\u6539\u53d8\u6587\u6863\u72b6\u6001\u4e3a[") + status.getDisp() + "]");
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        boolean bl = methodContext.getValue("ExcludeTrashed", false);
        ContextParameters.set0(chnlDocs.size() > 1);
        try {
            int n = chnlDocs.size();
            for (int i = 0; i < n; ++i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || chnlDoc.getStatusId() == 1028) continue;
                if (bl && chnlDoc.getStatusId() < 0) {
                    throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label3", "[\u6587\u6863-") + chnlDoc.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label4", "]\u5c1a\u5728\u5e9f\u7a3f\u7bb1\u4e2d\uff0c\u60a8\u6682\u65f6\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01"));
                }
                this.m_oDocumentMgr.changeStatus(status.getId(), chnlDoc);
            }
        }
        finally {
            ContextParameters.get0();
        }
    }

    public Reports copy(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 1);
    }

    public Reports quote(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        String string2 = methodContext.getValue("isPhoto");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 2, string2);
    }

    public Reports mirror(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 3);
    }

    public Reports move(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("ToChannelId", 0));
        String string = methodContext.getValue("isPhoto");
        String string2 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string2 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
        }
        boolean bl = false;
        bl = channel.isCluster();
        String string3 = channel.getId() + ",Name=" + channel.getDispDesc();
        if (!bl && !this.hasRight(user, channel, 31)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label5", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u76ee\u6807\u680f\u76ee\u4e0b\u521b\u5efa{1}[ID={0}]!"), new String[]{string3, string2}), null);
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        ContextParameters.set0(chnlDocs.size() > 1);
        return this.move(user, chnlDocs, channel, string);
    }

    private ContentLinks getContentLinks(User user, Channel channel) throws Throwable {
        Object object;
        this.validateRight(user, channel, 13, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label6", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int n = 0;
        try {
            object = channel.getAttributeValue("ContentLinkType");
            n = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = new ContentLinks(user);
        if (n <= 0) {
            return object;
        }
        WCMFilter wCMFilter = new WCMFilter("", "ContentLinkType=?", "");
        wCMFilter.addSearchValues(0, n);
        ((BaseObjs)object).open(wCMFilter);
        return object;
    }

    public Reports replaceContentLink(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        this.validateRight(user, methodContext.getObjectIds(), 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        Reports reports = new Reports(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label8", "\u6587\u6863\u70ed\u8bcd\u66ff\u6362"));
        HashMap<Integer, Object[]> hashMap = new HashMap<Integer, Object[]>(1);
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object;
            Object[] objectArray;
            ChnlDoc chnlDoc;
            block11: {
                Channel channel;
                chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || (channel = chnlDoc.getChannel()) == null) continue;
                Integer n2 = new Integer(channel.getId());
                objectArray = (Object[])hashMap.get(n2);
                if (objectArray == null) {
                    try {
                        object = this.getContentLinks(user, channel);
                        if (((BaseObjs)object).size() == 0) {
                            reports.addSucessedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label9", "[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label10", "]\u4e0a\u6ca1\u6709\u70ed\u8bcd\uff0c\u4e0d\u9700\u8981\u66ff\u6362."));
                            hashMap.put(n2, new Object[1]);
                            continue;
                        }
                        objectArray = new Object[2];
                        string = "";
                        HashMap<String, ContentLink> hashMap2 = new HashMap<String, ContentLink>();
                        for (int j = 0; j < ((BaseObjs)object).size(); ++j) {
                            ContentLink contentLink = (ContentLink)((BaseObjs)object).getAt(i);
                            if (j != 0) {
                                string = string + '|';
                            }
                            string = string + contentLink.getName();
                            hashMap2.put(contentLink.getName().toUpperCase(), contentLink);
                        }
                        objectArray[0] = "(?im)(" + string + ')';
                        objectArray[1] = hashMap2;
                        hashMap.put(n2, objectArray);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        reports.addFailedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label11", "\u60a8\u5728[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label12", "]\u4e0a\u6ca1\u6709\u83b7\u53d6\u66ff\u6362\u70ed\u8bcd\u7684\u6743\u9650."), throwable);
                        hashMap.put(n2, new Object[0]);
                        continue;
                    }
                }
                if (objectArray.length == 0) {
                    reports.addFailedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label11", "\u60a8\u5728[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label12", "]\u4e0a\u6ca1\u6709\u83b7\u53d6\u66ff\u6362\u70ed\u8bcd\u7684\u6743\u9650."), null);
                    continue;
                }
                if (objectArray.length == 1) {
                    reports.addSucessedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label9", "[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label10", "]\u4e0a\u6ca1\u6709\u70ed\u8bcd\uff0c\u4e0d\u9700\u8981\u66ff\u6362."));
                    continue;
                }
            }
            object = chnlDoc.getDocument();
            if (object == null) continue;
            string = ((Document)object).getHtmlContent();
            string = this.doCLReplace(string, objectArray);
            ((Document)object).setHtmlContent(string);
            try {
                ((CMSObj)object).validCanEditAndLock(user);
                this.m_oDocumentMgr.save((Document)object);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label14", "\u6587\u6863[{0}]\u66ff\u6362\u70ed\u8bcd\u6210\u529f."), new String[]{((Document)object).getTitle()}));
                continue;
            }
            catch (WCMException wCMException) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label15", "\u6587\u6863[{0}]\u66ff\u6362\u70ed\u8bcd\u5931\u8d25."), new String[]{((Document)object).getTitle()}), wCMException);
            }
        }
        return reports;
    }

    private String doCLReplace(String string, Object[] objectArray) {
        System.out.println(objectArray[0]);
        Pattern pattern = Pattern.compile((String)objectArray[0]);
        Matcher matcher = pattern.matcher(string);
        String string2 = "";
        int n = 0;
        HashMap hashMap = (HashMap)objectArray[1];
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            string2 = string2 + string.substring(n, n2);
            String string3 = matcher.group(0);
            ContentLink contentLink = (ContentLink)hashMap.get(string3.toUpperCase());
            string2 = contentLink != null ? string2 + "<a name=\"AnchorAddByWCM\" href=\"" + contentLink.getLinkUrl() + "\" _href=\"" + contentLink.getLinkUrl() + "\" title=\"" + contentLink.getLinkTitle() + "\" target=\"_blank\">" + string3 + "</a>" : string2 + string3;
            n = n3;
        }
        string2 = string2 + string.substring(n);
        System.out.println(string2);
        return string;
    }

    public void delete(MethodContext methodContext) throws Throwable {
        ChnlDocs chnlDocs;
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("Drop", false);
        int n = methodContext.getValue("FlowDocId", 0);
        if (n <= 0) {
            this.validateRight(user, methodContext.getObjectIds(), 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
        }
        ContextParameters.set0((chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds())).size() > 1);
        int n2 = chnlDocs.size();
        for (int i = 0; i < n2; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (channel = chnlDoc.getChannel()) == null || (document = chnlDoc.getDocument()) == null) continue;
            if (n > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(user, document, n, 1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
            }
            this.m_oDocumentMgr.delete(document, channel, bl);
            if (document.getType() != 20 || !bl) continue;
            this.m_oImageLibMgr.deleteDocumentQuoteImage(document.getId());
        }
    }

    public String export(MethodContext methodContext) throws Throwable {
        String string;
        int n;
        Object object;
        WCMFilter wCMFilter;
        CMSBaseObjs cMSBaseObjs;
        User user = this.getLoginUser();
        String string2 = methodContext.getValue("ExportFields");
        boolean bl = methodContext.getValue("ExportExtFields", false);
        boolean bl2 = methodContext.getValue("ExportAppendix", false);
        boolean bl3 = methodContext.getValue("ExportAll", false);
        DBManager dBManager = DBManager.getDBManager();
        if (bl) {
            cMSBaseObjs = new ExtendedFields(user);
            wCMFilter = new WCMFilter("", "TableName=?", "EXTFIELDID asc", "EXTFIELDID,FIELDNAME");
            wCMFilter.addSearchValues(0, "WCMDOCUMENT");
            cMSBaseObjs.open(wCMFilter);
            StringBuffer stringBuffer = new StringBuffer(256);
            if (!CMyString.isEmpty(string2)) {
                stringBuffer.append(string2).append(",");
            }
            object = null;
            n = cMSBaseObjs.size();
            for (int i = 0; i < n; ++i) {
                object = (ExtendedField)cMSBaseObjs.getAt(i);
                if (object == null || dBManager.getFieldInfo("WCMDOCUMENT", ((ExtendedField)object).getName()) == null) continue;
                stringBuffer.append(((ExtendedField)object).getName());
                stringBuffer.append(",");
            }
            string2 = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        cMSBaseObjs = null;
        wCMFilter = new WCMFilter("", "", "", string2);
        int n2 = 34;
        if (bl3) {
            Object object2;
            object = this.makeCurrChannelOrSite(methodContext);
            this.validateRight(user, (BaseChannel)object, n2, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label16", "\u5bfc\u51fa\u6587\u6863"));
            string = methodContext.getValue("ChannelIds");
            if (string == null || string.length() <= 0) {
                cMSBaseObjs = this.m_oDocumentMgr.getDocuments((BaseChannel)object, wCMFilter);
            } else {
                ViewDocuments viewDocuments = null;
                viewDocuments = (ViewDocuments)this.query(methodContext);
                String string3 = "";
                for (int i = viewDocuments.size() - 1; i >= 0; --i) {
                    object2 = (ViewDocument)viewDocuments.getAt(i);
                    if (object2 == null) continue;
                    int n3 = ((BaseObj)object2).getId();
                    string3 = string3 == "" ? string3 + n3 : string3 + "," + n3;
                }
                cMSBaseObjs = Documents.findByIds(user, string3);
            }
            int[] nArray = new int[1];
            n = 0;
            String string4 = null;
            object2 = user.getName();
            RightValue rightValue = new RightValue();
            for (int i = ((Documents)cMSBaseObjs).size() - 1; i >= 0; --i) {
                n = cMSBaseObjs.getIdAt(i);
                if (!DocumentAuthServer.isDefineRightOnDocument(n)) continue;
                rightValue.load(user, 605, n, true);
                if (rightValue.isHasRight(n2)) continue;
                nArray[0] = n;
                string4 = dBManager.sqlExecuteStringQuery(GET_CRUSER_SQL, nArray);
                if (((String)object2).equals(string4)) continue;
                cMSBaseObjs.removeAt(i, false);
            }
        } else {
            object = methodContext.getObjectIds();
            if (CMyString.isEmpty((String)object)) {
                throw new WCMException(10, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label17", "\u6ca1\u6709\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6587\u6863"));
            }
            this.validateRight(user, (String)object, n2, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label16", "\u5bfc\u51fa\u6587\u6863"));
            cMSBaseObjs = this.findDocumentsByChnlDocIds(user, (String)object);
            cMSBaseObjs.setFilter(wCMFilter);
        }
        if (cMSBaseObjs.isEmpty()) {
            return "no-available-documents";
        }
        object = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        string = ((DocumentExporter)object).export((Documents)cMSBaseObjs, string2, bl2);
        methodContext.setContentTypeIsHTML();
        return string;
    }

    public Reports publish(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        int n = methodContext.getValue("PublishType", 8);
        String string = methodContext.getValue("isPhoto");
        String string2 = methodContext.getValue("isVideo");
        String string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label18", "\u53d1\u5e03");
        String string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String string5 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            string5 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        } else if (string2 != null && string2.trim().equals("true")) {
            string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label76", "\u89c6\u9891");
            string5 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label77", "\u89c6\u9891");
        }
        Reports reports = new Reports(string3 + string4);
        boolean bl = methodContext.getValue("withdrawall", false);
        int n2 = chnlDocs.size();
        for (int i = 0; i < n2; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (channel = chnlDoc.getChannel()) == null || (document = chnlDoc.getDocument()) == null) continue;
            try {
                boolean bl2 = this.publishDocument(user, channel, document, n, bl);
                if (bl2) {
                    reports.addSucessedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label20", "\u53d1\u5e03{1}[{0}]\u6210\u529f."), new String[]{document.getTitle(), string5}));
                    continue;
                }
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label21", "\u53d1\u5e03{1}[{0}]\u5931\u8d25\uff01\u53ef\u80fd\u662f\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\uff01"), new String[]{document.getTitle(), string5}), null);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label72", "\u53d1\u5e03{1}[{0}]\u5931\u8d25\uff01"), new String[]{document.getTitle(), string5}), (Throwable)exception);
                String string6 = exception.getMessage();
                int n3 = string6.indexOf("[ERR-");
                if (n3 >= 0 && (n3 = string6.indexOf(93, n3 + 1)) > 0) {
                    string6 = string6.substring(n3 + 1);
                }
                reports.addFailedReport(string6, null);
            }
        }
        return reports;
    }

    private boolean publishDocument(User user, Channel channel, Document document, int n, boolean bl) throws WCMException {
        if (!this.hasRight(user, channel, document, 39)) {
            return false;
        }
        if (n == 7) {
            Documents documents = new Documents(user, 1, 1);
            documents.addElement(document);
            DocumentPublishHelper.delete(documents, channel, bl);
            return true;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        iPublishContent.setFolder(iPublishFolder);
        this.m_oPublishServer.publishContent(iPublishContent, n);
        return true;
    }

    private Reports transmit(User user, ChnlDocs chnlDocs, Channels channels, int n) throws WCMException {
        return this.transmit(user, chnlDocs, channels, n, "false");
    }

    private Reports transmit(User user, ChnlDocs chnlDocs, Channels channels, int n, String string) throws WCMException {
        CMSObj cMSObj;
        int n2;
        String string2 = this.makeTransmitDesc(n);
        String string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        Reports reports = new Reports(string2 + string3);
        if (!user.isAdministrator()) {
            for (n2 = channels.size() - 1; n2 >= 0; --n2) {
                cMSObj = (Channel)channels.getAt(n2);
                if (cMSObj == null) {
                    reports.addFailedReport(string2 + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label24", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(n2) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                    channels.removeAt(n2, false);
                    continue;
                }
                if (((Channel)cMSObj).isCluster() || AuthServer.hasRight(user, cMSObj, 31)) continue;
                reports.addFailedReport(string2 + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label26", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa{0}["), new String[]{string4}) + cMSObj + "].", null);
                channels.removeAt(n2, false);
            }
        }
        for (n2 = chnlDocs.size() - 1; n2 >= 0; --n2) {
            cMSObj = (ChnlDoc)chnlDocs.getAt(n2);
            if (cMSObj == null) {
                reports.addFailedReport(string2 + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label27", "\u5931\u8d25:{0}[ID="), new String[]{string3}) + chnlDocs.getIdAt(n2) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            if (1 == n && ((ChnlDoc)cMSObj).isEntity() && cMSObj.getPropertyAsInt("dockind", 0) != 0) {
                reports.addFailedReport(string2 + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label78", "\u5931\u8d25:\u5143\u6570\u636e\u5b9e\u4f53\u6587\u6863\u4e0d\u652f\u6301\u5728\u7ad9\u70b9\u4e0b\u76f4\u63a5\u590d\u5236"), null);
                continue;
            }
            Channel channel = ((ChnlDoc)cMSObj).getChannel();
            if (channel == null) {
                reports.addFailedReport(string2 + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label28", "\u5931\u8d25:{0}\u7684\u680f\u76ee[Id="), new String[]{string3}) + ((ChnlDoc)cMSObj).getChannelId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document document = ((ChnlDoc)cMSObj).getDocument();
            if (document == null) {
                reports.addFailedReport(string2 + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label30", "\u5931\u8d25:{0}[Id="), new String[]{string3}) + ((ChnlDoc)cMSObj).getDocId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(user, channel, document, 34)) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label31", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8{0}[Id="), new String[]{string4}) + document.getId() + ",Title=" + document.getTitle() + "]!", null);
                continue;
            }
            int n3 = channels.size();
            for (int i = 0; i < n3; ++i) {
                Channel channel2 = (Channel)channels.getAt(i);
                if (channel2 == null) {
                    reports.addFailedReport(string2 + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label24", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(i) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(channel, document, channel2, n, reports, string);
            }
        }
        return reports;
    }

    private void transmit(Channel channel, Document document, Channel channel2, int n, Reports reports) {
        this.transmit(channel, document, channel2, n, reports, "false");
    }

    private void transmit(Channel channel, Document document, Channel channel2, int n, Reports reports, String string) {
        String string2 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string2 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        String string3 = this.makeTransmitDesc(n);
        if (channel2.isVirtual()) {
            string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label32", "\u5f15\u7528");
        }
        try {
            switch (n) {
                case 1: {
                    Document document2 = this.m_oDocumentMgr.copyDocument(document, channel, channel2);
                    if (document2 == null) {
                        reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label33", "{0}\u5728{1}\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), new Object[]{document, channel2}), null);
                        return;
                    }
                    if (document2.getId() != document.getId()) {
                        this.m_oAppendixMgr.copyAppendixes(document, document2);
                        this.m_oRelationMgr.copyRelations(document, document2);
                        this.m_oDocReplyMgr.copyDocReplys(document, document2);
                    }
                    reports.addSucessedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label35", "\u6210\u529f{0}[{1}]\u5230\u680f\u76ee[{2}][ID={3}]."), new String[]{string3, document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId())}));
                    break;
                }
                case 2: {
                    reports.addReport(this.m_oDocumentMgr.quoteTo(document, channel2, string));
                    break;
                }
                case 3: {
                    reports.addReport(this.m_oDocumentMgr.mirrorTo(document, channel2));
                }
            }
        }
        catch (Throwable throwable) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label73", "{0}{4}[{1}]\u5230\u680f\u76ee[{2}][ID={3}]\u5931\u8d25!"), new String[]{string3, document.getTitle(), channel2.getDispDesc(), String.valueOf(channel2.getId()), string2}), throwable);
        }
    }

    private String makeTransmitDesc(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label37", "\u590d\u5236");
                break;
            }
            case 2: {
                string = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label32", "\u5f15\u7528");
                break;
            }
            case 3: {
                string = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label38", "\u955c\u50cf");
            }
        }
        return string;
    }

    private Reports move(User user, ChnlDocs chnlDocs, Channel channel, String string) throws WCMException {
        String string2 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label39", "\u79fb\u52a8");
        String string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            string4 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        Reports reports = new Reports(string2 + string3);
        for (int i = chnlDocs.size() - 1; i >= 0; --i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label40", "\u79fb\u52a8\u5931\u8d25:{1}[ID={0}]\u6ca1\u6709\u627e\u5230!"), new String[]{String.valueOf(chnlDocs.getIdAt(i)), string4}), null);
                continue;
            }
            Channel channel2 = chnlDoc.getChannel();
            if (channel2 == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label41", "\u79fb\u52a8\u5931\u8d25:\u5f85\u79fb\u52a8\u7684{1}\u7684\u680f\u76ee[Id={0}]\u4e0d\u5b58\u5728!"), new String[]{String.valueOf(chnlDoc.getChannelId()), string4}), null);
                continue;
            }
            Document document = chnlDoc.getDocument();
            if (document == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label42", "\u79fb\u52a8\u5931\u8d25:\u5f85\u79fb\u52a8\u7684{1}[Id={0}]\u4e0d\u5b58\u5728!"), new String[]{String.valueOf(chnlDoc.getDocId()), string4}), null);
                continue;
            }
            String string5 = document.getId() + ", Title=" + document.getTitle();
            if (!this.hasRight(user, channel2, document, WCMRightTypes.DOC_MOVE)) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label43", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u79fb\u52a8{1}[Id={0}]!"), new String[]{string5, string4}), null);
                continue;
            }
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(document, channel2, channel, string));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label44", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25!"), new String[]{document.getTitle(), channel.getDispDesc(), String.valueOf(channel.getId()), string4}), throwable);
            }
        }
        return reports;
    }

    public Object query(MethodContext methodContext) throws Exception {
        Object object;
        User user = this.getLoginUser();
        CMSBaseObjs cMSBaseObjs = null;
        String string = methodContext.getValue("ChannelIds");
        String string2 = methodContext.getValue("SiteIds");
        int n = methodContext.getValue("SiteType", -1);
        String string3 = methodContext.getValue("ISSEARCH");
        boolean bl = false;
        int n2 = 30;
        if (string != null && string.length() > 0) {
            cMSBaseObjs = Channels.findByIds(user, string);
            bl = true;
        } else {
            cMSBaseObjs = string2 != null && string2.length() > 0 ? WebSites.findByIds(user, string2) : (n >= 0 ? WebSiteHelper.getWebSitesByType(user, n, null) : WebSiteHelper.getWebSitesByRightIndex(user, n2, new WCMFilter(), null, false));
        }
        Channels channels = null;
        boolean bl2 = user.isAdministrator();
        if (bl) {
            boolean bl3 = false;
            if (methodContext.containsParameter("ContainsChildren")) {
                bl3 = methodContext.getValue("ContainsChildren", false);
            } else if (cMSBaseObjs.size() == 1) {
                bl3 = ((Channel)cMSBaseObjs.getAt(0)).isContainsChildren();
            }
            channels = this.makeChannelsWithRightOfChannels(user, bl2, cMSBaseObjs, n2, bl3);
        } else {
            channels = this.makeChildChannelsWithRightOfSites(user, bl2, n2, cMSBaseObjs);
        }
        if (channels.isEmpty()) {
            return new ViewDocuments(user, 1, 1);
        }
        WCMFilter wCMFilter = this.getFilterFromList(methodContext, cMSBaseObjs);
        WCMFilter wCMFilter2 = this.getFilterForCopyOnly(methodContext);
        wCMFilter.mergeWith(wCMFilter2);
        boolean bl4 = methodContext.getValue("IsInStat", false);
        if (bl4) {
            object = "WCMChnlDoc.DocStatus > 0 and WCMChnlDoc.CHNLID>0 and WCMChnlDoc.DocStatus != 1028";
            WCMFilter wCMFilter3 = new WCMFilter("", (String)object, "");
            wCMFilter.mergeWith(wCMFilter3);
        }
        object = new ViewDocuments(user, 1, 1);
        boolean bl5 = string3 != null && string3.trim().equals("1");
        boolean bl6 = ConfigServer.getServer().getSysConfigValue("TRSSERVER_ENABLE", "false").trim().equals("true");
        if (bl6 && (!bl || bl5)) {
            String string4 = "";
            if (!bl) {
                string4 = this.getFilterWhere(cMSBaseObjs, "siteid");
            } else if (bl5) {
                string4 = this.getFilterWhere(cMSBaseObjs, "docchannel");
            }
            DocsFromTRSServer docsFromTRSServer = (DocsFromTRSServer)DreamFactory.createObjectById("DocsFromTRSServer");
            wCMFilter.setSelect(methodContext.getValue("DocumentSelectFields"));
            TRSToWCMFilter tRSToWCMFilter = docsFromTRSServer.toTRSFilter(wCMFilter);
            if (tRSToWCMFilter.getTRSWhere() != "") {
                tRSToWCMFilter.setTRSWhere("(" + tRSToWCMFilter.getTRSWhere() + ") and " + string4);
            } else {
                tRSToWCMFilter.setTRSWhere(string4);
            }
            object = (ViewDocuments)docsFromTRSServer.openViewDocs(User.getSystem(), tRSToWCMFilter, methodContext.getPageIndex(), methodContext.getPageSize());
            return object;
        }
        String string5 = methodContext.getValue("ChannelId");
        String string6 = "";
        if (!CMyString.isEmpty(string5)) {
            string6 = this.makeSelectFields(methodContext);
        }
        if (CMyString.isEmpty(string6)) {
            ((ViewDocuments)object).setSelectFields(methodContext.getValue("ChnlDocSelectFields"), methodContext.getValue("DocumentSelectFields"));
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String[] stringArray = string6.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().indexOf("WCMCHNLDOC.") > -1) {
                    arrayList.add(stringArray[i]);
                    continue;
                }
                if (stringArray[i].toUpperCase().indexOf("WCMDOCUMENT.") <= -1) continue;
                arrayList2.add(stringArray[i]);
            }
            String string7 = arrayList.toString();
            string7 = string7.substring(1, string7.length() - 1);
            String string8 = arrayList2.toString();
            string8 = string8.substring(1, string8.length() - 1);
            ((ViewDocuments)object).setSelectFields(string7, string8);
        }
        ((BaseObjs)object).setPageSize(methodContext.getPageSize());
        ((BaseObjs)object).setCurrPage(methodContext.getPageIndex());
        ((ViewDocuments)object).setRightIndex(64);
        ((ViewDocuments)object).setNeedWithAuthFilter(user, true);
        if (bl) {
            ((ViewDocuments)object).open(channels, wCMFilter);
        } else if (user.isAdministrator()) {
            ((ViewDocuments)object).open(cMSBaseObjs, wCMFilter);
        } else {
            ((ViewDocuments)object).open(channels, wCMFilter);
        }
        return object;
    }

    private WCMFilter getFilterForCopyOnly(MethodContext methodContext) {
        boolean bl = methodContext.getValue("OnlyForCopy", false);
        WCMFilter wCMFilter = new WCMFilter();
        if (bl) {
            int n = methodContext.getValue("DocModal", 0);
            if (n == 5) {
                wCMFilter.setWhere("WCMChnlDoc.Modal = 2 or WCMChnlDoc.Modal = 3");
            } else if (n == 4) {
                wCMFilter.setWhere("WCMChnlDoc.Modal = 1 and WCMChnlDoc.DocOutUpId > 0");
            } else if (n == 1) {
                wCMFilter.setWhere("WCMChnlDoc.Modal = 1 and WCMChnlDoc.DocOutUpId <= 0");
            }
        }
        return wCMFilter;
    }

    private String getFilterWhere(CMSBaseObjs cMSBaseObjs, String string) {
        String string2 = "";
        if (cMSBaseObjs.size() == 1) {
            string2 = string2 + string + " = " + cMSBaseObjs.getIdAt(0);
        } else {
            string2 = string2 + string + " =(" + cMSBaseObjs.getIdAt(0);
            int n = cMSBaseObjs.size();
            for (int i = 1; i < n; ++i) {
                string2 = string2 + "," + cMSBaseObjs.getIdAt(i);
            }
            string2 = string2 + ")";
        }
        string2 = string2 + " and docstatus > 0";
        return string2;
    }

    private String makeSelectFields(MethodContext methodContext) throws NumberFormatException, WCMException {
        String string = methodContext.getValue("ChannelId");
        String string2 = methodContext.getValue("SiteIds");
        if (!CMyString.isEmpty(string2)) {
            return "";
        }
        if (CMyString.isEmpty(string)) {
            return "";
        }
        Channel channel = Channel.findById(Integer.parseInt(string));
        String string3 = channel.getPropertyAsString("SHOWFIELDS");
        if (CMyString.isEmpty(string3)) {
            return "";
        }
        String string4 = "WCMDocument.CRUSER,WCMDocument.CRTIME,WCMDocument.DOCTYPE,WCMDocument.DOCTITLE,WCMDocument.DOCID,WCMCHNLDOC.DOCCHANNEL,WCMDocument.ATTACHPIC,WCMDocument.DOCLINKTO,WCMDocument.DOCMIRRORTO,WCMCHNLDOC.CHNLID,WCMCHNLDOC.DOCORDERPRI,WCMCHNLDOC.MODAL,WCMCHNLDOC.INVALIDTIME,WCMCHNLDOC.DOCKIND,WCMChnlDoc.DocStatus,WCMCHNLDOC.RECID,WCMCHNLDOC.DOCID,WCMDocument.FLOWOPERATIONMARK";
        string3 = string3 + "," + string4;
        return string3;
    }

    private WCMFilter getFilterFromList(MethodContext methodContext, BaseObjs baseObjs) throws Exception {
        Object object;
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        if (ConfigServer.getServer().getSysConfigValue("EXTFIELD_QUERY", "false").toLowerCase().trim().equals("true")) {
            String string;
            WCMFilter wCMFilter2 = new WCMFilter("", "TABLENAME = 'WCMDOCUMENT' AND FIELDTYPE != 'DATETIME'", "", "EXTFIELDID");
            object = ExtendedFields.openWCMObjs(user, wCMFilter2);
            ExtendedField extendedField = null;
            wCMFilter2 = new WCMFilter();
            String string2 = null;
            String string3 = string = methodContext.getValue("IsOr", false) ? " or " : " and ";
            if (((BaseObjs)object).size() > 0) {
                Object object2;
                CharSequence charSequence;
                for (int i = 0; i < ((BaseObjs)object).size(); ++i) {
                    extendedField = (ExtendedField)((BaseObjs)object).getAt(i);
                    if (extendedField == null) continue;
                    charSequence = extendedField.getName();
                    object2 = methodContext.getValue((String)charSequence);
                    if (!methodContext.containsParameter((String)charSequence) || object2.trim().equals("")) continue;
                    if (extendedField.getTypeName().equalsIgnoreCase("string")) {
                        object2 = '%' + (String)object2 + '%';
                    }
                    wCMFilter2.addSearchValues((String)object2);
                    string2 = string2 != null ? string2 + string : "";
                    string2 = string2 + this.extFilter(extendedField, methodContext);
                }
                String string4 = " " + string + " ";
                charSequence = new StringBuffer();
                object2 = new String[]{wCMFilter.getWhere(), string2};
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    if (CMyString.isEmpty(object2[i])) continue;
                    ((StringBuffer)charSequence).append(object2[i]).append(string4);
                }
                if (((StringBuffer)charSequence).length() > 1) {
                    ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - string4.length());
                }
                wCMFilter.setWhere(((StringBuffer)charSequence).toString());
                if (wCMFilter2.getSearchValues() != null && wCMFilter.getSearchValues() != null) {
                    wCMFilter.getSearchValues().addAll(wCMFilter2.getSearchValues());
                } else if (wCMFilter2.getSearchValues() != null) {
                    wCMFilter.setSearchValues(wCMFilter2.getSearchValues());
                }
            }
        }
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        int n = methodContext.getValue("FilterType", 0);
        wCMFilter.mergeWith(this.makeFilterByType(user, baseObjs, n));
        object = methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty((String)object)) {
            if (wCMFilter.getWhere().length() > 0) {
                boolean bl = methodContext.getValue("IsOr", true);
                wCMFilter.setWhere(wCMFilter.getWhere() + (bl ? " or " : " and ") + "(" + (String)object + ")");
            } else {
                wCMFilter.setWhere("(" + (String)object + ")");
            }
        }
        return wCMFilter;
    }

    private String extFilter(ExtendedField extendedField, MethodContext methodContext) {
        String string = extendedField.getTypeName();
        String string2 = " ( WCMDocument." + extendedField.getName();
        string2 = string.equalsIgnoreCase("string") ? string2 + " like ? ) " : string2 + " = ? ) ";
        return string2;
    }

    private Channels makeChannelsWithRightOfChannels(User user, boolean bl, CMSBaseObjs cMSBaseObjs, int n, boolean bl2) throws WCMException {
        Channels channels = (Channels)cMSBaseObjs;
        for (int i = channels.size() - 1; i >= 0; --i) {
            boolean bl3;
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            boolean bl4 = bl3 = bl || user.getName().equals(channel.getCrUserName());
            if (bl3) {
                if (!bl2) continue;
                this.makeChildren(user, bl, n, channels, channel);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)channel, user);
            if (!rightValue.isHasRight(n)) {
                channels.removeAt(i, false);
            }
            if (rightValue.getValue() <= 0L || !bl2) continue;
            this.makeChildren(user, bl, n, channels, channel);
        }
        return channels;
    }

    private Channels makeChildChannelsWithRightOfSites(User user, boolean bl, int n, CMSBaseObjs cMSBaseObjs) throws WCMException {
        Object object = new Channels(null, 200, 1);
        int n2 = cMSBaseObjs.size();
        for (int i = 0; i < n2; ++i) {
            Object object2;
            WebSite webSite = (WebSite)cMSBaseObjs.getAt(i);
            if (webSite == null) continue;
            WCMFilter wCMFilter = null;
            String string = ConfigServer.getServer().getSysConfigValue(sQueryLeafChannelMode, "false");
            if (string.equalsIgnoreCase("true") || string.equals("1")) {
                object2 = "SiteId=? and not exists(select 1 from WCMChannel b where b.SiteId=? and b.ParentId = a.ChannelId)";
                wCMFilter = new WCMFilter("WCMChannel a", (String)object2, "");
                wCMFilter.addSearchValues(webSite.getId());
                wCMFilter.addSearchValues(webSite.getId());
            } else {
                object2 = "SiteId = ?";
                wCMFilter = new WCMFilter("", (String)object2, "");
                wCMFilter.addSearchValues(webSite.getId());
            }
            object2 = Channels.openWCMObjs(null, wCMFilter);
            if (bl || user.getName().equals(webSite.getCrUserName())) {
                if (i == 0) {
                    object = object2;
                    continue;
                }
                ((BaseObjs)object).addWith((BaseObjs)object2);
                continue;
            }
            int n3 = ((BaseObjs)object2).size();
            for (int j = 0; j < n3; ++j) {
                Channel channel = (Channel)((BaseObjs)object2).getAt(j);
                if (channel == null || !AuthServer.hasRight(user, (CMSObj)channel, n) || channel.getStatus() < 0) continue;
                ((BaseObjs)object).addElement(channel);
            }
        }
        return object;
    }

    public Relations queryRelations(MethodContext methodContext) throws Throwable {
        Cloneable cloneable;
        User user = this.getLoginUser();
        Document document = null;
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("ChnlDocId", 0);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0) {
            cloneable = ChnlDoc.findById(n2);
            document = Document.findById(cloneable.getDocId());
            if (n3 == 0 && !DocumentAuthServer.hasRight(user, cloneable, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{user.toString(), n + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863")}));
            }
        } else if (n > 0) {
            document = Document.findById(n);
            cloneable = document.getChannel();
            if (n3 == 0 && !DocumentAuthServer.hasRight(user, (BaseChannel)cloneable, document, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{user.toString(), n + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863")}));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (n3 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863"));
        }
        cloneable = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oRelationMgr.getRelations(document, (WCMFilter)cloneable);
    }

    public Appendixes queryAppendixes(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        User user = this.getLoginUser();
        Document document = null;
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("ChnlDocId", 0);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0) {
            cMSObj = ChnlDoc.findById(n2);
            document = Document.findById(cMSObj.getDocId());
            if (n3 == 0 && !DocumentAuthServer.hasRight(user, cMSObj, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{user.toString(), n + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f")}));
            }
        } else if (n > 0) {
            document = Document.findById(n);
            cMSObj = document.getChannel();
            if (n3 == 0 && !DocumentAuthServer.hasRight(user, (BaseChannel)cMSObj, document, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{user.toString(), n + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f")}));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (n3 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f"));
        }
        int n4 = methodContext.getValue("AppendixType", 50);
        n4 = methodContext.getValue("FilterType", n4);
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(document, n4, wCMFilter);
    }

    public ContentExtendValues queryExtendFields(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        User user = this.getLoginUser();
        Document document = null;
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("ChnlDocId", 0);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0) {
            if (n3 == 0) {
                this.validateRight(user, String.valueOf(n2), 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
            }
            cMSObj = ChnlDoc.findById(n2);
            document = Document.findById(cMSObj.getDocId());
        } else if (n > 0) {
            document = Document.findById(n);
            cMSObj = document.getChannel();
            if (n3 == 0) {
                this.validateRight(user, (BaseChannel)cMSObj, 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (n3 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        }
        if ((cMSObj = document.getChannel()) == null) {
            return new ContentExtendValues(user);
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        ContentExtFields contentExtFields = this.m_oExtFieldMgr.getExtFields(cMSObj, wCMFilter, false);
        ContentExtendValues contentExtendValues = new ContentExtendValues(user, contentExtFields.size(), 1);
        int n4 = contentExtFields.size();
        for (int i = 0; i < n4; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            String string = document.getPropertyAsString(contentExtField.getName());
            String string2 = CMyString.filterForHTMLValue(contentExtField.getAttributeValue("FIELDTYPE"));
            String[] stringArray = null;
            if (string != null && string2 != null && "678".indexOf(string2) != -1) {
                String string3 = CMyString.filterForHTMLValue(contentExtField.getAttributeValue("ENMVALUE"));
                if (CMyString.isEmpty(string3)) continue;
                stringArray = string3.split("~");
                if (!CMyString.isEmpty(string)) {
                    String[] stringArray2 = string.split(",");
                    boolean bl = true;
                    int n5 = stringArray.length;
                    for (int j = 0; j < n5; ++j) {
                        String[] stringArray3 = this.pairSplit(stringArray[j]);
                        for (int k = 0; k < stringArray2.length; ++k) {
                            if (!stringArray2[k].trim().equalsIgnoreCase(stringArray3[1])) continue;
                            string = bl ? stringArray3[0] : string + "," + stringArray3[0];
                            bl = false;
                        }
                    }
                }
            }
            string = string + "~" + string2;
            contentExtendValues.addElement(i + 1, contentExtField.getDesc(), contentExtField.getName(), string);
        }
        return contentExtendValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] pairSplit(String string) {
        String[] stringArray = new String[]{"", ""};
        if (string.indexOf("`") != -1) {
            String[] stringArray2 = string.split("`");
            if (stringArray2.length == 2) {
                stringArray[0] = stringArray2[0];
                stringArray[1] = stringArray2[1];
                return stringArray;
            } else {
                if (stringArray2.length != 1) return stringArray;
                stringArray[0] = stringArray[1] = stringArray2[0];
            }
            return stringArray;
        } else {
            stringArray[0] = string;
            stringArray[1] = string;
        }
        return stringArray;
    }

    public ViewDocuments queryRecycle(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        CMSBaseObjs cMSBaseObjs = null;
        String string = methodContext.getValue("ChannelIds");
        String string2 = methodContext.getValue("SiteIds");
        boolean bl = false;
        if (string != null && string.length() > 0) {
            cMSBaseObjs = Channels.findByIds(user, string);
            bl = true;
        } else if (string2 != null && string2.length() > 0) {
            cMSBaseObjs = WebSites.findByIds(user, string2);
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label45", "\u6ca1\u6709\u6307\u5b9a\u68c0\u7d22\u7684\u680f\u76ee[ChannelIds]\u6216\u8005\u68c0\u7d22\u7684\u7ad9\u70b9[SiteIds]\uff01"));
        }
        Channels channels = null;
        boolean bl2 = user.isAdministrator();
        int n = 30;
        if (bl) {
            boolean bl3 = methodContext.getValue("ContainsChildren", false);
            channels = this.makeChannelsWithRightOfChannels(user, bl2, cMSBaseObjs, n, bl3);
        } else {
            channels = this.makeChildChannelsWithRightOfSites(user, bl2, n, cMSBaseObjs);
        }
        if (channels.isEmpty()) {
            return new ViewDocuments(user, 1, 1);
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        int n2 = methodContext.getValue("FilterType", 0);
        wCMFilter.mergeWith(this.makeFilterByType(user, cMSBaseObjs, n2));
        ViewDocuments viewDocuments = new ViewDocuments(user, 1, 1);
        viewDocuments.setSelectFields(methodContext.getValue("ChnlDocSelectFields"), methodContext.getValue("DocumentSelectFields"));
        viewDocuments.setFromRecycle(true);
        viewDocuments.setPageSize(methodContext.getPageSize());
        viewDocuments.setCurrPage(methodContext.getPageIndex());
        viewDocuments.setRightIndex(bl ? 33 : -1);
        if (bl) {
            viewDocuments.open(channels, wCMFilter);
        } else if (user.isAdministrator()) {
            viewDocuments.open(cMSBaseObjs, wCMFilter);
        } else {
            viewDocuments.open(channels, wCMFilter);
        }
        CPager cPager = new CPager();
        cPager.setItemCount(viewDocuments.size());
        cPager.setPageSize(methodContext.getPageSize());
        cPager.setCurrentPageIndex(methodContext.getPageIndex());
        for (int i = cPager.getLastItemIndex() - 1; i >= cPager.getFirstItemIndex() - 1; --i) {
            ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
            if (viewDocument == null) continue;
            if (!viewDocument.hasRight(user, 18) && viewDocument.hasRight(user, 31) && !viewDocument.getCrUser().equals(user)) {
                viewDocuments.removeAt(i, false);
            }
            if (bl || viewDocument.hasRight(user, 33)) continue;
            viewDocuments.removeAt(i, false);
        }
        return viewDocuments;
    }

    public String preview(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("isPhoto");
        String string2 = methodContext.getValue("isVideo");
        String string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (string != null && string.trim().equals("true")) {
            string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        } else if (string2 != null && string2.trim().equals("true")) {
            string3 = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label77", "\u89c6\u9891");
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        String[] stringArray = new String[1];
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        int n = 0;
        Object[] objectArray = new Object[chnlDocs.size()];
        HashMap<String, Object> hashMap2 = null;
        ChnlDoc chnlDoc = null;
        Document document = null;
        Channel channel = null;
        int n2 = chnlDocs.size();
        for (int i = 0; i < n2; ++i) {
            document = null;
            hashMap2 = new HashMap<String, Object>(2);
            chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc != null) {
                document = chnlDoc.getDocument();
                channel = chnlDoc.getChannel();
            }
            if (document == null) {
                hashMap2.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label50", "\u76f8\u5173\u6587\u6863[DocId=") + chnlDoc.getDocId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"));
                hashMap2.put("URLs", new String[0]);
            } else {
                hashMap2.put("Name", document.getTitle());
                if (channel == null) {
                    hashMap2.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label51", "\u76f8\u5173\u680f\u76ee[ChannelId=") + chnlDoc.getChannelId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"));
                    hashMap2.put("URLs", new String[0]);
                } else if (!DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, 38)) {
                    hashMap2.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label52", "\u6ca1\u6709\u6743\u9650\u9884\u89c8\u6587\u6863"));
                    hashMap2.put("URLs", new String[0]);
                } else {
                    String[] stringArray2;
                    IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
                    IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, iPublishFolder);
                    try {
                        stringArray2 = new String[]{this.m_oPublishServer.previewContent(iPublishContent, stringArray)};
                        if (stringArray[0] != null) {
                            hashMap2.put("Warning", stringArray[0]);
                        }
                    }
                    catch (Exception exception) {
                        stringArray2 = new String[]{};
                        int n3 = exception.getMessage().indexOf(10);
                        String string4 = exception.getMessage();
                        if (n3 > 0) {
                            string4 = string4.substring(0, n3);
                        }
                        hashMap2.put("Exception", string4);
                        hashMap2.put("ExceptionDetail", CMyException.getStackTraceText(exception));
                    }
                    n += stringArray2.length;
                    hashMap2.put("URLs", stringArray2);
                }
            }
            objectArray[i] = hashMap2;
        }
        hashMap.put("Title", string3);
        hashMap.put("URLCount", String.valueOf(n));
        hashMap.put("Data", objectArray);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private boolean hasRight(User user, Channel channel, Document document, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, n);
    }

    private boolean hasRight(User user, Channel channel, int n) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(user, (CMSObj)channel, n);
    }

    private Channels findChannelsByChnlDocIds(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", "RecId in(" + string + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs(user, wCMFilter);
    }

    private Documents findDocumentsByChnlDocIds(User user, String string) throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = "select DOCID from WCMCHNLDOC where RECID=?";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            int[] nArray = CMyString.splitToInt(string, ",");
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                preparedStatement.setInt(1, nArray[i]);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    stringBuffer.append(',').append(resultSet.getInt(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, "", sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
        if (stringBuffer.length() > 1) {
            return Documents.findByIds(user, stringBuffer.substring(1));
        }
        return new Documents(user);
    }

    private void validateRight(User user, String string, int n, String string2) throws WCMException {
        if (ViewDocuments.QUERY_ACCORD_DOCUMENT_RIGHT) {
            ViewDocuments viewDocuments = WCMDocumentHelper.findViewDocumentsByIds(user, string);
            int n2 = viewDocuments.size();
            for (int i = 0; i < n2; ++i) {
                ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
                if (viewDocument == null) continue;
                String string3 = "DocId=" + viewDocument.getDocId();
                if (viewDocument.hasRight(user, n)) continue;
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{user.toString(), string3, string2}));
            }
        } else {
            if (user.isAdministrator()) {
                return;
            }
            Channels channels = this.findChannelsByChnlDocIds(user, string);
            int n3 = channels.size();
            for (int i = 0; i < n3; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                this.validateRight(user, channel, n, string2);
            }
        }
    }

    private void validateRight(User user, BaseChannel baseChannel, int n, String string) throws WCMException {
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label56", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label57", "]\u6ca1\u6709\u6743\u9650\u5728(") + baseChannel + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label58", ")\u4e0a\u6267\u884c[") + string + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label59", "]\u64cd\u4f5c\uff01"));
        }
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label61", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void makeChildren(User user, boolean bl, int n, Channels channels, Channel channel) throws WCMException {
        List list = channel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel2 = (Channel)list.get(i);
            if (channel2 == null) continue;
            if (bl || user.getName().equalsIgnoreCase(channel2.getCrUserName())) {
                channels.addElement(channel2);
                this.makeChildren(user, bl, n, channels, channel2);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)channel2, user);
            if (rightValue.isHasRight(n)) {
                channels.addElement(channel2);
            }
            if (rightValue.getValue() <= 0L) continue;
            this.makeChildren(user, bl, n, channels, channel2);
        }
    }

    private WCMFilter makeTimeFilterByType(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", string + ">=?", "");
        try {
            switch (n) {
                case 5: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label62", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), exception);
        }
        return wCMFilter;
    }

    private WCMFilter makeFilterByType(User user, BaseObjs baseObjs, int n) throws Exception {
        if (n == 0) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter();
        String string = null;
        switch (n) {
            case 1: {
                string = "WCMChnlDoc.DocStatus=?";
                wCMFilter.addSearchValues(0, 1);
                break;
            }
            case 3: {
                string = "WCMChnlDoc.DocStatus=?";
                wCMFilter.addSearchValues(0, 10);
                break;
            }
            case 8: {
                string = "WCMChnlDoc.DocStatus=?";
                wCMFilter.addSearchValues(0, 15);
                break;
            }
            case 9: {
                string = "WCMChnlDoc.DocStatus=?";
                wCMFilter.addSearchValues(0, 2);
                break;
            }
            case 2: {
                if (baseObjs.size() > 1) {
                    string = "WCMChnlDoc.DocStatus in(1,2,16,18)";
                    break;
                }
                WebSite webSite = ((BaseChannel)baseObjs.getAt(0)).getSite();
                IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(webSite.getWCMType(), webSite.getId());
                if (nArray == null || nArray.length == 0) {
                    nArray = new int[]{-1};
                }
                for (int i = 0; i < nArray.length; ++i) {
                    string = string == null ? "WCMChnlDoc.DocStatus in(?" : string + ",?";
                    wCMFilter.addSearchValues(i, nArray[i]);
                }
                if (string == null) break;
                string = string + ")";
                break;
            }
            case 4: {
                string = "WCMChnlDoc.CrUser=?";
                wCMFilter.addSearchValues(0, user.getName());
                break;
            }
            case 5: {
                string = "WCMChnlDoc.CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                break;
            }
            case 6: {
                string = "WCMChnlDoc.CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                break;
            }
            case 7: {
                string = "WCMChnlDoc.CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                break;
            }
        }
        wCMFilter.setWhere(string);
        return wCMFilter;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        ViewDocument viewDocument = ViewDocument.findById(baseChannel, methodContext.getObjectId(), methodContext.getValue("SelectFieldsOfChnlDoc"), methodContext.getValue("SelectFieldsOfDocument"));
        if (viewDocument == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(methodContext.getObjectId()), WCMTypes.getLowerObjName(605)}));
        }
        int n = methodContext.getValue("FlowDocId", 0);
        if (n > 0 && methodContext.getObjectId() > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, Document.findById(viewDocument.getDocId()), n, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label63", "\u67e5\u770b"));
        } else if (!viewDocument.hasRight(user, 34)) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label56", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label57", "]\u6ca1\u6709\u6743\u9650\u5728(") + baseChannel + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label64", ")\u4e0a\u6267\u884c[\u6d4f\u89c8\u6587\u6863]\u64cd\u4f5c\uff01[RecId=") + viewDocument.getId() + "]");
        }
        return viewDocument;
    }

    public void restore(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ChnlDocs chnlDocs = null;
        BaseChannel baseChannel = null;
        boolean bl = methodContext.getValue("RestoreAll", false);
        if (bl) {
            baseChannel = this.makeCurrChannelOrSite(methodContext);
            this.validateRight(user, baseChannel, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label65", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        } else {
            String string = methodContext.getObjectIds();
            this.validateRight(user, string, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label65", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
            chnlDocs = ChnlDocs.findByIds(user, string);
        }
        if (bl) {
            this.m_oDocumentMgr.restoreAll(user, baseChannel);
        } else {
            int n = chnlDocs.size();
            for (int i = 0; i < n; ++i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || !chnlDoc.isDeleted()) continue;
                this.m_oDocumentMgr.restore(chnlDoc);
            }
        }
    }

    public void clearRecycle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        this.validateRight(user, baseChannel, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label66", "\u6e05\u7a7a\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        this.m_oDocumentMgr.clearAll(user, baseChannel);
    }

    private BaseChannel makeCurrChannelOrSite(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("SiteID", 0);
        int n2 = methodContext.getValue("ChannelId", 0);
        if (n <= 0 && n2 <= 0) {
            return null;
        }
        if (n > 0 && n2 > 0) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label67", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u540c\u65f6\u6307\u5b9a\u4e86\u7ad9\u70b9ID[") + n + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label68", "]\u548c\u680f\u76eeID[") + n2 + "]!");
        }
        BaseChannel baseChannel = null;
        if (n > 0) {
            baseChannel = WebSite.findById(n);
        }
        if (n2 > 0) {
            baseChannel = Channel.findById(n2);
            methodContext.putContextCacheData("CurrChannel", baseChannel);
        }
        if (baseChannel == null) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label69", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + n + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label70", "]\u6216\u680f\u76ee[ID=") + n2 + "]!");
        }
        return baseChannel;
    }

    public String getDocumentRefrences(MethodContext methodContext) throws Exception {
        String string = "";
        String string2 = methodContext.getValue("ChannelIds");
        String string3 = methodContext.getValue("SiteIds");
        String string4 = methodContext.getValue("operation");
        boolean bl = false;
        if (!CMyString.isEmpty(string4) && (string4.equalsIgnoreCase("_forcedelete") || string4.equalsIgnoreCase("_delete"))) {
            bl = true;
        }
        if (!CMyString.isEmpty(string2) || !CMyString.isEmpty(string3)) {
            ViewDocuments viewDocuments = this.queryRecycle(methodContext);
            if (viewDocuments == null || viewDocuments.size() == 0) {
                return null;
            }
            string = viewDocuments.getIdListAsString(',');
        } else {
            string = methodContext.getObjectIds();
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(this.getReferencesByChnlDocIds(string, bl), 0);
    }

    private HashMap getReferencesByChnlDocIds(String string, boolean bl) throws WCMException {
        User user = this.getLoginUser();
        this.validateRight(user, string, 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label71", "\u6d4f\u89c8"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, string);
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>(1);
        Object[] objectArray = new Object[chnlDocs.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            CMSObj cMSObj;
            Object object;
            Channel channel;
            Document document;
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (document = chnlDoc.getDocument()) == null || (channel = document.getChannel()) == null) continue;
            Channels channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, null, true);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(9);
            if (channels != null && !channels.isEmpty()) {
                object = new String[channels.size()];
                for (int j = 0; j < channels.size(); ++j) {
                    cMSObj = (Channel)channels.getAt(j);
                    if (cMSObj == null) continue;
                    object[j] = CMyString.filterForHTMLValue(((Channel)cMSObj).getDesc());
                }
                hashMap2.put("refchannels", object);
            }
            hashMap2.put("docid", String.valueOf(document.getId()));
            hashMap2.put("doctitle", document.getTitle());
            hashMap2.put("docchnlid", chnlDoc.getPropertyAsString("DOCCHANNEL"));
            hashMap2.put("channelid", chnlDoc.getPropertyAsString("CHNLID"));
            hashMap2.put("channel", CMyString.filterForHTMLValue(channel.getDesc()));
            hashMap2.put("modal", String.valueOf(chnlDoc.getModal()));
            object = new WCMFilter("", "", "");
            if (bl && chnlDoc.getModal() == 1) {
                Document document2;
                String[] stringArray;
                ((WCMFilter)object).setWhere("RelatePhotoIds=?");
                ((WCMFilter)object).addSearchValues(0, String.valueOf(document.getId()));
                Appendixes appendixes = Appendixes.openWCMObjs(user, (WCMFilter)object);
                cMSObj = null;
                if (appendixes != null && !appendixes.isEmpty()) {
                    stringArray = new String[appendixes.size()];
                    for (int j = 0; j < appendixes.size(); ++j) {
                        cMSObj = (Appendix)appendixes.getAt(j);
                        if (cMSObj == null) continue;
                        document2 = Document.findById(((Appendix)cMSObj).getDocId());
                        stringArray[j] = CMyString.filterForHTMLValue(document2.getTitle());
                    }
                    hashMap2.put("refdocappendixs", stringArray);
                }
                stringArray = (String[])DreamFactory.createObjectById("IImageLibMgr");
                Documents documents = stringArray.getDocumentsQuoteImage(document.getId());
                document2 = null;
                if (documents != null && !documents.isEmpty()) {
                    String[] stringArray2 = new String[documents.size()];
                    for (int j = 0; j < documents.size(); ++j) {
                        document2 = (Document)documents.getAt(j);
                        if (document2 == null) continue;
                        stringArray2[j] = CMyString.filterForHTMLValue(document2.getTitle());
                    }
                    hashMap2.put("refdoccontents", stringArray2);
                }
            }
            objectArray[i] = hashMap2;
        }
        hashMap.put("docinfo", objectArray);
        return hashMap;
    }

    public int findChnlDocId(MethodContext methodContext) throws Throwable {
        int n;
        int n2 = methodContext.getValue("ChnlDocId", 0);
        if (n2 != 0) {
            return n2;
        }
        int n3 = methodContext.getValue("docId", 0);
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(n3, n = methodContext.getValue("channelId", 0));
        return chnlDoc != null ? chnlDoc.getId() : 0;
    }

    public Reports moveAll(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("FromChannelId", 0);
        Channel channel = this.findChannelById(n);
        Channel channel2 = this.findChannelById(methodContext.getValue("ToChannelId", 0));
        if (channel2.getStatus() < 0) {
            return null;
        }
        this.validateRight(user, channel, 56, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label37", "\u79fb\u52a8"));
        this.validateRight(user, channel2, 31, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label38", "\u6dfb\u52a0"));
        Channels channels = Channels.findByIds(user, n + "");
        WCMFilter wCMFilter = this.getFilterFromList(methodContext, channels);
        if (!CMyString.isEmpty(wCMFilter.getWhere())) {
            if (wCMFilter.getWhere().length() > 0) {
                wCMFilter.setWhere(wCMFilter.getWhere() + " and " + "( chnlId=" + n + ")");
            } else {
                wCMFilter.setWhere("( chnlId=" + n + ")");
            }
        }
        ViewDocuments viewDocuments = new ViewDocuments(user, 1, 1);
        if (methodContext.getPageSize() > 0) {
            viewDocuments.setPageSize(methodContext.getPageSize());
        } else {
            viewDocuments.setPageSize(-1);
        }
        viewDocuments.open(channel, wCMFilter);
        ContextParameters.set0(true);
        return this.m_oDocumentMgr.moveDocumentsToChannel(viewDocuments, channel, channel2);
    }

    public String cloneFile(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("Sourfile");
        return FilesMan.getFilesMan().copyWCMFile(string, string.substring(0, 2));
    }

    public String uploadImg(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("Sourfile");
        try {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = CMyFile.extractFileExt(string);
            String string3 = filesMan.getNextFilePathName("W0", string2);
            CMy3WLib.getFile(string, string3);
            return filesMan.copyFile(string3, "W0", false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object trsQuery(MethodContext methodContext) throws Exception {
        DatasFromTRSServer datasFromTRSServer = new DatasFromTRSServer();
        String string = methodContext.getValue("docTitle");
        if (string != null && !string.trim().equals("")) {
            datasFromTRSServer.setWhere("IR_URLTITLE = %" + string + "%");
        }
        return datasFromTRSServer.getDatasFromTRSServer(methodContext.getPageIndex(), methodContext.getPageSize());
    }

    public void saveTRSConfig(MethodContext methodContext) throws Exception {
        ConfigServer configServer = ConfigServer.getServer();
        configServer.updateConfigValue("TRSSERVER_HOST", methodContext.getValue("host"));
        configServer.updateConfigValue("TRSSERVER_PORT", methodContext.getValue("port"));
        configServer.updateConfigValue("TRSSERVER_USER", methodContext.getValue("user"));
        configServer.updateConfigValue("TRSSERVER_PWD", methodContext.getValue("pwd"));
        configServer.updateConfigValue("TRSSERVER_DB", methodContext.getValue("db"));
    }

    public Object queryForGroup(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("GroupId", 0);
        Group group = Group.findById(n);
        if (group == null) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label80", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u90e8\u95e8[GroupId=") + n);
        }
        ViewDocuments viewDocuments = new ViewDocuments(user, 1, 1);
        String string = methodContext.getValue("ChannelIds");
        String string2 = methodContext.getValue("SiteIds");
        int n2 = methodContext.getValue("SiteType", -1);
        CMSBaseObjs cMSBaseObjs = null;
        int n3 = 30;
        boolean bl = false;
        if (string != null && string.length() > 0) {
            cMSBaseObjs = Channels.findByIds(user, string);
            bl = true;
        } else {
            cMSBaseObjs = string2 != null && string2.length() > 0 ? WebSites.findByIds(user, string2) : (n2 >= 0 ? WebSiteHelper.getWebSitesByType(user, n2, null) : WebSiteHelper.getWebSitesByRightIndex(user, n3, new WCMFilter(), null, false));
        }
        Channels channels = null;
        boolean bl2 = user.isAdministrator();
        channels = bl ? this.makeChannelsWithRightOfChannels(user, bl2, cMSBaseObjs, n3, true) : this.makeChildChannelsWithRightOfSites(user, bl2, n3, cMSBaseObjs);
        if (channels.isEmpty()) {
            return viewDocuments;
        }
        Users users = this.getAllUsers(group, user);
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string3 = "WCMChnlDoc.DocStatus > 0 ";
        boolean bl3 = methodContext.getValue("IsInStat", false);
        if (bl3) {
            string3 = string3 + "and WCMChnlDoc.CHNLID>0 and WCMChnlDoc.DocStatus != 1028 ";
        }
        User user2 = null;
        if (users != null && users.size() > 0) {
            if (users.size() == 1) {
                user2 = (User)users.getAt(0);
                string3 = string3 + "and WCMChnlDoc.Cruser = ?";
                wCMFilter.setWhere(string3);
                wCMFilter.addSearchValues(0, user2.getName());
            } else {
                int n4 = users.size();
                for (int i = 0; i < n4; ++i) {
                    user2 = (User)users.getAt(i);
                    string3 = i == 0 ? string3 + "and (WCMChnlDoc.CrUser = ? or " : (i != n4 - 1 ? string3 + "WCMChnlDoc.CrUser = ? or " : string3 + "WCMChnlDoc.CrUser = ?)");
                    wCMFilter.setWhere(string3);
                    wCMFilter.addSearchValues(i, user2.getName());
                }
            }
        }
        WCMFilter wCMFilter2 = this.getFilterFromList(methodContext, cMSBaseObjs);
        WCMFilter wCMFilter3 = this.getFilterForCopyOnly(methodContext);
        wCMFilter2.mergeWith(wCMFilter3);
        wCMFilter2.mergeWith(wCMFilter);
        if (CMyString.isEmpty(wCMFilter2.getOrder())) {
            wCMFilter2.setOrder("WCMChnlDoc.CrUser asc");
        }
        viewDocuments.setSelectFields(methodContext.getValue("ChnlDocSelectFields"), methodContext.getValue("DocumentSelectFields"));
        viewDocuments.setPageSize(methodContext.getPageSize());
        viewDocuments.setCurrPage(methodContext.getPageIndex());
        viewDocuments.setRightIndex(64);
        viewDocuments.setNeedWithAuthFilter(user, true);
        if (user.isAdministrator()) {
            viewDocuments.open(cMSBaseObjs, wCMFilter2);
        } else {
            viewDocuments.open(channels, wCMFilter2);
        }
        return viewDocuments;
    }

    private Users getAllUsers(Group group, User user) throws WCMException {
        Users users = group.getUsers(user);
        WCMFilter wCMFilter = new WCMFilter("", "ParentId = ?", "");
        wCMFilter.addSearchValues(0, group.getId());
        Groups groups = Groups.openWCMObjs(user, wCMFilter);
        if (groups.size() > 0) {
            int n = groups.size();
            for (int i = 0; i < n; ++i) {
                Group group2 = (Group)groups.getAt(i);
                if (group2 == null) continue;
                users.addWith(this.getAllUsers(group2, user));
            }
        }
        return users;
    }

    public void editDocuments(MethodContext methodContext) throws Exception {
        boolean bl = methodContext.getValue("EditAll", false);
        String string = "";
        if (bl) {
            methodContext.setValue("PageSize", -1);
            string = ((ViewDocuments)this.query(methodContext)).getIdListAsString();
        } else {
            string = methodContext.getValue("ChnlDocIds");
        }
        if (CMyString.isEmpty(string)) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter("", "recid in(?)", "");
        int[] nArray = CMyString.splitToInt(string, ",");
        String string2 = "recid in(";
        for (int i = 0; i < nArray.length; ++i) {
            string2 = string2 + "?";
            wCMFilter.addSearchValues(nArray[i]);
            if (i >= nArray.length - 1) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        wCMFilter.setWhere(string2);
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(user, wCMFilter);
        this.changeViewDocsProperties(chnlDocs, methodContext);
    }

    private void changeViewDocsProperties(ChnlDocs chnlDocs, MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (chnlDocs == null) {
            return;
        }
        for (int i = 0; i < chnlDocs.size(); ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || !this.hasRight(user, chnlDoc, 32)) continue;
            String[] stringArray = new String[]{"CHNLID"};
            Document document = chnlDoc.getDocument();
            document = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, document, stringArray);
            document.save(user);
            chnlDoc = (ChnlDoc)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, chnlDoc, stringArray);
            chnlDoc.save(user);
        }
    }

    private boolean hasRight(User user, ChnlDoc chnlDoc, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, (BaseChannel)chnlDoc.getChannel(), chnlDoc.getDocument(), n);
    }

    public void changeDocLevel(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        String string = methodContext.getValue("DocumentIds");
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u6307\u5b9a\u7684DocumentIds\u4e3a\u7a7a");
        }
        int n = methodContext.getValue("DocLevel", 0);
        if (n > 0 && (cMSObj = DocLevel.findById(n)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u6587\u6863\u5bc6\u7ea7[id=" + n + "]\u4e0d\u5b58\u5728");
        }
        cMSObj = this.getLoginUser();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = Integer.parseInt(stringArray[i]);
            Document document = Document.findById(n2);
            if (document == null || !this.hasRight((User)cMSObj, document.getChannel(), document, 61)) continue;
            document.setDocLevel(n);
            document.save((User)cMSObj);
        }
    }
}

