/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.PhotoServiceProvider;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.PinyinHelper;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class UnZipFile4Batch
extends CMyUnZipFile {
    private Hashtable m_hAllFileNameIndex = null;
    private List m_filters = null;
    private boolean m_zFiltered = false;

    public UnZipFile4Batch(String string, String string2) {
        super(string, string2);
    }

    private boolean include(String string) {
        String string2 = CMyFile.extractFileExt(string);
        return this.m_filters.indexOf(string2.toLowerCase()) != -1;
    }

    public void setFilters(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.m_filters = new ArrayList(stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.m_filters.add(stringArray[i].toLowerCase());
        }
        this.m_zFiltered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnZipAnd() throws CMyException {
        String string = this.getZipFile();
        if (!CMyFile.fileExists(string)) {
            throw new CMyException(55, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label18", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u538b\u7f29\u6587\u4ef6[") + string + "]");
        }
        String string2 = this.getUnZipPath();
        if (!CMyFile.fileExists(string2)) {
            CMyFile.makeDir(string2, true);
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            boolean bl = '/' != File.pathSeparatorChar;
            byte[] byArray = new byte[1024];
            int n = 0;
            FileOutputStream fileOutputStream = null;
            String string3 = null;
            String string4 = this.getFileNameEncoding();
            if (CMyString.isEmpty(string4)) {
                string4 = "GBK";
            }
            this.m_hAllFileNameIndex = new Hashtable(10, 1.0f);
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry(string4);
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    string = zipEntry.getName();
                    if (bl) {
                        string = string.replace('/', File.separatorChar);
                    }
                    string = string2 + string;
                    if (this.m_zFiltered && !this.include(string)) {
                        zipEntry = zipInputStream.getNextEntry(string4);
                        continue;
                    }
                    string3 = PinyinHelper.convert(string);
                    String string5 = CMyFile.extractFilePath(string3);
                    if (!CMyFile.pathExists(string5)) {
                        CMyFile.makeDir(string5, true);
                    }
                    try {
                        fileOutputStream = new FileOutputStream(string3);
                        while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.flush();
                            }
                            catch (Exception exception) {}
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.m_hAllFileNameIndex.put(string, string3);
                }
                zipEntry = zipInputStream.getNextEntry(string4);
            }
        }
        catch (Exception exception) {
            throw new CMyException(200, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label19", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label20", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label21", "\u3011\u5931\u8d25\uff01"), exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                CMyFile.deleteFile(this.getZipFile());
            }
            catch (Exception exception) {}
        }
    }

    public Hashtable getAllFileNameIndex() {
        return this.m_hAllFileNameIndex;
    }

    public SortedMap getSortedFileNameIndex() {
        TreeMap treeMap = new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = String.valueOf(object);
                String string2 = String.valueOf(object2);
                return string2.compareTo(string);
            }
        });
        if (this.m_hAllFileNameIndex != null && !this.m_hAllFileNameIndex.isEmpty()) {
            Iterator iterator = this.m_hAllFileNameIndex.keySet().iterator();
            Object k = null;
            while (iterator.hasNext()) {
                k = iterator.next();
                treeMap.put(k, this.m_hAllFileNameIndex.get(k));
            }
        }
        return treeMap;
    }
}

