/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.ReflectUtil;
import com.trs.dev4.jdk16.utils.SortedProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXUtil {
    private static final MBeanServer s_BeanServer = ManagementFactory.getPlatformMBeanServer();

    public static final Object getAttribute(String beanName, String attrName) {
        try {
            return JMXUtil.accessAttribute0(beanName, attrName);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    private static Object accessAttribute0(String beanName, String attrName) throws MalformedObjectNameException, NullPointerException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ObjectName on = new ObjectName(beanName);
        return s_BeanServer.getAttribute(on, attrName);
    }

    public static final long getAttrAsLong(String beanName, String attrName) {
        Object obj = JMXUtil.getAttribute(beanName, attrName);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        return -1L;
    }

    public static final double getAttrAsDouble(String beanName, String attrName) {
        Object obj = JMXUtil.getAttribute(beanName, attrName);
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return -100.0;
    }

    public static final Properties getOperatingSystemMXBeanInfo() {
        SortedProperties info = new SortedProperties();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        JMXUtil.addGetterIfAvaliable(os, "SystemLoadAverage", info);
        JMXUtil.addGetterIfAvaliable(os, "OpenFileDescriptorCount", info);
        JMXUtil.addGetterIfAvaliable(os, "MaxFileDescriptorCount", info);
        JMXUtil.addGetterIfAvaliable(os, "CommittedVirtualMemorySize", info);
        JMXUtil.addGetterIfAvaliable(os, "TotalPhysicalMemorySize", info);
        JMXUtil.addGetterIfAvaliable(os, "TotalSwapSpaceSize", info);
        JMXUtil.addGetterIfAvaliable(os, "ProcessCpuTime", info);
        return info;
    }

    public static String getJVMInputArguments() {
        List<String> lstArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuilder sb = new StringBuilder();
        for (String arg : lstArguments) {
            sb.append(arg).append(" ");
        }
        return sb.toString();
    }

    public static void registerMBean(String mBeanName, Object mBean) {
        try {
            s_BeanServer.registerMBean(mBean, new ObjectName(mBeanName));
        }
        catch (InstanceAlreadyExistsException e) {
            System.out.println("WARNING: The MBean: [" + mBeanName + "] is already under the control of the MBean server");
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    private static void addGetterIfAvaliable(Object obj, String getter, Properties info) {
        String methodName = "get" + getter;
        try {
            Object v = ReflectUtil.invokePublicMethod(obj, methodName);
            if (v != null) {
                info.put(getter, v);
            }
        }
        catch (NoSuchMethodException v) {
        }
        catch (Exception e) {
            throw new WrappedException("fail to invoke " + methodName + "() on object " + obj + "!", e);
        }
    }
}

