/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.CloseUtil;
import com.trs.cis4.util.ConstUtil;
import com.trs.cis4.util.EncodingUtil;
import com.trs.cis4.util.RegexUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.cis4.util.FileUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static void main(String[] args) {
    }

    public static List listAllFiles(String folder) {
        ArrayList<String> list = new ArrayList<String>();
        String[] folders = FileUtil.getAllFolders(folder).split(",");
        int i = 0;
        while (i < folders.length) {
            if (folders[i].length() > 0) {
                File file = new File(folders[i]);
                File[] files = file.listFiles();
                int j = 0;
                while (j < files.length) {
                    if (files[j].isFile()) {
                        list.add(files[j].getAbsolutePath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    public static String getAllFolders(String folder) {
        File fDir = new File(folder);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] files = fDir.listFiles(fileFilter);
        if (files == null || files.length == 0) {
            return folder;
        }
        String folders = folder;
        int i = 0;
        while (i < files.length) {
            String path = files[i].getAbsolutePath();
            String foldername = FileUtil.getAllFolders(path);
            folders = String.valueOf(folders) + "," + foldername;
            ++i;
        }
        return folders;
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtil.readTextFile(file, EncodingUtil.detectCharset(file));
    }

    public static String readTextFile(String filePath) throws IOException {
        return FileUtil.readTextFile(new File(filePath));
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        String string;
        StringBuffer sb = new StringBuffer(4096);
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, encoding);
            br = new BufferedReader(isr);
            boolean firstLine = true;
            String line = br.readLine();
            while (line != null) {
                if (!firstLine) {
                    sb.append(ConstUtil.LINE_FEED);
                } else {
                    firstLine = false;
                }
                sb.append(line);
                line = br.readLine();
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            CloseUtil.closeReader(br);
            CloseUtil.closeReader(isr);
            CloseUtil.closeInputStream(fis);
            throw throwable;
        }
        CloseUtil.closeReader(br);
        CloseUtil.closeReader(isr);
        CloseUtil.closeInputStream(fis);
        return string;
    }

    public static String readTextFile(String filePath, String encoding) throws IOException {
        return FileUtil.readTextFile(new File(filePath), encoding);
    }

    public static void forceDeleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].delete();
                } else {
                    FileUtil.forceDeleteDirectory(files[i]);
                }
                ++i;
            }
        }
        directory.delete();
    }

    public static void forceDeleteDirectory(String dirPath) throws IOException {
        FileUtil.forceDeleteDirectory(new File(dirPath));
    }

    public static boolean moveDirectory(File sourceDir, File destDir) {
        if (!sourceDir.exists()) {
            return true;
        }
        boolean success = sourceDir.renameTo(destDir);
        boolean success2 = true;
        if (!success) {
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            File[] files = sourceDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File child = files[i];
                success2 = child.isDirectory() ? success2 && FileUtil.moveDirectory(child, new File(destDir, child.getName())) : success2 && FileUtil.moveFile(child, new File(destDir, child.getName()));
                ++i;
            }
        }
        boolean bl = success = success || success2;
        if (success && sourceDir.exists()) {
            success = sourceDir.delete();
        }
        if (logger.isDebugEnabled()) {
            if (success) {
                logger.debug((Object)("move folder from :[" + sourceDir.getAbsolutePath() + "] to [" + destDir.getAbsolutePath() + "] successful"));
            } else {
                logger.debug((Object)("move folder from :[" + sourceDir.getAbsolutePath() + "] to [" + destDir.getAbsolutePath() + "] failed"));
            }
        }
        return success;
    }

    public static boolean moveFile(File sourceFile, File destFile) {
        boolean success;
        if (destFile.exists()) {
            destFile.delete();
        }
        if (!(success = sourceFile.renameTo(destFile))) {
            success = FileUtil.doFileCopy(sourceFile, destFile);
        }
        if (success && sourceFile.exists()) {
            success = sourceFile.delete();
        }
        if (logger.isDebugEnabled()) {
            if (success) {
                logger.debug((Object)("move file from :[" + sourceFile.getAbsolutePath() + "] to [" + destFile.getAbsolutePath() + "] successful"));
            } else {
                logger.debug((Object)("move file from :[" + sourceFile.getAbsolutePath() + "] to [" + destFile.getAbsolutePath() + "] failed"));
            }
        }
        return success;
    }

    public static boolean copyFile(File sourceFile, File destFile) {
        if (destFile.exists()) {
            destFile.delete();
        }
        boolean success = FileUtil.doFileCopy(sourceFile, destFile);
        if (logger.isDebugEnabled()) {
            if (success) {
                logger.debug((Object)("copy file from :[" + sourceFile.getAbsolutePath() + "] to [" + destFile.getAbsolutePath() + "] successful"));
            } else {
                logger.debug((Object)("copy file from :[" + sourceFile.getAbsolutePath() + "] to [" + destFile.getAbsolutePath() + "] failed"));
            }
        }
        return success;
    }

    private static boolean doFileCopy(File sourceFile, File destFile) {
        boolean success = false;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileUtil.writeFile(destFile, (InputStream)new FileInputStream(sourceFile));
        }
        catch (IOException e) {
            logger.error((Object)("error while moving file:[" + sourceFile.getAbsolutePath() + "] to [" + destFile.getAbsolutePath() + "]"), (Throwable)e);
            success = false;
        }
        return success;
    }

    public static void writeFile(File targetFile, InputStream inputStream) throws IOException {
        FileOutputStream fos = null;
        try {
            int length;
            fos = new FileOutputStream(targetFile);
            byte[] buff = new byte[4096];
            while ((length = inputStream.read(buff, 0, 4096)) > 0) {
                fos.write(buff, 0, length);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(fos);
            CloseUtil.closeInputStream(inputStream);
            throw throwable;
        }
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeInputStream(inputStream);
    }

    public static void writeFile(String targetFilePath, InputStream inputStream) throws IOException {
        FileUtil.writeFile(new File(targetFilePath), inputStream);
    }

    public static void writeFile(File file, byte[] bytes) throws IOException {
        if (bytes == null) {
            return;
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(bos);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeOutputStream(bos);
        CloseUtil.closeOutputStream(fos);
    }

    public static void writeFile(String filePath, byte[] bytes) throws IOException {
        FileUtil.writeFile(new File(filePath), bytes);
    }

    public static void writeFile(File file, String content) throws IOException {
        FileUtil.writeFile(file, content, "utf-8");
    }

    public static void writeFile(String filePath, String content) throws IOException {
        FileUtil.writeFile(new File(filePath), content, "utf-8");
    }

    public static void appendFile(String filePath, String content) throws IOException {
        FileUtil.appendFile(filePath, content, "");
    }

    public static void appendFile(String filePath, String lineEnd, String content) throws IOException {
        if (content == null) {
            return;
        }
        FileWriter fileWriter = new FileWriter(filePath, true);
        fileWriter.write(lineEnd);
        fileWriter.write(content);
        CloseUtil.closeWriter(fileWriter);
    }

    public static void writeFile(File file, String content, String encoding) throws IOException {
        if (content == null) {
            return;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (Throwable throwable) {
            CloseUtil.closeWriter(bw);
            CloseUtil.closeWriter(osw);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeWriter(bw);
        CloseUtil.closeWriter(osw);
        CloseUtil.closeOutputStream(fos);
    }

    public static void writeFile(String filePath, String content, String encoding) throws IOException {
        FileUtil.writeFile(new File(filePath), content, encoding);
    }

    public static String getFileExtendName(String filePath) {
        return RegexUtil.getMatchGroup(filePath, "\\.([^\\.]+)$", 1);
    }

    public static String getFileName(String filePath) {
        return RegexUtil.getMatchGroup(filePath, "[^/\\\\]+$", 0);
    }

    public static void createFolder(String folderPath) {
        String filePath = folderPath;
        filePath = filePath.toString();
        File myFilePath = new File(filePath);
        try {
            if (myFilePath.isDirectory()) {
                System.out.println("the directory is exists!");
            } else {
                myFilePath.mkdir();
            }
        }
        catch (Exception e) {
            System.out.println("\u65b0\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519" + e);
            e.printStackTrace();
        }
    }

    public static void delAllFile(String path, String fileSeperator) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        int i = 0;
        while (i < tempList.length) {
            temp = path.endsWith(fileSeperator) ? new File(String.valueOf(path) + tempList[i]) : new File(String.valueOf(path) + fileSeperator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                FileUtil.delAllFile(String.valueOf(path) + "/ " + tempList[i], fileSeperator);
                FileUtil.delFolder(String.valueOf(path) + "/ " + tempList[i], fileSeperator);
            }
            ++i;
        }
    }

    public static void delFolder(String folderPath, String fileSeperator) {
        try {
            FileUtil.delAllFile(folderPath, fileSeperator);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            System.out.println("\u5220\u9664\u6587\u4ef6\u5939\u64cd\u4f5c\u51fa\u9519 ");
            e.printStackTrace();
        }
    }

    public void removeFile(String path) {
        this.removeFile(new File(path));
    }

    public void removeFile(File file) {
        File[] child;
        System.out.println("removing file " + file.getPath());
        if (file.isDirectory() && (child = file.listFiles()) != null && child.length != 0) {
            int i = 0;
            while (i < child.length) {
                this.removeFile(child[i]);
                child[i].delete();
                ++i;
            }
        }
        file.delete();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("\u6587\u4ef6\u592a\u957f\uff0c\u65e0\u6cd5\u83b7\u53d6\u5185\u5bb9\uff01" + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("\u8bfb\u6587\u4ef6\u9519\u8bef\uff01" + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private FileUtil() {
    }
}

