/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.impl.ASMUtil;
import com.trs.infra.discover.impl.Container;
import com.trs.infra.discover.impl.NodeDirectory;
import com.trs.infra.discover.impl.NodeResource;
import com.trs.infra.discover.impl.NodeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import trs.org.objectweb.asm.tree.ClassNode;

public class ContainerByZip
extends Container {
    private boolean m_zEasyJointURL;

    public ContainerByZip(URL location) {
        super(location);
        this.m_zEasyJointURL = "file".equals(location.getProtocol());
    }

    public void load() throws IOException {
        InputStream is = null;
        URL url = this.getLocation();
        try {
            ZipEntry ze = null;
            is = url.openStream();
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            ZipInputStream zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String zeName = ze.getName();
                if (ze.isDirectory()) {
                    this.addDirectory(zeName);
                    continue;
                }
                int length = 0;
                baos.reset();
                while ((length = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, length);
                }
                byte[] zeData = baos.toByteArray();
                if (!ze.getName().endsWith(".class")) {
                    this.addResource(zeName, zeData);
                    continue;
                }
                ClassNode cn = ASMUtil.getNodeFromData(zeData);
                if (cn == null) {
                    this.addResource(zeName, zeData);
                    continue;
                }
                this.addType(zeName, cn);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void addResource(String path, byte[] data) {
        String[] names = ContainerByZip.splitPath(path);
        int count = names.length;
        if (count <= 0) {
            return;
        }
        if (count == 1) {
            this.addRootNode(this.newResource(names[0], path, data));
            return;
        }
        NodeDirectory parent = this.getRootDirectory(names[0]);
        int limit = count - 1;
        int i = 1;
        while (i < limit) {
            parent = parent.getDirectoryNode(names[i]);
            ++i;
        }
        parent.addChild(this.newResource(names[limit], path, data));
    }

    private NodeResource newResource(String name, String path, byte[] data) {
        URL url = null;
        if (this.m_zEasyJointURL) {
            try {
                url = new URL("jar:" + this.getLocation().toString() + "!/" + path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new NodeResource(name, url);
    }

    private void addType(String path, ClassNode cn) {
        String[] names = ContainerByZip.splitPath(path);
        int count = names.length;
        if (count <= 0) {
            return;
        }
        if (count == 1) {
            this.addRootNode(this.newType(names[0], path, cn));
            return;
        }
        NodeDirectory parent = this.getRootDirectory(names[0]);
        int limit = count - 1;
        int i = 1;
        while (i < limit) {
            parent = parent.getDirectoryNode(names[i]);
            ++i;
        }
        parent.addChild(this.newType(names[limit], path, cn));
    }

    private NodeType newType(String name, String path, ClassNode cn) {
        URL url = null;
        if (this.m_zEasyJointURL) {
            try {
                url = new URL("jar:" + this.getLocation().toString() + "!/" + path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new NodeType(name, url, cn);
    }
}

