/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.utils;

import com.tencent.weibo.beans.QParameter;
import com.tencent.weibo.utils.Configuration;
import com.tencent.weibo.utils.QHttpUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QHttpClient {
    private static Log log = LogFactory.getLog(QHttpClient.class);
    HttpClient client = null;
    private MultiThreadedHttpConnectionManager connectionManager;
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();

    public QHttpClient() {
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(150);
        params.setConnectionTimeout(Configuration.getConnectionTimeout());
        params.setSoTimeout(Configuration.getReadTimeout());
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setCookiePolicy("ignoreCookies");
        this.client = new HttpClient(clientParams, (HttpConnectionManager)this.connectionManager);
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            log.debug((Object)("ProxyHost: " + this.proxyHost));
            log.debug((Object)("proxyPort: " + this.proxyPort));
            this.client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            this.client.getParams().setAuthenticationPreemptive(true);
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxyAuthUser, this.proxyAuthPassword));
                log.debug((Object)("Proxy AuthUser: " + this.proxyAuthUser));
                log.debug((Object)("Proxy AuthPassword: " + this.proxyAuthPassword));
            }
        }
    }

    public String httpGet(String url, String queryString) throws Exception {
        String responseData = null;
        if (queryString != null && !queryString.equals("")) {
            url = String.valueOf(url) + "?" + queryString;
        }
        log.debug((Object)("httpGet [1]. url = " + url));
        GetMethod httpGet = new GetMethod(url);
        httpGet.getParams().setParameter("http.socket.timeout", (Object)new Integer(Configuration.getConnectionTimeout()));
        try {
            try {
                int statusCode = -1;
                statusCode = this.proxyHost != null && !this.proxyHost.equals("") ? this.client.executeMethod(this.client.getHostConfiguration(), (HttpMethod)httpGet) : this.client.executeMethod((HttpMethod)httpGet);
                if (statusCode != 200) {
                    log.error((Object)("HttpGet [2] Method failed: " + httpGet.getStatusLine()));
                }
                responseData = httpGet.getResponseBodyAsString();
                log.debug((Object)(" httpGet [3] getResponseBodyAsString() = " + httpGet.getResponseBodyAsString()));
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            httpGet.releaseConnection();
            this.client = null;
        }
        return responseData;
    }

    public String httpPost(String url, String queryString) throws Exception {
        String responseData = null;
        log.debug((Object)("QHttpClient httpPost [1] url = " + url));
        PostMethod httpPost = new PostMethod(url);
        httpPost.addParameter("Content-Type", "application/x-www-form-urlencoded");
        httpPost.getParams().setParameter("http.socket.timeout", (Object)new Integer(Configuration.getConnectionTimeout()));
        if (queryString != null && !queryString.equals("")) {
            httpPost.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(queryString.getBytes()));
        }
        try {
            try {
                int statusCode = -1;
                statusCode = this.proxyHost != null && !this.proxyHost.equals("") ? this.client.executeMethod(this.client.getHostConfiguration(), (HttpMethod)httpPost) : this.client.executeMethod((HttpMethod)httpPost);
                if (statusCode != 200) {
                    System.err.println("HttpPost Method failed: " + httpPost.getStatusLine());
                }
                responseData = httpPost.getResponseBodyAsString();
                log.debug((Object)("QHttpClient httpPost [2] responseData = " + responseData));
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            httpPost.releaseConnection();
            this.client = null;
        }
        return responseData;
    }

    public String httpPostWithFile(String url, String queryString, List<QParameter> files) throws Exception {
        String responseData = null;
        url = String.valueOf(url) + '?' + queryString;
        PostMethod httpPost = new PostMethod(url);
        try {
            try {
                List<QParameter> listParams = QHttpUtil.getQueryParameters(queryString);
                int length = listParams.size() + (files == null ? 0 : files.size());
                Part[] parts = new Part[length];
                int i = 0;
                for (QParameter param : listParams) {
                    parts[i++] = new StringPart(param.getName(), QHttpUtil.formParamDecode(param.getValue()), "UTF-8");
                }
                for (QParameter param : files) {
                    String filePath = param.getValue();
                    File file = new File(filePath);
                    String name = param.getName();
                    parts[i++] = new FilePart(name, file, "image/jpeg", "utf-8");
                }
                httpPost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, httpPost.getParams()));
                int statusCode = -1;
                statusCode = this.proxyHost != null && !this.proxyHost.equals("") ? this.client.executeMethod(this.client.getHostConfiguration(), (HttpMethod)httpPost) : this.client.executeMethod((HttpMethod)httpPost);
                if (statusCode != 200) {
                    System.err.println("HttpPost Method failed: " + httpPost.getStatusLine());
                }
                responseData = httpPost.getResponseBodyAsString();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            httpPost.releaseConnection();
            this.client = null;
        }
        return responseData;
    }
}

