/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import java.util.logging.Level;

final class TimeoutTimer
implements Runnable {
    private final int timeoutSeconds;
    private final TDSCommand command;
    private Thread timerThread;
    private volatile boolean canceled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    TimeoutTimer(int n, TDSCommand tDSCommand) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == tDSCommand) {
            throw new AssertionError();
        }
        this.timeoutSeconds = n;
        this.command = tDSCommand;
    }

    final void start() {
        this.timerThread = new Thread(this);
        this.timerThread.setDaemon(true);
        this.timerThread.start();
    }

    final void stop() {
        this.canceled = true;
        this.timerThread.interrupt();
    }

    public void run() {
        int n = this.timeoutSeconds;
        try {
            do {
                if (this.canceled) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(1000L);
            } while (--n > 0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            this.command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
        }
        catch (SQLServerException sQLServerException) {
            this.command.log(Level.FINE, "Command could not be timed out. Reason: " + sQLServerException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !TimeoutTimer.class.desiredAssertionStatus();
    }
}

