/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.springframework.aop.TargetSource;

public class HotSwappableTargetSource
implements TargetSource,
Serializable {
    protected Object target;

    public HotSwappableTargetSource(Object initialTarget) {
        this.target = initialTarget;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public final boolean isStatic() {
        return false;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object o) {
    }

    public synchronized Object swap(Object newTarget) throws IllegalArgumentException {
        if (newTarget == null) {
            throw new IllegalArgumentException("Cannot swap to null");
        }
        Object old = this.target;
        this.target = newTarget;
        return old;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HotSwappableTargetSource)) {
            return false;
        }
        HotSwappableTargetSource otherTargetSource = (HotSwappableTargetSource)other;
        return otherTargetSource.target == this.target || otherTargetSource.target.equals(this.target);
    }

    public String toString() {
        return "Swappable TargetSource (" + this.getClass().getName() + "): " + (this.target != null ? "targetClass=" + this.target.getClass() : "UNITIALIZED");
    }
}

