/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;

public class BeanNameAutoProxyCreator
extends AbstractAutoProxyCreator {
    private List beanNames;

    public void setBeanNames(String[] beanNames) {
        this.beanNames = Arrays.asList(beanNames);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Object bean, String beanName, TargetSource targetSource) {
        if (this.beanNames != null) {
            if (this.beanNames.contains(beanName)) {
                return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
            }
            Iterator it = this.beanNames.iterator();
            while (it.hasNext()) {
                String mappedName = (String)it.next();
                if (!this.isMatch(beanName, mappedName)) continue;
                return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
            }
        }
        return DO_NOT_PROXY;
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return mappedName.endsWith("*") && beanName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && beanName.endsWith(mappedName.substring(1, mappedName.length()));
    }
}

