/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import weibo4j.http.Response;
import weibo4j.model.Source;
import weibo4j.model.StatusWapper;
import weibo4j.model.User;
import weibo4j.model.Visible;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Status
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -8795691786466526420L;
    private User user = null;
    private Date createdAt;
    private String id;
    private String mid;
    private long idstr;
    private String text;
    private Source source;
    private boolean favorited;
    private boolean truncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private String inReplyToScreenName;
    private String thumbnailPic;
    private String bmiddlePic;
    private String originalPic;
    private Status retweetedStatus = null;
    private String geo;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private int repostsCount;
    private int commentsCount;
    private String annotations;
    private int mlevel;
    private Visible visible;

    public Status() {
    }

    public Status(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.constructJson(json);
    }

    private void constructJson(JSONObject json) throws WeiboException {
        try {
            this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.id = json.getString("id");
            this.mid = json.getString("mid");
            this.idstr = json.getLong("idstr");
            this.text = json.getString("text");
            if (json.getString("source") != null && json.getString("source").length() != 0) {
                this.source = new Source(json.getString("source"));
            }
            this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", json);
            this.inReplyToUserId = Status.getLong("in_reply_to_user_id", json);
            this.inReplyToScreenName = json.getString("in_reply_toS_screenName");
            this.favorited = Status.getBoolean("favorited", json);
            this.truncated = Status.getBoolean("truncated", json);
            this.thumbnailPic = json.getString("thumbnail_pic");
            this.bmiddlePic = json.getString("bmiddle_pic");
            this.originalPic = json.getString("original_pic");
            this.repostsCount = json.getInt("reposts_count");
            this.commentsCount = json.getInt("comments_count");
            this.annotations = json.getString("annotations");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            if (!json.isNull("retweeted_status")) {
                this.retweetedStatus = new Status(json.getJSONObject("retweeted_status"));
            }
            this.mlevel = json.getInt("mlevel");
            this.geo = json.getString("geo");
            if (this.geo != null && !"".equals(this.geo) && !"null".equals(this.geo)) {
                this.getGeoInfo(this.geo);
            }
            if (!json.isNull("visible")) {
                this.visible = new Visible(json.getJSONObject("visible"));
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    private void getGeoInfo(String geo) {
        StringBuffer value = new StringBuffer();
        char[] cArray = geo.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '-' && c < ':') {
                value.append(c);
            }
            if (c == ',' && value.length() > 0) {
                this.latitude = Double.parseDouble(value.toString());
                this.longitude = Double.parseDouble(value.toString());
                value.delete(0, value.length());
            }
            ++n2;
        }
    }

    public Status(JSONObject json) throws WeiboException, JSONException {
        this.constructJson(json);
    }

    public Status(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.constructJson(json);
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public long getIdstr() {
        return this.idstr;
    }

    public void setIdstr(long idstr) {
        this.idstr = idstr;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public void setInReplyToStatusId(long inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public void setInReplyToUserId(long inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public void setInReplyToScreenName(String inReplyToScreenName) {
        this.inReplyToScreenName = inReplyToScreenName;
    }

    public String getThumbnailPic() {
        return this.thumbnailPic;
    }

    public void setThumbnailPic(String thumbnailPic) {
        this.thumbnailPic = thumbnailPic;
    }

    public String getBmiddlePic() {
        return this.bmiddlePic;
    }

    public void setBmiddlePic(String bmiddlePic) {
        this.bmiddlePic = bmiddlePic;
    }

    public String getOriginalPic() {
        return this.originalPic;
    }

    public void setOriginalPic(String originalPic) {
        this.originalPic = originalPic;
    }

    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    public void setRetweetedStatus(Status retweetedStatus) {
        this.retweetedStatus = retweetedStatus;
    }

    public String getGeo() {
        return this.geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getRepostsCount() {
        return this.repostsCount;
    }

    public void setRepostsCount(int repostsCount) {
        this.repostsCount = repostsCount;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int commentsCount) {
        this.commentsCount = commentsCount;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public int getMlevel() {
        return this.mlevel;
    }

    public void setMlevel(int mlevel) {
        this.mlevel = mlevel;
    }

    public Visible getVisible() {
        return this.visible;
    }

    public void setVisible(Visible visible) {
        this.visible = visible;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    public static StatusWapper constructWapperStatus(Response res) throws WeiboException {
        JSONArray statuses;
        JSONObject jsonStatus;
        block6: {
            jsonStatus = res.asJSONObject();
            statuses = null;
            if (!jsonStatus.isNull("statuses")) {
                statuses = jsonStatus.getJSONArray("statuses");
            }
            if (!jsonStatus.isNull("reposts")) {
                statuses = jsonStatus.getJSONArray("reposts");
            }
            if (statuses != null) break block6;
            return null;
        }
        try {
            int size = statuses.length();
            ArrayList<Status> status = new ArrayList<Status>(size);
            int i = 0;
            while (i < size) {
                status.add(new Status(statuses.getJSONObject(i)));
                ++i;
            }
            long previousCursor = jsonStatus.getLong("previous_curosr");
            long nextCursor = jsonStatus.getLong("next_cursor");
            long totalNumber = jsonStatus.getLong("total_number");
            String hasvisible = jsonStatus.getString("hasvisible");
            return new StatusWapper(status, previousCursor, nextCursor, totalNumber, hasvisible);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Status [user=" + this.user + ", idstr=" + this.idstr + ", createdAt=" + this.createdAt + ", id=" + this.id + ", text=" + this.text + ", source=" + this.source + ", favorited=" + this.favorited + ", truncated=" + this.truncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", inReplyToScreenName=" + this.inReplyToScreenName + ", thumbnailPic=" + this.thumbnailPic + ", bmiddlePic=" + this.bmiddlePic + ", originalPic=" + this.originalPic + ", retweetedStatus=" + this.retweetedStatus + ", geo=" + this.geo + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", repostsCount=" + this.repostsCount + ", commentsCount=" + this.commentsCount + ", mid=" + this.mid + ", annotations=" + this.annotations + ", mlevel=" + this.mlevel + ", visible=" + this.visible + "]";
    }
}

