/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobOutputStream
extends OutputStream {
    private Clob lo;
    private byte[] buf;
    private int bsize;
    private int bpos;
    private int clobpos;

    public ClobOutputStream(Clob lo, int pos) {
        this.lo = lo;
        this.clobpos = pos;
        this.bsize = 1024;
        this.buf = new byte[this.bsize];
        this.bpos = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos >= this.bsize) {
                this.lo.setString(this.clobpos, String.valueOf(this.buf).trim());
                this.clobpos += this.buf.length;
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)b;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            String str = new String(buf);
            this.lo.setString(this.clobpos, str.trim());
            this.clobpos += buf.length;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (off == 0 && len == buf.length) {
                this.lo.setString(this.clobpos, String.valueOf(buf).trim());
                this.clobpos += buf.length;
            } else {
                this.lo.setString(this.clobpos, String.valueOf(buf).trim(), off, len);
                this.clobpos += len;
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.lo.setString(this.clobpos, String.valueOf(this.buf).trim(), 0, this.bpos);
                this.clobpos += this.bpos;
            }
            this.bpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lo != null) {
            this.flush();
            this.lo = null;
        }
    }

    private void checkClosed() throws IOException {
        if (this.lo == null) {
            throw new IOException("ClobOutputStream is closed");
        }
    }
}

