/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.JdbcCallParseInfo;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.SqlCommandType;
import com.kingbase8.core.Utils;
import com.kingbase8.jdbc.EscapedFunctions;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class Parser {
    private static final int[] NO_BINDS = new int[0];
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER = new char[]{'\"', '0'};
    private static final char[] SINGLE_QUOTE = new char[]{'\''};

    public static List<NativeQuery> parseJdbcSql(String query, boolean standardConformingStrings, boolean withParameters, boolean splitStatements, boolean isBatchedReWriteConfigured, String ... returningColumnNames) throws SQLException {
        if (!withParameters && !splitStatements && returningColumnNames != null && returningColumnNames.length == 0) {
            return Collections.singletonList(new NativeQuery(query, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)));
        }
        Vector<Integer> funbodyindex = Parser.findoutFunctionBodyRangeindex(query);
        int fragmentStart = 0;
        int inParen = 0;
        char[] aChars = query.toCharArray();
        StringBuilder nativeSql = new StringBuilder(query.length() + 10);
        ArrayList<Integer> bindPositions = null;
        List<NativeQuery> nativeQueries = null;
        boolean isCurrentReWriteCompatible = false;
        boolean isValuesFound = false;
        int valuesBraceOpenPosition = -1;
        int valuesBraceClosePosition = -1;
        boolean isInsertPresent = false;
        boolean isReturningPresent = false;
        boolean isReturningPresentPrev = false;
        SqlCommandType currentCommandType = SqlCommandType.BLANK;
        SqlCommandType prevCommandType = SqlCommandType.BLANK;
        int numberOfStatements = 0;
        boolean whitespaceOnly = true;
        int keyWordCount = 0;
        int keywordStart = -1;
        for (int i = 0; i < aChars.length; ++i) {
            char aChar = aChars[i];
            boolean isKeyWordChar = false;
            whitespaceOnly &= aChar == ';' || Character.isWhitespace(aChar);
            switch (aChar) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, standardConformingStrings);
                    break;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    break;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    break;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    break;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    break;
                }
                case ')': {
                    if (--inParen != 0 || !isValuesFound) break;
                    valuesBraceClosePosition = nativeSql.length() + i - fragmentStart;
                    break;
                }
                case '?': {
                    nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                    if (i + 1 < aChars.length && aChars[i + 1] == '?') {
                        nativeSql.append('?');
                        ++i;
                    } else if (!withParameters) {
                        nativeSql.append('?');
                    } else {
                        if (bindPositions == null) {
                            bindPositions = new ArrayList<Integer>();
                        }
                        bindPositions.add(nativeSql.length());
                        int bindIndex = bindPositions.size();
                        nativeSql.append(NativeQuery.bindName(bindIndex));
                    }
                    fragmentStart = i + 1;
                    break;
                }
                case ';': {
                    if (Parser.isInfunctionbody(i, funbodyindex) || inParen != 0) break;
                    if (!whitespaceOnly) {
                        ++numberOfStatements;
                        nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                        whitespaceOnly = true;
                    }
                    fragmentStart = i + 1;
                    if (nativeSql.length() > 0) {
                        if (Parser.addReturning(nativeSql, currentCommandType, returningColumnNames, isReturningPresent)) {
                            isReturningPresent = true;
                        }
                        if (splitStatements) {
                            if (nativeQueries == null) {
                                nativeQueries = new ArrayList<NativeQuery>();
                            }
                            nativeQueries.add(new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions), false, SqlCommand.createStatementTypeInfo(currentCommandType, isBatchedReWriteConfigured, valuesBraceOpenPosition, valuesBraceClosePosition, isReturningPresent, nativeQueries.size())));
                        }
                    }
                    prevCommandType = currentCommandType;
                    isReturningPresentPrev = isReturningPresent;
                    currentCommandType = SqlCommandType.BLANK;
                    isReturningPresent = false;
                    if (!splitStatements) break;
                    if (bindPositions != null) {
                        bindPositions.clear();
                    }
                    nativeSql.setLength(0);
                    valuesBraceOpenPosition = -1;
                    valuesBraceClosePosition = -1;
                    break;
                }
                default: {
                    if (keywordStart >= 0) {
                        isKeyWordChar = Parser.isIdentifierContChar(aChar);
                        break;
                    }
                    isKeyWordChar = Parser.isIdentifierStartChar(aChar);
                    if (!isKeyWordChar) break;
                    keywordStart = i;
                }
            }
            if (!(keywordStart < 0 || i != aChars.length - 1 && isKeyWordChar)) {
                int wordLength = (isKeyWordChar ? i + 1 : i) - keywordStart;
                if (currentCommandType == SqlCommandType.BLANK) {
                    if (wordLength == 6 && Parser.parseUpdateKeyword(aChars, keywordStart)) {
                        currentCommandType = SqlCommandType.UPDATE;
                    } else if (wordLength == 6 && Parser.parseDeleteKeyword(aChars, keywordStart)) {
                        currentCommandType = SqlCommandType.DELETE;
                    } else if (wordLength == 4 && Parser.parseMoveKeyword(aChars, keywordStart)) {
                        currentCommandType = SqlCommandType.MOVE;
                    } else if (wordLength == 6 && Parser.parseSelectKeyword(aChars, keywordStart)) {
                        currentCommandType = SqlCommandType.SELECT;
                    } else if (wordLength == 4 && Parser.parseWithKeyword(aChars, keywordStart)) {
                        currentCommandType = SqlCommandType.WITH;
                    } else if (wordLength == 6 && Parser.parseInsertKeyword(aChars, keywordStart)) {
                        if (!isInsertPresent && (nativeQueries == null || nativeQueries.isEmpty())) {
                            isCurrentReWriteCompatible = keyWordCount == 0;
                            isInsertPresent = true;
                            currentCommandType = SqlCommandType.INSERT;
                        } else {
                            isCurrentReWriteCompatible = false;
                        }
                    }
                }
                if (inParen == 0 && aChar != ')') {
                    if (wordLength == 9 && Parser.parseReturningKeyword(aChars, keywordStart)) {
                        isReturningPresent = true;
                    } else if (wordLength == 6 && Parser.parseValuesKeyword(aChars, keywordStart)) {
                        isValuesFound = true;
                    }
                }
                keywordStart = -1;
                ++keyWordCount;
            }
            if (aChar != '(' || ++inParen != 1 || !isValuesFound || valuesBraceOpenPosition != -1) continue;
            valuesBraceOpenPosition = nativeSql.length() + i - fragmentStart;
        }
        if (!isValuesFound) {
            isCurrentReWriteCompatible = false;
        }
        if (!isCurrentReWriteCompatible) {
            valuesBraceOpenPosition = -1;
            valuesBraceClosePosition = -1;
        }
        if (fragmentStart < aChars.length && !whitespaceOnly) {
            nativeSql.append(aChars, fragmentStart, aChars.length - fragmentStart);
        } else if (numberOfStatements > 1) {
            isReturningPresent = false;
            currentCommandType = SqlCommandType.BLANK;
        } else if (numberOfStatements == 1) {
            isReturningPresent = isReturningPresentPrev;
            currentCommandType = prevCommandType;
        }
        if (nativeSql.length() == 0) {
            return nativeQueries != null ? nativeQueries : Collections.emptyList();
        }
        if (Parser.addReturning(nativeSql, currentCommandType, returningColumnNames, isReturningPresent)) {
            isReturningPresent = true;
        }
        NativeQuery lastQuery = new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions), !splitStatements, SqlCommand.createStatementTypeInfo(currentCommandType, isBatchedReWriteConfigured, valuesBraceOpenPosition, valuesBraceClosePosition, isReturningPresent, nativeQueries == null ? 0 : nativeQueries.size()));
        if (nativeQueries == null) {
            return Collections.singletonList(lastQuery);
        }
        if (!whitespaceOnly) {
            nativeQueries.add(lastQuery);
        }
        return nativeQueries;
    }

    private static boolean isInfunctionbody(int i, Vector<Integer> funbodyindex) {
        boolean bInfunbody = false;
        int funbodystart = 0;
        int funbodyend = 0;
        int loop = 0;
        while (loop < funbodyindex.size() && i >= funbodyindex.get(loop)) {
            if (i == funbodyindex.get(loop)) {
                bInfunbody = false;
                break;
            }
            if ((funbodyend = (funbodystart = loop++) + 1) != 0 && funbodyend < funbodyindex.size() && funbodyend % 2 != 0) {
                bInfunbody = true;
                continue;
            }
            bInfunbody = false;
        }
        return bInfunbody;
    }

    private static boolean isInSingleQuotebody(int i, Vector<Integer> singleQuotebodyindex) {
        boolean bInsingleQuotebody = false;
        int singleQuotebodystart = 0;
        int singleQuotebodyend = 0;
        int loop = 0;
        while (loop < singleQuotebodyindex.size() && i >= singleQuotebodyindex.get(loop)) {
            if (i == singleQuotebodyindex.get(loop)) {
                bInsingleQuotebody = false;
                break;
            }
            if ((singleQuotebodyend = (singleQuotebodystart = loop++) + 1) != 0 && singleQuotebodyend < singleQuotebodyindex.size() && singleQuotebodyend % 2 != 0) {
                bInsingleQuotebody = true;
                continue;
            }
            bInsingleQuotebody = false;
        }
        return bInsingleQuotebody;
    }

    private static Vector<Integer> findoutSingleQuoteBodyRangeindex(String query) {
        Vector<Integer> singleQuotebodyindex = new Vector<Integer>(100);
        String sqstr = query.toLowerCase();
        int quote_index = sqstr.indexOf(39, 0);
        while (quote_index != -1) {
            singleQuotebodyindex.add(quote_index);
            quote_index = Parser.parseSingleQuotes(sqstr.toCharArray(), quote_index, true);
            singleQuotebodyindex.add(quote_index);
            quote_index = sqstr.indexOf(39, quote_index + 1);
        }
        return singleQuotebodyindex;
    }

    private static boolean isInDoubleQuotebody(int i, Vector<Integer> doubleQuotebodyindex) {
        boolean bInsingleQuotebody = false;
        int doubleQuotebodystart = 0;
        int doubleQuotebodyend = 0;
        int loop = 0;
        while (loop < doubleQuotebodyindex.size() && i >= doubleQuotebodyindex.get(loop)) {
            if (i == doubleQuotebodyindex.get(loop)) {
                bInsingleQuotebody = false;
                break;
            }
            if ((doubleQuotebodyend = (doubleQuotebodystart = loop++) + 1) != 0 && doubleQuotebodyend < doubleQuotebodyindex.size() && doubleQuotebodyend % 2 != 0) {
                bInsingleQuotebody = true;
                continue;
            }
            bInsingleQuotebody = false;
        }
        return bInsingleQuotebody;
    }

    private static Vector<Integer> findoutDoubleQuoteBodyRangeindex(String query) {
        Vector<Integer> doubleQuotebodyindex = new Vector<Integer>(100);
        String sqstr = query.toLowerCase();
        int quote_index = sqstr.indexOf(34, 0);
        while (quote_index != -1) {
            doubleQuotebodyindex.add(quote_index);
            quote_index = Parser.parseDoubleQuotes(sqstr.toCharArray(), quote_index);
            doubleQuotebodyindex.add(quote_index);
            quote_index = sqstr.indexOf(34, quote_index + 1);
        }
        return doubleQuotebodyindex;
    }

    private static Vector<Integer> findoutFunctionBodyRangeindex(String query) {
        Vector<Integer> funbodyindex = new Vector<Integer>(100);
        Vector<Integer> singleQuotebodyindex = Parser.findoutSingleQuoteBodyRangeindex(query);
        Vector<Integer> doubleQuotebodyindex = Parser.findoutDoubleQuoteBodyRangeindex(query);
        String sqstr = query.toLowerCase();
        if (sqstr.indexOf(59) != -1) {
            int create_index = 0;
            int end_index = 0;
            create_index = sqstr.indexOf("create", create_index);
            end_index = sqstr.indexOf("end", create_index);
            while (create_index != -1 && end_index != -1) {
                int funend_index;
                int funstart_index;
                int tempindex = create_index + "create".length();
                if (sqstr.charAt(tempindex) != ' ' && sqstr.charAt(tempindex) != '\n' && sqstr.charAt(tempindex) != '\t' && sqstr.charAt(tempindex) != '\r') {
                    create_index = sqstr.indexOf("create", create_index + "create".length());
                    end_index = sqstr.indexOf("end", create_index);
                    continue;
                }
                int blankindex = Parser.getIndexOfNextBlank(sqstr, tempindex = Parser.skipBlank(sqstr, tempindex));
                if (blankindex == -1) {
                    create_index = sqstr.indexOf("create", tempindex);
                    end_index = sqstr.indexOf("end", create_index);
                    continue;
                }
                String stemp = sqstr.substring(tempindex, blankindex);
                if (stemp.compareToIgnoreCase("function") == 0 || stemp.compareToIgnoreCase("procedure") == 0 || stemp.compareToIgnoreCase("trigger") == 0) {
                    funstart_index = create_index;
                    do {
                        tempindex = end_index + "end".length();
                        if ((tempindex = Parser.skipBlank(sqstr, tempindex)) != sqstr.length() && sqstr.charAt(tempindex) != ';' || Parser.isInSingleQuotebody(tempindex, singleQuotebodyindex) || Parser.isInDoubleQuotebody(tempindex, doubleQuotebodyindex) || !Parser.isACompleteFunction(sqstr, funstart_index, tempindex, singleQuotebodyindex, doubleQuotebodyindex)) continue;
                        sqstr.indexOf("", funstart_index);
                        funend_index = end_index = tempindex;
                        funbodyindex.addElement(new Integer(funstart_index));
                        funbodyindex.addElement(new Integer(funend_index));
                        create_index = sqstr.indexOf("create", end_index);
                        end_index = sqstr.indexOf("end", create_index);
                        break;
                    } while ((end_index = sqstr.indexOf("end", tempindex)) != -1);
                    if (funbodyindex.contains(new Integer(funstart_index))) continue;
                    funbodyindex.addElement(new Integer(funstart_index));
                    funbodyindex.addElement(new Integer(query.length()));
                    break;
                }
                if (stemp.compareToIgnoreCase("or") == 0) {
                    tempindex = blankindex;
                    blankindex = Parser.getIndexOfNextBlank(sqstr, tempindex = Parser.skipBlank(sqstr, tempindex));
                    if (blankindex == -1) {
                        create_index = sqstr.indexOf("create", tempindex);
                        end_index = sqstr.indexOf("end", create_index);
                        continue;
                    }
                    stemp = sqstr.substring(tempindex, blankindex);
                    if (stemp.compareToIgnoreCase("replace") == 0) {
                        tempindex = blankindex;
                        blankindex = Parser.getIndexOfNextBlank(sqstr, tempindex = Parser.skipBlank(sqstr, tempindex));
                        if (blankindex == -1) {
                            create_index = sqstr.indexOf("create", tempindex);
                            end_index = sqstr.indexOf("end", create_index);
                            continue;
                        }
                        stemp = sqstr.substring(tempindex, blankindex);
                        if (stemp.compareToIgnoreCase("function") == 0 || stemp.compareToIgnoreCase("procedure") == 0 || stemp.compareToIgnoreCase("trigger") == 0) {
                            funstart_index = create_index;
                            do {
                                tempindex = end_index + "end".length();
                                if ((tempindex = Parser.skipBlank(sqstr, tempindex)) != sqstr.length() && sqstr.charAt(tempindex) != ';' || Parser.isInSingleQuotebody(tempindex, singleQuotebodyindex) || Parser.isInDoubleQuotebody(tempindex, doubleQuotebodyindex) || !Parser.isACompleteFunction(sqstr, funstart_index, tempindex, singleQuotebodyindex, doubleQuotebodyindex)) continue;
                                sqstr.indexOf("", funstart_index);
                                funend_index = end_index = tempindex;
                                funbodyindex.addElement(new Integer(funstart_index));
                                funbodyindex.addElement(new Integer(funend_index));
                                create_index = sqstr.indexOf("create", end_index);
                                end_index = sqstr.indexOf("end", create_index);
                                break;
                            } while ((end_index = sqstr.indexOf("end", tempindex)) != -1);
                            if (funbodyindex.contains(new Integer(funstart_index))) continue;
                            funbodyindex.addElement(new Integer(funstart_index));
                            funbodyindex.addElement(new Integer(query.length()));
                            break;
                        }
                        create_index = sqstr.indexOf("create", blankindex);
                        end_index = sqstr.indexOf("end", create_index);
                        continue;
                    }
                    create_index = sqstr.indexOf("create", blankindex);
                    end_index = sqstr.indexOf("end", create_index);
                    continue;
                }
                create_index = sqstr.indexOf("create", blankindex);
                end_index = sqstr.indexOf("end", create_index);
            }
        }
        return funbodyindex;
    }

    public static int skipBlank(String sqstr, int tempindex) {
        while (tempindex < sqstr.length() && (sqstr.charAt(tempindex) == ' ' || sqstr.charAt(tempindex) == '\n' || sqstr.charAt(tempindex) == '\t' || sqstr.charAt(tempindex) == '\r')) {
            ++tempindex;
        }
        return tempindex;
    }

    private static int getIndexOfNextBlank(String sqstr, int tempindex) {
        int blank_tempindex = sqstr.indexOf(" ", tempindex);
        int blankindex = blank_tempindex != -1 ? blank_tempindex : -1;
        blank_tempindex = sqstr.indexOf("\n", tempindex);
        if (blank_tempindex != -1 && blankindex != -1 && blank_tempindex < blankindex) {
            blankindex = blank_tempindex;
        }
        if ((blank_tempindex = sqstr.indexOf("\t", tempindex)) != -1 && blankindex != -1 && blank_tempindex < blankindex) {
            blankindex = blank_tempindex;
        }
        if ((blank_tempindex = sqstr.indexOf("\r", tempindex)) != -1 && blankindex != -1 && blank_tempindex < blankindex) {
            blankindex = blank_tempindex;
        }
        return blankindex;
    }

    private static boolean isACompleteFunction(String query, int start, int end, Vector<Integer> singleQuotebodyindex, Vector<Integer> doubleQuotebodyindex) {
        int numOfEnd;
        int numOfBegin = Parser.getNumOfBeginOrEnd(query, "begin", start, end, singleQuotebodyindex, doubleQuotebodyindex);
        return numOfBegin == (numOfEnd = Parser.getNumOfBeginOrEnd(query, "end", start, end, singleQuotebodyindex, doubleQuotebodyindex));
    }

    private static int getNumOfBeginOrEnd(String query, String str, int start, int end, Vector<Integer> singleQuotebodyindex, Vector<Integer> doubleQuotebodyindex) {
        String todo = query.substring(start, end).toLowerCase();
        int count = 0;
        int index = todo.indexOf(str, 0);
        while (index != -1) {
            if (index != 0 && todo.charAt(index - 1) != ' ' && todo.charAt(index - 1) != '\n' && todo.charAt(index - 1) != '\r' && todo.charAt(index - 1) != '\t' && todo.charAt(index - 1) != ';') {
                index += str.length();
                index = todo.indexOf(str, index);
                continue;
            }
            index += str.length();
            if ("end".equals(str)) {
                if (!((index = Parser.skipBlank(todo, index)) != todo.length() && todo.charAt(index) != ';' || Parser.isInSingleQuotebody(index + start, singleQuotebodyindex) || Parser.isInDoubleQuotebody(index + start, doubleQuotebodyindex))) {
                    ++count;
                }
            } else if ("begin".equals(str)) {
                if (todo.charAt(index) != ' ' && todo.charAt(index) != '\n' && todo.charAt(index) != '\r' && todo.charAt(index) != '\t') {
                    index = todo.indexOf(str, index);
                    continue;
                }
                if (todo.charAt(index = Parser.skipBlank(todo, index)) != ';' && todo.charAt(index) != '.' && !Parser.isInSingleQuotebody(index + start, singleQuotebodyindex) && !Parser.isInDoubleQuotebody(index + start, doubleQuotebodyindex)) {
                    ++count;
                }
            }
            index = todo.indexOf(str, index);
        }
        return count;
    }

    private static boolean addReturning(StringBuilder nativeSql, SqlCommandType currentCommandType, String[] returningColumnNames, boolean isReturningPresent) throws SQLException {
        if (isReturningPresent || returningColumnNames.length == 0) {
            return false;
        }
        if (currentCommandType != SqlCommandType.INSERT && currentCommandType != SqlCommandType.UPDATE && currentCommandType != SqlCommandType.DELETE) {
            return false;
        }
        nativeSql.append("\nRETURNING ");
        if (returningColumnNames.length == 1 && returningColumnNames[0].charAt(0) == '*') {
            nativeSql.append('*');
            return true;
        }
        for (int col = 0; col < returningColumnNames.length; ++col) {
            String columnName = returningColumnNames[col];
            if (col > 0) {
                nativeSql.append(", ");
            }
            Utils.escapeIdentifier(nativeSql, columnName);
        }
        return true;
    }

    private static int[] toIntArray(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return NO_BINDS;
        }
        int[] res = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
        } else {
            block8: while (++offset < query.length) {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        continue block8;
                    }
                    case '\'': {
                        return offset;
                    }
                }
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                for (int d = offset + 2; d < query.length; ++d) {
                    if (query[d] == '$') {
                        endIdx = d;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d])) break;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean parseDeleteKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    public static boolean parseInsertKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 105 && (query[offset + 1] | 0x20) == 110 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116;
    }

    public static boolean parseMoveKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 109 && (query[offset + 1] | 0x20) == 111 && (query[offset + 2] | 0x20) == 118 && (query[offset + 3] | 0x20) == 101;
    }

    public static boolean parseReturningKeyword(char[] query, int offset) {
        if (query.length < offset + 9) {
            return false;
        }
        return (query[offset] | 0x20) == 114 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 117 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 110 && (query[offset + 6] | 0x20) == 105 && (query[offset + 7] | 0x20) == 110 && (query[offset + 8] | 0x20) == 103;
    }

    public static boolean parseSelectKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 115 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 99 && (query[offset + 5] | 0x20) == 116;
    }

    public static boolean parseUpdateKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 100 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101;
    }

    public static boolean parseValuesKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 118 && (query[offset + 1] | 0x20) == 97 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 117 && (query[offset + 4] | 0x20) == 101 && (query[offset + 5] | 0x20) == 115;
    }

    public static boolean parseWithKeyword(char[] query, int offset) {
        if (query.length < offset + 4) {
            return false;
        }
        return (query[offset] | 0x20) == 119 && (query[offset + 1] | 0x20) == 105 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 104;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static boolean isOperatorChar(char c) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c) != -1;
    }

    public static boolean isIdentifierStartChar(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isIdentifierContChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean charTerminatesIdentifier(char c) {
        return c == '\"' || Parser.isSpace(c) || Parser.isOperatorChar(c);
    }

    public static boolean isDollarQuoteStartChar(char c) {
        return c != '$' && Parser.isIdentifierStartChar(c);
    }

    public static boolean isDollarQuoteContChar(char c) {
        return c != '$' && Parser.isIdentifierContChar(c);
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (arr[offA + i] == arr[offB + i]) continue;
            return false;
        }
        return true;
    }

    public static JdbcCallParseInfo modifyJdbcCall(String jdbcSql, boolean stdStrings, int serverVersion, int protocolVersion) throws SQLException {
        String sql = jdbcSql;
        boolean isFunction = false;
        boolean outParmBeforeFunc = false;
        int len = jdbcSql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i = 0;
        block10: while (i < len && !syntaxError) {
            char ch = jdbcSql.charAt(i);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    i = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        isFunction = true;
                        outParmBeforeFunc = true;
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c' || ch == 'C') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i + 4 <= len && jdbcSql.substring(i, i + 4).equalsIgnoreCase("call")) {
                        isFunction = true;
                        i += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\' && !stdStrings) {
                        i += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i == len && !syntaxError) {
            if (state == 1) {
                return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new KSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", i), KSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (serverVersion < 80100 || protocolVersion != 3) {
            sql = "select " + jdbcSql.substring(startIndex, endIndex) + " as result";
            return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
        }
        String s = jdbcSql.substring(startIndex, endIndex);
        StringBuilder sb = new StringBuilder(s);
        if (outParmBeforeFunc) {
            boolean needComma = false;
            int opening = s.indexOf(40) + 1;
            int closing = s.indexOf(41);
            for (int j = opening; j < closing; ++j) {
                if (Character.isWhitespace(sb.charAt(j))) continue;
                needComma = true;
                break;
            }
            if (needComma) {
                sb.insert(opening, "?,");
            } else {
                sb.insert(opening, "?");
            }
        }
        sql = "select * from " + sb.toString() + " as result";
        return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
    }

    public static String replaceProcessing(String p_sql, boolean replaceProcessingEnabled, boolean standardConformingStrings) throws SQLException {
        if (replaceProcessingEnabled) {
            int len = p_sql.length();
            char[] chars = p_sql.toCharArray();
            StringBuilder newsql = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                if ((i = Parser.parseSql(chars, i, newsql, false, standardConformingStrings)) >= len) continue;
                newsql.append(chars[i]);
                ++i;
            }
            return newsql.toString();
        }
        return p_sql;
    }

    private static int parseSql(char[] p_sql, int i, StringBuilder newsql, boolean stopOnComma, boolean stdStrings) throws SQLException {
        SqlParseState state = SqlParseState.IN_SQLCODE;
        int len = p_sql.length;
        int nestedParenthesis = 0;
        boolean endOfNested = false;
        --i;
        while (!endOfNested && ++i < len) {
            char c = p_sql[i];
            block0 : switch (state) {
                case IN_SQLCODE: {
                    if (c == '$') {
                        int i0 = i;
                        i = Parser.parseDollarQuotes(p_sql, i);
                        Parser.checkParsePosition(i, len, i0, p_sql, "Unterminated dollar quote started at position {0} in SQL {1}. Expected terminating $$");
                        newsql.append(p_sql, i0, i - i0 + 1);
                        break;
                    }
                    if (c == '\'') {
                        int i0 = i;
                        i = Parser.parseSingleQuotes(p_sql, i, stdStrings);
                        Parser.checkParsePosition(i, len, i0, p_sql, "Unterminated string literal started at position {0} in SQL {1}. Expected ' char");
                        newsql.append(p_sql, i0, i - i0 + 1);
                        break;
                    }
                    if (c == '\"') {
                        int i0 = i;
                        i = Parser.parseDoubleQuotes(p_sql, i);
                        Parser.checkParsePosition(i, len, i0, p_sql, "Unterminated identifier started at position {0} in SQL {1}. Expected \" char");
                        newsql.append(p_sql, i0, i - i0 + 1);
                        break;
                    }
                    if (c == '/') {
                        int i0 = i;
                        i = Parser.parseBlockComment(p_sql, i);
                        Parser.checkParsePosition(i, len, i0, p_sql, "Unterminated block comment started at position {0} in SQL {1}. Expected */ sequence");
                        newsql.append(p_sql, i0, i - i0 + 1);
                        break;
                    }
                    if (c == '-') {
                        int i0 = i;
                        i = Parser.parseLineComment(p_sql, i);
                        newsql.append(p_sql, i0, i - i0 + 1);
                        break;
                    }
                    if (c == '(') {
                        ++nestedParenthesis;
                    } else if (c == ')') {
                        if (--nestedParenthesis < 0) {
                            endOfNested = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && c == ',' && nestedParenthesis == 0) {
                            endOfNested = true;
                            break;
                        }
                        if (c == '{' && i + 1 < len) {
                            SqlParseState[] availableStates = SqlParseState.values();
                            for (int j = 1; j < availableStates.length; ++j) {
                                SqlParseState availableState = availableStates[j];
                                int matchedPosition = availableState.getMatchedPosition(p_sql, i + 1);
                                if (matchedPosition == 0) continue;
                                i += matchedPosition;
                                if (availableState.replacementKeyword != null) {
                                    newsql.append(availableState.replacementKeyword);
                                }
                                state = availableState;
                                break block0;
                            }
                        }
                    }
                    newsql.append(c);
                    break;
                }
                case ESC_FUNCTION: {
                    int posArgs;
                    for (posArgs = i; posArgs < len && p_sql[posArgs] != '('; ++posArgs) {
                    }
                    if (posArgs < len) {
                        String functionName = new String(p_sql, i, posArgs - i).trim();
                        i = posArgs + 1;
                        StringBuilder args = new StringBuilder();
                        i = Parser.parseSql(p_sql, i, args, false, stdStrings);
                        newsql.append(Parser.escapeFunction(functionName, args.toString(), stdStrings));
                    }
                    ++i;
                    while (i < len && p_sql[i] != '}') {
                        newsql.append(p_sql[i++]);
                    }
                    state = SqlParseState.IN_SQLCODE;
                    break;
                }
                case ESC_DATE: 
                case ESC_TIME: 
                case ESC_TIMESTAMP: 
                case ESC_OUTERJOIN: 
                case ESC_ESCAPECHAR: {
                    if (c == '}') {
                        state = SqlParseState.IN_SQLCODE;
                        break;
                    }
                    newsql.append(c);
                }
            }
        }
        return i;
    }

    private static void checkParsePosition(int i, int len, int i0, char[] p_sql, String message) throws KSQLException {
        if (i < len) {
            return;
        }
        throw new KSQLException(GT.tr(message, i0, new String(p_sql)), KSQLState.SYNTAX_ERROR);
    }

    private static String escapeFunction(String functionName, String args, boolean stdStrings) throws SQLException {
        int len = args.length();
        char[] argChars = args.toCharArray();
        ArrayList<StringBuilder> parsedArgs = new ArrayList<StringBuilder>();
        for (int i = 0; i < len; ++i) {
            int lastPos = i;
            StringBuilder arg = new StringBuilder();
            if (lastPos == (i = Parser.parseSql(argChars, i, arg, true, stdStrings))) continue;
            parsedArgs.add(arg);
        }
        try {
            Method escapeMethod = EscapedFunctions.getFunction(functionName);
            return (String)escapeMethod.invoke(null, parsedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new KSQLException(e.getTargetException().getMessage(), KSQLState.SYSTEM_ERROR);
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            buf.append(functionName).append('(');
            for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
                buf.append((CharSequence)parsedArgs.get(iArg));
                if (iArg == parsedArgs.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    static /* synthetic */ char[] access$200() {
        return SINGLE_QUOTE;
    }

    static /* synthetic */ char[] access$300() {
        return QUOTE_OR_ALPHABETIC_MARKER;
    }

    private static enum SqlParseState {
        IN_SQLCODE,
        ESC_DATE("d", Parser.access$200(), "DATE "),
        ESC_TIME("t", Parser.access$200(), "TIME "),
        ESC_TIMESTAMP("ts", Parser.access$200(), "TIMESTAMP "),
        ESC_FUNCTION("fn", Parser.access$300(), null),
        ESC_OUTERJOIN("oj", Parser.access$300(), null),
        ESC_ESCAPECHAR("escape", Parser.access$200(), "ESCAPE ");

        private final char[] escapeKeyword;
        private final char[] allowedValues;
        private final String replacementKeyword;

        private SqlParseState() {
            this("", new char[0], null);
        }

        private SqlParseState(String escapeKeyword, char[] allowedValues, String replacementKeyword) {
            this.escapeKeyword = escapeKeyword.toCharArray();
            this.allowedValues = allowedValues;
            this.replacementKeyword = replacementKeyword;
        }

        private int getMatchedPosition(char[] p_sql, int pos) {
            int newPos = pos;
            for (char c : this.escapeKeyword) {
                char curr;
                if (newPos >= p_sql.length) {
                    return 0;
                }
                if ((curr = p_sql[newPos++]) == c || curr == Character.toUpperCase(c)) continue;
                return 0;
            }
            if (newPos >= p_sql.length) {
                return 0;
            }
            char curr = p_sql[newPos];
            while (curr == ' ') {
                if (++newPos >= p_sql.length) {
                    return 0;
                }
                curr = p_sql[newPos];
            }
            for (char c : this.allowedValues) {
                if (curr != c && (c != '0' || !Character.isLetter(curr))) continue;
                return newPos - pos;
            }
            return 0;
        }
    }
}

