/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybPooledConnection;
import com.sybase.jdbc2.jdbc.SybXAConnection;
import com.sybase.jdbc2.jdbc.SybXAResource;
import com.sybase.jdbc2.jdbc.SybXAResource11;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.XAConnection;

public class SybConnectionProxy
implements SybConnection {
    protected final SybPooledConnection _realConn;
    private final boolean _realConnIsXA;
    private WeakHashMap _openStatements = new WeakHashMap();
    private boolean _wasClosed = false;

    public SybConnectionProxy(SybPooledConnection sybPooledConnection) {
        this._realConn = sybPooledConnection;
        this._realConnIsXA = this._realConn instanceof XAConnection;
    }

    public void cancel() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.cancel();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    private void checkIfClosed() throws SQLException {
        if (this._wasClosed) {
            ErrorMessage.raiseError("JZ0C0");
        }
    }

    private void checkLocalTransaction(String string) throws SQLException {
        SybXAResource sybXAResource = (SybXAResource)((SybXAConnection)this._realConn).getXAResource();
        if (!sybXAResource.isLocalTransactionOK()) {
            ErrorMessage.raiseError(sybXAResource instanceof SybXAResource11 ? "JZ0S6" : "JZ0S5", string);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        this.checkIfClosed();
        this._wasClosed = true;
        this.closeRememberedStatements();
        this._realConn.notifyListeners(null);
    }

    protected void closeRememberedStatements() {
        Iterator iterator = ((AbstractMap)this._openStatements).keySet().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._openStatements.clear();
    }

    public void commit() throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA) {
            this.checkLocalTransaction("commit()");
        }
        try {
            this._realConn.commit();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public Capture createCapture() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.createCapture();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        this.checkIfClosed();
        Statement statement = null;
        try {
            statement = this._realConn.createStatement();
            this.rememberStatement(statement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return statement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkIfClosed();
        Statement statement = null;
        try {
            statement = this._realConn.createStatement(n, n2);
            this.rememberStatement(statement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return statement;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public String getSessionID() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getSessionID();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._realConn.getSybMessageHandler();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this._wasClosed) {
            return true;
        }
        try {
            return this._realConn.isClosed();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkIfClosed();
        CallableStatement callableStatement = null;
        try {
            callableStatement = this._realConn.prepareCall(string);
            this.rememberStatement(callableStatement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkIfClosed();
        CallableStatement callableStatement = null;
        try {
            callableStatement = this._realConn.prepareCall(string, n, n2);
            this.rememberStatement(callableStatement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfClosed();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this._realConn.prepareStatement(string);
            this.rememberStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfClosed();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this._realConn.prepareStatement(string, n, n2);
            this.rememberStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkIfClosed();
        try {
            preparedStatement = this._realConn.prepareStatement(string, bl);
            this.rememberStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return preparedStatement;
    }

    public void regNoWatch(String string) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regNoWatch(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regWatch(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    protected void rememberStatement(Statement statement) {
        this._openStatements.put(statement, null);
    }

    public void rollback() throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA) {
            this.checkLocalTransaction("rollback()");
        }
        try {
            this._realConn.rollback();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && bl && this._realConnIsXA) {
            this.checkLocalTransaction("setAutoCommit()");
        }
        try {
            this._realConn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._realConn.setSybMessageHandler(sybMessageHandler);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    private void testConnection(SQLException sQLException) {
        boolean bl = true;
        try {
            bl = this._realConn.isClosed();
        }
        catch (SQLException sQLException2) {
            // empty catch block
        }
        if (bl) {
            this._realConn.notifyListeners(sQLException);
        }
    }

    protected boolean wasClosed() {
        return this._wasClosed;
    }
}

