/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmlutils.external;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmlutils.ParserUtils;

public class ParserUtilsXerces
implements ParserUtils {
    private static final String VALIDATION = "http://xml.org/sax/features/validation";

    public XMLReader getXMLReader(boolean bl) throws XMLMiddlewareException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    public DOMImplementation getDOMImplementation() throws XMLMiddlewareException {
        try {
            return new DOMImplementationImpl();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    public Document openDocument(InputSource inputSource, boolean bl) throws XMLMiddlewareException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(bl);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    public void writeDocument(Document document, String string, String string2) throws XMLMiddlewareException {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            if (string2 != null) {
                outputFormat.setEncoding(string2);
            }
            outputFormat.setIndenting(true);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
            xMLSerializer.asDOMSerializer().serialize(document);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
    }

    public String writeDocument(Document document) throws XMLMiddlewareException {
        OutputFormat outputFormat = new OutputFormat(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        String string = "";
        try {
            xMLSerializer.serialize(document);
            string = byteArrayOutputStream.toString("utf-8");
        }
        catch (Exception exception) {
            throw new XMLMiddlewareException(exception);
        }
        return string;
    }
}

