/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.MIME2Java;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;

final class UTF8Recognizer
extends XMLDeclRecognizer {
    private byte[] fUTF8BOM = new byte[]{-17, -69, -65};

    UTF8Recognizer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory readerFactory, XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, StringPool stringPool, ChunkyByteArray data, boolean xmlDecl, boolean allowJavaEncodingName) throws Exception {
        XMLDeclReader declReader;
        int encoding;
        byte bom2;
        byte bom1;
        XMLEntityHandler.EntityReader reader = null;
        boolean seeBOM = false;
        byte bom0 = data.byteAt(0);
        if (bom0 == this.fUTF8BOM[0] && (bom1 = data.byteAt(1)) == this.fUTF8BOM[1] && (bom2 = data.byteAt(2)) == this.fUTF8BOM[2]) {
            seeBOM = true;
        }
        if (seeBOM) {
            data.read(this.fUTF8BOM, 0, 3);
        }
        byte b0 = data.byteAt(0);
        boolean debug = false;
        if (b0 != 60) return reader;
        byte b1 = data.byteAt(1);
        if (b1 != 63) return reader;
        if (data.byteAt(2) != 120) return reader;
        if (data.byteAt(3) != 109) return reader;
        if (data.byteAt(4) != 108) return reader;
        byte b5 = data.byteAt(5);
        if (b5 != 32 && b5 != 9 && b5 != 10) {
            if (b5 != 13) return reader;
        }
        if ((encoding = this.prescanXMLDeclOrTextDecl(declReader = new XMLDeclReader(this, entityHandler, errorReporter, sendCharDataAsCharArray, data, stringPool), xmlDecl)) != -1) {
            String encname = stringPool.orphanString(encoding);
            String enc = encname.toUpperCase();
            if ("ISO-10646-UCS-2".equals(enc)) {
                throw new UnsupportedEncodingException(encname);
            }
            if ("ISO-10646-UCS-4".equals(enc)) {
                throw new UnsupportedEncodingException(encname);
            }
            if ("UTF-16".equals(enc)) {
                throw new UnsupportedEncodingException(encname);
            }
            String javaencname = MIME2Java.convert(enc);
            if (javaencname == null) {
                javaencname = encname;
            }
            try {
                data.rewind();
                if ("UTF-8".equalsIgnoreCase(javaencname)) return readerFactory.createUTF8Reader(entityHandler, errorReporter, sendCharDataAsCharArray, data, stringPool);
                if (!"UTF8".equalsIgnoreCase(javaencname)) return readerFactory.createCharReader(entityHandler, errorReporter, sendCharDataAsCharArray, new InputStreamReader((InputStream)data, javaencname), stringPool);
                return readerFactory.createUTF8Reader(entityHandler, errorReporter, sendCharDataAsCharArray, data, stringPool);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedEncodingException(encname);
            }
            catch (Exception e) {
                if (!debug) return reader;
                e.printStackTrace();
                return reader;
            }
        } else {
            data.rewind();
            return readerFactory.createUTF8Reader(entityHandler, errorReporter, sendCharDataAsCharArray, data, stringPool);
        }
    }

    final class XMLDeclReader
    extends XMLEntityReader {
        private StringPool fStringPool = null;
        private ChunkyByteArray fData = null;

        XMLDeclReader(UTF8Recognizer this$0, XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, ChunkyByteArray data, StringPool stringPool) {
            super(entityHandler, errorReporter, sendCharDataAsCharArray);
            this.fStringPool = stringPool;
            this.fData = data;
        }

        public boolean lookingAtChar(char ch, boolean skipPastChar) throws IOException {
            if (this.fData.byteAt(this.fCurrentOffset) != ch) {
                return false;
            }
            if (skipPastChar) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public boolean lookingAtSpace(boolean skipPastChar) throws IOException {
            int ch = this.fData.byteAt(this.fCurrentOffset) & 0xFF;
            if (ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                return false;
            }
            if (skipPastChar) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public void skipPastSpaces() throws IOException {
            int ch;
            while ((ch = this.fData.byteAt(this.fCurrentOffset) & 0xFF) == 32 || ch == 9 || ch == 10 || ch == 13) {
                ++this.fCurrentOffset;
            }
            return;
        }

        public boolean skippedString(char[] s) throws IOException {
            int offset = this.fCurrentOffset;
            for (int i = 0; i < s.length; ++i) {
                if (this.fData.byteAt(offset) != s[i]) {
                    return false;
                }
                ++offset;
            }
            this.fCurrentOffset = offset;
            return true;
        }

        public int scanStringLiteral() throws Exception {
            byte b;
            byte qchar;
            boolean single = this.lookingAtChar('\'', true);
            if (!single && !this.lookingAtChar('\"', true)) {
                return -1;
            }
            int offset = this.fCurrentOffset;
            byte by = qchar = single ? (byte)39 : 34;
            while ((b = this.fData.byteAt(this.fCurrentOffset)) != qchar) {
                if (b == -1) {
                    return -1;
                }
                ++this.fCurrentOffset;
            }
            int length = this.fCurrentOffset - offset;
            StringBuffer str = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                str.append((char)this.fData.byteAt(offset + i));
            }
            int stringIndex = this.fStringPool.addString(str.toString());
            ++this.fCurrentOffset;
            return stringIndex;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public int addString(int offset, int length) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public int addSymbol(int offset, int length) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public void skipToChar(char ch) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void skipPastName(char fastcheck) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void skipPastNmtoken(char fastcheck) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public boolean lookingAtValidChar(boolean skipPastChar) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanInvalidChar() throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanCharRef(boolean hex) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanAttValue(char qchar, boolean asSymbol) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanEntityValue(int qchar, boolean createString) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void scanQName(char fastcheck, QName qname) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanName(char fastcheck) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanContent(QName element) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }
    }
}

